/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.ascu;

import com.nokia.em.bts.coreasset.ascu.AntennaConfigListener;
import com.nokia.em.bts.coreasset.ascu.AntennaConfigurationManagerImpl;
import com.nokia.em.bts.coreasset.ascu.AscuCommissionData;
import com.nokia.em.bts.coreasset.ascu.AscuHwInfo;
import com.nokia.em.bts.coreasset.ascu.AscuSwInfo;
import com.nokia.em.bts.coreasset.ascu.EtaCommissionData;
import com.nokia.em.bts.coreasset.ascu.EtaUnitCommissionData;
import com.nokia.em.bts.rp.master.alarm.Alarm;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.TitledBorder;

public class AntennaClient
extends JFrame
implements AntennaConfigListener {
    JPanel leftPanel = new JPanel();
    BorderLayout mainBorderLayout = new BorderLayout();
    JPanel rightPanel = new JPanel();
    JPanel buttonPanel = new JPanel();
    JPanel outputPanel = new JPanel();
    BorderLayout rightBorderLayout = new BorderLayout();
    JButton executeButton = new JButton();
    FlowLayout buttonFlowLayout = new FlowLayout();
    BorderLayout outputBorderLayout = new BorderLayout();
    JScrollPane outputScrollPane = new JScrollPane();
    JTextArea outputTextArea = new JTextArea();
    BorderLayout leftBorderLayout = new BorderLayout();
    JScrollPane methodScrollPane = new JScrollPane();
    JList methodList;
    AntennaConfigurationManagerImpl antennaManager;

    public AntennaClient() {
        try {
            this.initData();
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        new AntennaClient();
    }

    public void sendMessage(String message) {
        this.outputTextArea.append("Message received: " + message + "\n");
    }

    void executeButton_actionPerformed() {
        String selectedMethod = (String)this.methodList.getSelectedValue();
        if ("setDateTime".equalsIgnoreCase(selectedMethod)) {
            this.outputTextArea.append(String.valueOf(this.antennaManager.setDateTime(new Date())) + "\n");
        } else if ("getDateTime".equalsIgnoreCase(selectedMethod)) {
            this.outputTextArea.append(this.antennaManager.getDateTime() + "\n");
        } else if ("setTilt".equalsIgnoreCase(selectedMethod)) {
            this.outputTextArea.append(String.valueOf(this.antennaManager.setTilt("Antenna1", 1.2f)) + "\n");
        } else if ("getTilt".equalsIgnoreCase(selectedMethod)) {
            this.outputTextArea.append(String.valueOf(this.antennaManager.getTilt("Antenna1")) + "\n");
        } else if ("getInServiceTime".equalsIgnoreCase(selectedMethod)) {
            this.outputTextArea.append(String.valueOf(this.antennaManager.getInServiceTime()) + "\n");
        } else if ("getAntennaTypes".equalsIgnoreCase(selectedMethod)) {
            Vector response = this.antennaManager.getAntennaTypes("");
            Enumeration en = response.elements();
            while (en.hasMoreElements()) {
                Hashtable ht = (Hashtable)en.nextElement();
                Enumeration enu = ht.keys();
                while (enu.hasMoreElements()) {
                    String key = (String)enu.nextElement();
                    this.outputTextArea.append(String.valueOf(key) + ": " + ht.get(key).toString() + "\n");
                }
            }
        } else if ("getCommissionData".equalsIgnoreCase(selectedMethod)) {
            this.antennaManager.getCommissionData();
            this.outputTextArea.append("Commission data requested");
        } else if ("getStatus".equalsIgnoreCase(selectedMethod)) {
            Vector response = this.antennaManager.getStatus("");
            Enumeration en = response.elements();
            while (en.hasMoreElements()) {
                Hashtable ht = (Hashtable)en.nextElement();
                Enumeration enu = ht.keys();
                while (enu.hasMoreElements()) {
                    String key = (String)enu.nextElement();
                    this.outputTextArea.append(String.valueOf(key) + ": " + ht.get(key).toString() + "\n");
                }
            }
        } else if ("getHwInfo".equalsIgnoreCase(selectedMethod)) {
            this.antennaManager.getHwInfo();
            this.outputTextArea.append("HW info requested.\n");
        } else if ("getSwInfo".equalsIgnoreCase(selectedMethod)) {
            this.outputTextArea.append("SW info requested.\n");
            this.antennaManager.getSwInfo();
        } else if ("selfTest".equalsIgnoreCase(selectedMethod)) {
            this.outputTextArea.append("Self test requested.\n");
            Vector response = this.antennaManager.selfTest();
            Enumeration en = response.elements();
            while (en.hasMoreElements()) {
                this.outputTextArea.append(String.valueOf((String)en.nextElement()) + "\n");
            }
        } else if ("getErrorStatus".equalsIgnoreCase(selectedMethod)) {
            Vector response = this.antennaManager.getErrorStatuses();
            Enumeration en = response.elements();
            while (en.hasMoreElements()) {
                this.outputTextArea.append(String.valueOf((String)en.nextElement()) + "\n");
            }
        } else if ("getSerialNumber".equalsIgnoreCase(selectedMethod)) {
            Vector response = this.antennaManager.getSerialNumber("");
            Enumeration en = response.elements();
            while (en.hasMoreElements()) {
                this.outputTextArea.append(String.valueOf((String)en.nextElement()) + "\n");
            }
        } else if ("setPollingInterval(1s)".equalsIgnoreCase(selectedMethod)) {
            this.antennaManager.setPollingInterval(1000);
        } else if ("setPollingInterval(10s)".equalsIgnoreCase(selectedMethod)) {
            this.antennaManager.setPollingInterval(10000);
        } else if ("setPollingInterval(100s)".equalsIgnoreCase(selectedMethod)) {
            this.antennaManager.setPollingInterval(100000);
        } else if ("setPollingInterval(1000s)".equalsIgnoreCase(selectedMethod)) {
            this.antennaManager.setPollingInterval(1000000);
        } else if ("calibrate".equalsIgnoreCase(selectedMethod)) {
            this.antennaManager.calibrate("Antenna1");
        } else if ("clearErrorStatus".equalsIgnoreCase(selectedMethod)) {
            this.outputTextArea.append(String.valueOf(this.antennaManager.clearErrorStatus("Antenna 12")) + "\n");
        } else if ("reset".equalsIgnoreCase(selectedMethod)) {
            this.outputTextArea.append(String.valueOf(this.antennaManager.reset()) + "\n");
        } else if ("reboot".equalsIgnoreCase(selectedMethod)) {
            this.outputTextArea.append(String.valueOf(this.antennaManager.reboot()) + "\n");
        } else if ("subscribeNotifications".equalsIgnoreCase(selectedMethod)) {
            this.outputTextArea.append("Subscribing notifications to port 61012");
            this.outputTextArea.append(this.antennaManager.subscribeNotifications(61012, this));
        } else if ("unsubscribeNotifications".equalsIgnoreCase(selectedMethod)) {
            this.outputTextArea.append(String.valueOf(this.antennaManager.unsubscribeNotifications()) + "\n");
        } else if ("connect".equalsIgnoreCase(selectedMethod)) {
            this.outputTextArea.append("Connecting... \n");
            this.antennaManager.connect();
        } else if ("disconnect".equalsIgnoreCase(selectedMethod)) {
            this.outputTextArea.append("Disconnecting... \n");
            this.antennaManager.disconnect();
        } else if ("setStatusOK".equalsIgnoreCase(selectedMethod)) {
            this.outputTextArea.append("ETA status set OK... \n");
            this.antennaManager.setStatus(0);
        } else if ("setStatusBUSY".equalsIgnoreCase(selectedMethod)) {
            this.outputTextArea.append("ETA status set BUSY... \n");
            this.antennaManager.setStatus(5);
        } else if ("setStatusFAILED".equalsIgnoreCase(selectedMethod)) {
            this.outputTextArea.append("ETA status set FAILED (6)... \n");
            this.antennaManager.setStatus(6);
        } else if ("commission".equalsIgnoreCase(selectedMethod)) {
            this.outputTextArea.append("Outdated. Please use commissionNew.\n");
        } else if ("commissionNew".equalsIgnoreCase(selectedMethod)) {
            this.outputTextArea.append("Commissioning... \n");
            EtaCommissionData ETAInfo = new EtaCommissionData();
            AscuCommissionData ASCUInfo = new AscuCommissionData();
            EtaUnitCommissionData antenna1 = new EtaUnitCommissionData();
            EtaUnitCommissionData antenna2 = new EtaUnitCommissionData();
            EtaUnitCommissionData antenna3 = new EtaUnitCommissionData();
            EtaUnitCommissionData antenna4 = new EtaUnitCommissionData();
            ASCUInfo.setASCU_Name("My RET1 Controller");
            ASCUInfo.setASCU_IPAddress("192.168.255.144");
            ASCUInfo.setASCU_IPGateway("192.168.255.254");
            ASCUInfo.setASCU_IPSubnetMask("255.255.255.0");
            ASCUInfo.setASCU_MACAddress("0e 00 00 02 01 02");
            ASCUInfo.setASCU_UserDefinedInUse("1");
            antenna1.setAntennaId("My Antenna1");
            antenna1.setAntennaType("Small Antenna");
            antenna1.setAntennaSerialNumber("ANT12349987-7863");
            antenna1.setAntennaMinTilt(0.0f);
            antenna1.setAntennaMaxTilt(14.0f);
            antenna1.setLCRId("10000");
            antenna2.setAntennaId("My Antenna2");
            antenna2.setAntennaType("Big Antenna");
            antenna2.setAntennaSerialNumber("ANT12349987-7864");
            antenna2.setAntennaMinTilt(0.0f);
            antenna2.setAntennaMaxTilt(8.0f);
            antenna2.setLCRId("10000");
            antenna3.setAntennaId("My Antenna3");
            antenna3.setAntennaType("Small Antenna");
            antenna3.setAntennaSerialNumber("ANT12349987-7865");
            antenna3.setAntennaMinTilt(0.0f);
            antenna3.setAntennaMaxTilt(14.0f);
            antenna3.setLCRId("10000");
            antenna4.setAntennaId("My Antenna4");
            antenna4.setAntennaType("Big Antenna");
            antenna4.setAntennaSerialNumber("ANT12349987-7866");
            antenna4.setAntennaMinTilt(0.0f);
            antenna4.setAntennaMaxTilt(18.0f);
            antenna4.setLCRId("10000");
            ETAInfo.addUnit(antenna1);
            ETAInfo.addUnit(antenna2);
            ETAInfo.addUnit(antenna3);
            ETAInfo.addUnit(antenna4);
            this.antennaManager.commission(ASCUInfo, ETAInfo);
        }
    }

    @Override
    public void hwInfoReceived(AscuHwInfo ascuHwInfo) {
        this.outputTextArea.append("HW info received. \n");
        this.outputTextArea.append(String.valueOf(ascuHwInfo.getAscuHwUnitInfos().toString()) + "\n");
    }

    @Override
    public void hwInfoReceiveFailed(int intFaultCode, String strFaultString) {
        this.outputTextArea.append("HW info receiving failed. \n");
        this.outputTextArea.append("Faultstring: " + strFaultString + ", Faultcode: " + intFaultCode + "\n");
    }

    @Override
    public void ascuCommissionDataReceived(AscuCommissionData CommissionData) {
        this.outputTextArea.append("ASCU commission data received. \n");
        this.outputTextArea.append(String.valueOf(CommissionData.toString()) + "\n");
    }

    @Override
    public void ascuCommissionDataReceiveFailed(int intFaultCode, String strFaultString) {
        this.outputTextArea.append("ASCU commission data receiving failed. \n");
        this.outputTextArea.append("Faultstring: " + strFaultString + ", Faultcode: " + intFaultCode + "\n");
    }

    @Override
    public void etaCommissionDataReceived(EtaCommissionData CommissionData) {
        this.outputTextArea.append("ETA commission data received. \n");
        this.outputTextArea.append(String.valueOf(CommissionData.toString()) + "\n");
    }

    @Override
    public void ascuStatus(String str) {
    }

    @Override
    public void etaCommissionDataReceiveFailed(int intFaultCode, String strFaultString) {
        this.outputTextArea.append("ETA commission data receiving failed. \n");
        this.outputTextArea.append("Faultstring: " + strFaultString + ", Faultcode: " + intFaultCode + "\n");
    }

    @Override
    public void swFilesUpdateStarted() {
        this.outputTextArea.append("SW files update started.\n");
    }

    @Override
    public void swFilesUpdated() {
        this.outputTextArea.append("SW failed updated.\n");
    }

    @Override
    public void swFilesUpdateFailed(int intFaultCode, String strFaultString) {
        this.outputTextArea.append("SW files update failed. \n");
        this.outputTextArea.append("Faultstring: " + strFaultString + ", Faultcode: " + intFaultCode + "\n");
    }

    @Override
    public void ascuCommissioned() {
        this.outputTextArea.append("ASCU commissioned. \n");
    }

    @Override
    public void alarmReceived(Alarm alarm) {
    }

    @Override
    public void ascuCommissioningFailed(int intFaultCode, String strFaultString) {
        this.outputTextArea.append("Commisioning failed. Fault string: " + strFaultString + ".\n");
        this.outputTextArea.append("Faultstring: " + strFaultString + ", Faultcode: " + intFaultCode + "\n");
    }

    @Override
    public void ascuConnected() {
        this.outputTextArea.append("ASCU connected. \n");
    }

    @Override
    public void ascuDisconnected() {
        this.outputTextArea.append("ASCU disconnected. \n");
    }

    @Override
    public void ascuConnectionFailed(int intFaultCode, String strFaultString) {
        this.outputTextArea.append("Connection failed. Fault string: " + strFaultString + ".\n");
    }

    @Override
    public void ascuDisconnectionFailed(int intFaultCode, String strFaultString) {
        this.outputTextArea.append("Disconnection failed. Fault string: " + strFaultString + ".\n");
    }

    @Override
    public void ascuConnectionDropped() {
        this.outputTextArea.append("Connection dropped. \n");
    }

    @Override
    public void ascuConnectionResumed() {
        this.outputTextArea.append("Connection resumed. \n");
    }

    @Override
    public void setTiltFailed(String strAntennaID, String strFaultCode, String strFaultString) {
        this.outputTextArea.append("Tilting for " + strAntennaID + " failed: " + strFaultString + ".\n");
    }

    @Override
    public void calibrationFailed(String strAntennaID, String strFaultCode, String strFaultString) {
        this.outputTextArea.append("Calibration of " + strAntennaID + " failed: " + strFaultString + ".\n");
    }

    @Override
    public void ascuError(int intFaultCode, String strFaultString) {
        this.outputTextArea.append("Ascu error:" + strFaultString + "\n");
    }

    @Override
    public void etaError(int intFaultCode, String strFaultString) {
        this.outputTextArea.append("Eta error:" + strFaultString + "\n");
    }

    @Override
    public void setTiltReady(String strAntennaID) {
        this.outputTextArea.append("Antenna tilt for antenna " + strAntennaID + " ready.\n");
    }

    @Override
    public void calibrationReady(String strAntennaID) {
        this.outputTextArea.append("Calibration of antenna " + strAntennaID + " ready.\n");
    }

    @Override
    public void swInfoReceived(AscuSwInfo ascuSwInfo) {
        this.outputTextArea.append("SW info received. \n");
        this.outputTextArea.append(String.valueOf(ascuSwInfo.getAscuUnitSwInfos().toString()) + "\n");
    }

    @Override
    public void swInfoReceiveFailed(int intFaultCode, String strFaultString) {
        this.outputTextArea.append("SW info receiving failed error:" + strFaultString + "\n");
    }

    private void initData() {
        this.antennaManager = new AntennaConfigurationManagerImpl("localhost", "61011");
        this.antennaManager.addAntennaConfigListener(this);
        Vector<String> methods = new Vector<String>();
        methods.addElement("connect");
        methods.addElement("disconnect");
        methods.addElement("commission");
        methods.addElement("commissionNew");
        methods.addElement("getSerialNumber");
        methods.addElement("getInServiceTime");
        methods.addElement("getErrorStatus");
        methods.addElement("getDateTime");
        methods.addElement("setDateTime");
        methods.addElement("getTilt");
        methods.addElement("setTilt");
        methods.addElement("selfTest");
        methods.addElement("getAntennaTypes");
        methods.addElement("getCommissionData");
        methods.addElement("getHwInfo");
        methods.addElement("getSwInfo");
        methods.addElement("getStatus");
        methods.addElement("clearErrorStatus");
        methods.addElement("calibrate");
        methods.addElement("reset");
        methods.addElement("reboot");
        methods.addElement("updateFiles");
        methods.addElement("subscribeNotifications");
        methods.addElement("unsubscribeNotifications");
        methods.addElement("setPollingInterval(1s)");
        methods.addElement("setPollingInterval(10s)");
        methods.addElement("setPollingInterval(100s)");
        methods.addElement("setPollingInterval(1000s)");
        methods.addElement("setStatusOK");
        methods.addElement("setStatusBUSY");
        methods.addElement("setStatusFAILED");
        methods.addElement("getSome");
        this.methodList = new JList(methods);
    }

    private void jbInit() throws Exception {
        this.setSize(new Dimension(470, 320));
        this.setTitle("XMLRPC Demo");
        this.getContentPane().setLayout(this.mainBorderLayout);
        this.leftPanel.setBorder(BorderFactory.createCompoundBorder(new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(134, 134, 134)), "Remote Methods"), BorderFactory.createEmptyBorder(0, 4, 10, 4)));
        this.leftPanel.setPreferredSize(new Dimension(185, 10));
        this.leftPanel.setLayout(this.leftBorderLayout);
        this.rightPanel.setLayout(this.rightBorderLayout);
        this.buttonPanel.setPreferredSize(new Dimension(10, 60));
        this.buttonPanel.setLayout(this.buttonFlowLayout);
        this.executeButton.setText("Execute");
        this.executeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AntennaClient.this.executeButton_actionPerformed();
            }
        });
        this.buttonFlowLayout.setAlignment(0);
        this.buttonFlowLayout.setVgap(10);
        this.outputPanel.setLayout(this.outputBorderLayout);
        this.outputPanel.setBorder(BorderFactory.createCompoundBorder(new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(134, 134, 134)), "Output"), BorderFactory.createEmptyBorder(0, 10, 10, 10)));
        this.setDefaultCloseOperation(3);
        this.methodScrollPane.setPreferredSize(new Dimension(140, 132));
        this.methodList.setSelectionMode(0);
        this.getContentPane().add((Component)this.leftPanel, "West");
        this.leftPanel.add((Component)this.methodScrollPane, "Center");
        this.methodScrollPane.getViewport().add((Component)this.methodList, null);
        this.getContentPane().add((Component)this.rightPanel, "Center");
        this.rightPanel.add((Component)this.buttonPanel, "North");
        this.buttonPanel.add((Component)this.executeButton, null);
        this.rightPanel.add((Component)this.outputPanel, "Center");
        this.outputPanel.add((Component)this.outputScrollPane, "Center");
        this.outputScrollPane.getViewport().add((Component)this.outputTextArea, null);
        this.setVisible(true);
    }
}

