/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.ascu;

import com.nokia.em.bts.coreasset.ascu.ASCUConnectionWatcher;
import com.nokia.em.bts.coreasset.ascu.Antenna;
import com.nokia.em.bts.coreasset.ascu.AntennaCalibrationHandler;
import com.nokia.em.bts.coreasset.ascu.AntennaConfigListener;
import com.nokia.em.bts.coreasset.ascu.AntennaConfigurationManager;
import com.nokia.em.bts.coreasset.ascu.AntennaImpl;
import com.nokia.em.bts.coreasset.ascu.AntennaUpdateFilesHandler;
import com.nokia.em.bts.coreasset.ascu.AscuCommissionData;
import com.nokia.em.bts.coreasset.ascu.AscuStatusPoller;
import com.nokia.em.bts.coreasset.ascu.AscuSwInfo;
import com.nokia.em.bts.coreasset.ascu.EtaCommissionData;
import com.nokia.em.bts.coreasset.ascu.FTPTransferData;
import com.nokia.em.bts.rp.master.alarm.Alarm;
import com.nokia.em.bts.rp.master.alarm.AlarmAdditionalInformation;
import com.nokia.em.bts.rp.master.tool.CoreAssetThread;
import com.nokia.em.poseidon.comm.http.Tools;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.apache.xmlrpc.AsyncCallback;
import org.apache.xmlrpc.WebServer;
import org.apache.xmlrpc.XmlRpcClient;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.XmlRpcHandler;

public class AntennaConfigurationManagerImpl
implements AntennaConfigurationManager {
    public static final int IN_SERVICE_TIME_NUMBER_FORMAT_EXCEPTION = -1;
    public static final int IN_SERVICE_TIME_OTHER_EXCEPTION = -2;
    public static final float TILT_NUMBER_FORMAT_EXCEPTION = -1.0f;
    public static final float TILT_OTHER_EXCEPTION = -2.0f;
    private String myServerUrl = "http://localhost:8080";
    private String myASCU_IPAddress = "";
    private String myASCU_ServerPort = "";
    private Vector myAntennas = new Vector();
    private Vector myAntennaConfigListeners = new Vector();
    private WebServer myAlarmServer = null;
    private XmlRpcClient myXmlRpcClient = null;
    private AscuStatusPoller myAscuStatusPoller = null;
    private boolean myBlnConnected = false;
    private ASCUConnectionWatcher myAscuConnectionWatcher = null;
    private String myASCU_URLTail = "";
    private static final int CONNECTION_WATCHER_POLLING_INTERVAL = 15000;
    private Logger myLogger = Logger.getLogger(this.getClass());

    public AntennaConfigurationManagerImpl() {
        this("", "", "");
    }

    public AntennaConfigurationManagerImpl(String strASCU_IPAddress, String strASCU_ServerPort) {
        this(strASCU_IPAddress, strASCU_ServerPort, "/RPC");
    }

    public AntennaConfigurationManagerImpl(String strASCU_IPAddress, String strASCU_ServerPort, String strASCU_URLTail) {
        if (!"".equals(strASCU_IPAddress)) {
            this.myASCU_IPAddress = strASCU_IPAddress;
        }
        if (!"".equals(strASCU_ServerPort)) {
            this.myASCU_ServerPort = strASCU_ServerPort;
        }
        if (strASCU_URLTail != null) {
            this.myASCU_URLTail = strASCU_URLTail;
        }
    }

    public String getASCU_IPAddress() {
        return this.myASCU_IPAddress;
    }

    public void setASCU_IPAddress(String strASCU_IPAddress) {
        this.myASCU_IPAddress = strASCU_IPAddress;
    }

    public String getASCU_URL() {
        return this.myServerUrl;
    }

    public void setASCU_URL(String strURL) {
        if (!this.myBlnConnected) {
            this.myASCU_IPAddress = strURL;
        }
    }

    public String getASCU_Port() {
        return this.myASCU_ServerPort;
    }

    public void setASCU_Port(String strPort) {
        if (!this.myBlnConnected) {
            this.myASCU_ServerPort = strPort;
        }
    }

    void setXmlRpcClient(XmlRpcClient xmlRpcClient) {
        this.myXmlRpcClient = xmlRpcClient;
    }

    protected boolean isConnected() {
        return this.myBlnConnected;
    }

    protected void ascuConnectionDropped() {
        int i = 0;
        while (i < this.myAntennaConfigListeners.size()) {
            ((AntennaConfigListener)this.myAntennaConfigListeners.elementAt(i)).ascuConnectionDropped();
            ++i;
        }
    }

    protected void ascuConnectionResumed() {
        int i = 0;
        while (i < this.myAntennaConfigListeners.size()) {
            ((AntennaConfigListener)this.myAntennaConfigListeners.elementAt(i)).ascuConnectionResumed();
            ++i;
        }
    }

    /*
     * Exception decompiling
     */
    private void commission(Hashtable hshtASCUParams, Vector vecAntennaParams) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [9[DOLOOP]], but top level block is 10[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean commission(Vector vecAntennaParams) {
        this.myLogger.info((Object)"Start to commission ETA");
        Vector<Vector> params = new Vector<Vector>();
        params.addElement(vecAntennaParams);
        this.updateAntennaVector(vecAntennaParams);
        boolean blnReturnValue = false;
        try {
            this.myLogger.info((Object)("out > Sending eta.commission with parameters: " + params));
            Object response = this.myXmlRpcClient.execute("eta.commission", params);
            this.myLogger.info((Object)("in > Gets reponse of eta.commission: " + response));
            if ("OK".equalsIgnoreCase(response.toString())) {
                blnReturnValue = true;
            } else {
                blnReturnValue = false;
                this.myLogger.error((Object)"Unrecognized response.");
            }
        }
        catch (XmlRpcException exception) {
            blnReturnValue = false;
            this.myLogger.error((Object)("XML-RPC Fault #" + Integer.toString(exception.code) + ":  "), (Throwable)exception);
        }
        catch (Exception exception) {
            this.myLogger.error((Object)exception);
        }
        return blnReturnValue;
    }

    private boolean commission(Hashtable hshtASCUParams) {
        this.myLogger.info((Object)"Starts to commission ASCU");
        Vector<Hashtable> params = new Vector<Hashtable>(10);
        params.addElement(hshtASCUParams);
        boolean blnReturnValue = false;
        try {
            this.myLogger.info((Object)("out > sending ascu.commission with parameters: " + params));
            Object response = this.myXmlRpcClient.execute("ascu.commission", params);
            this.myLogger.info((Object)("in > Gets response of ascu.commission: " + response));
            if (response instanceof Hashtable) {
                blnReturnValue = !this.checkForFaultCode((Hashtable)response);
            } else if ("OK".equalsIgnoreCase(response.toString())) {
                blnReturnValue = true;
            } else {
                blnReturnValue = false;
                this.myLogger.error((Object)"Unrecognized response.");
            }
        }
        catch (XmlRpcException exception) {
            this.myLogger.error((Object)(" XML-RPC Fault #" + Integer.toString(exception.code) + ": "), (Throwable)exception);
        }
        catch (Exception exception) {
            this.myLogger.error((Object)exception);
        }
        return blnReturnValue;
    }

    /*
     * Unable to fully structure code
     */
    private void updateFiles(Hashtable hshtFtpParams, Hashtable hshtPackageParams, Vector vecFilesParams) {
        block3: {
            params = new Vector<Cloneable>(10);
            try {
                strHost = this.getLocalHost();
                hshtFtpParams.put("ServerAddress", strHost);
                params.addElement(hshtFtpParams);
                params.addElement(hshtPackageParams);
                params.addElement(vecFilesParams);
                this.myXmlRpcClient.executeAsync("ascu.updateFiles", params, (AsyncCallback)new AntennaUpdateFilesHandler(this.myAntennaConfigListeners));
                break block3;
            }
            catch (Exception fte) {
                this.myLogger.error((Object)fte);
                i = 0;
                ** while (i < this.myAntennaConfigListeners.size())
            }
lbl-1000:
            // 1 sources

            {
                ((AntennaConfigListener)this.myAntennaConfigListeners.elementAt(i)).swFilesUpdateFailed(-1, fte.toString());
                ++i;
                continue;
            }
        }
    }

    private String getLocalHost() throws UnknownHostException {
        InetAddress address;
        try {
            Socket socket = new Socket(this.myASCU_IPAddress, Integer.parseInt(this.myASCU_ServerPort));
            address = socket.getLocalAddress();
            socket.close();
        }
        catch (Exception e) {
            this.myLogger.error((Object)e);
            address = InetAddress.getLocalHost();
        }
        return address.getHostAddress();
    }

    private boolean checkForFaultCode(Hashtable hshtResponse) {
        return hshtResponse.containsKey("faultCode");
    }

    private void updateHwInfo(Vector vecHwInfo) {
        try {
            Enumeration e = vecHwInfo.elements();
            while (e.hasMoreElements()) {
                Hashtable hwInfo = (Hashtable)e.nextElement();
                String hwSerialNumber = (String)hwInfo.get("HwSerialNumber");
                String hwVersion = (String)hwInfo.get("HwVersion");
                int i = 0;
                while (i < this.myAntennas.size()) {
                    AntennaImpl antenna = (AntennaImpl)this.myAntennas.get(i);
                    if (antenna.getSerialNumber().equalsIgnoreCase(hwSerialNumber)) {
                        antenna.setHwVersion(hwVersion);
                    }
                    ++i;
                }
            }
        }
        catch (Exception e) {
            this.myLogger.error((Object)e);
        }
    }

    private void updateAntennaVector(Vector vecAntennaParams) {
        String antennaId = "";
        String antennaType = "";
        String antennaSerialNumber = "";
        String LCRId = "";
        this.myAntennas.clear();
        try {
            int i = 0;
            while (i < vecAntennaParams.size()) {
                antennaId = (String)((Hashtable)vecAntennaParams.elementAt(i)).get("AntennaId");
                antennaType = (String)((Hashtable)vecAntennaParams.elementAt(i)).get("AntennaType");
                antennaSerialNumber = (String)((Hashtable)vecAntennaParams.elementAt(i)).get("AntennaSerialNumber");
                Integer antennaMinTilt = (Integer)((Hashtable)vecAntennaParams.elementAt(i)).get("AntennaMinTilt");
                Integer antennaMaxTilt = (Integer)((Hashtable)vecAntennaParams.elementAt(i)).get("AntennaMaxTilt");
                LCRId = (String)((Hashtable)vecAntennaParams.elementAt(i)).get("LCRId");
                this.myAntennas.addElement(new AntennaImpl(antennaId, antennaType, antennaSerialNumber, antennaMinTilt.intValue(), antennaMaxTilt.intValue(), LCRId));
                ++i;
            }
        }
        catch (Exception e) {
            this.myLogger.error((Object)e);
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void commission(AscuCommissionData ascuCommissionData, EtaCommissionData etaCommissionData) {
        block6: {
            if (ascuCommissionData != null && etaCommissionData != null) {
                ascuDataHashtable = new Hashtable<String, String>();
                antennaDataVector = new Vector<Hashtable<K, V>>();
                try {
                    ascuDataHashtable.put("ASCU_Name", ascuCommissionData.getASCU_Name());
                    ascuDataHashtable.put("ASCU_IPAddress", ascuCommissionData.getASCU_IPAddress());
                    ascuDataHashtable.put("ASCU_IPGateway", ascuCommissionData.getASCU_IPGateway());
                    ascuDataHashtable.put("ASCU_IPSubnetMask", ascuCommissionData.getASCU_IPSubnetMask());
                    ascuDataHashtable.put("ASCU_MACAddress", ascuCommissionData.getASCU_MACAddress());
                    ascuDataHashtable.put("ASCU_UserDefinedInUse", ascuCommissionData.getASCU_UserDefinedInUse());
                    i = 0;
                    while (i < etaCommissionData.getUnitAmount()) {
                        currentEta = etaCommissionData.getEta(i);
                        currentEtaHashtable = new Hashtable<String, Object>();
                        currentEtaHashtable.put("AntennaId", currentEta.getAntennaId());
                        currentEtaHashtable.put("AntennaType", currentEta.getAntennaType());
                        currentEtaHashtable.put("AntennaSerialNumber", currentEta.getAntennaSerialNumber());
                        currentEtaHashtable.put("AntennaMinTilt", (int)(currentEta.getAntennaMinTilt() * 10.0f));
                        currentEtaHashtable.put("AntennaMaxTilt", (int)(currentEta.getAntennaMaxTilt() * 10.0f));
                        currentEtaHashtable.put("LCRId", currentEta.getLCRId());
                        antennaDataVector.addElement(currentEtaHashtable);
                        ++i;
                    }
                    this.commission(ascuDataHashtable, antennaDataVector);
                    break block6;
                }
                catch (Exception exception) {
                    i = 0;
                    ** while (i < this.myAntennaConfigListeners.size())
                }
lbl-1000:
                // 1 sources

                {
                    ((AntennaConfigListener)this.myAntennaConfigListeners.elementAt(i)).ascuCommissioningFailed(-1, exception.toString());
                    ++i;
                    continue;
lbl44:
                    // 1 sources

                    break block6;
                }
            }
            i = 0;
            while (i < this.myAntennaConfigListeners.size()) {
                ((AntennaConfigListener)this.myAntennaConfigListeners.elementAt(i)).ascuCommissioningFailed(-1, "ASCU commission failed");
                ++i;
            }
        }
    }

    @Override
    public Vector getSerialNumber(String strEta) {
        Vector<String> params = new Vector<String>();
        params.addElement(strEta);
        Vector vecReturnValue = new Vector();
        try {
            Object response = this.myXmlRpcClient.execute("eta.getSerialNumber", params);
            vecReturnValue = (Vector)response;
        }
        catch (XmlRpcException exception) {
            this.myLogger.error((Object)("XML-RPC Fault #" + Integer.toString(exception.code) + ": "), (Throwable)exception);
        }
        catch (Exception exception) {
            this.myLogger.error((Object)exception);
        }
        return vecReturnValue;
    }

    @Override
    public Vector getSerialNumbers() {
        Vector<String> params = new Vector<String>();
        params.addElement("");
        Vector vecReturnValue = new Vector();
        try {
            Object response = this.myXmlRpcClient.execute("eta.getSerialNumber", params);
            vecReturnValue = (Vector)response;
        }
        catch (XmlRpcException exception) {
            this.myLogger.error((Object)("XML-RPC Fault #" + Integer.toString(exception.code) + ": "), (Throwable)exception);
        }
        catch (Exception exception) {
            this.myLogger.error((Object)exception);
        }
        return vecReturnValue;
    }

    @Override
    public String subscribeNotifications(int intPort, AntennaConfigListener listener) {
        if (!this.myAntennaConfigListeners.contains(listener)) {
            this.myAntennaConfigListeners.addElement(listener);
        }
        Hashtable<String, Integer> subscriptionParams = new Hashtable<String, Integer>();
        subscriptionParams.put("TcpPort", intPort);
        Vector<Hashtable<String, Integer>> params = new Vector<Hashtable<String, Integer>>();
        params.addElement(subscriptionParams);
        String strReturnValue = "";
        try {
            if (this.myAlarmServer == null) {
                this.myAlarmServer = new WebServer(intPort);
                this.myAlarmServer.addHandler("omc", (Object)this);
            }
            Object response = this.myXmlRpcClient.execute("ascu.subscribeNotifications", params);
            strReturnValue = response.toString();
        }
        catch (XmlRpcException exception) {
            this.myLogger.error((Object)("XML-RPC Fault #" + Integer.toString(exception.code) + ": "), (Throwable)exception);
            strReturnValue = exception.toString();
        }
        catch (Exception exception) {
            this.myLogger.error((Object)exception);
            strReturnValue = exception.toString();
        }
        return strReturnValue;
    }

    @Override
    public String unsubscribeNotifications() {
        String strReturnValue = "";
        try {
            Object response = this.myXmlRpcClient.execute("ascu.unsubscribeNotifications", new Vector());
            strReturnValue = response.toString();
        }
        catch (XmlRpcException exception) {
            this.myLogger.error((Object)("XML-RPC Fault #" + Integer.toString(exception.code) + ": "), (Throwable)exception);
        }
        catch (Exception exception) {
            this.myLogger.error((Object)exception);
        }
        return strReturnValue;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void updateFiles(FTPTransferData ftpTransferData, AscuSwInfo ascuSwInfo) {
        block6: {
            if (ftpTransferData != null && ascuSwInfo != null) {
                ftpTransferDataHashtable = new Hashtable<String, Object>();
                ascuSwInfoHashtable = new Hashtable<String, String>();
                swInfoVector = new Vector<Hashtable<K, V>>();
                try {
                    ascuSwInfoHashtable.put("SoftwareReleaseVersion", ascuSwInfo.getBuildDescriptorId());
                    ascuSwInfoHashtable.put("BuildDescriptorId", ascuSwInfo.getSoftwareReleaseVersion());
                    ftpTransferDataHashtable.put("ServerAddress", ftpTransferData.getServerAddress());
                    ftpTransferDataHashtable.put("UserName", ftpTransferData.getUserName());
                    ftpTransferDataHashtable.put("Password", ftpTransferData.getPassword());
                    ftpTransferDataHashtable.put("FtpPort", ftpTransferData.getFtpPort());
                    i = 0;
                    while (i < ascuSwInfo.getAscuUnitAmount()) {
                        currentUnit = ascuSwInfo.getUnitSwInfo(i);
                        currentUnitHashtable = new Hashtable<String, Object>();
                        currentUnitHashtable.put("Name", currentUnit.getFileName());
                        currentUnitHashtable.put("Path", currentUnit.getSwPath());
                        currentUnitHashtable.put("Version", currentUnit.getSwVersion());
                        currentUnitHashtable.put("HwUnit", currentUnit.getFileType());
                        currentUnitHashtable.put("NumberOfBlocks", currentUnit.getNumberOfBlocks());
                        currentUnitHashtable.put("CheckSum", currentUnit.getFileCheckSum());
                        swInfoVector.addElement(currentUnitHashtable);
                        ++i;
                    }
                    this.updateFiles(ftpTransferDataHashtable, ascuSwInfoHashtable, swInfoVector);
                    break block6;
                }
                catch (Exception exception) {
                    i = 0;
                    ** while (i < this.myAntennaConfigListeners.size())
                }
lbl-1000:
                // 1 sources

                {
                    ((AntennaConfigListener)this.myAntennaConfigListeners.elementAt(i)).swFilesUpdateFailed(-1, exception.toString());
                    ++i;
                    continue;
lbl45:
                    // 1 sources

                    break block6;
                }
            }
            i = 0;
            while (i < this.myAntennaConfigListeners.size()) {
                ((AntennaConfigListener)this.myAntennaConfigListeners.elementAt(i)).swFilesUpdateFailed(-1, "File update failed");
                ++i;
            }
        }
    }

    @Override
    public Vector getErrorStatuses() {
        Vector vecReturnValue = new Vector();
        try {
            Object response = this.myXmlRpcClient.execute("ascu.getErrorStatus", new Vector());
            vecReturnValue = (Vector)response;
        }
        catch (XmlRpcException exception) {
            this.myLogger.error((Object)("XML-RPC Fault #" + Integer.toString(exception.code) + ": "), (Throwable)exception);
        }
        catch (Exception exception) {
            this.myLogger.error((Object)exception);
        }
        this.myLogger.debug((Object)("Response for ascu.getErrorStatus: " + vecReturnValue));
        return vecReturnValue;
    }

    @Override
    public void calibrate(String strAntennaId) {
        Vector<String> params = new Vector<String>();
        params.addElement(strAntennaId);
        try {
            this.myXmlRpcClient.executeAsync("eta.calibrate", params, (AsyncCallback)new AntennaCalibrationHandler(strAntennaId, this.myAntennaConfigListeners, (XmlRpcHandler)this.myXmlRpcClient));
        }
        catch (Exception exception) {
            this.myLogger.error((Object)exception);
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public String clearErrorStatus(String strDeviceId) {
        block4: {
            params = new Vector<String>();
            params.addElement(strDeviceId);
            strReturnValue = "";
            try {
                response = this.myXmlRpcClient.execute("eta.clearErrorStatus", params);
                strReturnValue = response.toString();
            }
            catch (XmlRpcException exception) {
                this.myLogger.error((Object)("XML-RPC Fault #" + Integer.toString(exception.code) + ": "), (Throwable)exception);
                i = 0;
                ** while (i < this.myAntennaConfigListeners.size())
            }
lbl-1000:
            // 1 sources

            {
                ((AntennaConfigListener)this.myAntennaConfigListeners.elementAt(i)).ascuError(exception.code, exception.toString());
                ++i;
                continue;
lbl15:
                // 1 sources

                break block4;
            }
            catch (Exception exception) {
                this.myLogger.error((Object)exception);
            }
        }
        return strReturnValue;
    }

    @Override
    public String reset() {
        String strReturnValue = "";
        try {
            Object response = this.myXmlRpcClient.execute("eta.reset", new Vector());
            strReturnValue = response.toString();
        }
        catch (XmlRpcException exception) {
            this.myLogger.error((Object)("XML-RPC Fault #" + Integer.toString(exception.code) + ": "), (Throwable)exception);
        }
        catch (Exception exception) {
            this.myLogger.error((Object)exception);
        }
        return strReturnValue;
    }

    @Override
    public String reboot() {
        String strReturnValue = "";
        try {
            this.myLogger.info((Object)"Start to reboot, sending ascu.reboot");
            Object response = this.myXmlRpcClient.execute("ascu.reboot", new Vector());
            strReturnValue = response.toString();
            this.myLogger.debug((Object)("Get response of ascu.reboot: " + strReturnValue));
        }
        catch (XmlRpcException exception) {
            this.myLogger.error((Object)("XML-RPC Fault #" + Integer.toString(exception.code)), (Throwable)exception);
        }
        catch (Exception exception) {
            this.myLogger.error((Object)exception);
        }
        return strReturnValue;
    }

    @Override
    public int getInServiceTime() {
        int intReturnValue = -2;
        try {
            Object response = this.myXmlRpcClient.execute("ascu.getInServiceTime", new Vector());
            intReturnValue = Integer.parseInt(response.toString());
        }
        catch (XmlRpcException exception) {
            this.myLogger.error((Object)("XML-RPC Fault #" + Integer.toString(exception.code) + ": "), (Throwable)exception);
        }
        catch (NumberFormatException exception) {
            this.myLogger.error((Object)"Return value is not integer!", (Throwable)exception);
            intReturnValue = -1;
        }
        catch (Exception exception) {
            this.myLogger.error((Object)"Failed to get server time: ", (Throwable)exception);
        }
        return intReturnValue;
    }

    /*
     * Exception decompiling
     */
    @Override
    public float getTilt(String strAntennaId) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [10[DOLOOP]], but top level block is 11[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public float setTilt(String strAntennaId, float fAntennaTilt) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[DOLOOP]], but top level block is 9[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public Date getDateTime() {
        block4: {
            dateReturnValue = new Date(0L);
            try {
                response = this.myXmlRpcClient.execute("ascu.getDateTime", new Vector<E>());
                this.myLogger.info((Object)("in > " + response.toString()));
                dateReturnValue = (Date)response;
            }
            catch (XmlRpcException exception) {
                this.myLogger.error((Object)("XML-RPC Fault #" + Integer.toString(exception.code) + ": "), (Throwable)exception);
                i = 0;
                ** while (i < this.myAntennaConfigListeners.size())
            }
lbl-1000:
            // 1 sources

            {
                ((AntennaConfigListener)this.myAntennaConfigListeners.elementAt(i)).ascuError(exception.code, exception.toString());
                ++i;
                continue;
lbl14:
                // 1 sources

                break block4;
            }
            catch (Exception exception) {
                this.myLogger.error((Object)exception);
            }
        }
        return dateReturnValue;
    }

    @Override
    public String setDateTime(Date dateTime) {
        Vector<Date> params = new Vector<Date>();
        params.addElement(dateTime);
        String strReturnValue = "";
        try {
            Object response = this.myXmlRpcClient.execute("ascu.setDateTime", params);
            this.myLogger.error((Object)("in > " + response.toString()));
            strReturnValue = response.toString();
        }
        catch (XmlRpcException exception) {
            this.myLogger.error((Object)("XML-RPC Fault #" + Integer.toString(exception.code) + ": "), (Throwable)exception);
        }
        catch (Exception exception) {
            this.myLogger.error((Object)exception);
        }
        return strReturnValue;
    }

    @Override
    public Vector selfTest() {
        Vector vecReturnValue = new Vector();
        try {
            Object response = this.myXmlRpcClient.execute("ascu.selfTest", new Vector());
            this.myLogger.error((Object)("in > " + response.toString()));
            vecReturnValue = (Vector)response;
        }
        catch (XmlRpcException exception) {
            this.myLogger.error((Object)("XML-RPC Fault #" + Integer.toString(exception.code) + ": "), (Throwable)exception);
        }
        catch (Exception exception) {
            this.myLogger.error((Object)exception);
        }
        return vecReturnValue;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public Vector getAntennaTypes(String strAntennaType) {
        block4: {
            params = new Vector<String>();
            params.addElement(strAntennaType);
            vecReturnValue = new Vector();
            try {
                response = this.myXmlRpcClient.execute("eta.getType", params);
                this.myLogger.error((Object)("in > " + response.toString()));
                vecReturnValue = (Vector)response;
            }
            catch (XmlRpcException exception) {
                this.myLogger.error((Object)("XML-RPC Fault #" + Integer.toString(exception.code) + ": "), (Throwable)exception);
                i = 0;
                ** while (i < this.myAntennaConfigListeners.size())
            }
lbl-1000:
            // 1 sources

            {
                ((AntennaConfigListener)this.myAntennaConfigListeners.elementAt(i)).etaError(exception.code, exception.toString());
                ++i;
                continue;
lbl16:
                // 1 sources

                break block4;
            }
            catch (Exception exception) {
                this.myLogger.error((Object)exception);
            }
        }
        return vecReturnValue;
    }

    /*
     * Exception decompiling
     */
    @Override
    public void getHwInfo() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [9[DOLOOP]], but top level block is 10[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public void getSwInfo() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [9[DOLOOP]], but top level block is 10[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public String getAscuStatus() {
        String strStatus = "";
        try {
            Object response = this.myXmlRpcClient.execute("ascu.getStatus", new Vector());
            this.myLogger.error((Object)("in > " + response.toString()));
            strStatus = response.toString();
        }
        catch (XmlRpcException exception) {
            this.myLogger.error((Object)("XML-RPC Fault #" + Integer.toString(exception.code) + ": "), (Throwable)exception);
        }
        catch (Exception exception) {
            this.myLogger.error((Object)exception);
        }
        return strStatus;
    }

    @Override
    public void pollAscuStatus(String strStatusToEndPoll) {
        if (this.myAscuStatusPoller != null) {
            this.myAscuStatusPoller.safeStop();
        }
        this.myAscuStatusPoller = new AscuStatusPoller(strStatusToEndPoll, this.myAntennaConfigListeners, this.myXmlRpcClient);
        this.myAscuStatusPoller.start();
    }

    @Override
    public void stopAscuStatusPoller() {
        if (this.myAscuStatusPoller != null) {
            this.myAscuStatusPoller.safeStop();
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public Vector getStatus(String strEta) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [9[DOLOOP]], but top level block is 10[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public void getCommissionData() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[DOLOOP]], but top level block is 9[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Unable to fully structure code
     */
    private Hashtable getAscuCommissionData() {
        block4: {
            hstbReturnValue = new Hashtable();
            try {
                response = this.myXmlRpcClient.execute("ascu.getCommissionData", new Vector<E>());
                this.myLogger.error((Object)("in > " + response.toString()));
                hstbReturnValue = (Hashtable)response;
            }
            catch (XmlRpcException exception) {
                this.myLogger.error((Object)("XML-RPC Fault #" + Integer.toString(exception.code) + ": "), (Throwable)exception);
                i = 0;
                ** while (i < this.myAntennaConfigListeners.size())
            }
lbl-1000:
            // 1 sources

            {
                ((AntennaConfigListener)this.myAntennaConfigListeners.elementAt(i)).ascuError(exception.code, exception.toString());
                ++i;
                continue;
            }
lbl14:
            // 1 sources

            hstbReturnValue.put("faultCode", 0);
            break block4;
            catch (Exception exception) {
                this.myLogger.error((Object)exception.toString());
            }
        }
        return hstbReturnValue;
    }

    /*
     * Unable to fully structure code
     */
    private Vector getEtaCommissionData() {
        block4: {
            vecReturnValue = new Vector();
            try {
                response = this.myXmlRpcClient.execute("eta.getCommissionData", new Vector<E>());
                this.myLogger.error((Object)("in > " + response.toString()));
                vecReturnValue = (Vector)response;
            }
            catch (XmlRpcException exception) {
                this.myLogger.error((Object)("XML-RPC Fault #" + Integer.toString(exception.code) + ": "), (Throwable)exception);
                i = 0;
                ** while (i < this.myAntennaConfigListeners.size())
            }
lbl-1000:
            // 1 sources

            {
                ((AntennaConfigListener)this.myAntennaConfigListeners.elementAt(i)).ascuError(exception.code, exception.toString());
                ++i;
                continue;
lbl14:
                // 1 sources

                break block4;
            }
            catch (Exception exception) {
                this.myLogger.error((Object)exception);
            }
        }
        return vecReturnValue;
    }

    @Override
    public Vector getHashtableAntennas() {
        Vector<Hashtable> hashtableAntennas = new Vector<Hashtable>();
        Enumeration e = this.myAntennas.elements();
        while (e.hasMoreElements()) {
            AntennaImpl antenna = (AntennaImpl)e.nextElement();
            hashtableAntennas.addElement(antenna.getHashtablePresentation());
        }
        return hashtableAntennas;
    }

    public void setAntennas(Vector vecAntennas) {
        this.myAntennas = vecAntennas;
    }

    public void setDebug(boolean blnDebug) {
    }

    public void setServerUrl(String strServerUrl) {
        this.myServerUrl = strServerUrl;
    }

    @Override
    public Antenna getAntenna(String strAntennaId) {
        Antenna antenna = null;
        Enumeration e = this.myAntennas.elements();
        while (e.hasMoreElements()) {
            antenna = (Antenna)e.nextElement();
            if (!strAntennaId.equals(antenna.getAntennaId())) continue;
            return antenna;
        }
        return null;
    }

    @Override
    public void addAntennaConfigListener(AntennaConfigListener antennaConfigListener) {
        if (!this.myAntennaConfigListeners.contains(antennaConfigListener)) {
            this.myAntennaConfigListeners.addElement(antennaConfigListener);
        }
    }

    @Override
    public void removeAntennaConfigListener(AntennaConfigListener antennaConfigListener) {
        if (this.myAntennaConfigListeners.contains(antennaConfigListener)) {
            this.myAntennaConfigListeners.remove(antennaConfigListener);
        }
    }

    @Override
    public Vector getAntennas() {
        return this.myAntennas;
    }

    @Override
    public void connect() {
        CoreAssetThread worker = new CoreAssetThread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            protected Object construct() throws Exception {
                var1_1 = AntennaConfigurationManagerImpl.this;
                synchronized (var1_1) {
                    block12: {
                        AntennaConfigurationManagerImpl.access$3(AntennaConfigurationManagerImpl.this, Tools.getURLAsString((String)"http", (String)AntennaConfigurationManagerImpl.access$0(AntennaConfigurationManagerImpl.this), (int)Integer.parseInt(AntennaConfigurationManagerImpl.access$1(AntennaConfigurationManagerImpl.this)), (String)AntennaConfigurationManagerImpl.access$2(AntennaConfigurationManagerImpl.this)));
                        if (!AntennaConfigurationManagerImpl.access$4(AntennaConfigurationManagerImpl.this)) {
                            try {
                                AntennaConfigurationManagerImpl.access$5(AntennaConfigurationManagerImpl.this, null);
                                AntennaConfigurationManagerImpl.access$5(AntennaConfigurationManagerImpl.this, new XmlRpcClient(AntennaConfigurationManagerImpl.access$6(AntennaConfigurationManagerImpl.this)));
                                time = AntennaConfigurationManagerImpl.this.getInServiceTime();
                                if (time >= 0) {
                                    AntennaConfigurationManagerImpl.access$7(AntennaConfigurationManagerImpl.this, true);
                                    if (AntennaConfigurationManagerImpl.access$8(AntennaConfigurationManagerImpl.this) != null) {
                                        AntennaConfigurationManagerImpl.access$8(AntennaConfigurationManagerImpl.this).interrupt();
                                    }
                                    AntennaConfigurationManagerImpl.access$10(AntennaConfigurationManagerImpl.this, new ASCUConnectionWatcher(AntennaConfigurationManagerImpl.this, AntennaConfigurationManagerImpl.access$9(AntennaConfigurationManagerImpl.this), 15000));
                                    AntennaConfigurationManagerImpl.access$8(AntennaConfigurationManagerImpl.this).start();
                                    i = 0;
                                    while (i < AntennaConfigurationManagerImpl.access$11(AntennaConfigurationManagerImpl.this).size()) {
                                        ((AntennaConfigListener)AntennaConfigurationManagerImpl.access$11(AntennaConfigurationManagerImpl.this).elementAt(i)).ascuConnected();
                                        ++i;
                                    }
                                } else {
                                    i = 0;
                                    while (i < AntennaConfigurationManagerImpl.access$11(AntennaConfigurationManagerImpl.this).size()) {
                                        ((AntennaConfigListener)AntennaConfigurationManagerImpl.access$11(AntennaConfigurationManagerImpl.this).elementAt(i)).ascuConnectionFailed(-1, "XML RPC client instantiation failed");
                                        ++i;
                                    }
                                }
                                break block12;
                            }
                            catch (Exception exc) {
                                AntennaConfigurationManagerImpl.access$12(AntennaConfigurationManagerImpl.this).error((Object)exc);
                                i = 0;
                                ** while (i < AntennaConfigurationManagerImpl.access$11((AntennaConfigurationManagerImpl)AntennaConfigurationManagerImpl.this).size())
                            }
lbl-1000:
                            // 1 sources

                            {
                                ((AntennaConfigListener)AntennaConfigurationManagerImpl.access$11(AntennaConfigurationManagerImpl.this).elementAt(i)).ascuConnectionFailed(-1, exc.toString());
                                ++i;
                                continue;
                            }
                        }
                    }
                }
                return null;
            }
        };
        worker.start();
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void disconnect() {
        block5: {
            if (this.myBlnConnected) {
                try {
                    this.myAscuConnectionWatcher.safeStop();
                    this.myBlnConnected = false;
                    i = 0;
                    while (i < this.myAntennaConfigListeners.size()) {
                        ((AntennaConfigListener)this.myAntennaConfigListeners.elementAt(i)).ascuDisconnected();
                        ++i;
                    }
                    break block5;
                }
                catch (Exception e) {
                    this.myLogger.error((Object)e);
                    i = 0;
                    ** while (i < this.myAntennaConfigListeners.size())
                }
lbl-1000:
                // 1 sources

                {
                    ((AntennaConfigListener)this.myAntennaConfigListeners.elementAt(i)).ascuDisconnectionFailed(-1, e.toString());
                    ++i;
                    continue;
                }
            }
        }
    }

    @Override
    public synchronized void setPollingInterval(int intInterval) {
        try {
            if (this.myAscuConnectionWatcher == null) {
                this.myAscuConnectionWatcher = new ASCUConnectionWatcher(this, this.myXmlRpcClient, intInterval);
            }
            this.myAscuConnectionWatcher.setInterval(intInterval);
        }
        catch (Exception e) {
            this.myLogger.error((Object)e);
        }
    }

    @Override
    public String alarmNotification(Hashtable hshtAlarm) {
        try {
            this.myLogger.error((Object)("in > " + hshtAlarm.toString()));
            SimpleDateFormat format = new SimpleDateFormat("yyyyMMddhhmmss");
            String strSeverity = (String)hshtAlarm.get("AlarmSeverity");
            int severity = -1;
            if ("a3".equalsIgnoreCase(strSeverity)) {
                severity = 18;
            } else if ("a2".equalsIgnoreCase(strSeverity)) {
                severity = 17;
            } else if ("a1".equalsIgnoreCase(strSeverity)) {
                severity = 16;
            } else if ("notice".equalsIgnoreCase(strSeverity)) {
                severity = 19;
            }
            int alarmNumber = Integer.parseInt((String)hshtAlarm.get("AlarmCode"));
            String strActivity = (String)hshtAlarm.get("Event");
            int activity = -1;
            if ("Cancel".equalsIgnoreCase(strActivity)) {
                activity = 1;
            } else if ("Set".equalsIgnoreCase(strActivity)) {
                activity = 2;
            }
            if ("Transient".equalsIgnoreCase(strActivity)) {
                activity = 3;
            }
            String description = (String)hshtAlarm.get("AlarmDescription");
            Date datetime = (Date)hshtAlarm.get("Time");
            String time = format.format(datetime);
            String componentId = (String)hshtAlarm.get("ComponentId");
            Alarm receivedAlarm = new Alarm(severity, alarmNumber, activity, -1, -1, description, new AlarmAdditionalInformation(), time, new HashMap(), new HashMap(), componentId, -1, -1, -1, -1, -1, -1, "Coreasset_Unknown", -1, "Coreasset_Unknown", -1, new ArrayList(), -1);
            Enumeration e = this.myAntennaConfigListeners.elements();
            while (e.hasMoreElements()) {
                AntennaConfigListener listener = (AntennaConfigListener)e.nextElement();
                listener.alarmReceived(receivedAlarm);
            }
        }
        catch (Exception e) {
            return e.toString();
        }
        return "OK";
    }

    public void setStatus(int intStatusCode) {
        try {
            Vector<Integer> params = new Vector<Integer>();
            params.addElement(intStatusCode);
            Object response = this.myXmlRpcClient.execute("eta.setStatus", params);
            this.myLogger.error((Object)("in > " + response.toString()));
        }
        catch (XmlRpcException exception) {
            this.myLogger.error((Object)("XML-RPC Fault #" + Integer.toString(exception.code) + ": "), (Throwable)exception);
        }
        catch (Exception exception) {
            this.myLogger.error((Object)exception);
        }
    }

    public void sendMessage(String message) {
        this.myLogger.debug((Object)("Message received: " + message));
    }

    static /* synthetic */ String access$0(AntennaConfigurationManagerImpl antennaConfigurationManagerImpl) {
        return antennaConfigurationManagerImpl.myASCU_IPAddress;
    }

    static /* synthetic */ String access$1(AntennaConfigurationManagerImpl antennaConfigurationManagerImpl) {
        return antennaConfigurationManagerImpl.myASCU_ServerPort;
    }

    static /* synthetic */ String access$2(AntennaConfigurationManagerImpl antennaConfigurationManagerImpl) {
        return antennaConfigurationManagerImpl.myASCU_URLTail;
    }

    static /* synthetic */ void access$3(AntennaConfigurationManagerImpl antennaConfigurationManagerImpl, String string) {
        antennaConfigurationManagerImpl.myServerUrl = string;
    }

    static /* synthetic */ boolean access$4(AntennaConfigurationManagerImpl antennaConfigurationManagerImpl) {
        return antennaConfigurationManagerImpl.myBlnConnected;
    }

    static /* synthetic */ void access$5(AntennaConfigurationManagerImpl antennaConfigurationManagerImpl, XmlRpcClient xmlRpcClient) {
        antennaConfigurationManagerImpl.myXmlRpcClient = xmlRpcClient;
    }

    static /* synthetic */ String access$6(AntennaConfigurationManagerImpl antennaConfigurationManagerImpl) {
        return antennaConfigurationManagerImpl.myServerUrl;
    }

    static /* synthetic */ void access$7(AntennaConfigurationManagerImpl antennaConfigurationManagerImpl, boolean bl) {
        antennaConfigurationManagerImpl.myBlnConnected = bl;
    }

    static /* synthetic */ ASCUConnectionWatcher access$8(AntennaConfigurationManagerImpl antennaConfigurationManagerImpl) {
        return antennaConfigurationManagerImpl.myAscuConnectionWatcher;
    }

    static /* synthetic */ XmlRpcClient access$9(AntennaConfigurationManagerImpl antennaConfigurationManagerImpl) {
        return antennaConfigurationManagerImpl.myXmlRpcClient;
    }

    static /* synthetic */ void access$10(AntennaConfigurationManagerImpl antennaConfigurationManagerImpl, ASCUConnectionWatcher aSCUConnectionWatcher) {
        antennaConfigurationManagerImpl.myAscuConnectionWatcher = aSCUConnectionWatcher;
    }

    static /* synthetic */ Vector access$11(AntennaConfigurationManagerImpl antennaConfigurationManagerImpl) {
        return antennaConfigurationManagerImpl.myAntennaConfigListeners;
    }

    static /* synthetic */ Logger access$12(AntennaConfigurationManagerImpl antennaConfigurationManagerImpl) {
        return antennaConfigurationManagerImpl.myLogger;
    }
}

