/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.ascu;

import com.nokia.em.bts.coreasset.ascu.EtaServer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.InetAddress;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import org.apache.log4j.Logger;
import org.apache.xmlrpc.WebServer;
import org.apache.xmlrpc.XmlRpcClient;
import org.apache.xmlrpc.XmlRpcException;

public class AntennaServer
extends JFrame {
    JScrollPane mainScrollPane = new JScrollPane();
    JTextArea outputTextArea = new JTextArea();
    BorderLayout mainBorderLayout = new BorderLayout();
    JPanel messagePanel = new JPanel();
    BorderLayout messageBorderLayout = new BorderLayout();
    JTextField messageTextField = new JTextField();
    JButton messageButton = new JButton();
    private static final String server_url = "http://localhost:61011";
    private XmlRpcClient server;
    public Hashtable ascuParams = new Hashtable();
    public Vector antennaParams = new Vector();
    public Hashtable antennaTilts = new Hashtable();
    public int myASCUStatus = 0;

    public AntennaServer() {
        Hashtable<String, String> ASCUInfo = new Hashtable<String, String>();
        Hashtable<String, Object> antenna1 = new Hashtable<String, Object>();
        Hashtable<String, Object> antenna2 = new Hashtable<String, Object>();
        Hashtable<String, Object> antenna3 = new Hashtable<String, Object>();
        Hashtable<String, Object> antenna4 = new Hashtable<String, Object>();
        Hashtable<String, Object> antenna5 = new Hashtable<String, Object>();
        ASCUInfo.put("ASCU_Name", "My RET1 Controller");
        ASCUInfo.put("ASCU_IPAddress", "192.168.255.144");
        ASCUInfo.put("ASCU_IPGateway", "192.168.255.254");
        ASCUInfo.put("ASCU_IPSubnetMask", "255.255.255.0");
        ASCUInfo.put("ASCU_MACAddress", "0e 00 00 02 01 02");
        ASCUInfo.put("UserDefinedInUse", "true");
        this.ascuParams = ASCUInfo;
        antenna1.put("AntennaId", "My Antenna1");
        antenna1.put("AntennaType", "Small Antenna");
        antenna1.put("AntennaSerialNumber", "ANT12349987-7863");
        antenna1.put("AntennaMinTilt", 0);
        antenna1.put("AntennaMaxTilt", 14);
        antenna1.put("LCRId", "10000");
        antenna2.put("AntennaId", "My Antenna2");
        antenna2.put("AntennaType", "Big Antenna");
        antenna2.put("AntennaSerialNumber", "ANT12349987-7864");
        antenna2.put("AntennaMinTilt", 2);
        antenna2.put("AntennaMaxTilt", 10);
        antenna2.put("LCRId", "20000");
        antenna3.put("AntennaId", "My Antenna3");
        antenna3.put("AntennaType", "Big Antenna");
        antenna3.put("AntennaSerialNumber", "ANT12349987-7865");
        antenna3.put("AntennaMinTilt", 2);
        antenna3.put("AntennaMaxTilt", 8);
        antenna3.put("LCRId", "30000");
        antenna4.put("AntennaId", "My Antenna4");
        antenna4.put("AntennaType", "Big Antenna");
        antenna4.put("AntennaSerialNumber", "ANT12349987-7866");
        antenna4.put("AntennaMinTilt", 0);
        antenna4.put("AntennaMaxTilt", 14);
        antenna4.put("LCRId", "30000");
        antenna5.put("AntennaId", "My Antenna5");
        antenna5.put("AntennaType", "Big Antenna");
        antenna5.put("AntennaSerialNumber", "ANT12349987-7867");
        antenna5.put("AntennaMinTilt", 0);
        antenna5.put("AntennaMaxTilt", 11);
        antenna5.put("LCRId", "30000");
        this.antennaParams.addElement(antenna1);
        this.antennaParams.addElement(antenna2);
        this.antennaParams.addElement(antenna3);
        this.antennaParams.addElement(antenna4);
        this.antennaParams.addElement(antenna5);
        this.antennaTilts.put("My Antenna1", 0);
        this.antennaTilts.put("My Antenna2", 0);
        this.antennaTilts.put("My Antenna3", 0);
        this.antennaTilts.put("My Antenna4", 0);
        this.antennaTilts.put("My Antenna5", 0);
        try {
            this.jbInit();
            this.server = new XmlRpcClient(server_url);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String commission(Hashtable ascup) {
        this.outputTextArea.append("Commission of ASCU asked. \n");
        if (!ascup.isEmpty()) {
            this.ascuParams = ascup;
            return "OK";
        }
        return "SMALL";
    }

    public String commission(Hashtable ascup, Vector antennap) {
        this.outputTextArea.append("Commission asked. \n");
        this.ascuParams = ascup;
        this.antennaParams = antennap;
        this.antennaTilts.clear();
        int i = 0;
        while (i < antennap.size()) {
            this.antennaTilts.put(((Hashtable)antennap.elementAt(i)).get("AntennaId"), 0);
            ++i;
        }
        return "OK";
    }

    public String reboot() {
        this.outputTextArea.append("Reboot requested. \n");
        return "OK";
    }

    public int getInServiceTime() {
        this.outputTextArea.append("In service time asked. \n");
        return 557;
    }

    public Vector getErrorStatus() {
        this.outputTextArea.append("Error status asked. \n");
        Vector<String> result = new Vector<String>();
        result.addElement("RS 485 Comms broken");
        result.addElement("RS 767 Comms broken");
        return result;
    }

    public Vector selfTest() {
        Vector<String> tests = new Vector<String>();
        tests.addElement("Test1");
        tests.addElement("Test2");
        tests.addElement("Test3");
        this.outputTextArea.append("Self test asked. \n");
        return tests;
    }

    public Vector getHwInfo() {
        this.outputTextArea.append("HW info requested. \n");
        Vector result = new Vector();
        Hashtable<String, String> HWUnit1 = new Hashtable<String, String>();
        Hashtable<String, String> HWUnit2 = new Hashtable<String, String>();
        Hashtable<String, String> HWUnit3 = new Hashtable<String, String>();
        HWUnit1.put("ComponentId", "ANT12349987-7863");
        HWUnit1.put("HwUnit", "KATHREIN_ANTENNA_4X");
        HWUnit1.put("HwSerialNumber", "ANT12349987-7863");
        HWUnit1.put("HwVersion", "AN123-456.7");
        HWUnit2.put("ComponentId", "ANT12349987-7864");
        HWUnit2.put("HwUnit", "KATHREIN_ANTENNA_4X");
        HWUnit2.put("HwSerialNumber", "ANT12349987-7864");
        HWUnit2.put("HwVersion", "AN123-456.6");
        HWUnit3.put("ComponentId", "ANT12349987-7865");
        HWUnit3.put("HwUnit", "KATHREIN_ANTENNA_4X");
        HWUnit3.put("HwSerialNumber", "ANT12349987-7865");
        HWUnit3.put("HwVersion", "AN123-456.8");
        result.addElement(HWUnit1);
        result.addElement(HWUnit2);
        result.addElement(HWUnit3);
        return result;
    }

    public String subscribeNotifications(Hashtable subscriptionParams) {
        this.outputTextArea.append("Subscription for alarms requested on port " + (Integer)subscriptionParams.get("TcpPort") + ". \n");
        return "OK";
    }

    public String unsubscribeNotifications() {
        this.outputTextArea.append("Unsubscription from alarms requested. \n");
        return "OK";
    }

    public Hashtable getCommissionData() {
        this.outputTextArea.append("Commission data from ASCU requested. \n");
        Hashtable result = (Hashtable)this.ascuParams.clone();
        return result;
    }

    public Vector getSwInfo() {
        this.outputTextArea.append("SW Info requested. \n");
        Vector<Cloneable> result = new Vector<Cloneable>();
        Hashtable<String, String> SwGeneralInfo = new Hashtable<String, String>();
        Hashtable<String, Object> SwInfoUnit1 = new Hashtable<String, Object>();
        Hashtable<String, Object> SwInfoUnit2 = new Hashtable<String, Object>();
        Hashtable<String, Object> SwInfoUnit3 = new Hashtable<String, Object>();
        Vector<Hashtable<String, Object>> units = new Vector<Hashtable<String, Object>>();
        SwGeneralInfo.put("SoftwareReleaseVersion", "ascu_1.0.2");
        SwGeneralInfo.put("BuildDescriptorId", "ID123");
        SwInfoUnit1.put("Name", "Kathrein-Ant-SW-RT1");
        SwInfoUnit1.put("Version", "_A0109.bin");
        SwInfoUnit1.put("Path", "C:\\USER\\ASCU\\");
        SwInfoUnit1.put("HwUnit", "Kathrein-Antenna");
        SwInfoUnit1.put("CheckSum", 653481);
        SwInfoUnit1.put("ActiveFlag", "TRUE");
        SwInfoUnit1.put("NewFlag", "FALSE");
        SwInfoUnit2.put("Name", "Kathrein-Ant-SW-RT2");
        SwInfoUnit2.put("Version", "_A0110.bin");
        SwInfoUnit2.put("Path", "C:\\USER\\ASCU\\");
        SwInfoUnit2.put("HwUnit", "Kathrein-Antenna");
        SwInfoUnit2.put("CheckSum", 653481);
        SwInfoUnit2.put("ActiveFlag", "FALSE");
        SwInfoUnit2.put("NewFlag", "TRUE");
        SwInfoUnit3.put("Name", "Kathrein-Ant-SW-RT3");
        SwInfoUnit3.put("Version", "_A0111.bin");
        SwInfoUnit3.put("Path", "C:\\USER\\ASCU\\");
        SwInfoUnit3.put("HwUnit", "Kathrein-Antenna");
        SwInfoUnit3.put("CheckSum", 553781);
        SwInfoUnit3.put("ActiveFlag", "TRUE");
        SwInfoUnit3.put("NewFlag", "TRUE");
        units.addElement(SwInfoUnit1);
        units.addElement(SwInfoUnit2);
        units.addElement(SwInfoUnit3);
        result.addElement(SwGeneralInfo);
        result.addElement(units);
        return result;
    }

    public Vector getAntennaSerialNumbers() {
        Vector<String> sn = new Vector<String>();
        sn.addElement("ANT12349987-7863");
        sn.addElement("ANT12349987-3475");
        sn.addElement("ANT12349987-8347");
        this.outputTextArea.append("Antenna serial numbers asked. \n");
        return sn;
    }

    public Date getDateTime() {
        this.outputTextArea.append("Date time asked.\n");
        Date currentDate = new Date();
        return currentDate;
    }

    public static void main(String[] args) {
        try {
            WebServer webServer = new WebServer(61011);
            AntennaServer antennaServer = new AntennaServer();
            EtaServer etaServer = new EtaServer(antennaServer);
            webServer.addHandler("eta", (Object)etaServer);
            webServer.addHandler("ascu", (Object)antennaServer);
        }
        catch (Exception exception) {
            System.err.println("AntennaServer " + exception.toString());
            Logger.getLogger(AntennaServer.class).error((Object)exception);
        }
    }

    public void sendAlarm() {
        Hashtable<String, Object> alarm = new Hashtable<String, Object>();
        alarm.put("ComponentId", "AN12349988-8866");
        alarm.put("AlarmSeverity", "a2");
        alarm.put("AlarmCode", "0x04");
        alarm.put("Time", new Date());
        alarm.put("Event", "set");
        alarm.put("AlarmDescription", "BLOCK_NUMBER_SEQUENCE_ERROR");
        Vector<Hashtable<String, Object>> params = new Vector<Hashtable<String, Object>>();
        params.addElement(alarm);
        try {
            this.server.execute("omc.alarmNotification", params);
        }
        catch (XmlRpcException exception) {
            this.outputTextArea.append("AntennaServer: XML-RPC Fault #" + Integer.toString(exception.code) + ": " + exception.toString());
            exception.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void sendAlarmButton_actionPerformed() {
        this.sendAlarm();
    }

    void sendSWupdateButton_actionPerformed() {
        Vector<String> params = new Vector<String>();
        params.addElement("OK");
    }

    void messageButton_actionPerformed() {
        Vector<String> params = new Vector<String>();
        params.addElement(this.messageTextField.getText());
        try {
            this.server.execute("omc.sendMessage", params);
        }
        catch (XmlRpcException exception) {
            this.outputTextArea.append("AntennaServer: XML-RPC Fault #" + Integer.toString(exception.code) + ": " + exception.toString());
            exception.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setSize(new Dimension(400, 320));
        this.setLocation(500, 300);
        this.setDefaultCloseOperation(3);
        this.setTitle("Antenna Server    " + InetAddress.getLocalHost().getHostAddress());
        this.getContentPane().setLayout(this.mainBorderLayout);
        this.mainScrollPane.setBorder(BorderFactory.createCompoundBorder(new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(134, 134, 134)), "Output"), BorderFactory.createEmptyBorder(0, 10, 10, 10)));
        this.messagePanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 7, 5));
        this.messagePanel.setPreferredSize(new Dimension(10, 40));
        this.messagePanel.setLayout(this.messageBorderLayout);
        this.messageButton.setMargin(new Insets(2, 12, 2, 12));
        this.messageButton.setText("Send message");
        this.messageButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AntennaServer.this.messageButton_actionPerformed();
            }
        });
        JButton sendAlarmButton = new JButton();
        sendAlarmButton.setText("Send Alarm");
        sendAlarmButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AntennaServer.this.sendAlarmButton_actionPerformed();
            }
        });
        JButton sendSWupdateButton = new JButton();
        sendSWupdateButton.setText("Send SW update resp");
        sendSWupdateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AntennaServer.this.sendSWupdateButton_actionPerformed();
            }
        });
        this.messageBorderLayout.setHgap(10);
        this.outputTextArea.setLineWrap(true);
        this.outputTextArea.setEditable(false);
        this.getContentPane().add((Component)this.mainScrollPane, "Center");
        this.getContentPane().add((Component)this.messagePanel, "South");
        JPanel buttonPanel = new JPanel();
        this.messageTextField.setSize(50, 8);
        this.messageTextField.setText("ok");
        buttonPanel.setLayout(new GridLayout());
        buttonPanel.add(this.messageTextField);
        buttonPanel.add(this.messageButton);
        buttonPanel.add(sendAlarmButton);
        this.messagePanel.add(buttonPanel);
        this.mainScrollPane.getViewport().add((Component)this.outputTextArea, null);
        this.setVisible(true);
    }
}

