/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.ascu;

import com.nokia.em.bts.coreasset.ascu.AntennaServer;
import java.util.Hashtable;
import java.util.Vector;

public class EtaServer {
    AntennaServer antennaServer = null;
    private int myEtaStatusCode = 5;

    public EtaServer(AntennaServer antennaServer) {
        this.antennaServer = antennaServer;
    }

    public String setStatus(int intStatusCode) {
        System.out.println("Statuscode set to:" + intStatusCode);
        this.myEtaStatusCode = intStatusCode;
        System.out.println("Current statuscode:" + this.myEtaStatusCode);
        return "OK";
    }

    public Vector getCommissionData() {
        this.antennaServer.outputTextArea.append("Commission data for ETAs requested. \n");
        return this.antennaServer.antennaParams;
    }

    public int setTilt(Hashtable tiltParams) {
        System.out.println("setTilt!");
        this.antennaServer.outputTextArea.append(String.valueOf(tiltParams.toString()) + "\n");
        String antennaId = (String)tiltParams.get("AntennaId");
        int antennaTilt = (Integer)tiltParams.get("AntennaTilt");
        this.antennaServer.outputTextArea.append("Set tilt " + antennaTilt + " for " + antennaId + " asked.\n");
        if (this.antennaServer.antennaTilts.contains(antennaId)) {
            System.out.println(this.antennaServer.antennaTilts.toString());
            this.antennaServer.antennaTilts.put(antennaId, antennaTilt);
        }
        return antennaTilt;
    }

    public Vector getSerialNumber(String eta) {
        this.antennaServer.outputTextArea.append("Serial number asked for " + eta + ". \n");
        Vector<String> serNums = new Vector<String>();
        if ("".equals(eta)) {
            serNums.addElement("ANT12349987-7863");
            serNums.addElement("ANT12349987-7864");
            serNums.addElement("ANT12349987-7865");
            serNums.addElement("ANT12349987-7866");
            serNums.addElement("ANT12349987-7867");
        } else {
            serNums.addElement("ANT12349987-7867");
        }
        return serNums;
    }

    public String calibrate(String antennaId) {
        this.antennaServer.outputTextArea.append("Calibrate requested for antenna Id: " + antennaId + ". \n");
        return "OK";
    }

    public String clearErrorStatus(String deviceId) {
        this.antennaServer.outputTextArea.append("Clear error status asked for device " + deviceId + ". \n");
        return "OK";
    }

    public String reset() {
        this.antennaServer.outputTextArea.append("Reset requested. \n");
        return "OK";
    }

    public Vector getStatus(String eta) {
        this.antennaServer.outputTextArea.append("ETA status requested for " + eta + ". \n");
        Vector result = new Vector();
        Hashtable<String, Object> unit1 = new Hashtable<String, Object>();
        Hashtable<String, Object> unit2 = new Hashtable<String, Object>();
        Hashtable<String, Object> unit3 = new Hashtable<String, Object>();
        unit1.put("AntennaId", "Antenna1");
        unit1.put("Tilt", 30);
        unit1.put("StatusCode", this.myEtaStatusCode);
        unit2.put("AntennaId", "Antenna2");
        unit2.put("Tilt", 40);
        unit2.put("StatusCode", this.myEtaStatusCode);
        unit3.put("AntennaId", "Antenna3");
        unit3.put("Tilt", 50);
        unit3.put("StatusCode", this.myEtaStatusCode);
        result.addElement(unit1);
        if (!"".equals(eta)) {
            result.addElement(unit2);
            result.addElement(unit3);
        }
        return result;
    }

    public int getTilt(String antennaId) {
        this.antennaServer.outputTextArea.append("Get tilt for " + antennaId + " asked. \n");
        return 6;
    }

    public String commission(Vector antennaParams) {
        this.antennaServer.outputTextArea.append("Commission of ETAs asked. \n");
        if (!antennaParams.isEmpty()) {
            this.antennaServer.antennaParams = antennaParams;
            this.antennaServer.antennaTilts.clear();
            int i = 0;
            while (i < antennaParams.size()) {
                this.antennaServer.antennaTilts.put(((Hashtable)antennaParams.elementAt(i)).get("AntennaId"), 0);
                ++i;
            }
            return "OK";
        }
        return "Not OK";
    }

    public Vector getHwInfo() {
        this.antennaServer.outputTextArea.append("ETA HW info requested. \n");
        Vector result = new Vector();
        Hashtable<String, String> HWUnit1 = new Hashtable<String, String>();
        Hashtable<String, String> HWUnit2 = new Hashtable<String, String>();
        Hashtable<String, String> HWUnit3 = new Hashtable<String, String>();
        HWUnit1.put("ComponentId", "ANT12349987-7863");
        HWUnit1.put("HwUnit", "KATHREIN_ANTENNA_4X");
        HWUnit1.put("HwSerialNumber", "12349987-7863");
        HWUnit1.put("HwVersion", "AN123-456.7");
        HWUnit1.put("ComponentId", "ANT12349987-7864");
        HWUnit2.put("HwUnit", "KATHREIN_ANTENNA_4X");
        HWUnit2.put("HwSerialNumber", "12349987-7864");
        HWUnit2.put("HwVersion", "AN123-456.6");
        HWUnit1.put("ComponentId", "ANT12349987-7865");
        HWUnit3.put("HwUnit", "KATHREIN_ANTENNA_4X");
        HWUnit3.put("HwSerialNumber", "12349987-7865");
        HWUnit3.put("HwVersion", "AN123-456.8");
        result.addElement(HWUnit1);
        result.addElement(HWUnit2);
        result.addElement(HWUnit3);
        return result;
    }
}

