/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.commissioning;

import com.nokia.em.bts.coreasset.CoreAsset;
import com.nokia.em.bts.coreasset.commissioning.CommissioningListener;
import com.nokia.em.bts.coreasset.commissioning.CommissioningManager;
import com.nokia.em.bts.coreasset.message.SWUpToDate;
import com.nokia.em.bts.coreasset.message.SWUpdateRequest;
import com.nokia.em.bts.coreasset.scenario.ScenarioManagerImpl;
import com.nokia.em.bts.rp.master.connection.BTSConnection;
import com.nokia.em.bts.rp.master.filetransfer.FTPTransferInfo;
import com.nokia.em.bts.rp.master.filetransfer.FileTransferListener;
import com.nokia.em.bts.rp.master.filetransfer.FileTransferServer;
import com.nokia.em.bts.rp.master.message.Ack;
import com.nokia.em.bts.rp.master.message.BTSMessage;
import com.nokia.em.bts.rp.master.message.CommissioningReply;
import com.nokia.em.bts.rp.master.message.CommissioningRequest;
import com.nokia.em.bts.rp.master.message.ParseCommissionDataReply;
import com.nokia.em.bts.rp.master.message.ParseCommissionDataRequest;
import com.nokia.em.bts.rp.master.tool.CoreAssetThread;
import com.nokia.em.poseidon.util.timer.TimerService;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.apache.log4j.Logger;

public class CommissioningManagerImpl
implements CommissioningManager {
    private static final int COM_PARSING_TIMEOUT = 60000;
    private FTPTransferInfo myFTPTransferInfo;
    private BTSConnection myConnection;
    private Logger myLogger = Logger.getLogger(this.getClass());

    public CommissioningManagerImpl(BTSConnection connection) {
        this.myConnection = connection;
        this.myFTPTransferInfo = new FTPTransferInfo();
    }

    @Override
    public FTPTransferInfo getFTPTransferInfo() {
        return this.myFTPTransferInfo;
    }

    @Override
    public void updateCommissioningFile(CommissioningListener commissioningListener, FileTransferListener fileTransferListener, File comFile, boolean sendParseRequest) {
        FTPTransferInfo commissioningFileInfo = new FTPTransferInfo(comFile.getAbsolutePath(), this.myConnection.getLocalIPAddress(), "", new char[0]);
        this.updateCommissioningFile(commissioningListener, fileTransferListener, commissioningFileInfo, sendParseRequest);
    }

    @Override
    public void updateCommissioningFile(CommissioningListener commissioningListener, FileTransferListener fileTransferListener, File comFile) {
        this.updateCommissioningFile(commissioningListener, fileTransferListener, comFile, true);
    }

    @Override
    public void updateCommissioningFile(CommissioningListener commissioningListener, FileTransferListener fileTransferListener, FTPTransferInfo ftpTransferInfo) {
        this.updateCommissioningFile(commissioningListener, fileTransferListener, ftpTransferInfo, true);
    }

    @Override
    public void updateCommissioningFile(final CommissioningListener commissioningListener, final FileTransferListener fileTransferListener, final FTPTransferInfo ftpTransferInfo, final boolean sendParseRequest) {
        CoreAssetThread worker = new CoreAssetThread(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            protected Object construct() {
                if (CoreAsset.isSnapshotOpening()) {
                    commissioningListener.fileSendingFailed(85);
                    CommissioningManagerImpl.this.myLogger.debug((Object)"No support for snapshot opening.");
                    return true;
                }
                final int seqNumber = CommissioningManagerImpl.this.myConnection.createScenario();
                File file = new File(ftpTransferInfo.getFileId());
                FileTransferServer server = CommissioningManagerImpl.this.myConnection.getFileTransferFactory().getFileTransferServer();
                server.initListenerAndPath(fileTransferListener, file.getParent());
                ftpTransferInfo.setUserName(server.getUserName());
                ftpTransferInfo.setPassword(server.getPassword().toCharArray());
                ftpTransferInfo.setFileName(file.getName());
                try {
                    int port = server.startServer();
                    if (port != 21) {
                        ftpTransferInfo.setServerAddress(String.valueOf(ftpTransferInfo.getServerAddress()) + ":" + port);
                    }
                }
                catch (Exception fpiue) {
                    CommissioningManagerImpl.this.myConnection.deleteScenario(seqNumber);
                    commissioningListener.fileSendingFailed(300);
                    return false;
                }
                SWUpdateRequest swUpdtReq = new SWUpdateRequest(seqNumber, false, ftpTransferInfo);
                CommissioningManagerImpl.this.myConnection.sendToBTS((BTSMessage)swUpdtReq);
                BTSMessage response = CommissioningManagerImpl.this.myConnection.receiveFromBTS(seqNumber);
                if (!(response instanceof Ack)) {
                    server.stopServer();
                    CommissioningManagerImpl.this.myLogger.error((Object)"Wrong reply received from BTS. Ack expected.");
                    CommissioningManagerImpl.this.myConnection.deleteScenario(seqNumber);
                    commissioningListener.fileSendingFailed(28);
                    return false;
                }
                Ack ackResponse = (Ack)response;
                if (!ackResponse.getAck()) {
                    server.stopServer();
                    CommissioningManagerImpl.this.myLogger.debug((Object)("ComFileUpdateRequestRejected. BTS replied Nack to FileUpdateRequest with reason " + ackResponse.getNackReason()));
                    CommissioningManagerImpl.this.myConnection.deleteScenario(seqNumber);
                    commissioningListener.fileSendingFailed(302);
                    return false;
                }
                response = CommissioningManagerImpl.this.myConnection.receiveFromBTS(seqNumber);
                server.stopServer();
                if (!(response instanceof SWUpToDate)) {
                    CommissioningManagerImpl.this.myLogger.error((Object)"Wrong reply received from BTS. FilesUpToDate expected.");
                    commissioningListener.fileSendingFailed(28);
                    return false;
                }
                SWUpToDate swUpToDate = (SWUpToDate)response;
                if (swUpToDate.getUpdateResult() != 36) {
                    commissioningListener.fileSendingFailed(301);
                    return false;
                }
                commissioningListener.fileSent();
                if (!sendParseRequest) {
                    CommissioningManagerImpl.this.myLogger.debug((Object)"CommissioningManagerImpl.updateFile, Was requested not to parse commission file, stopping scenario.");
                    CommissioningManagerImpl.this.myConnection.deleteScenario(seqNumber);
                    return true;
                }
                ParseCommissionDataRequest parseCommissionDataRequest = new ParseCommissionDataRequest(seqNumber);
                ActionListener actionListener = new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ev) {
                        CommissioningManagerImpl.this.myConnection.interruptScenario(seqNumber);
                    }
                };
                TimerService.getInstance().startTimer(actionListener, 60000L, false, 1);
                CommissioningManagerImpl.this.myConnection.sendToBTS((BTSMessage)parseCommissionDataRequest);
                BTSMessage resp = CommissioningManagerImpl.this.myConnection.receiveFromBTS(seqNumber);
                TimerService.getInstance().stopTimer(actionListener);
                CommissioningManagerImpl.this.myConnection.deleteScenario(seqNumber);
                if (resp instanceof ParseCommissionDataReply) {
                    ParseCommissionDataReply parseReply = (ParseCommissionDataReply)resp;
                    if (parseReply.getDataParsingNackReason() == 34) {
                        commissioningListener.fileDistributed();
                        return true;
                    }
                    commissioningListener.fileDistributionFailed(parseReply.getDataParsingNackReason());
                    return false;
                }
                if (resp == null) {
                    CommissioningManagerImpl.this.myLogger.debug((Object)"Commissioning file parsing failed, timeout.");
                    commissioningListener.fileDistributionFailed(68);
                    return false;
                }
                CommissioningManagerImpl.this.myLogger.error((Object)("Wrong reply received from BTS. ParseCommissionDataReply expected, " + resp.getClass() + " received."));
                commissioningListener.fileDistributionFailed(28);
                return false;
            }

            protected void finished() {
                try {
                    this.get();
                }
                catch (ExecutionException ite) {
                    CommissioningManagerImpl.this.myLogger.error((Object)"Updating failed: ", ite.getCause());
                }
            }
        };
        worker.start();
    }

    @Override
    public void updateCommissioningInformation(final CommissioningListener commissioningListener) {
        CoreAssetThread commissioningWorker = new CoreAssetThread(){

            protected Object construct() {
                if (CoreAsset.isSnapshotOpening()) {
                    CommissioningManagerImpl.this.myLogger.debug((Object)"No support for snapshot opening.");
                    commissioningListener.commissioningInformationUpdateFailed(85);
                    return true;
                }
                int seqNumber = CommissioningManagerImpl.this.myConnection.createScenario();
                CommissioningRequest commissioningRequest = new CommissioningRequest(seqNumber);
                CommissioningManagerImpl.this.myConnection.sendToBTS((BTSMessage)commissioningRequest);
                BTSMessage response = CommissioningManagerImpl.this.myConnection.receiveFromBTS(seqNumber);
                if (response instanceof Ack) {
                    Ack ackResponse = (Ack)response;
                    if (ackResponse.getAck()) {
                        response = CommissioningManagerImpl.this.myConnection.receiveFromBTS(seqNumber);
                    } else {
                        CommissioningManagerImpl.this.myConnection.deleteScenario(seqNumber);
                        CommissioningManagerImpl.this.myLogger.debug((Object)("CommissioningStateUnknown. BTS replied Nack to CommissionRequest with reason " + ackResponse.getNackReason()));
                        commissioningListener.commissioningInformationUpdateFailed(ackResponse.getNackReason());
                        return false;
                    }
                }
                if (response instanceof CommissioningReply) {
                    CommissioningManagerImpl.this.myConnection.deleteScenario(seqNumber);
                    CommissioningReply commissioningReply = (CommissioningReply)response;
                    CommissioningManagerImpl.this.myConnection.setBTSId(commissioningReply.getBtsId());
                    List ftpTransferInfos = commissioningReply.getFTPTransferInfo();
                    if (ftpTransferInfos != null && ftpTransferInfos.size() > 0) {
                        FTPTransferInfo firstFTPTransferInfo = (FTPTransferInfo)ftpTransferInfos.get(0);
                        ScenarioManagerImpl.setFTPTransferInfo(firstFTPTransferInfo);
                        CommissioningManagerImpl.this.myFTPTransferInfo = firstFTPTransferInfo;
                        commissioningListener.commissioningInformationUpdated(ftpTransferInfos);
                        return true;
                    }
                    CommissioningManagerImpl.this.myFTPTransferInfo = new FTPTransferInfo();
                    commissioningListener.commissioningInformationUpdated(null);
                    return true;
                }
                CommissioningManagerImpl.this.myConnection.deleteScenario(seqNumber);
                CommissioningManagerImpl.this.myLogger.error((Object)"Wrong reply received from BTS. CommissioningReply or Ack expected.");
                commissioningListener.commissioningInformationUpdateFailed(28);
                return false;
            }

            protected void finished() {
                try {
                    this.get();
                }
                catch (ExecutionException ite) {
                    Throwable t = ite.getCause();
                    CommissioningManagerImpl.this.myLogger.error((Object)"Updating failed, ", t);
                }
            }
        };
        commissioningWorker.start();
    }
}

