/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.configuration;

import com.nokia.em.bts.coreasset.configuration.BTSConfigObject;
import com.nokia.em.bts.coreasset.configuration.BTSConfigurationManager;
import com.nokia.em.bts.coreasset.configuration.ObjectChangeListener;
import com.nokia.em.bts.rp.master.RadioAccessTechnologyType;
import com.nokia.em.bts.rp.master.connection.BTSConnection;
import com.nokia.em.bts.rp.master.tool.Tools;
import com.nokia.em.poseidon.util.GeneralUtils;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.log4j.Logger;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class AbstractBTSConfigObject
implements BTSConfigObject {
    public static final String OBJECT_TYPE_VALUE_UNIT = "Unit";
    public static final String OBJECT_TYPE_VALUE_SITE = "BS";
    public static final String OBJECT_TYPE_VALUE_CABINET = "Cabinet";
    public static final String OBJECT_TYPE_VALUE_CELL = "Cell";
    public static final String OBJECT_TYPE_VALUE_SUBUNIT = "Subunit";
    public static final String OBJECT_TYPE_VALUE_LINK = "Link";
    public static final String OBJECT_TYPE_VALUE_EACINPUT = "EACInput";
    public static final String OBJECT_TYPE_VALUE_EACOUTPUT = "EACOutput";
    public static final String OBJECT_TYPE_VALUE_OBJECT_RELATION = "ObjectRelation";
    public static final String OBJECT_TYPE_VALUE_CELLGROUP = "CellGroup";
    protected final BTSConnection myConnection;
    protected final BTSConfigurationManager myBTSConfigurationManager;
    protected static final String ID_NODENAME = "_id";
    protected Map<String, String> myCustomAttributes = new HashMap<String, String>();
    protected RadioAccessTechnologyType myRatType;
    private int myObjectType;
    private int myId;
    private final Vector<ObjectChangeListener> myObjectChangeListeners;
    private Logger myLogger = Logger.getLogger(this.getClass());
    private boolean myEditable = false;

    public AbstractBTSConfigObject(BTSConfigurationManager btsConfMgr, int intId, int intObjectType) {
        this.myConnection = btsConfMgr != null ? btsConfMgr.getBTSConnection() : null;
        this.myId = intId;
        this.myObjectType = intObjectType;
        this.myObjectChangeListeners = new Vector(10);
        this.myBTSConfigurationManager = btsConfMgr;
        this.myCustomAttributes = new Hashtable<String, String>(10);
    }

    @Override
    public final Vector<ObjectChangeListener> getObjectChangeListeners() {
        return this.myObjectChangeListeners;
    }

    private Node toNode(Document doc) {
        Node root = this.getRoot(doc);
        if (this.myCustomAttributes.size() > 0 && root != null) {
            Iterator<String> customKeys = this.getCustomAttributeKeys();
            while (customKeys.hasNext()) {
                String key = customKeys.next();
                String value = this.getCustomAttributeValue(key);
                try {
                    root.appendChild(this.createElement(doc, key, value));
                }
                catch (DOMException e) {
                    this.myLogger.debug((Object)("invalid tag. key: " + key + ", value: " + value), (Throwable)e);
                }
            }
        }
        return root;
    }

    @Override
    public abstract Object getEditableCopy();

    @Override
    public Iterator<String> getCustomAttributeKeys() {
        return this.myCustomAttributes.keySet().iterator();
    }

    @Override
    public String getCustomAttributeValue(String strKey) {
        return this.myCustomAttributes.get(strKey);
    }

    @Override
    public Map<String, String> getCustomAttributes() {
        return new HashMap<String, String>(this.myCustomAttributes);
    }

    @Override
    public void setCustomAttribute(String key, String value) {
        if (!this.isEditable()) {
            throw new UnsupportedOperationException("Operation not supported in online model");
        }
        this.myCustomAttributes.put(key, value);
        this.sendObjectChanged();
    }

    @Override
    public void setCustomAttributes(Map<String, String> map) {
        if (!this.isEditable()) {
            throw new UnsupportedOperationException("Operation not supported in online model");
        }
        this.doSetCustomAttributes(map);
        this.sendObjectChanged();
    }

    @Override
    public void replaceCustomAttributes(Map<String, String> map) {
        this.myCustomAttributes.putAll(map);
    }

    @Override
    public boolean isEditable() {
        return this.myEditable;
    }

    protected void setEditable(boolean editable) {
        this.myEditable = editable;
    }

    abstract void update(BTSConfigObject var1);

    @Override
    public String writeXML() {
        String str = "";
        try {
            str = Tools.xmlToString((Node)this.toNode(DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument()));
        }
        catch (Exception e) {
            this.myLogger.error((Object)"Failed to create xml string: ", (Throwable)e);
        }
        return str;
    }

    public final void setRatType(RadioAccessTechnologyType ratType) {
        if (!this.isEditable()) {
            throw new UnsupportedOperationException("Operation not supported in online model");
        }
        this.doSetRatType(ratType);
    }

    protected final void doSetRatType(RadioAccessTechnologyType ratType) {
        this.myRatType = ratType;
    }

    public final RadioAccessTechnologyType getRatType() {
        return this.myRatType;
    }

    protected abstract Node getRoot(Document var1);

    protected void doSetCustomAttributes(Map<String, String> map) {
        this.myCustomAttributes = map;
    }

    protected void doSetId(int intId) {
        this.myId = intId;
    }

    protected static String nodeValueOf(int intValue) {
        switch (intValue) {
            case 3: {
                return OBJECT_TYPE_VALUE_SITE;
            }
            case 4: {
                return OBJECT_TYPE_VALUE_CABINET;
            }
            case 5: {
                return OBJECT_TYPE_VALUE_CELL;
            }
            case 10: {
                return OBJECT_TYPE_VALUE_UNIT;
            }
            case 11: {
                return OBJECT_TYPE_VALUE_EACINPUT;
            }
            case 12: {
                return OBJECT_TYPE_VALUE_EACOUTPUT;
            }
            case 13: {
                return OBJECT_TYPE_VALUE_LINK;
            }
            case 14: {
                return OBJECT_TYPE_VALUE_SUBUNIT;
            }
            case 48: {
                return OBJECT_TYPE_VALUE_OBJECT_RELATION;
            }
            case 78: {
                return OBJECT_TYPE_VALUE_CELLGROUP;
            }
        }
        return "Coreasset_Unknown";
    }

    protected final Element createElement(Document document, String strElementName, Object nodeValue) {
        Element element = document.createElement(strElementName);
        if (nodeValue instanceof String) {
            String strValue = (String)nodeValue;
            if (!"Coreasset_Unknown".equals(strValue)) {
                element.appendChild(document.createTextNode(strValue));
            }
        } else if (nodeValue instanceof Integer) {
            Integer integerValue = (Integer)nodeValue;
            if (integerValue != -1) {
                element.appendChild(document.createTextNode(integerValue.toString()));
            }
        } else if (nodeValue instanceof Float) {
            Float floatValue = (Float)nodeValue;
            if (GeneralUtils.isEqual((double)floatValue.floatValue(), (double)-1.0)) {
                element.appendChild(document.createTextNode(floatValue.toString()));
            }
        } else if (nodeValue instanceof Long) {
            Long longValue = (Long)nodeValue;
            if (longValue != -1L) {
                element.appendChild(document.createTextNode(longValue.toString()));
            }
        } else {
            element.appendChild(document.createTextNode(""));
        }
        return element;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void sendObjectChanged() {
        Vector vecListeners;
        AbstractBTSConfigObject abstractBTSConfigObject = this;
        synchronized (abstractBTSConfigObject) {
            vecListeners = (Vector)this.getObjectChangeListeners().clone();
        }
        int size = vecListeners.size();
        if (size > 0) {
            int i = 0;
            while (i < size) {
                ObjectChangeListener listener = (ObjectChangeListener)vecListeners.elementAt(i);
                try {
                    listener.objectChanged(this);
                }
                catch (Exception e) {
                    this.myLogger.error((Object)"Gui throwed", (Throwable)e);
                }
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void sendObjectRemoved() {
        Vector vecListeners;
        AbstractBTSConfigObject abstractBTSConfigObject = this;
        synchronized (abstractBTSConfigObject) {
            vecListeners = (Vector)this.getObjectChangeListeners().clone();
        }
        int size = vecListeners.size();
        if (size > 0) {
            int i = 0;
            while (i < size) {
                ObjectChangeListener listener = (ObjectChangeListener)vecListeners.elementAt(i);
                try {
                    listener.objectRemoved();
                }
                catch (Exception e) {
                    this.myLogger.error((Object)"Gui throwed", (Throwable)e);
                }
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void sendChildRemoved(int intObjectId, int intObjectType) {
        Vector vecListeners;
        AbstractBTSConfigObject abstractBTSConfigObject = this;
        synchronized (abstractBTSConfigObject) {
            vecListeners = (Vector)this.getObjectChangeListeners().clone();
        }
        int size = vecListeners.size();
        if (size > 0) {
            int i = 0;
            while (i < size) {
                ObjectChangeListener listener = (ObjectChangeListener)vecListeners.elementAt(i);
                try {
                    listener.childRemoved(intObjectId, intObjectType);
                }
                catch (Exception e) {
                    this.myLogger.error((Object)"Gui throwed", (Throwable)e);
                }
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void sendChildAdded(int intObjectId, int intObjectType) {
        Vector vecListeners;
        AbstractBTSConfigObject abstractBTSConfigObject = this;
        synchronized (abstractBTSConfigObject) {
            vecListeners = (Vector)this.getObjectChangeListeners().clone();
        }
        int size = vecListeners.size();
        if (size > 0) {
            int i = 0;
            while (i < size) {
                ObjectChangeListener listener = (ObjectChangeListener)vecListeners.elementAt(i);
                try {
                    listener.childAdded(intObjectId, intObjectType);
                }
                catch (Exception e) {
                    this.myLogger.error((Object)"Gui throwed", (Throwable)e);
                }
                ++i;
            }
        }
    }

    @Override
    public final synchronized void addObjectChangeListener(ObjectChangeListener listener) {
        if (listener != null) {
            if (this.myObjectChangeListeners.contains(listener)) {
                this.myLogger.debug((Object)"Adding ObjectChangeListener, but it already exists.");
            } else {
                this.myObjectChangeListeners.addElement(listener);
                this.myLogger.trace((Object)("Added ObjectChangeListener, now have " + this.myObjectChangeListeners.size() + " listeners."));
            }
        }
    }

    @Override
    public final synchronized void removeObjectChangeListener(ObjectChangeListener listener) {
        if (listener != null) {
            this.myObjectChangeListeners.removeElement(listener);
        }
    }

    @Override
    public final int getObjectType() {
        return this.myObjectType;
    }

    @Override
    public final void setObjectType(int intObjectType) {
        this.myObjectType = intObjectType;
    }

    @Override
    public final int getId() {
        return this.myId;
    }

    @Override
    public final void setId(int intId) {
        if (!this.isEditable()) {
            throw new UnsupportedOperationException("Operation not supported in online model");
        }
        this.doSetId(intId);
    }

    @Override
    public void removeObjectChangeListeners() {
        this.myObjectChangeListeners.clear();
    }
}

