/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.configuration;

import com.nokia.em.bts.coreasset.CoreAsset;
import com.nokia.em.bts.coreasset.configuration.AbstractBTSConfigObject;
import com.nokia.em.bts.coreasset.configuration.BTSConfigurationManager;
import com.nokia.em.bts.coreasset.configuration.Cabinet;
import com.nokia.em.bts.coreasset.configuration.CabinetImpl;
import com.nokia.em.bts.coreasset.configuration.Cell;
import com.nokia.em.bts.coreasset.configuration.CellGroup;
import com.nokia.em.bts.coreasset.configuration.CellGroupImpl;
import com.nokia.em.bts.coreasset.configuration.CellImpl;
import com.nokia.em.bts.coreasset.configuration.ConfigurationObjectFactoryImpl;
import com.nokia.em.bts.coreasset.configuration.EACInput;
import com.nokia.em.bts.coreasset.configuration.EACInputImpl;
import com.nokia.em.bts.coreasset.configuration.EACObject;
import com.nokia.em.bts.coreasset.configuration.EACOutput;
import com.nokia.em.bts.coreasset.configuration.EACOutputImpl;
import com.nokia.em.bts.coreasset.configuration.Link;
import com.nokia.em.bts.coreasset.configuration.LinkImpl;
import com.nokia.em.bts.coreasset.configuration.ModelListener;
import com.nokia.em.bts.coreasset.configuration.ObjectChangeListener;
import com.nokia.em.bts.coreasset.configuration.ObjectRelation;
import com.nokia.em.bts.coreasset.configuration.ObjectRelationImpl;
import com.nokia.em.bts.coreasset.configuration.OfflineSiteListener;
import com.nokia.em.bts.coreasset.configuration.Site;
import com.nokia.em.bts.coreasset.configuration.SiteImpl;
import com.nokia.em.bts.coreasset.configuration.SubUnit;
import com.nokia.em.bts.coreasset.configuration.SubUnitImpl;
import com.nokia.em.bts.coreasset.configuration.Unit;
import com.nokia.em.bts.coreasset.configuration.UnitImpl;
import com.nokia.em.bts.coreasset.message.CreateDatabaseFile;
import com.nokia.em.bts.coreasset.message.DataChangeNotif;
import com.nokia.em.bts.coreasset.message.DatabaseFileCreated;
import com.nokia.em.bts.coreasset.scenario.ScenarioManagerImpl;
import com.nokia.em.bts.rp.master.RadioAccessTechnologyType;
import com.nokia.em.bts.rp.master.connection.BTSConnection;
import com.nokia.em.bts.rp.master.connection.BTSNotificationListener;
import com.nokia.em.bts.rp.master.connection.ConnectionInfoAdapter;
import com.nokia.em.bts.rp.master.connection.ConnectionInfoListener;
import com.nokia.em.bts.rp.master.filetransfer.FTPTransferInfo;
import com.nokia.em.bts.rp.master.filetransfer.FileTransferClient;
import com.nokia.em.bts.rp.master.message.Ack;
import com.nokia.em.bts.rp.master.message.BTSInboundMessage;
import com.nokia.em.bts.rp.master.message.BTSMessage;
import com.nokia.em.bts.rp.master.message.FileLoadCompleted;
import com.nokia.em.bts.rp.master.message.Timeout;
import com.nokia.em.bts.rp.master.snapshot.SaverProgressListener;
import com.nokia.em.bts.rp.master.snapshot.SnapshotSaver;
import com.nokia.em.bts.rp.master.time.TimeZoneChangeListener;
import com.nokia.em.bts.rp.master.tool.CoreAssetThread;
import com.nokia.em.bts.rp.master.tool.Tools;
import com.nokia.em.poseidon.plugin.service.Service;
import com.nokia.em.poseidon.services.snapshot.PSnapshotConst;
import com.nokia.em.poseidon.util.file.PFileUtils;
import com.nokia.em.poseidon.util.probe.Probe;
import com.nokia.em.poseidon.util.probe.ProbeManager;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.log4j.Logger;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BTSConfigurationManagerImpl
extends ConnectionInfoAdapter
implements BTSNotificationListener,
BTSConfigurationManager,
SnapshotSaver,
Service {
    protected RadioAccessTechnologyType myRatType;
    private boolean isGetConfigurationFileTimeout = false;
    private File myOriginalSiteConf;
    private SiteImpl mySite;
    private BTSConnection myConnection;
    private TimeZoneChangeListener myTimeListener;
    private static final String BTSCONFFILENAME = "siteconf.xml";
    private static final String SNAPSHOT_TASK_SITECONF = "SiteConf";
    private static final String SNAPSHOT_TASK_NAME_SITECONF = "CoreAsset_Snapshot_SiteConf";
    private static final int SNAPSHOT_TIMEOUT = 10000;
    private static final String PROBE_TASK_NAME = "CoreAsset-CreateModel";
    private static final int SITECONF_MAX_RETRY = 10;
    private static final int SITECONF_RETRY_INTERVAL = 10000;
    private List<ObjectRelation> myObjectRelations;
    private Queue<BTSMessage> myBTSNotifications;
    private int myInitialBTSId;
    private CoreAssetThread myNotifWorker;
    private boolean myHWModelReady;
    private boolean myEACLinesReady;
    private String myDefaultCabinetProductCode;
    private Logger myLogger;
    private final Object lock = new Object();
    private boolean myShouldRun = true;
    private Set<ObjectRelation> myPendingObjectRelations;
    private ReentrantLock relationInsertLock = new ReentrantLock();
    private static final String BS_ID_NODENAME = "_bsId";
    private boolean myStoreNotifs = true;

    public boolean isGetConfigurationFileTimeout() {
        return this.isGetConfigurationFileTimeout;
    }

    public BTSConfigurationManagerImpl() {
        this.init();
    }

    public BTSConfigurationManagerImpl(BTSConnection connection) {
        this.init();
        this.setBTSConnection(connection);
    }

    @Override
    public void setBTSConnection(BTSConnection connection) {
        this.myConnection = connection;
        connection.addConnectionInfoListener((ConnectionInfoListener)this);
        this.myConnection.subscribeNotification((BTSNotificationListener)this);
    }

    protected void init() {
        this.myLogger = Logger.getLogger(this.getClass());
        this.myLogger.debug((Object)("BTSConfigurationManagerImpl " + this.toString()));
        this.myPendingObjectRelations = new HashSet<ObjectRelation>(10);
        this.myTimeListener = null;
        this.mySite = null;
        this.myObjectRelations = new CopyOnWriteArrayList<ObjectRelation>();
        this.myBTSNotifications = new ConcurrentLinkedQueue<BTSMessage>();
        this.myHWModelReady = false;
        this.myEACLinesReady = false;
        this.myInitialBTSId = -1;
        this.myDefaultCabinetProductCode = "Coreasset_Unknown";
        this.myNotifWorker = new CoreAssetThread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected Object construct() {
                while (BTSConfigurationManagerImpl.this.myShouldRun) {
                    try {
                        Object message;
                        if (BTSConfigurationManagerImpl.this.myHWModelReady) {
                            message = (BTSMessage)BTSConfigurationManagerImpl.this.myBTSNotifications.poll();
                            if (message != null) {
                                if (message.getSeqNbr() == -1) break;
                                BTSConfigurationManagerImpl.this.processNotification((BTSMessage)message);
                                continue;
                            }
                            Object object = BTSConfigurationManagerImpl.this.lock;
                            synchronized (object) {
                                BTSConfigurationManagerImpl.this.lock.wait();
                                continue;
                            }
                        }
                        message = BTSConfigurationManagerImpl.this.lock;
                        synchronized (message) {
                            BTSConfigurationManagerImpl.this.lock.wait();
                        }
                    }
                    catch (Exception ex) {
                        BTSConfigurationManagerImpl.this.myLogger.error((Object)"processNotification error: ", (Throwable)ex);
                    }
                }
                return true;
            }
        };
        this.myNotifWorker.start();
    }

    public BTSConfigurationManagerImpl(BTSConnection connection, TimeZoneChangeListener timeListener) {
        this(connection);
        this.myRatType = RadioAccessTechnologyType.BTS;
        this.myTimeListener = timeListener;
        connection.addConnectionInfoListener((ConnectionInfoListener)this.myTimeListener);
    }

    public BTSConfigurationManagerImpl(BTSConnection connection, TimeZoneChangeListener timeListener, RadioAccessTechnologyType type) {
        this(connection);
        this.myTimeListener = timeListener;
        this.myRatType = type;
        connection.addConnectionInfoListener((ConnectionInfoListener)this.myTimeListener);
    }

    public final int getInitialBTSId() {
        return this.myInitialBTSId;
    }

    @Override
    public final TimeZoneChangeListener getTimeListener() {
        return this.myTimeListener;
    }

    @Override
    public void addPendingRelationForMissingUnit(ObjectRelation relation) {
        this.myPendingObjectRelations.add(relation);
        this.myObjectRelations.remove(relation);
    }

    protected File getConfigurationFile(int dbType) {
        int seqNumber;
        File file;
        block15: {
            this.isGetConfigurationFileTimeout = false;
            if (CoreAsset.isSnapshotOpening() && dbType == 11) {
                URL url = CoreAsset.getSnapshotOpenLocation();
                File file2 = new File(String.valueOf(url.getFile()) + CoreAsset.FILE_SEPARATOR + SNAPSHOT_TASK_SITECONF + CoreAsset.FILE_SEPARATOR + SNAPSHOT_TASK_SITECONF + ".xml");
                return file2.isFile() ? file2 : null;
            }
            file = null;
            String confFileName = null;
            seqNumber = this.myConnection.createScenario();
            if (dbType != 11) {
                this.myLogger.error((Object)("Unknown DB Type " + Integer.toString(dbType)));
                return null;
            }
            confFileName = BTSCONFFILENAME;
            CreateDatabaseFile createDb = new CreateDatabaseFile(seqNumber, dbType, confFileName, this.myRatType.getBTSMessageType());
            this.myConnection.sendToBTS((BTSMessage)createDb);
            ProbeManager.probeInterval((String)PROBE_TASK_NAME, (String)"Message sent to BTS");
            BTSMessage response = this.myConnection.receiveFromBTS(seqNumber, 60000L);
            ProbeManager.probeInterval((String)PROBE_TASK_NAME, (String)"Message received from BTS");
            if (response instanceof DatabaseFileCreated) {
                DatabaseFileCreated temp = (DatabaseFileCreated)response;
                try {
                    FTPTransferInfo ftpTransferInfo = temp.getFTPTransferInfo();
                    if (ftpTransferInfo != null && ftpTransferInfo.getFileId() != null) {
                        FileTransferClient client = this.myConnection.getFileTransferFactory().getFileTransferClient();
                        client.setFTPTransferInfo(ftpTransferInfo);
                        file = client.getFile();
                        this.myConnection.sendToBTS((BTSMessage)new FileLoadCompleted(seqNumber, new String[]{ftpTransferInfo.getFileId()}));
                        break block15;
                    }
                    ftpTransferInfo = ScenarioManagerImpl.getFTPTransferInfo();
                    ftpTransferInfo.setFileName(temp.getFileId());
                    FileTransferClient client = this.myConnection.getFileTransferFactory().getFileTransferClient();
                    client.setFTPTransferInfo(ftpTransferInfo);
                    file = client.getFile();
                }
                catch (Exception e) {
                    this.myLogger.error((Object)"File transfer failed: ", (Throwable)e);
                    file = null;
                }
            } else if (response instanceof Ack) {
                Ack ackResponse = (Ack)response;
                if (!ackResponse.getAck()) {
                    file = null;
                }
            } else if (response instanceof Timeout) {
                file = null;
                this.isGetConfigurationFileTimeout = true;
            } else {
                this.myLogger.error((Object)("Wrong response message is received from BTS. DatabaseFileCreated or Ack expected, " + response + " received."));
            }
        }
        this.myConnection.deleteScenario(seqNumber);
        if (file != null) {
            try {
                this.myOriginalSiteConf = File.createTempFile("btssmSiteConf", ".xml");
                PFileUtils.copyFile((File)this.myOriginalSiteConf, (File)file);
                this.myOriginalSiteConf.deleteOnExit();
            }
            catch (IOException e) {
                this.myLogger.debug((Object)"Cannot copy the original site conf to a temporary file.");
            }
            file.deleteOnExit();
        }
        return file;
    }

    @Override
    public BTSConnection getBTSConnection() {
        return this.myConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        this.myConnection.removeConnectionInfoListener((ConnectionInfoListener)this);
        this.myConnection.unsubscribeNotification((BTSNotificationListener)this);
        this.myConnection.removeConnectionInfoListener((ConnectionInfoListener)this.myTimeListener);
        Object object = this.lock;
        synchronized (object) {
            this.myShouldRun = false;
            CoreAssetThread putter = new CoreAssetThread(){

                protected Object construct() throws Exception {
                    BTSConfigurationManagerImpl.this.myBTSNotifications.offer(new BTSInboundMessage(-1));
                    return true;
                }
            };
            putter.start();
            this.lock.notifyAll();
        }
        this.myObjectRelations.clear();
        this.myConnection = null;
        this.myTimeListener = null;
    }

    private String getHWData() {
        int l;
        Unit unit;
        StringBuilder sb = new StringBuilder("<?xml version=\"1.0\"?><DBObjects><SiteConfMgmDB>");
        sb.append("<BSs>");
        sb.append(this.mySite.writeXML());
        sb.append("</BSs>");
        Cabinet cabinet = this.mySite.getCabinet();
        sb.append("<Cabinets>");
        sb.append(cabinet.writeXML());
        sb.append("</Cabinets>");
        sb.append("<Cells>");
        int j = 0;
        while (j < this.mySite.getCells().size()) {
            sb.append(this.mySite.getCells().get(j).writeXML());
            ++j;
        }
        sb.append("</Cells>");
        sb.append("<ObjectRelations>");
        int i = 0;
        while (i < this.myObjectRelations.size()) {
            sb.append(this.myObjectRelations.get(i).writeXML());
            ++i;
        }
        sb.append("</ObjectRelations>");
        sb.append("<CellGroups>");
        Iterator<CellGroup> cellGroupIter = this.mySite.getCellGroups().iterator();
        while (cellGroupIter.hasNext()) {
            sb.append(cellGroupIter.next().writeXML());
        }
        sb.append("</CellGroups>");
        sb.append("<Units>");
        int k = 0;
        while (k < cabinet.getUnits().size()) {
            sb.append(cabinet.getUnits().get(k).writeXML());
            ++k;
        }
        sb.append("</Units>");
        sb.append("<Subunits>");
        k = 0;
        while (k < cabinet.getUnits().size()) {
            unit = cabinet.getUnits().get(k);
            l = 0;
            while (l < unit.getSubUnits().size()) {
                sb.append(unit.getSubUnits().get(l).writeXML());
                ++l;
            }
            ++k;
        }
        sb.append("</Subunits>");
        sb.append("<Links>");
        k = 0;
        while (k < cabinet.getUnits().size()) {
            unit = cabinet.getUnits().get(k);
            l = 0;
            while (l < unit.getLinks().size()) {
                sb.append(unit.getLinks().get(l).writeXML());
                ++l;
            }
            ++k;
        }
        sb.append("</Links>");
        sb.append(this.getEACData());
        sb.append("</SiteConfMgmDB></DBObjects>");
        return sb.toString();
    }

    private String getEACData() {
        StringBuilder sb = new StringBuilder("<EACInputs>");
        List<EACObject> eacs = this.mySite.getEACs();
        int i = 0;
        while (i < eacs.size()) {
            if (eacs.get(i) instanceof EACInput) {
                sb.append(((EACInput)eacs.get(i)).writeXML());
            }
            ++i;
        }
        sb.append("</EACInputs><EACOutputs>");
        i = 0;
        while (i < eacs.size()) {
            if (eacs.get(i) instanceof EACOutput) {
                sb.append(((EACOutput)eacs.get(i)).writeXML());
            }
            ++i;
        }
        sb.append("</EACOutputs>");
        return sb.toString();
    }

    private Boolean createHWModel(File file) {
        if (file != null) {
            ConfigurationObjectFactoryImpl confObjFact = new ConfigurationObjectFactoryImpl(this, file);
            try {
                this.mySite = confObjFact.createSite();
            }
            catch (Exception ex) {
                this.myLogger.error((Object)("Cannot create site model from siteconf.xml. Refer to the copy of siteconf.xml: " + file.getAbsolutePath()), (Throwable)ex);
                return false;
            }
            if (this.mySite == null) {
                this.myLogger.warn((Object)("Error, no Site defined in siteconf.xml. Created dummy Site object. Refer to the copy of siteconf.xml: " + file.getAbsolutePath()));
                this.setSite(new SiteImpl(this));
            } else if (!file.delete()) {
                file.deleteOnExit();
            }
            this.updateBSId();
            ((SiteImpl)this.getSite()).doSetEACs(confObjFact.createEACs());
            Cabinet cabinet = confObjFact.getCabinet();
            if (this.getSite().getCabinet() == null && cabinet == null) {
                CabinetImpl defCabinet = new CabinetImpl(this);
                defCabinet.doSetProductCode(this.myDefaultCabinetProductCode);
                ((SiteImpl)this.getSite()).doSetCabinet(defCabinet);
                this.myLogger.warn((Object)"Error: no Cabinet(s) defined. Created dummy Cabinet object.");
            } else {
                ((SiteImpl)this.getSite()).doSetCabinet(cabinet);
                this.myLogger.debug((Object)("Error: found cabinet " + cabinet.getId() + " belonging to non-existent Site . Added to Site " + this.getSite().getId() + "."));
            }
            List<Unit> vecRemainingUnits = confObjFact.getRemainingUnits();
            for (UnitImpl unitImpl : vecRemainingUnits) {
                CabinetImpl firstCabinet = (CabinetImpl)this.getSite().getCabinet();
                firstCabinet.doAddUnit(unitImpl);
                this.myLogger.trace((Object)("cannot add unit " + unitImpl.getId() + " to cabinet " + unitImpl.getCabinetId() + " in site " + unitImpl.doGetSiteId() + ". Cabinet not found. Added to cabinet " + firstCabinet.getId() + " in site " + this.getSite().getId() + "."));
            }
            ((SiteImpl)this.getSite()).doSetCells(confObjFact.createCells());
            confObjFact.createCellGroups();
            this.myObjectRelations = confObjFact.createObjectRelations();
            ((SiteImpl)this.getSite()).doSetCellGroups(confObjFact.getCellGroupRelations());
            return true;
        }
        this.myLogger.error((Object)"Unable to build model. The HW configuration file is not defined.");
        return false;
    }

    private void updateBSId() {
        Site site = this.getSite();
        if (this.myConnection != null && site != null) {
            int bsid = site.getId();
            String nodevalue = site.getCustomAttributeValue(BS_ID_NODENAME);
            if (nodevalue != null) {
                try {
                    bsid = Integer.valueOf(nodevalue);
                }
                catch (Exception e) {
                    this.myLogger.error((Object)"Invalid _bsId", (Throwable)e);
                }
            }
            this.myConnection.setBTSId(bsid);
        }
    }

    private UnitImpl getCoreFSMUnit() {
        List<Unit> units = this.mySite.getCabinet().getUnits();
        for (Unit tmpUnit : units) {
            UnitImpl unit = (UnitImpl)tmpUnit;
            if (!"CORE_FSM".equals(unit.getUnitType())) continue;
            return unit;
        }
        return null;
    }

    private void updateLinkInformation(LinkImpl newLinkImpl, int oType) {
        LinkImpl oldLinkImpl;
        UnitImpl unitForLink;
        int intOperationType;
        block24: {
            intOperationType = oType;
            unitForLink = null;
            oldLinkImpl = null;
            try {
                int unitId = newLinkImpl.getUnitId();
                UnitImpl unitImpl = (UnitImpl)this.mySite.getCabinet().getUnit(unitId);
                if ("S1".equals(newLinkImpl.getLinkType()) || "X2".equals(newLinkImpl.getLinkType())) {
                    unitImpl = this.getCoreFSMUnit();
                }
                if (unitImpl == null) break block24;
                unitForLink = unitImpl;
                for (LinkImpl linkImpl : unitImpl.getLinks()) {
                    if (linkImpl.getId() != newLinkImpl.getId()) continue;
                    oldLinkImpl = linkImpl;
                    break;
                }
            }
            catch (Exception e) {
                this.myLogger.warn((Object)"Error occured when trying to process link:", (Throwable)e);
                return;
            }
        }
        if (intOperationType == 24) {
            List<Unit> unitList;
            AbstractBTSConfigObject oldLinkImplTmp = null;
            unitForLink = this.getCoreFSMUnit();
            if (unitForLink != null) {
                for (Link link : unitForLink.getLinks()) {
                    LinkImpl linkI = (LinkImpl)link;
                    if (linkI.getId() != newLinkImpl.getId()) continue;
                    oldLinkImplTmp = linkI;
                    break;
                }
            }
            if (oldLinkImplTmp == null && (unitList = this.mySite.getCabinet().getUnits()) != null) {
                block4: for (Unit unit : unitList) {
                    unitForLink = (UnitImpl)unit;
                    for (Link link : unitForLink.getLinks()) {
                        LinkImpl linkI = (LinkImpl)link;
                        if (linkI.getId() != newLinkImpl.getId()) continue;
                        oldLinkImplTmp = linkI;
                        continue block4;
                    }
                }
            }
            if (unitForLink != null) {
                unitForLink.sendChildRemoved(oldLinkImplTmp.getId(), 13);
                unitForLink.doDeleteLink((Link)((Object)oldLinkImplTmp));
            } else {
                this.myLogger.warn((Object)("Unable to remove link with id " + Integer.toString(newLinkImpl.getId()) + " from unit with id " + Integer.toString(newLinkImpl.getUnitId()) + ": Unit doesn't exist in model."));
            }
            if (oldLinkImplTmp != null) {
                oldLinkImplTmp.sendObjectRemoved();
            } else {
                this.myLogger.warn((Object)("Unable to delete link with id " + Integer.toString(newLinkImpl.getId()) + " It doesn't exist or it has been deleted already."));
            }
        } else if (intOperationType == 22) {
            if (oldLinkImpl == null) {
                if (unitForLink != null) {
                    unitForLink.doAddLink(newLinkImpl);
                    unitForLink.sendChildAdded(newLinkImpl.getId(), 13);
                } else {
                    this.myLogger.warn((Object)("Unable to insert link " + Integer.toString(newLinkImpl.getId()) + " to unit " + Integer.toString(newLinkImpl.getUnitId()) + ". Unit does not exist."));
                }
            } else {
                this.myLogger.debug((Object)("Unable to insert link " + Integer.toString(newLinkImpl.getId()) + " to unit " + Integer.toString(newLinkImpl.getUnitId()) + ". Link already exists in this unit. Continuing with update."));
                intOperationType = 23;
            }
        }
        if (intOperationType == 23) {
            if (oldLinkImpl != null) {
                oldLinkImpl.update(newLinkImpl);
                oldLinkImpl.sendObjectChanged();
            } else {
                this.myLogger.debug((Object)("Unable to update link " + Integer.toString(newLinkImpl.getId()) + ". Link with such id is not found in this configuration. " + "Continuing with insert."));
                this.updateLinkInformation(newLinkImpl, 22);
            }
        }
        if (intOperationType != 23 && intOperationType != 22 && intOperationType != 24) {
            this.myLogger.error((Object)("Unrecognised operation." + intOperationType));
        }
    }

    private void updateCellInformation(CellImpl newCellImpl, int intOperationType) {
        block10: {
            if (newCellImpl == null) {
                this.myLogger.warn((Object)("Inconsistent information. upadating cell failed. Object does not exist in model." + intOperationType));
                return;
            }
            if (intOperationType == 23) {
                try {
                    int cellId = newCellImpl.getCellId();
                    CellImpl oldCell = (CellImpl)this.mySite.getCell(cellId);
                    if (oldCell != null) {
                        oldCell.update(newCellImpl);
                        oldCell.sendObjectChanged();
                        break block10;
                    }
                    this.myLogger.debug((Object)("Unable to update cell with id " + Integer.toString(cellId) + " Such cell doesn't exist in this configuration."));
                }
                catch (Exception e) {
                    this.myLogger.error((Object)"Error occured when trying to process cell: ", (Throwable)e);
                }
            } else if (intOperationType == 22) {
                this.mySite.addCell(newCellImpl);
            } else if (intOperationType == 24) {
                int cellId = newCellImpl.getCellId();
                CellImpl cellFound = (CellImpl)this.mySite.getCell(cellId);
                this.delelteCellInformation(cellFound, cellId);
            } else {
                this.myLogger.warn((Object)("Unknown operation type " + intOperationType));
            }
        }
    }

    private void updateUnitInformation(UnitImpl newUnitImpl, int intOperationType) {
        int unitId;
        UnitImpl oldUnitImpl = null;
        CabinetImpl cabinetImpl = null;
        try {
            unitId = newUnitImpl.getId();
            CabinetImpl someCabinet = (CabinetImpl)this.mySite.getCabinet();
            UnitImpl someUnit = (UnitImpl)someCabinet.getUnit(unitId);
            if (someUnit != null) {
                cabinetImpl = someCabinet;
                oldUnitImpl = someUnit;
            }
            if (cabinetImpl == null) {
                cabinetImpl = someCabinet;
            }
        }
        catch (Exception e) {
            this.myLogger.error((Object)"trying to process Unit: ", (Throwable)e);
            return;
        }
        if (intOperationType == 24) {
            if (oldUnitImpl != null) {
                cabinetImpl.sendChildRemoved(oldUnitImpl.getId(), 10);
                cabinetImpl.doRemoveUnitFromTheModel(oldUnitImpl);
                oldUnitImpl.sendObjectRemoved();
            } else {
                this.myLogger.debug((Object)("Unable to delete unit with id " + unitId + " It doesn't exist or it has been deleted already."));
            }
        } else if (intOperationType == 22 || intOperationType == 23) {
            if (oldUnitImpl != null) {
                String oldUnitType = oldUnitImpl.getUnitType();
                oldUnitImpl.update(newUnitImpl);
                if (oldUnitType.isEmpty() && !newUnitImpl.getUnitType().isEmpty()) {
                    cabinetImpl.sendChildAdded(newUnitImpl.getId(), 10);
                    this.getSite().sendObjectChanged();
                }
                oldUnitImpl.sendObjectChanged();
            } else {
                cabinetImpl.doAddUnit(newUnitImpl);
                cabinetImpl.sendChildAdded(newUnitImpl.getId(), 10);
                this.getSite().sendObjectChanged();
                ArrayList<ObjectRelation> tempList = new ArrayList<ObjectRelation>(this.myPendingObjectRelations);
                for (ObjectRelation relation : tempList) {
                    if (relation.getFromId() != newUnitImpl.getId() && relation.getToId() != newUnitImpl.getId()) continue;
                    this.myLogger.debug((Object)"Found pending relation for inserted unit. Trying to create the relation...");
                    this.writeLockingUpdateObjectRelationInsert(relation);
                }
            }
        } else {
            this.myLogger.warn((Object)("Unknown operation type " + intOperationType));
        }
    }

    private void updateCellGroupInformation(CellGroupImpl cellGroup) {
        CellGroupImpl oldCellGroup = (CellGroupImpl)this.mySite.getCellGroup(cellGroup.getId());
        if (oldCellGroup != null) {
            this.myLogger.debug((Object)("Cellgroup with id " + oldCellGroup.getId() + " changed."));
            oldCellGroup.doSetCustomAttributes(cellGroup.getCustomAttributes());
            oldCellGroup.sendObjectChanged();
        } else {
            this.myLogger.warn((Object)("old CellGroup not existing with id " + cellGroup.getId()));
        }
    }

    private void updateObjectRelation(ObjectRelation relation, int intOperationType) {
        if (intOperationType == 22) {
            this.writeLockingUpdateObjectRelationInsert(relation);
        } else if (intOperationType == 24) {
            this.updateObjectRelationRemove(relation.getId());
        }
    }

    private void writeLockingUpdateObjectRelationInsert(ObjectRelation relation) {
        try {
            this.relationInsertLock.lock();
            this.updateObjectRelationInsert(relation);
        }
        finally {
            this.relationInsertLock.unlock();
        }
    }

    private void updateObjectRelationInsert(ObjectRelation relation) {
        int fromType = relation.getFromType();
        int fromId = relation.getFromId();
        int toType = relation.getToType();
        int toId = relation.getToId();
        int type = relation.getType();
        for (ObjectRelation oldRelation : this.myObjectRelations) {
            if (oldRelation.getId() != relation.getId()) continue;
            if (fromType == oldRelation.getFromType() && fromId == oldRelation.getFromId() && toType == oldRelation.getToType() && toId == oldRelation.getToId() && type == oldRelation.getType()) {
                this.myLogger.debug((Object)"Relation matches, no changes, return.");
                return;
            }
            this.myLogger.debug((Object)"Relation insert, different relation exists already with same id. Removing old relation and inserting new. Model could be corrupted.");
            this.updateObjectRelationRemove(relation.getId());
            break;
        }
        this.myObjectRelations.add(relation);
        if (fromType == 5 && toType == 14) {
            this.updateObjectRelationInsertCellSubUnit(fromId, toId, relation);
        } else if (fromType == 14 && toType == 5) {
            this.updateObjectRelationInsertCellSubUnit(toId, fromId, relation);
        } else if (fromType == 5 && toType == 10) {
            this.updateObjectRelationInsertCellUnit(fromId, toId, relation);
        } else if (fromType == 10 && toType == 5) {
            this.updateObjectRelationInsertCellUnit(toId, fromId, relation);
        } else if (fromType == 5 && toType == 78) {
            this.updateObjectRelationInsertCellCellGroup(fromId, toId, relation);
        } else if (fromType == 78 && toType == 5) {
            this.updateObjectRelationInsertCellCellGroup(toId, fromId, relation);
        } else if (fromType == 10 && toType == 10) {
            if (type == 9) {
                this.updateObjectRelationInsertUnitUnitContained(fromId, toId, relation);
            } else {
                this.updateObjectRelationInsertUnitUnit(fromId, toId, relation);
            }
        } else if (fromType == 10 && toType == 78) {
            this.updateObjectRelationInsertUnitCellGroup(fromId, toId, relation);
        } else if (fromType == 78 && toType == 10) {
            this.updateObjectRelationInsertUnitCellGroup(toId, fromId, relation);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void updateObjectRelationInsertCellSubUnit(int cellId, int subUnitId, ObjectRelation relation) {
        this.myLogger.debug((Object)("[CARelation] Cell-SubUnit object relation inserting, cell: " + cellId + " subunit: " + subUnitId));
        try {
            Object var4_4 = null;
            SubUnitImpl subUnitImpl = null;
            boolean cellFound = false;
            boolean subUnitFound = false;
            for (CellImpl cellImpl : this.mySite.getCells()) {
                if (cellId == cellImpl.getCellId()) {
                    cellFound = true;
                    break;
                }
                this.myLogger.debug((Object)"[CARelation] Cell-SubUnit relation insert, cell not found.");
            }
            Cabinet cabinet = this.mySite.getCabinet();
            for (Unit unit : cabinet.getUnits()) {
                for (SubUnitImpl subUnitImpl2 : unit.getSubUnits()) {
                    if (subUnitId == subUnitImpl2.getId()) {
                        subUnitFound = true;
                        subUnitImpl = subUnitImpl2;
                        continue;
                    }
                    this.myLogger.debug((Object)"[CARelation] Cell-SubUnit relation insert, subunit not found.");
                }
            }
            if (subUnitFound && cellFound) {
                void var4_5;
                var4_5.doAddRelationSubUnitId(subUnitId);
                subUnitImpl.doAddRelationCellId(cellId);
                var4_5.sendObjectChanged();
                subUnitImpl.sendObjectChanged();
                this.myPendingObjectRelations.remove(relation);
            } else {
                this.myLogger.warn((Object)"[CARelation] Cell-SubUnit relation insert, missing objects. Adding relation to buffer...");
                this.myPendingObjectRelations.add(relation);
                this.myObjectRelations.remove(relation);
            }
        }
        catch (Exception exception) {
            this.myLogger.error((Object)"[CARelation] Cannot insert ObjectRelation Cell-SubUnit ", (Throwable)exception);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void updateObjectRelationInsertCellUnit(int cellId, int unitId, ObjectRelation relation) {
        this.myLogger.debug((Object)("[CARelation] Cell-Unit object relation inserting, cell: " + cellId + " unit: " + unitId));
        try {
            Object var4_4 = null;
            UnitImpl unitImpl = null;
            boolean cellFound = false;
            boolean unitFound = false;
            for (CellImpl cellImpl : this.mySite.getCells()) {
                if (cellId != cellImpl.getCellId()) continue;
                cellFound = true;
                break;
            }
            if (!cellFound) {
                this.myLogger.debug((Object)("[CARelation] Cell-Unit relation insert, cell: " + cellId + " unit: " + unitId + ", cell not found."));
            }
            for (UnitImpl unitImpl2 : this.mySite.getCabinet().getUnits()) {
                if (unitId != unitImpl2.getId()) continue;
                unitFound = true;
                unitImpl = unitImpl2;
                break;
            }
            if (!unitFound) {
                this.myLogger.debug((Object)("[CARelation] Cell-Unit relation insert, cell: " + cellId + " unit: " + unitId + ", unit not found."));
            }
            if (unitFound && cellFound) {
                void var4_5;
                var4_5.doAddRelationUnitId(unitId);
                unitImpl.doAddRelationCellId(cellId);
                var4_5.sendObjectChanged();
                unitImpl.sendObjectChanged();
                this.myPendingObjectRelations.remove(relation);
            } else {
                this.myLogger.warn((Object)("[CARelation] Cell-Unit relation insert, missing objects, cell: " + cellId + " unit: " + unitId + ". . Adding relation to buffer..."));
                this.myPendingObjectRelations.add(relation);
                this.myObjectRelations.remove(relation);
            }
        }
        catch (Exception exception) {
            this.myLogger.error((Object)"[CARelation] Cannot insert ObjectRelation Cell-Unit ", (Throwable)exception);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void updateObjectRelationInsertCellCellGroup(int cellId, int cellGroupId, ObjectRelation relation) {
        this.myLogger.debug((Object)("[CARelation] Cell-CellGroup object relation inserting, cell: " + cellId + " cellgroup: " + cellGroupId));
        try {
            Object var4_4 = null;
            Object var5_8 = null;
            boolean cellFound = false;
            boolean cellGroupFound = false;
            for (CellImpl cellImpl : this.mySite.getCells()) {
                if (cellId == cellImpl.getCellId()) {
                    cellFound = true;
                    break;
                }
                this.myLogger.debug((Object)"[CARelation] Cell-CellGroup relation insert, cell not found.");
            }
            if (cellFound) {
                void var4_5;
                void var5_12;
                Set<CellGroup> cellGroups = this.mySite.getCellGroups();
                for (CellGroupImpl cellGroupImpl : cellGroups) {
                    if (cellGroupImpl.getId() != cellGroupId) continue;
                    cellGroupFound = true;
                    break;
                }
                if (!cellGroupFound) {
                    CellGroupImpl cellGroupImpl = new CellGroupImpl(cellGroupId);
                    cellGroups.add(cellGroupImpl);
                    this.mySite.doSetCellGroups(cellGroups);
                }
                var5_12.doAddCell(cellId);
                var4_5.doSetCellGroupRelation((CellGroup)var5_12);
                this.mySite.sendObjectChanged();
                var4_5.sendObjectChanged();
                this.myPendingObjectRelations.remove(relation);
            } else {
                this.myLogger.warn((Object)("[CARelation] Cell-CellGroup relation insert, missing cell, cell: " + cellId + " cellgroup: " + cellGroupId + ". Adding relation to buffer..."));
                this.myPendingObjectRelations.add(relation);
                this.myObjectRelations.remove(relation);
            }
        }
        catch (Exception exception) {
            this.myLogger.error((Object)"[CARelation] Cannot insert ObjectRelation Cell-CellGroup ", (Throwable)exception);
        }
    }

    private void updateObjectRelationInsertUnitUnitContained(int fromId, int toId, ObjectRelation relation) {
        this.myLogger.debug((Object)("[CARelation] Unit-Unit Contained object relation inserting, from: " + fromId + " to: " + toId));
        try {
            UnitImpl fromUnit = this.searchUnitFromModel(fromId);
            UnitImpl toUnit = this.searchUnitFromModel(toId);
            if (fromUnit != null && toUnit != null) {
                fromUnit.doAddContainedRelationUnitId(toId);
                toUnit.doSetParentUnitId(fromId);
                fromUnit.sendObjectChanged();
                toUnit.sendObjectChanged();
                this.myPendingObjectRelations.remove(relation);
            } else {
                this.myLogger.warn((Object)("[CARelation] Unit-Unit Contained relation insert, missing objects, unit1: " + fromId + " unit2: " + toId + ". Adding relation to buffer..."));
                this.myPendingObjectRelations.add(relation);
                this.myObjectRelations.remove(relation);
            }
        }
        catch (Exception e) {
            this.myLogger.error((Object)"[CARelation] Cannot insert ObjectRelation Unit-Unit Contained", (Throwable)e);
        }
    }

    private void updateObjectRelationInsertUnitUnit(int unit1Id, int unit2Id, ObjectRelation relation) {
        this.myLogger.debug((Object)("[CARelation] Unit-Unit object relation inserting, unit1: " + unit1Id + " unit2: " + unit2Id));
        try {
            UnitImpl unit1Impl = this.searchUnitFromModel(unit1Id);
            UnitImpl unit2Impl = this.searchUnitFromModel(unit2Id);
            if (unit1Impl != null && unit2Impl != null) {
                unit1Impl.doAddRelationUnitId(unit2Id);
                unit2Impl.doAddRelationUnitId(unit1Id);
                unit1Impl.sendObjectChanged();
                unit2Impl.sendObjectChanged();
                this.myPendingObjectRelations.remove(relation);
            } else {
                this.myLogger.warn((Object)("[CARelation] Unit-Unit relation insert, missing objects, unit1: " + unit1Id + " unit2: " + unit2Id + ". Adding relation to buffer..."));
                this.myPendingObjectRelations.add(relation);
                this.myObjectRelations.remove(relation);
            }
        }
        catch (Exception e) {
            this.myLogger.error((Object)"[CARelation] Cannot insert ObjectRelation Unit-Unit", (Throwable)e);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void updateObjectRelationInsertUnitCellGroup(int unitId, int cellGroupId, ObjectRelation relation) {
        this.myLogger.debug((Object)("[CARelation] Unit-CellGroup object relation inserting, unit: " + unitId + " cellgroup: " + cellGroupId));
        Object var5_4 = null;
        boolean cellGroupFound = false;
        try {
            UnitImpl unit = this.searchUnitFromModel(unitId);
            if (unit != null) {
                void var5_8;
                Set<CellGroup> cellGroups = this.mySite.getCellGroups();
                for (CellGroupImpl cellGroupImpl : cellGroups) {
                    if (cellGroupImpl.getId() != cellGroupId) continue;
                    cellGroupFound = true;
                    break;
                }
                if (!cellGroupFound) {
                    CellGroupImpl cellGroupImpl = new CellGroupImpl(cellGroupId);
                    cellGroups.add(cellGroupImpl);
                    this.mySite.doSetCellGroups(cellGroups);
                }
                var5_8.doAddUnit(unitId);
                unit.doAddCellGroupRelation((CellGroup)var5_8);
                this.mySite.sendObjectChanged();
                unit.sendObjectChanged();
                this.myPendingObjectRelations.remove(relation);
            } else {
                this.myLogger.warn((Object)("[CARelation] Unit-CellGroup relation insert, missing unit, unit1: " + unitId + " cellGroup: " + cellGroupId + ". Adding relation to buffer..."));
                this.myPendingObjectRelations.add(relation);
                this.myObjectRelations.remove(relation);
            }
        }
        catch (Exception e) {
            this.myLogger.error((Object)"[CARelation] Cannot remove ObjectRelation Unit-CellGroup", (Throwable)e);
        }
    }

    private void updateObjectRelationRemove(int id) {
        this.myLogger.debug((Object)("[CARelation] Relation remove " + id));
        ObjectRelation relation = null;
        for (ObjectRelation iterRelation : this.myObjectRelations) {
            if (iterRelation.getId() != id) continue;
            relation = iterRelation;
            this.myObjectRelations.remove(iterRelation);
        }
        if (relation == null) {
            this.myLogger.debug((Object)"[CARelation] Cannot delete relation, not found in existing relations.");
            return;
        }
        this.myLogger.debug((Object)"[CARelation] Old relation found, continuing delete.");
        int fromType = relation.getFromType();
        int fromId = relation.getFromId();
        int toType = relation.getToType();
        int toId = relation.getToId();
        int type = relation.getType();
        if (fromType == 5 && toType == 14) {
            this.updateObjectRelationRemoveCellSubUnit(fromId, toId);
        } else if (fromType == 14 && toType == 5) {
            this.updateObjectRelationRemoveCellSubUnit(toId, fromId);
        } else if (fromType == 5 && toType == 10) {
            this.updateObjectRelationRemoveCellUnit(fromId, toId);
        } else if (fromType == 10 && toType == 5) {
            this.updateObjectRelationRemoveCellUnit(toId, fromId);
        } else if (fromType == 5 && toType == 78) {
            this.updateObjectRelationRemoveCellCellGroup(fromId, toId);
        } else if (fromType == 78 && toType == 5) {
            this.updateObjectRelationRemoveCellCellGroup(toId, fromId);
        } else if (fromType == 10 && toType == 10) {
            if (type == 9) {
                this.updateObjectRelationRemoveUnitUnitContained(fromId, toId);
            } else {
                this.updateObjectRelationRemoveUnitUnit(fromId, toId);
            }
        } else if (fromType == 10 && toType == 78) {
            this.updateObjectRelationRemoveUnitCellGroup(fromId, toId);
        } else if (fromType == 78 && toType == 10) {
            this.updateObjectRelationRemoveUnitCellGroup(toId, fromId);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void updateObjectRelationRemoveCellSubUnit(int cellId, int subUnitId) {
        this.myLogger.debug((Object)"[CARelation] Cell-SubUnit object relation deleting.");
        try {
            Object var3_3 = null;
            boolean cellFound = false;
            for (CellImpl cellImpl : this.mySite.getCells()) {
                if (cellId == cellImpl.getCellId()) {
                    cellImpl.doDeleteRelationSubUnitId(subUnitId);
                    cellFound = true;
                    break;
                }
                this.myLogger.debug((Object)"[CARelation] Cell-SubUnit relation delete, cell not found.");
            }
            for (Unit unit : this.mySite.getCabinet().getUnits()) {
                for (SubUnitImpl subUnitImpl : unit.getSubUnits()) {
                    if (subUnitId == subUnitImpl.getId()) {
                        subUnitImpl.doDeleteRelationCellId(cellId);
                        if (cellFound) {
                            void var3_4;
                            var3_4.sendObjectChanged();
                        }
                        subUnitImpl.sendObjectChanged();
                        return;
                    }
                    this.myLogger.debug((Object)"[CARelation] Cell-SubUnit relation delete, subunit not found.");
                }
            }
        }
        catch (Exception exception) {
            this.myLogger.warn((Object)"[CARelation] Cannot remove ObjectRelation Cell-SubUnit ", (Throwable)exception);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void updateObjectRelationRemoveCellUnit(int cellId, int unitId) {
        this.myLogger.debug((Object)"[CARelation] Cell-Unit object relation deleting.");
        try {
            Object var3_3 = null;
            boolean cellFound = false;
            for (CellImpl cellImpl : this.mySite.getCells()) {
                if (cellId == cellImpl.getCellId()) {
                    cellImpl.doDeleteRelationUnitId(unitId);
                    cellFound = true;
                    break;
                }
                this.myLogger.debug((Object)"[CARelation] Cell-Unit relation delete, cell not found.");
            }
            for (UnitImpl unitImpl : this.mySite.getCabinet().getUnits()) {
                if (unitId == unitImpl.getId()) {
                    unitImpl.doDeleteRelationCellId(cellId);
                    if (cellFound) {
                        void var3_4;
                        var3_4.sendObjectChanged();
                    }
                    unitImpl.sendObjectChanged();
                    return;
                }
                this.myLogger.debug((Object)"[CARelation] Cell-Unit relation delete, unit not found.");
            }
        }
        catch (Exception exception) {
            this.myLogger.warn((Object)"[CARelation] Cannot remove ObjectRelation Cell-Unit ", (Throwable)exception);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void updateObjectRelationRemoveCellCellGroup(int cellId, int cellGroupId) {
        this.myLogger.debug((Object)"[CARelation] Cell-CellGroup object relation deleting.");
        try {
            Object var3_3 = null;
            boolean cellFound = false;
            for (CellImpl cellImpl : this.mySite.getCells()) {
                if (cellId == cellImpl.getCellId() && cellGroupId == cellImpl.getCellGroup().getId()) {
                    cellImpl.doSetCellGroupRelation(null);
                    cellFound = true;
                    break;
                }
                this.myLogger.debug((Object)"[CARelation] Cell-CellGroup relation delete, cell not found.");
            }
            for (CellGroupImpl cellGroupImpl : this.mySite.getCellGroups()) {
                if (cellGroupId == cellGroupImpl.getId()) {
                    cellGroupImpl.doRemoveCell(cellId);
                    break;
                }
                this.myLogger.debug((Object)"[CARelation] Cell-CellGroup relation delete, cellgroup not found.");
            }
            if (cellFound) {
                void var3_4;
                var3_4.sendObjectChanged();
            }
            this.mySite.sendObjectChanged();
        }
        catch (Exception exception) {
            this.myLogger.warn((Object)"[CARelation] Cannot remove ObjectRelation Cell-CellGroup", (Throwable)exception);
        }
    }

    private void updateObjectRelationRemoveUnitUnitContained(int fromId, int toId) {
        this.myLogger.debug((Object)"[CARelation] Unit-Unit Contained object relation deleting.");
        try {
            UnitImpl fromUnit = this.searchUnitFromModel(fromId);
            UnitImpl toUnit = this.searchUnitFromModel(toId);
            if (fromUnit != null) {
                fromUnit.doRemoveContainedRelationUnitId(toId);
            } else {
                this.myLogger.debug((Object)"[CARelation] Unit-Unit Contained relation delete, fromUnit not found.");
            }
            if (toUnit != null) {
                toUnit.doSetParentUnitId(-1);
            } else {
                this.myLogger.debug((Object)"[CARelation] Unit-Unit Contained relation delete, toUnit found.");
            }
            if (fromUnit != null) {
                fromUnit.sendObjectChanged();
            }
            if (toUnit != null) {
                toUnit.sendObjectChanged();
            }
        }
        catch (Exception e) {
            this.myLogger.warn((Object)"[CARelation] Cannot remove ObjectRelation Unit-Unit Contained", (Throwable)e);
        }
    }

    private void updateObjectRelationRemoveUnitUnit(int fromId, int toId) {
        this.myLogger.debug((Object)"[CARelation] Unit-Unit object relation deleting.");
        try {
            UnitImpl fromUnit = this.searchUnitFromModel(fromId);
            UnitImpl toUnit = this.searchUnitFromModel(toId);
            if (fromUnit != null) {
                fromUnit.doRemoveRelationUnitId(toId);
            } else {
                this.myLogger.debug((Object)"[CARelation] Unit-Unit relation delete, fromUnit not found.");
            }
            if (toUnit != null) {
                toUnit.doRemoveRelationUnitId(fromId);
            } else {
                this.myLogger.debug((Object)"[CARelation] Unit-Unit relation delete, toUnit not found.");
            }
            if (fromUnit != null) {
                fromUnit.sendObjectChanged();
            }
            if (toUnit != null) {
                toUnit.sendObjectChanged();
            }
        }
        catch (Exception e) {
            this.myLogger.warn((Object)"[CARelation] Cannot remove ObjectRelation Unit-Unit", (Throwable)e);
        }
    }

    private void updateObjectRelationRemoveUnitCellGroup(int unitId, int cellGroupId) {
        this.myLogger.debug((Object)"[CARelation] Unit-CellGroup object relation deleting.");
        try {
            UnitImpl unit = this.searchUnitFromModel(unitId);
            Set<CellGroup> cellGroups = this.mySite.getCellGroups();
            Iterator<CellGroup> iter = cellGroups.iterator();
            CellGroupImpl foundCellGroup = null;
            while (iter.hasNext()) {
                CellGroup cellGroup = iter.next();
                if (cellGroup.getId() == cellGroupId) {
                    foundCellGroup = (CellGroupImpl)cellGroup;
                    foundCellGroup.doRemoveUnit(unitId);
                    if (unit != null) {
                        unit.doRemoveCellGroupRelation(foundCellGroup);
                        unit.sendObjectChanged();
                    } else {
                        this.myLogger.debug((Object)"[CARelation] Unit-CellGroup relation delete, Unit not found.");
                    }
                    this.mySite.sendObjectChanged();
                    continue;
                }
                this.myLogger.debug((Object)"[CARelation] Unit-CellGroup relation delete, CellGroup not found.");
            }
        }
        catch (Exception e) {
            this.myLogger.warn((Object)"[CARelation] Cannot remove ObjectRelation Unit-CellGroup", (Throwable)e);
        }
    }

    private void updateSiteInformation(SiteImpl newSiteImpl, int intOperationType) {
        if (intOperationType == 22 || intOperationType == 23) {
            this.mySite.update(newSiteImpl);
            this.updateBSId();
            this.mySite.sendObjectChanged();
        } else {
            this.myLogger.warn((Object)(String.valueOf(intOperationType) + " is not allowed operation."));
        }
    }

    private void updateSubUnitInformation(SubUnitImpl newSubUnitImpl, int intOperationType) {
        int parentUnitId;
        int subUnitId;
        UnitImpl parentUnitImpl = null;
        SubUnitImpl oldSubUnitImpl = null;
        try {
            subUnitId = newSubUnitImpl.getId();
            parentUnitId = newSubUnitImpl.getParentUnitId();
            if (this.mySite.getCabinet().getUnit(parentUnitId) != null) {
                parentUnitImpl = (UnitImpl)this.mySite.getCabinet().getUnit(parentUnitId);
                oldSubUnitImpl = (SubUnitImpl)parentUnitImpl.getSubUnit(subUnitId);
            }
        }
        catch (Exception e) {
            this.myLogger.error((Object)"trying to process SubUnit", (Throwable)e);
            return;
        }
        if (intOperationType == 23) {
            if (oldSubUnitImpl != null) {
                oldSubUnitImpl.update(newSubUnitImpl);
                oldSubUnitImpl.sendObjectChanged();
            } else {
                this.myLogger.debug((Object)("Unable to update subunit with id " + Integer.toString(subUnitId) + " Such subunit doesn't exist in this configuration. Continue with insert."));
                this.updateSubUnitInformation(newSubUnitImpl, 22);
            }
        } else if (intOperationType == 22) {
            if (parentUnitImpl != null) {
                if (parentUnitImpl.getSubUnit(subUnitId) == null) {
                    parentUnitImpl.doAddSubUnit(newSubUnitImpl);
                    parentUnitImpl.sendChildAdded(subUnitId, 14);
                } else {
                    this.myLogger.debug((Object)("Unable to insert subunit with id " + Integer.toString(subUnitId) + " Such subunit already exists in unit with id " + parentUnitId));
                    this.updateSubUnitInformation(newSubUnitImpl, 23);
                }
            } else {
                this.myLogger.debug((Object)("Unable to insert subunit with id " + Integer.toString(subUnitId) + " Parent unit object with id " + parentUnitId + " not found. "));
            }
        } else if (intOperationType == 24) {
            if (oldSubUnitImpl != null) {
                if (parentUnitImpl != null) {
                    parentUnitImpl.sendChildRemoved(oldSubUnitImpl.getId(), 14);
                    parentUnitImpl.doDeleteSubUnit(oldSubUnitImpl);
                } else {
                    this.myLogger.debug((Object)("Unable to delete subunit with id " + Integer.toString(subUnitId) + " from parent unit with id " + Integer.toString(parentUnitId) + ". Parent Unit object not found."));
                }
                oldSubUnitImpl.sendObjectRemoved();
            } else {
                this.myLogger.debug((Object)("Unable to delete subunit with id " + Integer.toString(subUnitId) + " Such subunit doesn't exist in this configuration."));
            }
        } else {
            this.myLogger.warn((Object)(String.valueOf(intOperationType) + " is not allowed operation."));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleNotification(BTSMessage message) {
        this.myBTSNotifications.offer(message);
        Object object = this.lock;
        synchronized (object) {
            this.lock.notify();
        }
    }

    private void updateInputEACInformation(EACInputImpl newEACInputImpl, int intOperationType) {
        int eacId;
        EACInputImpl oldEACInputImpl = null;
        try {
            eacId = newEACInputImpl.getId();
            SiteImpl someSite = (SiteImpl)this.getSite();
            if (someSite.getInputEAC(eacId) != null) {
                oldEACInputImpl = (EACInputImpl)someSite.getInputEAC(eacId);
            }
        }
        catch (Exception e) {
            this.myLogger.error((Object)"trying to process input EAC: ", (Throwable)e);
            return;
        }
        if (intOperationType == 23) {
            if (oldEACInputImpl != null) {
                oldEACInputImpl.update(newEACInputImpl);
                Vector<ObjectChangeListener> objChangeListeners = oldEACInputImpl.getObjectChangeListeners();
                int i = 0;
                while (i < objChangeListeners.size()) {
                    objChangeListeners.elementAt(i).objectChanged(newEACInputImpl);
                    ++i;
                }
            } else {
                this.myLogger.debug((Object)("Unable to modify Input EAC " + eacId + ". Input EAC does not exist in this " + "configuration."));
            }
        } else if (intOperationType == 22) {
            if (oldEACInputImpl == null) {
                this.getSite().addInputEAC(newEACInputImpl);
                this.mySite.sendChildAdded(newEACInputImpl.getId(), 11);
            }
        } else if (intOperationType == 24) {
            if (oldEACInputImpl != null) {
                this.getSite().removeInputEAC(oldEACInputImpl);
                this.mySite.sendChildRemoved(oldEACInputImpl.getId(), 11);
            }
        } else {
            this.myLogger.warn((Object)(String.valueOf(intOperationType) + " is not allowed operation for EAC."));
        }
    }

    private void updateOutputEACInformation(EACOutputImpl newEACOutputImpl, int intOperationType) {
        int eacId;
        EACOutputImpl oldEACOutputImpl = null;
        try {
            eacId = newEACOutputImpl.getId();
            if (this.getSite().getOutputEAC(eacId) != null) {
                oldEACOutputImpl = (EACOutputImpl)this.getSite().getOutputEAC(eacId);
            }
        }
        catch (Exception e) {
            this.myLogger.error((Object)"trying to process output EAC: ", (Throwable)e);
            return;
        }
        if (intOperationType == 23) {
            if (oldEACOutputImpl != null) {
                oldEACOutputImpl.update(newEACOutputImpl);
                Vector<ObjectChangeListener> objChangeListeners = oldEACOutputImpl.getObjectChangeListeners();
                int i = 0;
                while (i < objChangeListeners.size()) {
                    objChangeListeners.elementAt(i).objectChanged(newEACOutputImpl);
                    ++i;
                }
            } else {
                this.myLogger.debug((Object)("Unable to modify Output EAC " + eacId + ". Output EAC does not exist in this " + "configuration."));
            }
        } else if (intOperationType == 22) {
            if (oldEACOutputImpl == null) {
                this.getSite().addOutputEAC(newEACOutputImpl);
                this.mySite.sendChildAdded(newEACOutputImpl.getId(), 12);
            }
        } else if (intOperationType == 24) {
            if (oldEACOutputImpl != null) {
                this.getSite().removeOutputEAC(oldEACOutputImpl);
                this.mySite.sendChildRemoved(oldEACOutputImpl.getId(), 12);
            }
        } else {
            this.myLogger.warn((Object)(String.valueOf(intOperationType) + " is not allowed operation for EAC."));
        }
    }

    private void setSite(SiteImpl site) {
        this.mySite = site;
    }

    private synchronized void processNotification(BTSMessage message) {
        if (message == null) {
            this.myLogger.debug((Object)"BTSConfigurationManagerImpl.processnotif start, message is null");
        } else if (message instanceof DataChangeNotif) {
            DataChangeNotif notif = (DataChangeNotif)message;
            try {
                NodeList list = notif.getConfigObjectData();
                StringBuffer stringBuffer = new StringBuffer();
                int i = 0;
                while (i < list.getLength()) {
                    stringBuffer.append(Tools.xmlToString((Node)list.item(i)));
                    ++i;
                }
                this.myLogger.trace((Object)("BTSConfigurationManagerImpl.processnotif, db: " + stringBuffer));
            }
            catch (Exception e) {
                this.myLogger.debug((Object)("BTSConfigurationManagerImpl.processnotif, probl. logloop. " + e));
            }
            if (notif.getConfigObjectData() != null) {
                ConfigurationObjectFactoryImpl confObjFactoryImpl = new ConfigurationObjectFactoryImpl(this);
                if (notif.getConfigObjectType() == 10) {
                    UnitImpl unitImpl = confObjFactoryImpl.createUnit(notif.getConfigObjectData());
                    if (unitImpl != null && unitImpl.getId() != 0 && unitImpl.getId() != -1) {
                        if (unitImpl.getCabinetId() == -1) {
                            UnitImpl oldUnitImpl = this.searchUnitFromModel(unitImpl.getId());
                            if (oldUnitImpl != null) {
                                this.updateUnitInformation(oldUnitImpl, notif.getOperationType());
                            } else {
                                this.myLogger.error((Object)("Inconsistent information. " + unitImpl.getId() + " not found. Object does not exist in model."));
                            }
                        } else {
                            this.updateUnitInformation(unitImpl, notif.getOperationType());
                        }
                    } else {
                        this.myLogger.error((Object)("Processing DataChangeNotif for unit failed. Object couldn't be created from " + notif.getConfigObjectData()));
                    }
                } else if (notif.getConfigObjectType() == 13) {
                    LinkImpl linkImpl = confObjFactoryImpl.createLink(notif.getConfigObjectData());
                    if (linkImpl != null && linkImpl.getId() != 0 && linkImpl.getId() != -1) {
                        this.updateLinkInformation(linkImpl, notif.getOperationType());
                    } else {
                        this.myLogger.error((Object)("Processing DataChangeNotif for link failed. Object couldn't be created from " + notif.getConfigObjectData()));
                    }
                } else if (notif.getConfigObjectType() == 3) {
                    SiteImpl siteImpl = confObjFactoryImpl.createSite(notif.getConfigObjectData());
                    this.updateSiteInformation(siteImpl, notif.getOperationType());
                } else if (notif.getConfigObjectType() == 14) {
                    SubUnitImpl subUnitImpl = confObjFactoryImpl.createSubUnit(notif.getConfigObjectData());
                    if (subUnitImpl != null && subUnitImpl.getId() != 0 && subUnitImpl.getId() != -1) {
                        if (subUnitImpl.getParentUnitId() == -1 && notif.getOperationType() == 24) {
                            UnitImpl someUnit = this.searchParentUnitFromModel(subUnitImpl.getId());
                            if (someUnit != null) {
                                this.updateSubUnitInformation((SubUnitImpl)someUnit.getSubUnit(subUnitImpl.getId()), notif.getOperationType());
                            } else {
                                this.myLogger.error((Object)("Processing DataChangeNotif for subunit failed. Object couldn't be created from " + notif.getConfigObjectData() + " and parent not found in model."));
                            }
                        } else {
                            this.updateSubUnitInformation(subUnitImpl, notif.getOperationType());
                        }
                    } else {
                        this.myLogger.error((Object)("Processing DataChangeNotif for subunit failed. Object couldn't be created from " + notif.getConfigObjectData()));
                    }
                } else if (notif.getConfigObjectType() == 11) {
                    EACInputImpl eacInputImpl = confObjFactoryImpl.createEACInput(notif.getConfigObjectData());
                    if (eacInputImpl != null && eacInputImpl.getId() != 0 && eacInputImpl.getId() != -1) {
                        this.updateInputEACInformation(eacInputImpl, notif.getOperationType());
                    } else {
                        this.myLogger.error((Object)("Processing DataChangeNotif for Input EAC failed. Object couldn't be created from " + notif.getConfigObjectData()));
                    }
                } else if (notif.getConfigObjectType() == 12) {
                    EACOutputImpl eacOutputImpl = confObjFactoryImpl.createEACOutput(notif.getConfigObjectData());
                    if (eacOutputImpl != null && eacOutputImpl.getId() != 0 && eacOutputImpl.getId() != -1) {
                        this.updateOutputEACInformation(eacOutputImpl, notif.getOperationType());
                    } else {
                        this.myLogger.error((Object)("Processing DataChangeNotif for Output EAC failed. Object couldn't be created from " + notif.getConfigObjectData()));
                    }
                } else if (notif.getConfigObjectType() == 51) {
                    List<CellImpl> cells = confObjFactoryImpl.createCells(notif.getConfigObjectData());
                    for (CellImpl cellImpl : cells) {
                        this.updateCellInformation(cellImpl, notif.getOperationType());
                    }
                } else if (notif.getConfigObjectType() == 5) {
                    CellImpl cellImpl = confObjFactoryImpl.createCell(notif.getConfigObjectData());
                    this.updateCellInformation(cellImpl, notif.getOperationType());
                } else if (notif.getConfigObjectType() == 48) {
                    ObjectRelationImpl objectRelation = confObjFactoryImpl.createObjectRelation(notif.getConfigObjectData());
                    this.updateObjectRelation(objectRelation, notif.getOperationType());
                } else if (notif.getConfigObjectType() == 78) {
                    if (notif.getOperationType() == 23) {
                        CellGroupImpl cellGroup = confObjFactoryImpl.createCellGroup(notif.getConfigObjectData());
                        this.updateCellGroupInformation(cellGroup);
                    } else {
                        this.myLogger.error((Object)"Cellgroup datachange is not update operation, not supported.");
                    }
                } else {
                    this.myLogger.warn((Object)("processing DataChangeNotif. Configuration object type " + notif.getConfigObjectType() + " is unknown."));
                }
            } else if (notif.getConfigObjectId() != -1 && notif.getOperationType() != -1 && notif.getConfigObjectType() != -1) {
                int intId = notif.getConfigObjectId();
                int intOperation = notif.getOperationType();
                int intObjectType = notif.getConfigObjectType();
                if (intOperation == 24) {
                    Cabinet someCabinet = this.getSite().getCabinet();
                    if (intObjectType == 10) {
                        UnitImpl someUnit = this.searchUnitFromModel(intId);
                        if (someUnit != null) {
                            this.updateUnitInformation(someUnit, intOperation);
                        } else {
                            this.myLogger.warn((Object)("Inconsistent information. Deleting unit " + intId + " failed. Object does not exist in model."));
                        }
                    } else if (intObjectType == 13) {
                        boolean linkFound = false;
                        List<Unit> vecUnits = someCabinet.getUnits();
                        int j = 0;
                        while (j < vecUnits.size()) {
                            UnitImpl someUnit = (UnitImpl)vecUnits.get(j);
                            LinkImpl someLink = (LinkImpl)someUnit.getLink(intId);
                            if (someLink != null) {
                                this.updateLinkInformation(someLink, intOperation);
                                linkFound = true;
                                break;
                            }
                            ++j;
                        }
                        if (!linkFound) {
                            this.myLogger.warn((Object)("Inconsistent information. Deleting link " + intId + " failed. Object does not exist in model."));
                        }
                    } else if (intObjectType == 3) {
                        if (this.getSite().getId() == intId) {
                            this.updateSiteInformation((SiteImpl)this.getSite(), intOperation);
                        } else {
                            this.myLogger.warn((Object)("Inconsistent information. Deleting site " + intId + " failed. Object does not exist in model."));
                        }
                    } else if (intObjectType == 14) {
                        UnitImpl someUnit = this.searchParentUnitFromModel(intId);
                        if (someUnit != null) {
                            this.updateSubUnitInformation((SubUnitImpl)someUnit.getSubUnit(intId), intOperation);
                        } else {
                            this.myLogger.warn((Object)("Inconsistent information. Deleting subunit " + intId + " failed. Object does not exist in model."));
                        }
                    } else if (intObjectType == 5) {
                        this.updateCellInformation(intId, intOperation);
                    } else if (intObjectType == 48) {
                        boolean relationFound = false;
                        for (ObjectRelation relation : this.myObjectRelations) {
                            if (relation.getId() != intId) continue;
                            relationFound = true;
                            this.updateObjectRelation(relation, intOperation);
                        }
                        if (!relationFound) {
                            this.myLogger.warn((Object)("Inconsistent information. Deleting relation " + intId + " failed. Object does not exist in model."));
                        }
                    } else if (intObjectType == 11) {
                        SiteImpl someSite = (SiteImpl)this.getSite();
                        EACInputImpl eacInputImpl = (EACInputImpl)someSite.getInputEAC(intId);
                        if (eacInputImpl != null) {
                            this.updateInputEACInformation(eacInputImpl, intOperation);
                        } else {
                            this.myLogger.warn((Object)("Inconsistent information. Deleting EACInput " + intId + " failed. Object does not exist in model."));
                        }
                    } else if (intObjectType == 12) {
                        SiteImpl someSite = (SiteImpl)this.getSite();
                        EACOutputImpl eacOutputImpl = (EACOutputImpl)someSite.getOutputEAC(intId);
                        if (eacOutputImpl != null) {
                            this.updateOutputEACInformation(eacOutputImpl, intOperation);
                        } else {
                            this.myLogger.warn((Object)("Inconsistent information. Deleting EACOutput " + intId + " failed. Object does not exist in model."));
                        }
                    } else {
                        this.myLogger.warn((Object)("processing DataChangeNotif. Configuration object type " + notif.getConfigObjectType() + " is unknown."));
                    }
                } else {
                    this.myLogger.warn((Object)"processing DataChangeNotif. Object Data missing.");
                }
            } else {
                this.myLogger.warn((Object)"processing DataChangeNotif. Insufficient information from BTS. ");
            }
        }
    }

    private void updateCellInformation(int intId, int intOperation) {
        CellImpl cellFound = null;
        List<Cell> vecCells = this.getSite().getCells();
        int i = 0;
        while (i < vecCells.size()) {
            CellImpl someCell = (CellImpl)vecCells.get(i);
            if (someCell.getCellId() == intId) {
                cellFound = someCell;
                break;
            }
            ++i;
        }
        if (intOperation == 23 || intOperation == 22 || intOperation == 24) {
            this.updateCellInformation(cellFound, intOperation);
        } else {
            this.myLogger.warn((Object)("Unknown operation type " + intOperation));
        }
    }

    private void delelteCellInformation(CellImpl cellFound, int cellId) {
        if (cellFound != null) {
            this.getSite().deleteCell(cellFound);
        } else {
            this.myLogger.warn((Object)("Inconsistent information. Deleting cell " + cellId + " failed. Object does not exist in model."));
        }
    }

    private UnitImpl searchUnitFromModel(int idForSearchedUnitImpl) {
        try {
            UnitImpl someUnit = (UnitImpl)this.getSite().getCabinet().getUnit(idForSearchedUnitImpl);
            if (someUnit != null) {
                return someUnit;
            }
            this.myLogger.debug((Object)("Searching unit " + idForSearchedUnitImpl + ", not found."));
        }
        catch (Exception e) {
            this.myLogger.error((Object)("Error occured when trying to search unit " + idForSearchedUnitImpl), (Throwable)e);
        }
        return null;
    }

    private UnitImpl searchParentUnitFromModel(int idOfSubUnit) {
        List<Unit> vecUnits = this.getSite().getCabinet().getUnits();
        int j = 0;
        while (j < vecUnits.size()) {
            UnitImpl someUnit = (UnitImpl)vecUnits.get(j);
            SubUnitImpl someSubUnit = (SubUnitImpl)someUnit.getSubUnit(idOfSubUnit);
            if (someSubUnit != null) {
                return someUnit;
            }
            ++j;
        }
        return null;
    }

    public void btsConnected() {
        this.myLogger.debug((Object)"btsConnected event received.");
        this.myBTSNotifications.clear();
        this.myHWModelReady = false;
    }

    @Override
    public void createOfflineSite(final OfflineSiteListener listener) {
        CoreAssetThread worker = new CoreAssetThread(){

            protected Object construct() {
                BTSConfigurationManagerImpl.this.myLogger.debug((Object)"BTSConfigurationManagerImpl.createofflinesite, start");
                Site offlineSite = null;
                try {
                    Object cells;
                    HashMap<Integer, List<Integer>> relatedUnitIds = new HashMap<Integer, List<Integer>>();
                    HashMap<Integer, List<Integer>> containedUnitIds = new HashMap<Integer, List<Integer>>();
                    Site site = BTSConfigurationManagerImpl.this.getSite();
                    offlineSite = site.getEditableCopy();
                    int j = 0;
                    while (j < site.getCells().size()) {
                        Cell cell = site.getCells().get(j);
                        Cell offlineCell = cell.getEditableCopy();
                        offlineSite.addCell(offlineCell);
                        ++j;
                    }
                    Cabinet cabinet = site.getCabinet();
                    Cabinet offlineCabinet = cabinet.getEditableCopy();
                    offlineCabinet.setSite(offlineSite);
                    offlineSite.addCabinet(offlineCabinet);
                    int k = 0;
                    while (k < cabinet.getUnits().size()) {
                        try {
                            Unit unit = cabinet.getUnits().get(k);
                            Unit offlineUnit = null;
                            offlineUnit = unit.getEditableCopy();
                            offlineUnit.setSite(offlineSite);
                            offlineCabinet.addUnit(offlineUnit);
                            containedUnitIds.put(offlineUnit.getId(), unit.getContainedUnitIds());
                            relatedUnitIds.put(offlineUnit.getId(), unit.getRelatedUnitIds());
                            cells = unit.getCells();
                            int l = 0;
                            while (l < cells.size()) {
                                try {
                                    Cell offlineCell = offlineSite.getCell(((Cell)cells.get(l)).getCellId());
                                    if (offlineCell != null) {
                                        offlineCell.addUnit(offlineUnit);
                                        offlineUnit.addCell(offlineCell);
                                    } else {
                                        BTSConfigurationManagerImpl.this.myLogger.debug((Object)(String.valueOf(unit.getUnitType()) + unit.getVariant() + unit.getNumber() + "'s related offlineCell was null."));
                                    }
                                }
                                catch (Exception e) {
                                    BTSConfigurationManagerImpl.this.myLogger.warn((Object)("Failed to map unit " + unit.getUnitType() + unit.getVariant() + unit.getNumber() + " to a cell: "), (Throwable)e);
                                }
                                ++l;
                            }
                            l = 0;
                            while (l < unit.getSubUnits().size()) {
                                SubUnit subUnit = unit.getSubUnits().get(l);
                                SubUnit offlineSubUnit = subUnit.getEditableCopy();
                                offlineSubUnit.setParentUnit(offlineUnit);
                                offlineUnit.addSubUnit(offlineSubUnit);
                                List<Integer> cellIds = subUnit.getRelationCellIds();
                                int m = 0;
                                while (m < cells.size()) {
                                    try {
                                        Cell offlineCell = offlineSite.getCell(cellIds.get(m));
                                        if (offlineCell != null) {
                                            offlineCell.addSubUnit(offlineSubUnit);
                                            offlineSubUnit.addCell(offlineCell);
                                        } else {
                                            BTSConfigurationManagerImpl.this.myLogger.debug((Object)(String.valueOf(subUnit.getName()) + subUnit.getNumber() + "'s related offlineCell was null."));
                                        }
                                    }
                                    catch (Exception e) {
                                        BTSConfigurationManagerImpl.this.myLogger.warn((Object)("Failed to map subunit " + subUnit.getName() + subUnit.getNumber() + " to a cell: "), (Throwable)e);
                                    }
                                    ++m;
                                }
                                ++l;
                            }
                        }
                        catch (Exception e) {
                            BTSConfigurationManagerImpl.this.myLogger.error((Object)"Failed to create offline unit", (Throwable)e);
                        }
                        ++k;
                    }
                    k = 0;
                    while (k < offlineCabinet.getUnits().size()) {
                        Unit ou;
                        Unit offlineUnit = offlineCabinet.getUnits().get(k);
                        int id = offlineUnit.getId();
                        List contained = (List)containedUnitIds.get(id);
                        List related = (List)relatedUnitIds.get(id);
                        Iterator iter = contained.iterator();
                        while (iter.hasNext()) {
                            try {
                                ou = offlineCabinet.getUnit((Integer)iter.next());
                                if (ou != null) {
                                    offlineUnit.addContainedUnit(ou);
                                    continue;
                                }
                                BTSConfigurationManagerImpl.this.myLogger.debug((Object)(String.valueOf(offlineUnit.getUnitType()) + offlineUnit.getVariant() + offlineUnit.getNumber() + "'s contained unit was null."));
                            }
                            catch (Exception e) {
                                BTSConfigurationManagerImpl.this.myLogger.warn((Object)("Failed to get contained units for " + offlineUnit.getUnitType() + offlineUnit.getVariant() + offlineUnit.getNumber() + ": "), (Throwable)e);
                            }
                        }
                        iter = related.iterator();
                        while (iter.hasNext()) {
                            try {
                                ou = offlineCabinet.getUnit((Integer)iter.next());
                                if (ou != null) {
                                    offlineUnit.addRelatedUnit(ou);
                                    continue;
                                }
                                BTSConfigurationManagerImpl.this.myLogger.debug((Object)(String.valueOf(offlineUnit.getUnitType()) + offlineUnit.getVariant() + offlineUnit.getNumber() + "'s related unit was null."));
                            }
                            catch (Exception e) {
                                BTSConfigurationManagerImpl.this.myLogger.warn((Object)("Failed to get related units for " + offlineUnit.getUnitType() + offlineUnit.getVariant() + offlineUnit.getNumber() + ": "), (Throwable)e);
                            }
                        }
                        ++k;
                    }
                    Iterator<CellGroup> groups = site.getCellGroups().iterator();
                    while (groups.hasNext()) {
                        try {
                            CellGroup group = groups.next();
                            CellGroup offlineCellGroup = group.getEditableCopy();
                            offlineSite.addCellGroup(offlineCellGroup);
                            cells = group.getCellIds().iterator();
                            while (cells.hasNext()) {
                                try {
                                    int id = cells.next();
                                    offlineCellGroup.addCell(offlineSite.getCell(id));
                                }
                                catch (Exception e) {
                                    BTSConfigurationManagerImpl.this.myLogger.warn((Object)"Failed to add offline cell to offline cell group: ", (Throwable)e);
                                }
                            }
                            Iterator<Integer> units = group.getUnitIds().iterator();
                            while (units.hasNext()) {
                                try {
                                    int id = units.next();
                                    offlineCellGroup.addUnit(offlineSite.getCabinet().getUnit(id));
                                }
                                catch (Exception e) {
                                    BTSConfigurationManagerImpl.this.myLogger.warn((Object)"Failed to add offline unit to offline cell group: ", (Throwable)e);
                                }
                            }
                        }
                        catch (Exception e) {
                            BTSConfigurationManagerImpl.this.myLogger.error((Object)"Failed to create offline cell groups", (Throwable)e);
                        }
                    }
                }
                catch (Exception e) {
                    BTSConfigurationManagerImpl.this.myLogger.error((Object)"Failed to create offline site: ", (Throwable)e);
                }
                BTSConfigurationManagerImpl.this.myLogger.debug((Object)"BTSConfmanaimpl.createofflinesite, calling listener.buildsucceeded");
                listener.buildSucceeded(offlineSite);
                BTSConfigurationManagerImpl.this.myLogger.debug((Object)"BTSConfmanaimpl.createofflinesites, calling listener.buildsucceeded returned.");
                return null;
            }
        };
        worker.start();
    }

    @Override
    public final Site getSite() {
        return this.mySite;
    }

    public void btsNotificationReceived(BTSMessage message) {
        if (this.myStoreNotifs && message instanceof DataChangeNotif) {
            this.handleNotification(message);
        }
    }

    @Override
    public void buildHWModel(final ModelListener listener) {
        CoreAssetThread worker = new CoreAssetThread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected Object construct() {
                Boolean returnValue;
                block12: {
                    File file;
                    ProbeManager.addProbe((Probe.Type)Probe.Type.MULTIPLE_EXECUTION, (String)BTSConfigurationManagerImpl.PROBE_TASK_NAME, (String)"Creates model");
                    ProbeManager.startProbe((String)BTSConfigurationManagerImpl.PROBE_TASK_NAME);
                    int retryCount = 0;
                    BTSConfigurationManagerImpl.this.myStoreNotifs = true;
                    BTSConfigurationManagerImpl.this.myBTSNotifications.clear();
                    while ((file = BTSConfigurationManagerImpl.this.getConfigurationFile(11)) == null && !CoreAsset.isSnapshotOpening() && !BTSConfigurationManagerImpl.this.isGetConfigurationFileTimeout() && retryCount < 10) {
                        ++retryCount;
                        try {
                            if (retryCount < 10) {
                                BTSConfigurationManagerImpl.this.myLogger.debug((Object)("Create HW Model from siteconf file failed for " + retryCount + " time, retry after " + 10 + " seconds..."));
                            }
                            4.sleep((long)10000L);
                        }
                        catch (InterruptedException e) {
                            BTSConfigurationManagerImpl.this.myLogger.error((Object)("The current thread is interrupted in " + retryCount + " time retry. "), (Throwable)e);
                        }
                        BTSConfigurationManagerImpl.this.myBTSNotifications.clear();
                    }
                    ProbeManager.probeInterval((String)BTSConfigurationManagerImpl.PROBE_TASK_NAME, (String)"Receiving siteconf File with FTP");
                    returnValue = BTSConfigurationManagerImpl.this.createHWModel(file);
                    ProbeManager.probeInterval((String)BTSConfigurationManagerImpl.PROBE_TASK_NAME, (String)"Model building");
                    try {
                        if (returnValue.booleanValue()) {
                            BTSConfigurationManagerImpl.this.myEACLinesReady = true;
                            CoreAsset.addSnapshotSaver(BTSConfigurationManagerImpl.this);
                            try {
                                listener.buildSucceeded();
                            }
                            catch (Exception e) {
                                BTSConfigurationManagerImpl.this.myLogger.error((Object)"GUI broken, continuing anyway: ", (Throwable)e);
                            }
                            ProbeManager.probeInterval((String)BTSConfigurationManagerImpl.PROBE_TASK_NAME, (String)"Gui model building");
                            BTSConfigurationManagerImpl.this.myLogger.debug((Object)"Model built, GUI is ready.");
                            Object e = BTSConfigurationManagerImpl.this.lock;
                            synchronized (e) {
                                BTSConfigurationManagerImpl.this.myLogger.trace((Object)"HW created succesfully.");
                                BTSConfigurationManagerImpl.this.myHWModelReady = true;
                                BTSConfigurationManagerImpl.this.lock.notify();
                                break block12;
                            }
                        }
                        BTSConfigurationManagerImpl.this.myLogger.error((Object)"Configuration build failed.");
                        SiteImpl site = new SiteImpl(BTSConfigurationManagerImpl.this);
                        site.doSetCabinet(new CabinetImpl(BTSConfigurationManagerImpl.this));
                        BTSConfigurationManagerImpl.this.setSite(site);
                        listener.buildFailed();
                        BTSConfigurationManagerImpl.this.myBTSNotifications.clear();
                        BTSConfigurationManagerImpl.this.myStoreNotifs = false;
                    }
                    catch (Exception e) {
                        BTSConfigurationManagerImpl.this.myLogger.error((Object)"Configuration build failed: ", (Throwable)e);
                        BTSConfigurationManagerImpl.this.setSite(new SiteImpl(BTSConfigurationManagerImpl.this));
                        listener.buildFailed();
                        BTSConfigurationManagerImpl.this.myBTSNotifications.clear();
                        BTSConfigurationManagerImpl.this.myStoreNotifs = false;
                    }
                }
                ProbeManager.stopProbe((String)BTSConfigurationManagerImpl.PROBE_TASK_NAME, (String)"Handling pending datachangenotifs");
                return returnValue;
            }
        };
        worker.start();
    }

    @Override
    public void setDefaultCabinetProductCode(String strProductCode) {
        this.myDefaultCabinetProductCode = strProductCode;
    }

    @Override
    public boolean isHWModelReady() {
        return this.myHWModelReady;
    }

    @Override
    public boolean isEACLinesReady() {
        return this.myEACLinesReady;
    }

    public Collection<String> getSavingTasks(PSnapshotConst.SNAPSHOT_LEVEL level) {
        ArrayList<String> l = new ArrayList<String>();
        l.add(SNAPSHOT_TASK_NAME_SITECONF);
        return l;
    }

    public boolean isLocalisationRequired() {
        return true;
    }

    public void save(final String url, PSnapshotConst.SNAPSHOT_LEVEL level, final SaverProgressListener sp) {
        CoreAssetThread worker = new CoreAssetThread(){

            protected Object construct() {
                BTSConfigurationManagerImpl.this.runSave(url, sp);
                return null;
            }
        };
        worker.start();
    }

    private void runSave(String url, SaverProgressListener sp) {
        block10: {
            try {
                sp.taskStarted(SNAPSHOT_TASK_NAME_SITECONF, 7, 10000, this.isLocalisationRequired());
                File dir = new File(String.valueOf(url) + CoreAsset.FILE_SEPARATOR + SNAPSHOT_TASK_SITECONF);
                if (!dir.mkdir()) {
                    this.myLogger.warn((Object)"Failed to create site configuration snapshot directory");
                }
                String siteconfFile = String.valueOf(url) + CoreAsset.FILE_SEPARATOR + SNAPSHOT_TASK_SITECONF + CoreAsset.FILE_SEPARATOR + SNAPSHOT_TASK_SITECONF;
                File f = new File(String.valueOf(siteconfFile) + ".xml");
                File fOriginal = new File(String.valueOf(siteconfFile) + "_original.xml");
                OutputStreamWriter out = null;
                try {
                    try {
                        out = new OutputStreamWriter(new FileOutputStream(f, false));
                        out.write(this.getHWData());
                        if (this.myOriginalSiteConf.exists()) {
                            PFileUtils.copyFile((File)fOriginal, (File)this.myOriginalSiteConf);
                        } else {
                            this.myLogger.warn((Object)"The original site conf is not existing anymore.");
                        }
                    }
                    catch (Exception e) {
                        sp.taskUpdated(SNAPSHOT_TASK_NAME_SITECONF, 4, this.isLocalisationRequired());
                        this.myLogger.error((Object)"Failed to save site configuration snapshot file: ", (Throwable)e);
                        out.close();
                        sp.taskUpdated(SNAPSHOT_TASK_NAME_SITECONF, 8, this.isLocalisationRequired());
                        this.myLogger.debug((Object)"Site configuration snapshot file successfully created");
                        break block10;
                    }
                }
                catch (Throwable throwable) {
                    out.close();
                    sp.taskUpdated(SNAPSHOT_TASK_NAME_SITECONF, 8, this.isLocalisationRequired());
                    this.myLogger.debug((Object)"Site configuration snapshot file successfully created");
                    throw throwable;
                }
                out.close();
                sp.taskUpdated(SNAPSHOT_TASK_NAME_SITECONF, 8, this.isLocalisationRequired());
                this.myLogger.debug((Object)"Site configuration snapshot file successfully created");
            }
            catch (Exception e) {
                sp.taskUpdated(SNAPSHOT_TASK_NAME_SITECONF, 4, this.isLocalisationRequired());
                this.myLogger.error((Object)"Failed to save site configuration snapshot data: ", (Throwable)e);
            }
        }
        sp.saveCompleted((SnapshotSaver)this);
    }

    public void cancel(SaverProgressListener sp) {
        sp.saveCancelled((SnapshotSaver)this);
    }

    public int getSavingPriority() {
        return 2;
    }

    public void stopProcess(int process) {
    }

    public RadioAccessTechnologyType getRatType() {
        return this.myRatType;
    }

    public void setRatType(RadioAccessTechnologyType ratType) {
        this.myRatType = ratType;
    }

    public void start() {
    }

    public void stop() {
    }
}

