/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.configuration;

import com.nokia.em.bts.coreasset.CoreAsset;
import com.nokia.em.bts.coreasset.configuration.AbstractBTSConfigObject;
import com.nokia.em.bts.coreasset.configuration.BTSConfigObject;
import com.nokia.em.bts.coreasset.configuration.BTSConfigurationManager;
import com.nokia.em.bts.coreasset.configuration.Cabinet;
import com.nokia.em.bts.coreasset.configuration.ObjectChangeListener;
import com.nokia.em.bts.coreasset.configuration.RackShelfSlot;
import com.nokia.em.bts.coreasset.configuration.Site;
import com.nokia.em.bts.coreasset.configuration.Unit;
import com.nokia.em.bts.coreasset.configuration.UnitComparator;
import com.nokia.em.bts.coreasset.configuration.UnitImpl;
import com.nokia.em.bts.coreasset.message.RemoveUnitFromDBRequest;
import com.nokia.em.bts.rp.master.message.Ack;
import com.nokia.em.bts.rp.master.message.BTSMessage;
import com.nokia.em.bts.rp.master.tool.CoreAssetThread;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class CabinetImpl
extends AbstractBTSConfigObject
implements Cabinet {
    protected static final String NODENAME = "Cabinet";
    protected static final String BSID_NODENAME = "_bsId";
    protected static final String CABINET_TYPE_NODENAME = "_cabinetType";
    protected static final String PRODUCT_CODE_NODENAME = "_productCode";
    protected static final String SERIAL_NUMBER_NODENAME = "_serialNro";
    private Vector myUnitsUserRequestedToRemove;
    private UnitComparator myUnitComparator;
    private String myCabinetType;
    private int mySiteId;
    private String myProductCode;
    private String mySerialNro;
    private List<Unit> myUnits;
    private Map<Integer, Unit> myUnitsMap = new HashMap<Integer, Unit>();
    private Logger myLogger = Logger.getLogger(this.getClass());
    private Site mySite;

    public CabinetImpl(BTSConfigurationManager btsConfMgr) {
        this(btsConfMgr, -1, -1, "Coreasset_Unknown", "Coreasset_Unknown", "Coreasset_Unknown");
    }

    public CabinetImpl(BTSConfigurationManager btsConfMgr, int intId, int intSiteId, String strCabinetType, String strProductCode, String strSerialNro) {
        super(btsConfMgr, intId, 4);
        this.mySiteId = intSiteId;
        this.myCabinetType = strCabinetType;
        this.myProductCode = strProductCode;
        this.mySerialNro = strSerialNro;
        this.myUnitsUserRequestedToRemove = new Vector(20);
        this.myUnits = new ArrayList<Unit>();
        this.myUnitComparator = UnitComparator.getInstance();
    }

    private CabinetImpl(Cabinet c) {
        this(null, c.getId(), c.getSite().getId(), c.getCabinetType(), c.getProductCode(), c.getSerialNro());
        this.doSetCustomAttributes(c.getCustomAttributes());
        this.setEditable(true);
    }

    public CabinetImpl() {
        this((BTSConfigurationManager)null);
        this.setEditable(true);
    }

    @Override
    protected final Node getRoot(Document doc) {
        Element root = doc.createElement(NODENAME);
        root.appendChild(this.createElement(doc, "_id", this.getId()));
        root.appendChild(this.createElement(doc, BSID_NODENAME, this.doGetSiteId()));
        root.appendChild(this.createElement(doc, CABINET_TYPE_NODENAME, this.getCabinetType()));
        root.appendChild(this.createElement(doc, PRODUCT_CODE_NODENAME, this.getProductCode()));
        root.appendChild(this.createElement(doc, SERIAL_NUMBER_NODENAME, this.getSerialNro()));
        return root;
    }

    protected final Vector doGetUnitsUserRequestedToRemove() {
        return this.myUnitsUserRequestedToRemove;
    }

    protected final void doRemoveUnitFromTheModel(UnitImpl unit) {
        this.myUnits.remove(unit);
        this.myUnitsMap.remove(unit.getId());
        this.removeUnitIdFromPendingList(unit.getId());
    }

    protected final int doGetSiteId() {
        return this.mySiteId;
    }

    protected final void doSetSiteId(int intSiteId) {
        this.mySiteId = intSiteId;
    }

    protected final void doSetSerialNro(String strSerialNro) {
        this.mySerialNro = strSerialNro;
    }

    protected void doSetCabinetType(String strCabinetType) {
        this.myCabinetType = strCabinetType;
    }

    protected final void doSetProductCode(String strProductCode) {
        this.myProductCode = strProductCode;
    }

    private synchronized void addUnitIdToPendingList(int unitId) {
        this.myUnitsUserRequestedToRemove.add(unitId);
    }

    private synchronized void removeUnitIdFromPendingList(int unitId) {
        this.myUnitsUserRequestedToRemove.remove((Object)unitId);
    }

    @Override
    protected final void update(BTSConfigObject btsConfigObject) {
        if (btsConfigObject instanceof CabinetImpl && btsConfigObject != null) {
            try {
                CabinetImpl newCabinet = (CabinetImpl)btsConfigObject;
                this.doSetCabinetType(newCabinet.getCabinetType());
                this.doSetProductCode(newCabinet.getProductCode());
                this.doSetSerialNro(newCabinet.getSerialNro());
                this.doSetSiteId(newCabinet.doGetSiteId());
                this.doSetCustomAttributes(newCabinet.getCustomAttributes());
            }
            catch (Exception e) {
                this.myLogger.error((Object)e);
            }
        } else {
            this.myLogger.debug((Object)("Unable to update Cabinet using " + btsConfigObject));
        }
    }

    protected final void doAddUnit(Unit unit) {
        if (unit != null && this.myUnits != null) {
            this.myUnits.add(unit);
            this.myUnitsMap.put(unit.getId(), unit);
            if (this.mySite != null) {
                this.mySite.upateMaxObjectId(unit.getId());
            }
        }
    }

    @Override
    public void removeUnitFromDB(final int unitId) {
        CoreAssetThread worker = new CoreAssetThread(){

            protected Object construct() {
                if (CoreAsset.isSnapshotOpening()) {
                    CabinetImpl.this.myLogger.debug((Object)"No snapshot open supported.");
                    UnitImpl unit = (UnitImpl)CabinetImpl.this.getUnit(unitId);
                    if (unit != null) {
                        Vector listeners = (Vector)unit.getObjectChangeListeners().clone();
                        int i = 0;
                        while (i < listeners.size()) {
                            ((ObjectChangeListener)listeners.elementAt(i)).objectRemoveFailed(85);
                            ++i;
                        }
                    }
                    return true;
                }
                boolean blnReturnValue = false;
                UnitImpl unit = (UnitImpl)CabinetImpl.this.getUnit(unitId);
                if (unit != null) {
                    Vector listeners = (Vector)unit.getObjectChangeListeners().clone();
                    int seqNumber = CabinetImpl.this.myConnection.createScenario();
                    RemoveUnitFromDBRequest removeUnitFromDBRequest = new RemoveUnitFromDBRequest(seqNumber, unitId);
                    CabinetImpl.this.myConnection.sendToBTS((BTSMessage)removeUnitFromDBRequest);
                    BTSMessage response = CabinetImpl.this.myConnection.receiveFromBTS(seqNumber);
                    CabinetImpl.this.myConnection.deleteScenario(seqNumber);
                    if (response instanceof Ack) {
                        Ack ackResponse = (Ack)response;
                        if (!ackResponse.getAck()) {
                            int i = 0;
                            while (i < listeners.size()) {
                                ((ObjectChangeListener)listeners.elementAt(i)).objectRemoveFailed(ackResponse.getNackReason());
                                ++i;
                            }
                        } else {
                            blnReturnValue = true;
                            CabinetImpl.this.addUnitIdToPendingList(unitId);
                            int i = 0;
                            while (i < listeners.size()) {
                                ((ObjectChangeListener)listeners.elementAt(i)).objectRemoveRequested();
                                ++i;
                            }
                        }
                    } else {
                        int i = 0;
                        while (i < listeners.size()) {
                            ((ObjectChangeListener)listeners.elementAt(i)).objectRemoveFailed(28);
                            ++i;
                        }
                    }
                } else {
                    CabinetImpl.this.myLogger.debug((Object)("Unit " + unitId + " can't be removed, it can't be found."));
                }
                return blnReturnValue;
            }
        };
        worker.start();
    }

    @Override
    public final String getCabinetType() {
        return this.myCabinetType;
    }

    @Override
    public Site getSite() {
        return this.isEditable() ? this.mySite : this.myBTSConfigurationManager.getSite();
    }

    @Override
    public final String getProductCode() {
        return this.myProductCode;
    }

    @Override
    public final String getSerialNro() {
        return this.mySerialNro;
    }

    @Override
    public List<Unit> getUnits() {
        ArrayList<Unit> u = new ArrayList<Unit>(this.myUnits);
        return u;
    }

    @Override
    public final List<Unit> getUnits(boolean blnExist) {
        ArrayList<Unit> selectedUnits = new ArrayList<Unit>(20);
        int i = 0;
        int size = this.myUnits.size();
        while (i < size) {
            Unit unit = this.myUnits.get(i);
            if (unit.getExist() == blnExist) {
                selectedUnits.add(unit);
            }
            ++i;
        }
        Collections.sort(selectedUnits, this.myUnitComparator);
        return selectedUnits;
    }

    @Override
    public Unit getUnit(int intId) {
        return this.myUnitsMap.get(intId);
    }

    @Override
    public final Unit getUnit(RackShelfSlot rackShelfSlot) {
        int i = 0;
        int size = this.myUnits.size();
        while (i < size) {
            Unit someUnit = this.myUnits.get(i);
            if (someUnit.getRackShelfSlot().isSame(rackShelfSlot)) {
                return someUnit;
            }
            ++i;
        }
        return null;
    }

    @Override
    public final List<Unit> getUnits(RackShelfSlot rackShelfSlot) {
        ArrayList<Unit> l = new ArrayList<Unit>();
        int i = 0;
        int size = this.myUnits.size();
        while (i < size) {
            Unit someUnit = this.myUnits.get(i);
            if (someUnit.getRackShelfSlot().isSame(rackShelfSlot)) {
                l.add(someUnit);
            }
            ++i;
        }
        return l;
    }

    @Override
    public Cabinet getEditableCopy() {
        if (this.isEditable()) {
            throw new UnsupportedOperationException("This cabinet is already editable");
        }
        return new CabinetImpl(this);
    }

    @Override
    public void addUnit(Unit unit) {
        if (!this.isEditable()) {
            throw new UnsupportedOperationException("Operation not supported in online model");
        }
        if (unit != null) {
            if (!this.myUnits.contains(unit)) {
                if (unit.getId() == -1 && unit instanceof UnitImpl) {
                    if (this.mySite != null) {
                        ((UnitImpl)unit).doSetId(this.mySite.getAvailableId());
                        unit.setSite(this.mySite);
                        this.myLogger.debug((Object)("Assigned id " + unit.getId() + " to unit " + unit.getName()));
                    } else {
                        this.myLogger.error((Object)"Cannot assign id to a unit because site has not been set for the parent cabinet");
                    }
                } else if (this.mySite != null) {
                    this.mySite.upateMaxObjectId(unit.getId());
                }
                this.myUnits.add(unit);
                this.myUnitsMap.put(unit.getId(), unit);
                unit.setCabinet(this);
                this.sendChildAdded(unit.getId(), 10);
            } else {
                this.myLogger.error((Object)"The unit has been added");
            }
        } else {
            this.myLogger.error((Object)"Cannot add null unit");
        }
    }

    @Override
    public void deleteUnit(Unit unit) {
        if (!this.isEditable()) {
            throw new UnsupportedOperationException("Operation not supported in online model");
        }
        if (unit != null) {
            this.sendChildRemoved(unit.getId(), 10);
            this.myUnits.remove(unit);
            this.myUnitsMap.remove(unit.getId());
            unit.sendObjectRemoved();
            unit.destroy();
        } else {
            this.myLogger.error((Object)"Cannot delete null unit");
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void deleteAllUnit() {
        if (this.isEditable()) ** GOTO lbl10
        throw new UnsupportedOperationException("Operation not supported in online model");
lbl-1000:
        // 1 sources

        {
            unit = this.myUnits.remove(0);
            if (unit == null) continue;
            this.myUnitsMap.remove(unit.getId());
            this.sendChildRemoved(unit.getId(), 10);
            unit.sendObjectRemoved();
            unit.destroy();
lbl10:
            // 3 sources

            ** while (this.myUnits.size() > 0)
        }
lbl11:
        // 1 sources

    }

    @Override
    public void deleteUnit(int id) {
        if (!this.isEditable()) {
            throw new UnsupportedOperationException("Operation not supported in online model");
        }
        this.deleteUnit(this.getUnit(id));
    }

    @Override
    public Unit getUnit(String name) {
        int i = 0;
        int size = this.myUnits.size();
        while (i < size) {
            Unit unit = this.myUnits.get(i);
            if (unit.getName().equals(name)) {
                return unit;
            }
            ++i;
        }
        return null;
    }

    @Override
    public void setSite(Site s) {
        if (!this.isEditable()) {
            throw new UnsupportedOperationException("Operation not supported in online model");
        }
        if (s != null) {
            this.mySite = s;
        } else {
            this.myLogger.error((Object)"Cannot set null site");
        }
    }

    @Override
    public void setCabinetType(String strCabinetType) {
        if (!this.isEditable()) {
            throw new UnsupportedOperationException("Operation not supported in online model");
        }
        this.doSetCabinetType(strCabinetType);
    }

    @Override
    public void destroy() {
        if (!this.isEditable()) {
            throw new UnsupportedOperationException("Operation not supported in online model");
        }
        int i = 0;
        int size = this.myUnits.size();
        while (i < size) {
            this.myUnits.get(i).destroy();
            ++i;
        }
        this.myUnits.clear();
        this.myUnitsMap.clear();
    }
}

