/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.configuration;

import com.nokia.em.bts.coreasset.configuration.AbstractBTSConfigObject;
import com.nokia.em.bts.coreasset.configuration.BTSConfigObject;
import com.nokia.em.bts.coreasset.configuration.Cell;
import com.nokia.em.bts.coreasset.configuration.CellGroup;
import com.nokia.em.bts.coreasset.configuration.Unit;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class CellGroupImpl
extends AbstractBTSConfigObject
implements CellGroup {
    protected static final String NODENAME = "CellGroup";
    protected static final String CELL_GROUP_NAME_NODENAME = "CellGroupName";
    private Set<Integer> myUnitIds;
    private Set<Integer> myCellIds;
    private List<Unit> myUnits;
    private List<Cell> myCells;
    private Logger myLogger;
    private String myName = "Coreasset_Unknown";
    private int myLCGId = -1;

    public CellGroupImpl(int cellGroupId) {
        super(null, -1, 78);
        this.doSetCellGroupId(cellGroupId);
        this.myUnitIds = new TreeSet<Integer>();
        this.myCellIds = new TreeSet<Integer>();
        this.myLogger = Logger.getLogger(this.getClass());
    }

    private CellGroupImpl(CellGroup cellGroup) {
        super(null, -1, cellGroup.getObjectType());
        this.doSetCellGroupId(cellGroup.getCellGroupId());
        this.setEditable(true);
        this.myLogger = Logger.getLogger(this.getClass());
        this.myCells = new ArrayList<Cell>();
        this.myUnits = new ArrayList<Unit>();
    }

    public CellGroupImpl(int cellGroupId, String cellGroupName) {
        super(null, -1, 78);
        this.doSetCellGroupId(cellGroupId);
        this.doSetName(cellGroupName);
        this.setEditable(true);
        this.myLogger = Logger.getLogger(this.getClass());
        this.myCells = new ArrayList<Cell>();
        this.myUnits = new ArrayList<Unit>();
    }

    @Override
    public int getCellGroupId() {
        return this.myLCGId;
    }

    public boolean equals(Object obj) {
        return obj instanceof CellGroupImpl && ((CellGroupImpl)obj).getId() == this.getId();
    }

    public int hashCode() {
        return this.getId();
    }

    protected boolean doRemoveCell(Integer cellId) {
        return this.myCellIds.remove(cellId);
    }

    protected boolean doRemoveUnit(Integer unitId) {
        return this.myUnitIds.remove(unitId);
    }

    protected void doAddCell(Integer cellId) {
        this.myCellIds.add(cellId);
    }

    protected void doAddUnit(Integer unitId) {
        this.myUnitIds.add(unitId);
    }

    @Override
    protected final void update(BTSConfigObject btsConfigObject) {
    }

    @Override
    protected final Node getRoot(Document doc) {
        Element root = doc.createElement(NODENAME);
        root.appendChild(this.createElement(doc, "_id", this.getCellGroupId()));
        root.appendChild(this.createElement(doc, CELL_GROUP_NAME_NODENAME, this.getName()));
        return root;
    }

    @Override
    public CellGroup getEditableCopy() {
        if (this.isEditable()) {
            throw new UnsupportedOperationException("This cell group is already editable");
        }
        return new CellGroupImpl(this);
    }

    protected final void doSetName(String strName) {
        this.myName = strName;
    }

    protected final void doSetCellGroupId(int id) {
        this.myLCGId = id;
    }

    @Override
    public final String getName() {
        return this.myName;
    }

    @Override
    public Set<Integer> getCellIds() {
        return this.myCellIds;
    }

    @Override
    public Set<Integer> getUnitIds() {
        return this.myUnitIds;
    }

    @Override
    public void addUnit(Unit unit) {
        if (!this.isEditable()) {
            throw new UnsupportedOperationException("Operation not supported in online model");
        }
        this.myUnits.add(unit);
        this.sendChildAdded(unit.getId(), 10);
    }

    @Override
    public void removeUnit(Unit unit) {
        if (!this.isEditable()) {
            throw new UnsupportedOperationException("Operation not supported in online model");
        }
        if (unit != null) {
            this.myUnits.remove(unit);
            this.sendObjectChanged();
        }
    }

    @Override
    public void removeUnit(int id) {
        if (!this.isEditable()) {
            throw new UnsupportedOperationException("Operation not supported in online model");
        }
        this.removeUnit(this.getUnit(id));
    }

    @Override
    public Unit getUnit(int id) {
        if (!this.isEditable()) {
            throw new UnsupportedOperationException("Operation not supported in online model");
        }
        int i = 0;
        while (i < this.myUnits.size()) {
            if (this.myUnits.get(i).getId() == id) {
                return this.myUnits.get(i);
            }
            ++i;
        }
        return null;
    }

    @Override
    public Unit getUnit(String name) {
        if (!this.isEditable()) {
            throw new UnsupportedOperationException("Operation not supported in online model");
        }
        int i = 0;
        while (i < this.myUnits.size()) {
            if (this.myUnits.get(i).getName().trim().equalsIgnoreCase(name.trim())) {
                return this.myUnits.get(i);
            }
            ++i;
        }
        return null;
    }

    @Override
    public List<Unit> getUnits() {
        if (!this.isEditable()) {
            throw new UnsupportedOperationException("Operation not supported in online model");
        }
        return this.myUnits;
    }

    @Override
    public void addCell(Cell cell) {
        if (!this.isEditable()) {
            throw new UnsupportedOperationException("Operation not supported in online model");
        }
        if (cell != null) {
            this.myCells.add(cell);
            this.sendChildAdded(cell.getId(), 5);
        } else {
            this.myLogger.error((Object)"Cannot add null cell");
        }
    }

    @Override
    public void removeCell(Cell cell) {
        if (!this.isEditable()) {
            throw new UnsupportedOperationException("Operation not supported in online model");
        }
        if (cell != null) {
            this.myCells.remove(cell);
            this.sendObjectChanged();
        } else {
            this.myLogger.error((Object)"Cannot remove null cell");
        }
    }

    @Override
    public void removeCell(int id) {
        if (!this.isEditable()) {
            throw new UnsupportedOperationException("Operation not supported in online model");
        }
        this.removeCell(this.getCell(id));
    }

    @Override
    public Cell getCell(int id) {
        if (!this.isEditable()) {
            throw new UnsupportedOperationException("Operation not supported in online model");
        }
        int i = 0;
        while (i < this.myCells.size()) {
            if (this.myCells.get(i).getId() == id) {
                return this.myCells.get(i);
            }
            ++i;
        }
        return null;
    }

    @Override
    public Cell getCellByCellId(int id) {
        if (!this.isEditable()) {
            throw new UnsupportedOperationException("Operation not supported in online model");
        }
        int i = 0;
        while (i < this.myCells.size()) {
            if (this.myCells.get(i).getId() == id) {
                return this.myCells.get(i);
            }
            ++i;
        }
        return null;
    }

    @Override
    public List<Cell> getCells() {
        if (!this.isEditable()) {
            throw new UnsupportedOperationException("Operation not supported in online model");
        }
        return this.myCells;
    }

    @Override
    public void destroy() {
        if (!this.isEditable()) {
            throw new UnsupportedOperationException("Operation not supported in online model");
        }
        this.myUnits.clear();
        this.myCells.clear();
    }

    public String toString() {
        return "CellGroup " + this.getId() + " (" + this.myName + ")";
    }
}

