/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.configuration;

import com.nokia.em.bts.coreasset.CoreAsset;
import com.nokia.em.bts.coreasset.configuration.AbstractBTSConfigObject;
import com.nokia.em.bts.coreasset.configuration.BTSConfigObject;
import com.nokia.em.bts.coreasset.configuration.BTSConfigurationManager;
import com.nokia.em.bts.coreasset.configuration.Cabinet;
import com.nokia.em.bts.coreasset.configuration.Cell;
import com.nokia.em.bts.coreasset.configuration.CellGroup;
import com.nokia.em.bts.coreasset.configuration.ChangeStateListener;
import com.nokia.em.bts.coreasset.configuration.Site;
import com.nokia.em.bts.coreasset.configuration.SubUnit;
import com.nokia.em.bts.coreasset.configuration.Unit;
import com.nokia.em.bts.coreasset.configuration.UnitComparator;
import com.nokia.em.bts.coreasset.message.BlockOperationsCompleted;
import com.nokia.em.bts.coreasset.message.ChangeCellBlockingStateRequest;
import com.nokia.em.bts.rp.master.message.Ack;
import com.nokia.em.bts.rp.master.message.BTSMessage;
import com.nokia.em.bts.rp.master.tool.CoreAssetThread;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class CellImpl
extends AbstractBTSConfigObject
implements Cell {
    protected static final String NODENAME = "Cell";
    protected static final String BLOCKING_STATE_NODENAME = "_blockingState";
    protected static final String BLOCKING_STATE_BLOCKED_NODEVALUE = "blocked";
    protected static final String BLOCKING_STATE_UNBLOCKED_NODEVALUE = "unblocked";
    protected static final String BLOCKING_STATE_DEFERRED_BLOCK_NODEVALUE = "deferredBlock";
    protected static final String STATE_NODENAME = "_state";
    protected static final String STATE_WORKING_NODEVALUE = "working";
    protected static final String STATE_DEGRADED_NODEVALUE = "degraded";
    protected static final String STATE_FAULTY_NODEVALUE = "faulty";
    protected static final String STATE_RESETTING_NODEVALUE = "resetting";
    protected static final String CELL_AVAILABILITY_NODENAME = "_cellAvailability";
    protected static final String CELL_AVAILABILITY_ACTIVE_NODEVALUE = "active";
    protected static final String CELL_AVAILABILITY_INACTIVE_NODEVALUE = "inactive";
    protected static final String CELL_AVAILABILITY_SHUTTINGDOWN_NODEVALUE = "Shutting down";
    protected static final String OPERATIONAL_STATE_NODENAME = "_operationalState";
    protected static final String OPERATIONAL_STATE_ENABLED_NODEVALUE = "enabled";
    protected static final String OPERATIONAL_STATE_DISABLED_NODEVALUE = "disabled";
    protected static final String CONCEPT_NODENAME = "_concept";
    protected static final String GLOBAL_CELL_ID_NODENAME = "_globalCellId";
    protected static final String INTELLIGENT_SHUTDOWN_TIMEOUT_NODENAME = "_intelligentShutdownTimeout";
    protected static final String ALLOWED_CARRIERS_NODENAME = "Allowed.Carriers";
    private List<Integer> myRelationUnitIds;
    private List<Integer> myRelationSubUnitIds;
    private int myAvailability;
    private int myBlockingState;
    private int myState;
    private int myOperationalState;
    private String myConcept;
    private int myIntelligentShutdownTimeout;
    private int myGlobalCellId;
    private int[] myAllowedCarriers;
    private CellGroup myCellGroup;
    private Logger myLogger;
    private List<Unit> myUnits;
    private List<SubUnit> mySubUnits;
    private Site mySite;
    private int myCellId;

    public CellImpl(BTSConfigurationManager btsConfMgr) {
        this(btsConfMgr, -1, -1, -1, -1, "Coreasset_Unknown", -1, -1);
    }

    public CellImpl(BTSConfigurationManager btsConfMgr, int intId, int intBlockingState, int intAvailability, int intOperationalState, String strConcept, int intGlobalCellId, int intIntelligentShutdownTimeout) {
        super(btsConfMgr, intId, 5);
        this.doSetId(-1);
        this.doSetState(-1);
        this.myCellId = intId;
        this.myLogger = Logger.getLogger(this.getClass());
        this.myBlockingState = intBlockingState;
        this.myAvailability = intAvailability;
        this.myOperationalState = intOperationalState;
        this.myRelationUnitIds = new Vector<Integer>();
        this.myRelationSubUnitIds = new Vector<Integer>();
        this.myConcept = strConcept;
        this.myGlobalCellId = intGlobalCellId;
        this.myIntelligentShutdownTimeout = intIntelligentShutdownTimeout;
        this.myAllowedCarriers = new int[0];
    }

    private CellImpl(Cell c) {
        this(null, c.getCellId(), c.getBlockingState(), c.getAvailability(), c.getOperationalState(), c.getConcept(), c.getGlobalCellId(), c.getIntelligentShutdownTimeout());
        this.doSetAllowedCarriers(c.getAllowedCarriers());
        this.doSetCellGroupRelation(c.getCellGroup());
        this.doSetCustomAttributes(c.getCustomAttributes());
        this.doSetState(c.getState());
        this.mySubUnits = new ArrayList<SubUnit>();
        this.myUnits = new ArrayList<Unit>();
        this.setEditable(true);
    }

    public CellImpl(int cellId) {
        this((BTSConfigurationManager)null);
        this.myCellId = cellId;
        this.mySubUnits = new ArrayList<SubUnit>();
        this.myUnits = new ArrayList<Unit>();
        this.setEditable(true);
    }

    @Override
    protected final Node getRoot(Document doc) {
        Element root = doc.createElement(NODENAME);
        root.appendChild(this.createElement(doc, "_id", this.getCellId()));
        root.appendChild(this.createElement(doc, BLOCKING_STATE_NODENAME, CellImpl.nodeValueOf(this.myBlockingState)));
        root.appendChild(this.createElement(doc, STATE_NODENAME, CellImpl.nodeValueOf(this.myState)));
        root.appendChild(this.createElement(doc, CELL_AVAILABILITY_NODENAME, CellImpl.nodeValueOf(this.myAvailability)));
        root.appendChild(this.createElement(doc, OPERATIONAL_STATE_NODENAME, CellImpl.nodeValueOf(this.myOperationalState)));
        root.appendChild(this.createElement(doc, CONCEPT_NODENAME, this.getConcept()));
        root.appendChild(this.createElement(doc, GLOBAL_CELL_ID_NODENAME, this.getGlobalCellId()));
        root.appendChild(this.createElement(doc, INTELLIGENT_SHUTDOWN_TIMEOUT_NODENAME, this.getIntelligentShutdownTimeout()));
        Element allowedCarriersElement = doc.createElement(ALLOWED_CARRIERS_NODENAME);
        root.appendChild(allowedCarriersElement);
        int i = 0;
        while (i < this.myAllowedCarriers.length) {
            Node carrierNode = allowedCarriersElement.appendChild(doc.createElement("Carrier"));
            carrierNode.appendChild(doc.createTextNode(Integer.toString(this.myAllowedCarriers[i])));
            ++i;
        }
        return root;
    }

    protected final void doSetCellGroupRelation(CellGroup cellGroup) {
        this.myCellGroup = cellGroup;
    }

    protected static final String nodeValueOf(int intValue) {
        switch (intValue) {
            case 55: {
                return BLOCKING_STATE_BLOCKED_NODEVALUE;
            }
            case 57: {
                return BLOCKING_STATE_UNBLOCKED_NODEVALUE;
            }
            case 62: {
                return BLOCKING_STATE_DEFERRED_BLOCK_NODEVALUE;
            }
            case 52: {
                return STATE_WORKING_NODEVALUE;
            }
            case 53: {
                return STATE_DEGRADED_NODEVALUE;
            }
            case 54: {
                return STATE_FAULTY_NODEVALUE;
            }
            case 58: {
                return STATE_RESETTING_NODEVALUE;
            }
            case 27: {
                return OPERATIONAL_STATE_ENABLED_NODEVALUE;
            }
            case 28: {
                return OPERATIONAL_STATE_DISABLED_NODEVALUE;
            }
            case 46: {
                return CELL_AVAILABILITY_ACTIVE_NODEVALUE;
            }
            case 47: {
                return CELL_AVAILABILITY_INACTIVE_NODEVALUE;
            }
            case 48: {
                return CELL_AVAILABILITY_SHUTTINGDOWN_NODEVALUE;
            }
        }
        return "Coreasset_Unknown";
    }

    protected final void doSetAvailability(int intAvailability) {
        this.myAvailability = intAvailability;
    }

    protected final void doSetBlockingState(int intBlockingState) {
        this.myBlockingState = intBlockingState;
    }

    protected final void doSetState(int intState) {
        this.myState = intState;
    }

    protected final void doSetOperationalState(int intOperationalState) {
        this.myOperationalState = intOperationalState;
    }

    protected final void doSetRelationUnitIds(List<Integer> unitIds) {
        this.myRelationUnitIds = unitIds;
    }

    protected final void doSetConcept(String strConcept) {
        this.myConcept = strConcept;
    }

    protected final void doSetGlobalCellId(int intGlobalCellId) {
        this.myGlobalCellId = intGlobalCellId;
    }

    protected final void doSetCellId(int intCellId) {
        this.myCellId = intCellId;
    }

    protected final void doSetIntelligentShutdownTimeout(int intIntelligentShutdownTimeout) {
        this.myIntelligentShutdownTimeout = intIntelligentShutdownTimeout;
    }

    protected final void doSetAllowedCarriers(int[] allowedCarriers) {
        this.myAllowedCarriers = allowedCarriers;
    }

    private void checkAndBlockWhileHWModelBuild() {
        this.myLogger.debug((Object)"checkblock start.");
        while (!this.myBTSConfigurationManager.isHWModelReady()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                this.myLogger.debug((Object)"rebuild model, sleep", (Throwable)e);
            }
        }
        this.myLogger.debug((Object)"checkblock released.");
    }

    @Override
    public final CellGroup getCellGroup() {
        return this.myCellGroup;
    }

    @Override
    public final int getBlockingState() {
        return this.myBlockingState;
    }

    @Override
    public final int getAvailability() {
        return this.myAvailability;
    }

    @Override
    public final int getState() {
        return this.myState;
    }

    @Override
    public final int getOperationalState() {
        return this.myOperationalState;
    }

    protected final void doAddRelationUnitId(int intUnitId) {
        Integer integer = intUnitId;
        if (!this.myRelationUnitIds.contains(integer)) {
            this.myRelationUnitIds.add(integer);
        }
    }

    protected final void doAddRelationSubUnitId(int intSubUnitId) {
        Integer integer = intSubUnitId;
        if (!this.myRelationSubUnitIds.contains(integer)) {
            this.myRelationSubUnitIds.add(integer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void doDeleteRelationSubUnitId(int intSubUnitId) {
        if (this.myRelationSubUnitIds != null) {
            List<Integer> list = this.myRelationSubUnitIds;
            synchronized (list) {
                int i = 0;
                while (i < this.myRelationSubUnitIds.size()) {
                    if (Integer.parseInt(this.myRelationSubUnitIds.get(i).toString()) == intSubUnitId) {
                        this.myRelationSubUnitIds.remove(i);
                    }
                    ++i;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void doDeleteRelationUnitId(int intUnitId) {
        if (this.myRelationUnitIds != null) {
            List<Integer> list = this.myRelationUnitIds;
            synchronized (list) {
                int i = 0;
                while (i < this.myRelationUnitIds.size()) {
                    if (Integer.parseInt(this.myRelationUnitIds.get(i).toString()) == intUnitId) {
                        this.myRelationUnitIds.remove(i);
                    }
                    ++i;
                }
            }
        }
    }

    @Override
    public void block(final ChangeStateListener listener, final int intPriority) {
        if (this.isEditable()) {
            throw new UnsupportedOperationException("Cannot block editable cell");
        }
        CoreAssetThread worker = new CoreAssetThread(){

            protected Object construct() {
                int messagePriority;
                if (CoreAsset.isSnapshotOpening()) {
                    CellImpl.this.myLogger.debug((Object)"Not supported in snapshot open mode.");
                    listener.stateChangeFailed(85);
                    return false;
                }
                int seqNumber = CellImpl.this.myConnection.createScenario();
                if (intPriority == 49) {
                    messagePriority = 69;
                } else if (intPriority == 50) {
                    messagePriority = 32;
                } else if (intPriority == 63) {
                    messagePriority = 70;
                } else {
                    throw new IllegalArgumentException("Illegal priority " + intPriority);
                }
                ChangeCellBlockingStateRequest changeCellBlockingStateRequest = new ChangeCellBlockingStateRequest(seqNumber, CellImpl.this.getCellId(), 12, messagePriority);
                CellImpl.this.myConnection.sendToBTS((BTSMessage)changeCellBlockingStateRequest);
                BTSMessage response = CellImpl.this.myConnection.receiveFromBTS(seqNumber);
                if (response instanceof Ack) {
                    Ack ackResponse = (Ack)response;
                    if (!ackResponse.getAck()) {
                        listener.stateChangeRequestDenied(ackResponse.getNackReason());
                        CellImpl.this.myConnection.deleteScenario(seqNumber);
                        return false;
                    }
                    listener.stateChangeRequestAccepted();
                    response = CellImpl.this.myConnection.receiveFromBTS(seqNumber);
                    if (response instanceof BlockOperationsCompleted) {
                        BlockOperationsCompleted blockOperResponse = (BlockOperationsCompleted)response;
                        int responseCode = blockOperResponse.getSuccessCode();
                        CellImpl.this.myConnection.deleteScenario(seqNumber);
                        CellImpl.this.checkAndBlockWhileHWModelBuild();
                        if (responseCode == 36) {
                            return true;
                        }
                        if (responseCode == 62) {
                            listener.stateChangeFailed(responseCode);
                            return false;
                        }
                        listener.stateChangeFailed(responseCode);
                        return false;
                    }
                }
                CellImpl.this.myConnection.deleteScenario(seqNumber);
                CellImpl.this.checkAndBlockWhileHWModelBuild();
                if (response == null) {
                    listener.stateChangeFailed(87);
                    return false;
                }
                listener.stateChangeFailed(28);
                return false;
            }

            protected void finished() {
                try {
                    CellImpl.this.checkAndBlockWhileHWModelBuild();
                    if (((Boolean)this.get()).booleanValue()) {
                        listener.stateChangeCompleted();
                    }
                }
                catch (Exception e) {
                    CellImpl.this.myLogger.error((Object)"Exception: ", (Throwable)e);
                    listener.stateChangeFailed(30);
                }
            }
        };
        worker.start();
    }

    @Override
    public void unblock(final ChangeStateListener listener, final int intPriority) {
        if (this.isEditable()) {
            throw new UnsupportedOperationException("Cannot unblock editable cell");
        }
        CoreAssetThread worker = new CoreAssetThread(){

            protected Object construct() {
                int messagePriority;
                if (CoreAsset.isSnapshotOpening()) {
                    CellImpl.this.myLogger.debug((Object)"Not supported in snapshot open mode.");
                    listener.stateChangeFailed(85);
                    return false;
                }
                int seqNumber = CellImpl.this.myConnection.createScenario();
                if (intPriority == 49) {
                    messagePriority = 69;
                } else if (intPriority == 50) {
                    messagePriority = 32;
                } else if (intPriority == 63) {
                    messagePriority = 70;
                } else {
                    throw new IllegalArgumentException("Illegal priority " + intPriority);
                }
                ChangeCellBlockingStateRequest changeCellBlockingStateRequest = new ChangeCellBlockingStateRequest(seqNumber, CellImpl.this.getCellId(), 13, messagePriority, BTSMessage.Type.BTS);
                CellImpl.this.myConnection.sendToBTS((BTSMessage)changeCellBlockingStateRequest);
                BTSMessage response = CellImpl.this.myConnection.receiveFromBTS(seqNumber);
                if (response instanceof Ack) {
                    Ack ackResponse = (Ack)response;
                    if (!ackResponse.getAck()) {
                        listener.stateChangeRequestDenied(ackResponse.getNackReason());
                        CellImpl.this.myConnection.deleteScenario(seqNumber);
                        return false;
                    }
                    listener.stateChangeRequestAccepted();
                    response = CellImpl.this.myConnection.receiveFromBTS(seqNumber);
                    if (response instanceof BlockOperationsCompleted) {
                        BlockOperationsCompleted blockOperResponse = (BlockOperationsCompleted)response;
                        int responseCode = blockOperResponse.getSuccessCode();
                        CellImpl.this.myConnection.deleteScenario(seqNumber);
                        if (responseCode == 36) {
                            return true;
                        }
                        CellImpl.this.checkAndBlockWhileHWModelBuild();
                        listener.stateChangeFailed(responseCode);
                        return false;
                    }
                }
                CellImpl.this.myConnection.deleteScenario(seqNumber);
                CellImpl.this.checkAndBlockWhileHWModelBuild();
                if (response == null) {
                    listener.stateChangeFailed(87);
                    return false;
                }
                listener.stateChangeFailed(28);
                return false;
            }

            protected void finished() {
                try {
                    CellImpl.this.checkAndBlockWhileHWModelBuild();
                    if (((Boolean)this.get()).booleanValue()) {
                        listener.stateChangeCompleted();
                    }
                }
                catch (Exception e) {
                    CellImpl.this.myLogger.error((Object)"Exception: ", (Throwable)e);
                    listener.stateChangeFailed(30);
                }
            }
        };
        worker.start();
    }

    @Override
    protected final void update(BTSConfigObject btsConfigObject) {
        if (btsConfigObject instanceof CellImpl && btsConfigObject != null) {
            try {
                CellImpl newCell = (CellImpl)btsConfigObject;
                this.doSetAvailability(newCell.getAvailability());
                this.doSetState(newCell.getState());
                this.doSetOperationalState(newCell.getOperationalState());
                this.doSetBlockingState(newCell.getBlockingState());
                this.doSetConcept(newCell.getConcept());
                this.doSetGlobalCellId(newCell.getGlobalCellId());
                this.doSetIntelligentShutdownTimeout(newCell.getIntelligentShutdownTimeout());
                this.doSetAllowedCarriers(newCell.getAllowedCarriers());
                this.doSetCustomAttributes(newCell.getCustomAttributes());
            }
            catch (Exception e) {
                this.myLogger.error((Object)e);
            }
        } else {
            this.myLogger.error((Object)("Unable to update Cell using " + btsConfigObject));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final List<Integer> getRelationSubUnitIds() {
        List<Integer> list = this.myRelationSubUnitIds;
        synchronized (list) {
            return new ArrayList<Integer>(this.myRelationSubUnitIds);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final List<Integer> getRelationUnitIds() {
        List<Integer> list = this.myRelationUnitIds;
        synchronized (list) {
            return new ArrayList<Integer>(this.myRelationUnitIds);
        }
    }

    @Override
    public final int getGlobalCellId() {
        return this.myGlobalCellId;
    }

    @Override
    public final int getIntelligentShutdownTimeout() {
        return this.myIntelligentShutdownTimeout;
    }

    @Override
    public final String getConcept() {
        return this.myConcept;
    }

    @Override
    public final int[] getAllowedCarriers() {
        return this.myAllowedCarriers;
    }

    @Override
    public final Site getSite() {
        return this.isEditable() ? this.mySite : this.myBTSConfigurationManager.getSite();
    }

    @Override
    public final void setSite(Site s) {
        this.mySite = s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final List<Unit> getCurrentUnits() {
        ArrayList<Unit> returnList = new ArrayList<Unit>(20);
        Cabinet someCabinet = this.getSite().getCabinet();
        List<Integer> list = this.myRelationUnitIds;
        synchronized (list) {
            int i = 0;
            while (i < this.myRelationUnitIds.size()) {
                Integer someInteger = this.myRelationUnitIds.get(i);
                Unit someUnit = someCabinet.getUnit(someInteger);
                if (someUnit != null) {
                    returnList.add(someUnit);
                }
                ++i;
            }
        }
        Collections.sort(returnList, UnitComparator.getInstance());
        return returnList;
    }

    @Override
    public Cell getEditableCopy() {
        if (this.isEditable()) {
            throw new UnsupportedOperationException("This cell is already editable");
        }
        return new CellImpl(this);
    }

    @Override
    public void addUnit(Unit unit) {
        if (!this.isEditable()) {
            throw new UnsupportedOperationException("Operation not supported in online model");
        }
        this.myUnits.add(unit);
        this.sendChildAdded(unit.getId(), 10);
    }

    @Override
    public void removeUnit(Unit unit) {
        if (!this.isEditable()) {
            throw new UnsupportedOperationException("Operation not supported in online model");
        }
        if (unit != null) {
            this.myUnits.remove(unit);
            this.sendObjectChanged();
        }
    }

    @Override
    public void removeUnit(int id) {
        if (!this.isEditable()) {
            throw new UnsupportedOperationException("Operation not supported in online model");
        }
        this.removeUnit(this.getUnit(id));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Unit getUnit(int id) {
        List<Integer> list = this.myRelationUnitIds;
        synchronized (list) {
            int i = 0;
            while (i < this.myRelationUnitIds.size()) {
                if (this.myRelationUnitIds.get(i) == id) {
                    return this.myBTSConfigurationManager.getSite().getUnit(id);
                }
                ++i;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Unit getUnit(String name) {
        Site site = this.myBTSConfigurationManager.getSite();
        List<Integer> list = this.myRelationUnitIds;
        synchronized (list) {
            int i = 0;
            while (i < this.myRelationUnitIds.size()) {
                if (site.getUnit(this.myRelationUnitIds.get(i)).getName().equals(name)) {
                    return this.myBTSConfigurationManager.getSite().getUnit(this.myRelationUnitIds.get(i));
                }
                ++i;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Unit> getUnits() {
        if (this.isEditable()) {
            return this.myUnits;
        }
        ArrayList<Unit> units = new ArrayList<Unit>();
        Site site = this.myBTSConfigurationManager.getSite();
        List<Integer> list = this.myRelationUnitIds;
        synchronized (list) {
            int i = 0;
            while (i < this.myRelationUnitIds.size()) {
                int id = this.myRelationUnitIds.get(i);
                Unit unit = site.getUnit(id);
                if (unit != null) {
                    units.add(unit);
                } else {
                    this.myLogger.debug((Object)("Unit " + id + " related to cell " + this.getCellId() + " does not exist."));
                }
                ++i;
            }
        }
        return units;
    }

    @Override
    public void addSubUnit(SubUnit subUnit) {
        if (!this.isEditable()) {
            throw new UnsupportedOperationException("Operation not supported in online model");
        }
        this.mySubUnits.add(subUnit);
        this.sendChildAdded(subUnit.getId(), 14);
    }

    @Override
    public void removeSubUnit(SubUnit subUnit) {
        if (!this.isEditable()) {
            throw new UnsupportedOperationException("Operation not supported in online model");
        }
        if (subUnit != null) {
            this.mySubUnits.remove(subUnit);
            this.sendObjectChanged();
        }
    }

    @Override
    public void removeSubUnit(int id) {
        if (!this.isEditable()) {
            throw new UnsupportedOperationException("Operation not supported in online model");
        }
        this.removeSubUnit(this.getSubUnit(id));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SubUnit getSubUnit(int id) {
        List<Integer> list = this.myRelationSubUnitIds;
        synchronized (list) {
            int i = 0;
            while (i < this.myRelationSubUnitIds.size()) {
                if (this.myRelationSubUnitIds.get(i) == id) {
                    return this.myBTSConfigurationManager.getSite().getSubUnit(id);
                }
                ++i;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<SubUnit> getSubUnits() {
        if (this.isEditable()) {
            return this.mySubUnits;
        }
        ArrayList<SubUnit> subunits = new ArrayList<SubUnit>();
        Site site = this.myBTSConfigurationManager.getSite();
        List<Integer> list = this.myRelationSubUnitIds;
        synchronized (list) {
            int i = 0;
            while (i < this.myRelationSubUnitIds.size()) {
                int id = this.myRelationSubUnitIds.get(i);
                SubUnit subUnit = site.getSubUnit(id);
                if (subUnit != null) {
                    subunits.add(subUnit);
                } else {
                    this.myLogger.debug((Object)("SubUnit " + id + " related to cell " + this.getCellId() + " does not exist."));
                }
                ++i;
            }
        }
        return subunits;
    }

    @Override
    public void setGlobalCellId(int cellId) {
        if (!this.isEditable()) {
            throw new UnsupportedOperationException("Operation not supported in online model");
        }
        this.doSetGlobalCellId(cellId);
        this.sendObjectChanged();
    }

    @Override
    public void destroy() {
        if (this.myUnits != null) {
            int i = 0;
            while (i < this.myUnits.size()) {
                this.myUnits.get(i).removeCell(this);
                ++i;
            }
            this.myUnits.clear();
            i = 0;
            while (i < this.mySubUnits.size()) {
                this.mySubUnits.get(i).removeCell(this);
                ++i;
            }
            this.mySubUnits.clear();
            this.mySite = null;
        }
    }

    @Override
    public void setCellId(int id) {
        if (!this.isEditable()) {
            throw new UnsupportedOperationException("Operation not supported in online model");
        }
        this.doSetCellId(id);
        this.sendObjectChanged();
    }

    @Override
    public int getCellId() {
        return this.myCellId;
    }

    public String toString() {
        return "Cell " + this.myCellId + " (" + this.myGlobalCellId + ")";
    }
}

