/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.configuration;

import com.nokia.em.bts.coreasset.configuration.BTSConfigObject;
import com.nokia.em.bts.coreasset.configuration.BTSConfigurationManager;
import com.nokia.em.bts.coreasset.configuration.Cabinet;
import com.nokia.em.bts.coreasset.configuration.CabinetImpl;
import com.nokia.em.bts.coreasset.configuration.Cell;
import com.nokia.em.bts.coreasset.configuration.CellGroup;
import com.nokia.em.bts.coreasset.configuration.CellGroupImpl;
import com.nokia.em.bts.coreasset.configuration.CellImpl;
import com.nokia.em.bts.coreasset.configuration.EACInputImpl;
import com.nokia.em.bts.coreasset.configuration.EACOutputImpl;
import com.nokia.em.bts.coreasset.configuration.Link;
import com.nokia.em.bts.coreasset.configuration.LinkImpl;
import com.nokia.em.bts.coreasset.configuration.ObjectRelation;
import com.nokia.em.bts.coreasset.configuration.ObjectRelationImpl;
import com.nokia.em.bts.coreasset.configuration.Site;
import com.nokia.em.bts.coreasset.configuration.SiteImpl;
import com.nokia.em.bts.coreasset.configuration.SubUnit;
import com.nokia.em.bts.coreasset.configuration.SubUnitImpl;
import com.nokia.em.bts.coreasset.configuration.Unit;
import com.nokia.em.bts.coreasset.configuration.UnitImpl;
import com.nokia.em.bts.coreasset.scenario.hwmanagement.InputVoltage;
import com.nokia.em.bts.coreasset.scenario.performancemanagement.PerformanceDataBuilder;
import com.nokia.em.bts.coreasset.tool.JreBugFixer;
import com.nokia.em.bts.rp.master.time.TimeZoneChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import java.util.TimeZone;
import java.util.Vector;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class ConfigurationObjectFactoryImpl {
    public static final String TRUE = "1";
    public static final String FALSE = "0";
    private Document myDocument;
    private List<Cell> myCells;
    private List<Unit> myUnits;
    private Cabinet myCabinet;
    private Site mySite;
    private List myEACs;
    private List<Link> myLinks;
    private List<SubUnit> mySubUnits;
    private List<ObjectRelation> myRelations;
    private Set<CellGroup> myCellGroups;
    private BTSConfigurationManager myBTSConfigurationManager;
    private Logger myLogger = Logger.getLogger(this.getClass());

    ConfigurationObjectFactoryImpl(BTSConfigurationManager btsConfMgr) {
        this.myBTSConfigurationManager = btsConfMgr;
        this.mySubUnits = new ArrayList<SubUnit>(20);
        this.myUnits = new ArrayList<Unit>(20);
        this.myCells = new ArrayList<Cell>(20);
        this.myEACs = Collections.synchronizedList(new ArrayList());
        this.myLinks = new ArrayList<Link>(20);
        this.myRelations = new CopyOnWriteArrayList<ObjectRelation>();
        this.myCellGroups = new HashSet<CellGroup>();
        this.myDocument = null;
    }

    public ConfigurationObjectFactoryImpl(BTSConfigurationManager btsConfMgr, File file) {
        this(btsConfMgr);
        try {
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            this.myDocument = docBuilder.parse(file);
            this.myDocument.getDocumentElement().normalize();
        }
        catch (SAXParseException err) {
            String strError = "** Parsing error, line " + err.getLineNumber() + ", uri " + err.getSystemId() + " " + err.getMessage();
            this.myLogger.error((Object)("XML Parsing failed: " + strError));
        }
        catch (SAXException e) {
            this.myLogger.error((Object)("SAXException: " + e.toString()));
        }
        catch (Throwable t) {
            this.myLogger.error((Object)("instantiation failed: " + t.toString()));
        }
    }

    public List<Unit> getRemainingUnits() {
        return this.myUnits;
    }

    protected void destroy() {
        this.myBTSConfigurationManager = null;
    }

    protected Set<CellGroup> getCellGroupRelations() {
        return this.myCellGroups;
    }

    protected void createCellGroups() {
        NodeList nodeList = this.myDocument.getElementsByTagName("CellGroup");
        if (nodeList.getLength() != 0) {
            int i = 0;
            while (i < nodeList.getLength()) {
                this.myCellGroups.add(this.createCellGroup(nodeList.item(i).getChildNodes()));
                ++i;
            }
        }
    }

    protected List<ObjectRelation> createObjectRelations() {
        NodeList relsNodeList = this.myDocument.getElementsByTagName("ObjectRelation");
        if (relsNodeList.getLength() != 0) {
            int i = 0;
            while (i < relsNodeList.getLength()) {
                this.myRelations.add(this.createObjectRelation(relsNodeList.item(i).getChildNodes()));
                ++i;
            }
        }
        this.createCellGroupRelations();
        this.createCellUnitRelations();
        this.createCellSubUnitRelations();
        this.createUnitUnitRelations();
        return this.myRelations;
    }

    protected Cabinet getCabinet() {
        return this.myCabinet;
    }

    protected List createEACs() {
        NodeList eacsNodeList = this.myDocument.getElementsByTagName("EACInput");
        int i = 0;
        while (i < eacsNodeList.getLength()) {
            this.myEACs.add(this.createEACInput(eacsNodeList.item(i).getChildNodes()));
            ++i;
        }
        if (i == 0) {
            this.myLogger.debug((Object)"No input EAC information found!");
        }
        eacsNodeList = this.myDocument.getElementsByTagName("EACOutput");
        i = 0;
        while (i < eacsNodeList.getLength()) {
            this.myEACs.add(this.createEACOutput(eacsNodeList.item(i).getChildNodes()));
            ++i;
        }
        if (i == 0) {
            this.myLogger.debug((Object)"No output EAC information found!");
        }
        return this.myEACs;
    }

    protected List<Cell> createCells() {
        NodeList cellsNodeList = this.myDocument.getElementsByTagName("Cell");
        if (cellsNodeList.getLength() != 0) {
            int i = 0;
            while (i < cellsNodeList.getLength()) {
                this.myCells.add(this.createCell(cellsNodeList.item(i).getChildNodes()));
                ++i;
            }
        }
        return this.myCells;
    }

    protected SiteImpl createSite() {
        this.mySubUnits = (ArrayList)((ArrayList)this.createSubUnits()).clone();
        this.myUnits = (ArrayList)((ArrayList)this.createUnits()).clone();
        this.myCabinet = this.createCabinet();
        NodeList sitesNodeList = this.myDocument.getElementsByTagName("BS");
        if (sitesNodeList.getLength() != 0) {
            this.mySite = this.createSite(sitesNodeList.item(0).getChildNodes());
        }
        return (SiteImpl)this.mySite;
    }

    protected BTSConfigObject createChangedObject(int intConfigObjectId, int intConfigObjectType) {
        NodeList nodeList = null;
        if (intConfigObjectType == 5) {
            nodeList = this.getChangedObjectParameters("Cell", intConfigObjectId);
            if (nodeList != null) {
                return this.createCell(nodeList);
            }
        } else if (intConfigObjectType == 4) {
            nodeList = this.getChangedObjectParameters("Cabinet", intConfigObjectId);
            if (nodeList != null) {
                return this.createCabinet(nodeList);
            }
        } else if (intConfigObjectType == 10) {
            nodeList = this.getChangedObjectParameters("Unit", intConfigObjectId);
            if (nodeList != null) {
                return this.createUnit(nodeList);
            }
        } else if (intConfigObjectType == 13) {
            nodeList = this.getChangedObjectParameters("Link", intConfigObjectId);
            if (nodeList != null) {
                return this.createLink(nodeList);
            }
        } else if (intConfigObjectType == 3) {
            nodeList = this.getChangedObjectParameters("BS", intConfigObjectId);
            if (nodeList != null) {
                return this.createSite(nodeList);
            }
        } else if (intConfigObjectType == 14) {
            nodeList = this.getChangedObjectParameters("Subunit", intConfigObjectId);
            if (nodeList != null) {
                return this.createSubUnit(nodeList);
            }
        } else if (intConfigObjectType == 11) {
            nodeList = this.getChangedObjectParameters("EACInput", intConfigObjectId);
            if (nodeList != null) {
                return this.createEACInput(nodeList);
            }
        } else if (intConfigObjectType == 12 && (nodeList = this.getChangedObjectParameters("EACOutput", intConfigObjectId)) != null) {
            return this.createEACOutput(nodeList);
        }
        return null;
    }

    protected List<Link> createLinks() {
        NodeList linksNodeList = this.myDocument.getElementsByTagName("Link");
        if (linksNodeList.getLength() != 0) {
            int i = 0;
            while (i < linksNodeList.getLength()) {
                this.myLinks.add(this.createLink(linksNodeList.item(i).getChildNodes()));
                ++i;
            }
        }
        return this.myLinks;
    }

    protected SiteImpl createSite(NodeList nodeList) {
        return this.createSite(nodeList, true);
    }

    protected SiteImpl createSite(NodeList nodeList, boolean persistent) {
        boolean flag = false;
        String strErrMessage = "";
        int intCounter = 0;
        SiteImpl siteImpl = new SiteImpl(persistent ? this.myBTSConfigurationManager : null);
        siteImpl.doSetRatType(this.myBTSConfigurationManager.getRatType());
        Hashtable<String, String> attributes = new Hashtable<String, String>(10);
        Vector<String> expectedNodes = new Vector<String>(20);
        expectedNodes.addElement("_id");
        expectedNodes.addElement("_activeClockUnit");
        expectedNodes.addElement("_authenticationServer");
        expectedNodes.addElement("_blockingState");
        expectedNodes.addElement("_bsAddress");
        expectedNodes.addElement("_doorSwitchInUse");
        expectedNodes.addElement("_hostAddress");
        expectedNodes.addElement("_hostId");
        expectedNodes.addElement("_mainsPowerAlarmId");
        expectedNodes.addElement("_networkType");
        expectedNodes.addElement("_NTPAddress");
        expectedNodes.addElement("_numberOfLines");
        expectedNodes.addElement("_OMMaster");
        expectedNodes.addElement("_operationalStatus");
        expectedNodes.addElement("_siteName");
        expectedNodes.addElement("_TComMaster");
        expectedNodes.addElement("_timeZone");
        expectedNodes.addElement("_mibbuType");
        expectedNodes.addElement("_swUpdateSource");
        expectedNodes.addElement("_timeZoneLocation");
        expectedNodes.addElement("_smokeAlarmInUse");
        int j = 0;
        while (j < nodeList.getLength()) {
            Node node = nodeList.item(j);
            String nodeValue = null;
            String nodeName = node.getNodeName();
            if (node.hasChildNodes()) {
                nodeValue = node.getFirstChild().getNodeValue();
            }
            if (nodeName.equals("_id")) {
                expectedNodes.removeElement("_id");
                if (nodeValue != null) {
                    siteImpl.doSetId(Integer.parseInt(nodeValue));
                }
            } else if (nodeName.equals("_hostAddress")) {
                expectedNodes.removeElement("_hostAddress");
                if (nodeValue != null) {
                    siteImpl.doSetHostAddress(nodeValue);
                }
            } else if (nodeName.equals("_hostId")) {
                expectedNodes.removeElement("_hostId");
                if (nodeValue != null) {
                    siteImpl.doSetHostId(Integer.parseInt(nodeValue));
                }
            } else if (nodeName.equals("_networkType")) {
                expectedNodes.removeElement("_networkType");
                if (nodeValue != null) {
                    siteImpl.doSetNetworkType(nodeValue);
                }
            } else if (nodeName.equals("_siteName")) {
                expectedNodes.removeElement("_siteName");
                if (nodeValue != null) {
                    siteImpl.doSetName(nodeValue);
                }
            } else if (nodeName.equals("_bsAddress")) {
                expectedNodes.removeElement("_bsAddress");
                if (nodeValue != null) {
                    siteImpl.doSetAddress(nodeValue);
                }
            } else if (nodeName.equals("_operationalStatus")) {
                expectedNodes.removeElement("_operationalStatus");
                if (nodeValue != null) {
                    if (nodeValue.equalsIgnoreCase("initializing")) {
                        siteImpl.doSetOperationalState(36);
                    }
                    if (nodeValue.equalsIgnoreCase("NotCommissioned")) {
                        siteImpl.doSetOperationalState(37);
                    } else if (nodeValue.equalsIgnoreCase("Commissioned")) {
                        siteImpl.doSetOperationalState(38);
                    } else if (nodeValue.equalsIgnoreCase("Configured")) {
                        siteImpl.doSetOperationalState(39);
                    } else if (nodeValue.equalsIgnoreCase("IntegratedToRAN")) {
                        siteImpl.doSetOperationalState(40);
                    } else if (nodeValue.equalsIgnoreCase("OnAir")) {
                        siteImpl.doSetOperationalState(41);
                    } else if (nodeValue.equalsIgnoreCase("TestDedicated")) {
                        siteImpl.doSetOperationalState(42);
                    } else if (nodeValue.equalsIgnoreCase("Integrated")) {
                        siteImpl.doSetOperationalState(65);
                    } else if (nodeValue.equalsIgnoreCase("Operational")) {
                        siteImpl.doSetOperationalState(66);
                    } else {
                        this.myLogger.debug((Object)("Warning: node " + nodeName + " in Site id " + siteImpl.getId() + " has unrecognized value " + nodeValue));
                    }
                }
            } else if (nodeName.equals("_blockingState")) {
                expectedNodes.removeElement("_blockingState");
                if (nodeValue != null) {
                    if (nodeValue.equalsIgnoreCase("blocked")) {
                        siteImpl.doSetBlockingState(55);
                    } else if (nodeValue.equalsIgnoreCase("unblocked")) {
                        siteImpl.doSetBlockingState(57);
                    } else if (nodeValue.equalsIgnoreCase("deferredBlock")) {
                        siteImpl.doSetBlockingState(62);
                    } else {
                        this.myLogger.debug((Object)("Warning: node " + nodeName + " in Site id " + siteImpl.getId() + " has unrecognized value " + nodeValue));
                    }
                }
            } else if (nodeName.equals("_activeClockUnit")) {
                expectedNodes.removeElement("_activeClockUnit");
                if (nodeValue != null) {
                    siteImpl.doSetActiveClockUnit(Integer.parseInt(nodeValue));
                }
            } else if (nodeName.equals("_OMMaster")) {
                expectedNodes.removeElement("_OMMaster");
                if (nodeValue != null) {
                    siteImpl.doSetOMMaster(Integer.parseInt(nodeValue));
                }
            } else if (nodeName.equals("btsType")) {
                expectedNodes.removeElement("btsType");
                if (nodeValue != null) {
                    siteImpl.doSetBtsType(String.valueOf(nodeValue));
                }
            } else if (nodeName.equals("_TComMaster")) {
                expectedNodes.removeElement("_TComMaster");
                if (nodeValue != null) {
                    siteImpl.doSetTComMaster(Integer.parseInt(nodeValue));
                }
            } else if (nodeName.equals("_authenticationServer")) {
                expectedNodes.removeElement("_authenticationServer");
                if (nodeValue != null) {
                    siteImpl.doSetAuthenticationServer(nodeValue);
                }
            } else if (nodeName.equals("_doorSwitchInUse")) {
                expectedNodes.removeElement("_doorSwitchInUse");
                if (nodeValue != null) {
                    if (nodeValue.equalsIgnoreCase(FALSE) || nodeValue.equalsIgnoreCase(TRUE)) {
                        siteImpl.doSetDoorSwitchInUse(Integer.parseInt(nodeValue));
                    } else {
                        this.myLogger.debug((Object)("Warning: node " + nodeName + " in Site id " + siteImpl.getId() + " has unrecognized value " + nodeValue));
                        siteImpl.doSetDoorSwitchInUse(-1);
                    }
                }
            } else if (nodeName.equals("_mainsPowerAlarmId")) {
                expectedNodes.removeElement("_mainsPowerAlarmId");
                if (nodeValue != null) {
                    siteImpl.doSetMainsPowerAlarmId(Integer.parseInt(nodeValue));
                }
            } else if (nodeName.equals("_NTPAddress")) {
                expectedNodes.removeElement("_NTPAddress");
                if (nodeValue != null) {
                    siteImpl.doSetNTPAddress(nodeValue);
                }
            } else if (nodeName.equals("_numberOfLines")) {
                expectedNodes.removeElement("_numberOfLines");
                if (nodeValue != null) {
                    siteImpl.doSetNumberOfLines(Integer.parseInt(nodeValue));
                }
            } else if (nodeName.equals("_timeZone")) {
                expectedNodes.removeElement("_timeZone");
                if (nodeValue != null) {
                    siteImpl.doSetTimeZoneOffset(Float.parseFloat(node.getFirstChild().getNodeValue()));
                }
            } else if (nodeName.equals("_timeZoneLocation")) {
                expectedNodes.removeElement("_timeZoneLocation");
                if (nodeValue == null) {
                    TimeZoneChangeListener timeListener = this.myBTSConfigurationManager.getTimeListener();
                    if (timeListener != null) {
                        timeListener.timeZoneResolveFailed();
                    }
                    this.myLogger.error((Object)"_timeZoneLocation has no value.");
                } else {
                    boolean blnFound = false;
                    String timeZoneId = node.getFirstChild().getNodeValue();
                    try {
                        String[] timeZones = TimeZone.getAvailableIDs();
                        int i = 0;
                        while (i < timeZones.length) {
                            String someTimeZoneId = timeZones[i];
                            if (timeZoneId.equals(someTimeZoneId)) {
                                blnFound = true;
                                break;
                            }
                            ++i;
                        }
                    }
                    catch (Exception e) {
                        TimeZoneChangeListener timeListener = this.myBTSConfigurationManager.getTimeListener();
                        if (timeListener != null) {
                            timeListener.timeZoneResolveFailed();
                        }
                        this.myLogger.error((Object)"Error in parsing time zone.");
                    }
                    if (blnFound) {
                        TimeZone timeZone = TimeZone.getTimeZone(timeZoneId);
                        if ("Europe/Simferopol".equals(timeZoneId)) {
                            timeZone = JreBugFixer.getSimferopplTimeZone(siteImpl.getTimeZoneOffset());
                        }
                        if ("Europe/Kaliningrad".equals(timeZoneId)) {
                            timeZone = JreBugFixer.getKaliningradTimeZone(siteImpl.getTimeZoneOffset());
                        }
                        siteImpl.doSetTimeZone(timeZone);
                        PerformanceDataBuilder.setTimeZone(timeZone);
                    } else {
                        TimeZoneChangeListener timeListener = this.myBTSConfigurationManager.getTimeListener();
                        if (timeListener != null) {
                            timeListener.timeZoneResolveFailed();
                        }
                        this.myLogger.error((Object)("Warning: TimeZone <" + timeZoneId + "> not recognised."));
                    }
                }
            } else if (nodeName.equals("_mibbuType")) {
                expectedNodes.removeElement("_mibbuType");
                if (nodeValue != null) {
                    if (nodeValue.equalsIgnoreCase("NotEquipped")) {
                        siteImpl.doSetMibbuType(61);
                    } else if (nodeValue.equalsIgnoreCase("56Ah")) {
                        siteImpl.doSetMibbuType(59);
                    } else if (nodeValue.equalsIgnoreCase("90Ah")) {
                        siteImpl.doSetMibbuType(60);
                    } else {
                        this.myLogger.debug((Object)("Warning: node " + nodeName + " in Site id " + siteImpl.getId() + " has unrecognized value " + nodeValue));
                    }
                }
            } else if (nodeName.equals("_swUpdateSource")) {
                expectedNodes.removeElement("_swUpdateSource");
                if (nodeValue != null) {
                    if (nodeValue.equalsIgnoreCase("btsMgr")) {
                        siteImpl.doSetSwUpdateSource(74);
                    } else if (nodeValue.equalsIgnoreCase("internal")) {
                        siteImpl.doSetSwUpdateSource(73);
                    } else if (nodeValue.equalsIgnoreCase("none")) {
                        siteImpl.doSetSwUpdateSource(72);
                    } else if (nodeValue.equalsIgnoreCase("netAct")) {
                        siteImpl.doSetSwUpdateSource(75);
                    } else if (nodeValue.equalsIgnoreCase("swUpdateFailed")) {
                        siteImpl.doSetSwUpdateSource(76);
                    } else {
                        this.myLogger.debug((Object)("Warning: node " + nodeName + " in Site id " + siteImpl.getId() + " has unrecognized value " + nodeValue));
                    }
                }
            } else if (nodeName.equals("_smokeAlarmInUse")) {
                expectedNodes.removeElement("_smokeAlarmInUse");
                if (nodeValue != null) {
                    if (nodeValue.equalsIgnoreCase(FALSE) || nodeValue.equalsIgnoreCase(TRUE)) {
                        siteImpl.doSetSmokeAlarmInUse(Integer.parseInt(nodeValue));
                    } else if ("notinuse".equalsIgnoreCase(nodeValue)) {
                        siteImpl.doSetSmokeAlarmInUse(0);
                    } else if ("inuse".equalsIgnoreCase(nodeValue)) {
                        siteImpl.doSetSmokeAlarmInUse(1);
                    } else {
                        this.myLogger.debug((Object)("Warning: node " + nodeName + " in Site id " + siteImpl.getId() + " has unrecognized value " + nodeValue));
                        siteImpl.doSetSmokeAlarmInUse(-1);
                    }
                }
            } else if (!"#text".equals(nodeName) && !"#comment".equals(node.getNodeName())) {
                if (nodeValue != null) {
                    attributes.put(nodeName, nodeValue);
                } else {
                    attributes.put(nodeName, "Coreasset_Unknown");
                    flag = true;
                    strErrMessage = String.valueOf(strErrMessage) + nodeName + ", ";
                    ++intCounter;
                }
            }
            ++j;
        }
        if (this.myCabinet != null) {
            siteImpl.doSetCabinet(this.myCabinet);
        }
        if (flag) {
            if (intCounter > 1) {
                this.myLogger.trace((Object)("Warning: nodes " + strErrMessage + "in Site id " + siteImpl.getId() + " don't have any values."));
            } else {
                this.myLogger.trace((Object)("Warning: node " + strErrMessage + "in Site id " + siteImpl.getId() + " doesn't have any value."));
            }
        }
        int i = 0;
        while (i < expectedNodes.size()) {
            TimeZoneChangeListener timeListener;
            String someNodeName = (String)expectedNodes.elementAt(i);
            this.myLogger.trace((Object)("Warning: node " + someNodeName + " is missing in Site with id " + siteImpl.getId() + "."));
            if (someNodeName.equalsIgnoreCase("_timeZoneLocation") && (timeListener = this.myBTSConfigurationManager.getTimeListener()) != null) {
                timeListener.timeZoneResolveFailed();
            }
            ++i;
        }
        siteImpl.doSetCustomAttributes((Hashtable)attributes.clone());
        return siteImpl;
    }

    protected List<CellImpl> createCells(NodeList nodeList) {
        ArrayList<CellImpl> cells = new ArrayList<CellImpl>();
        int i = 0;
        while (i < nodeList.getLength()) {
            Node node = nodeList.item(i);
            String nodeName = node.getNodeName();
            if (nodeName.equalsIgnoreCase("Cell")) {
                cells.add(this.createCell(node.getChildNodes()));
            }
            ++i;
        }
        return cells;
    }

    protected CellImpl createCell(NodeList nodeList) {
        boolean flag = false;
        String strErrMessage = "";
        int intCounter = 0;
        CellImpl cellImpl = new CellImpl(this.myBTSConfigurationManager);
        cellImpl.doSetRatType(this.myBTSConfigurationManager.getRatType());
        Hashtable<String, String> attributes = new Hashtable<String, String>(10);
        Vector<String> expectedNodes = new Vector<String>(10);
        expectedNodes.addElement("_id");
        expectedNodes.addElement("_cellAvailability");
        expectedNodes.addElement("_state");
        expectedNodes.addElement("_blockingState");
        expectedNodes.addElement("_operationalState");
        expectedNodes.addElement("_concept");
        expectedNodes.addElement("_globalCellId");
        expectedNodes.addElement("_intelligentShutdownTimeout");
        int j = 0;
        while (j < nodeList.getLength()) {
            Node node = nodeList.item(j);
            String nodeName = node.getNodeName();
            String nodeValue = null;
            expectedNodes.remove(nodeName);
            if (node.hasChildNodes()) {
                nodeValue = node.getFirstChild().getNodeValue();
            }
            if (nodeName.equals("_id")) {
                if (nodeValue != null) {
                    cellImpl.doSetCellId(Integer.parseInt(nodeValue));
                }
            } else if (nodeName.equals("_cellAvailability")) {
                if (nodeValue != null) {
                    if (nodeValue.equalsIgnoreCase("active")) {
                        cellImpl.doSetAvailability(46);
                    } else if (nodeValue.equalsIgnoreCase("inactive")) {
                        cellImpl.doSetAvailability(47);
                    } else if (nodeValue.equalsIgnoreCase("Shutting down")) {
                        cellImpl.doSetAvailability(48);
                    } else {
                        this.myLogger.debug((Object)("Warning: node " + nodeName + " in Cell id " + cellImpl.getCellId() + " has unrecognized value " + nodeValue));
                    }
                }
            } else if (nodeName.equals("_state")) {
                if (nodeValue != null) {
                    if (nodeValue.equalsIgnoreCase("working")) {
                        cellImpl.doSetState(52);
                    } else if (nodeValue.equalsIgnoreCase("degraded")) {
                        cellImpl.doSetState(53);
                    } else if (nodeValue.equalsIgnoreCase("faulty")) {
                        cellImpl.doSetState(54);
                    } else if (nodeValue.equalsIgnoreCase("resetting")) {
                        cellImpl.doSetState(58);
                    } else {
                        this.myLogger.debug((Object)("Warning: node " + nodeName + " in Cell id " + cellImpl.getCellId() + " has unrecognized value " + nodeValue));
                    }
                }
            } else if (nodeName.equals("_blockingState")) {
                if (nodeValue != null) {
                    if (nodeValue.equalsIgnoreCase("unblocked")) {
                        cellImpl.doSetBlockingState(57);
                    } else if (nodeValue.equalsIgnoreCase("blocked")) {
                        cellImpl.doSetBlockingState(55);
                    } else if (nodeValue.equalsIgnoreCase("deferredBlock")) {
                        cellImpl.doSetBlockingState(62);
                    } else {
                        this.myLogger.debug((Object)("Warning: node " + nodeName + " in Cell id " + cellImpl.getCellId() + " has unrecognized value " + nodeValue));
                    }
                }
            } else if (nodeName.equals("_operationalState")) {
                if (nodeValue != null) {
                    if (nodeValue.equalsIgnoreCase("enabled")) {
                        cellImpl.doSetOperationalState(27);
                    } else if (nodeValue.equalsIgnoreCase("disabled")) {
                        cellImpl.doSetOperationalState(28);
                    } else {
                        this.myLogger.debug((Object)("Warning: node " + nodeName + " in Cell id " + cellImpl.getCellId() + " has unrecognized value " + nodeValue));
                    }
                }
            } else if (nodeName.equals("_concept")) {
                if (nodeValue != null) {
                    cellImpl.doSetConcept(nodeValue);
                }
            } else if (nodeName.equals("_globalCellId")) {
                if (nodeValue != null) {
                    cellImpl.doSetGlobalCellId(Integer.parseInt(nodeValue));
                }
            } else if (nodeName.equals("_intelligentShutdownTimeout")) {
                if (nodeValue != null) {
                    cellImpl.doSetIntelligentShutdownTimeout(Integer.parseInt(nodeValue));
                }
            } else if (nodeName.equals("Allowed.Carriers")) {
                try {
                    NodeList carriersList = node.getChildNodes();
                    ArrayList<String> allowedCarriers = new ArrayList<String>();
                    int i = 0;
                    while (i < carriersList.getLength()) {
                        Node allowedCarrierNode = carriersList.item(i);
                        if (allowedCarrierNode != null && allowedCarrierNode.hasChildNodes()) {
                            allowedCarriers.add(allowedCarrierNode.getFirstChild().getNodeValue().trim());
                        }
                        ++i;
                    }
                    int[] intCarriers = new int[allowedCarriers.size()];
                    int i2 = 0;
                    while (i2 < allowedCarriers.size()) {
                        intCarriers[i2] = Integer.parseInt((String)allowedCarriers.get(i2));
                        ++i2;
                    }
                    cellImpl.doSetAllowedCarriers(intCarriers);
                }
                catch (Exception ex) {
                    this.myLogger.error((Object)("Error in parsing allowed carriers. " + ex.getMessage()));
                }
            } else if (!"#text".equals(nodeName) && !"#comment".equals(node.getNodeName())) {
                if (nodeValue != null) {
                    attributes.put(nodeName, nodeValue);
                } else {
                    attributes.put(nodeName, "Coreasset_Unknown");
                    flag = true;
                    strErrMessage = String.valueOf(strErrMessage) + nodeName + ", ";
                    ++intCounter;
                }
            }
            ++j;
        }
        if (flag) {
            if (intCounter > 1) {
                this.myLogger.trace((Object)("Warning: nodes " + strErrMessage + "in Cell with id number - " + cellImpl.getCellId() + ", don't have any values"));
            } else {
                this.myLogger.trace((Object)("Warning: node " + strErrMessage + "in Cell with id number - " + cellImpl.getCellId() + ", doesn't have any value"));
            }
        }
        int i = 0;
        while (i < expectedNodes.size()) {
            this.myLogger.trace((Object)("Warning: node " + expectedNodes.elementAt(i) + " in Cell id " + cellImpl.getCellId() + " is missing."));
            ++i;
        }
        cellImpl.doSetCustomAttributes(attributes);
        return cellImpl;
    }

    protected LinkImpl createLink(NodeList nodeList) {
        boolean flag = false;
        String strErrMessage = "";
        int intCounter = 0;
        LinkImpl linkImpl = new LinkImpl(this.myBTSConfigurationManager);
        linkImpl.doSetRatType(this.myBTSConfigurationManager.getRatType());
        Hashtable<String, String> attributes = new Hashtable<String, String>(10);
        Vector<String> expectedNodes = new Vector<String>(10);
        expectedNodes.addElement("_id");
        expectedNodes.addElement("_linkType");
        expectedNodes.addElement("_linkState");
        expectedNodes.addElement("_unitId");
        expectedNodes.addElement("LinkName");
        int j = 0;
        while (j < nodeList.getLength()) {
            Node node = nodeList.item(j);
            String nodeName = node.getNodeName();
            String nodeValue = null;
            expectedNodes.removeElement(nodeName);
            if (node.hasChildNodes()) {
                nodeValue = node.getFirstChild().getNodeValue();
            }
            if (nodeName.equals("_id")) {
                if (nodeValue != null) {
                    linkImpl.doSetId(Integer.parseInt(nodeValue));
                }
            } else if (nodeName.equals("_linkType")) {
                if (nodeValue != null) {
                    linkImpl.setLinkType(nodeValue);
                }
            } else if (nodeName.equals("_linkState")) {
                if (nodeValue != null) {
                    if (nodeValue.equalsIgnoreCase("true")) {
                        linkImpl.setLinkState(true);
                    } else if (nodeValue.equalsIgnoreCase("false")) {
                        linkImpl.setLinkState(false);
                    } else {
                        this.myLogger.debug((Object)("Warning: Link with id number - " + linkImpl.getId() + " has unidentified link state: " + nodeValue));
                    }
                }
            } else if (nodeName.equals("LinkName")) {
                if (nodeValue != null) {
                    linkImpl.setLinkName(nodeValue);
                }
            } else if (nodeName.equals("_unitId")) {
                if (nodeValue != null) {
                    linkImpl.setUnitId(Integer.parseInt(nodeValue));
                }
            } else if (!"#text".equals(nodeName) && !"#comment".equals(node.getNodeName())) {
                if (nodeValue != null) {
                    attributes.put(nodeName, nodeValue);
                } else {
                    attributes.put(nodeName, "Coreasset_Unknown");
                    flag = true;
                    strErrMessage = String.valueOf(strErrMessage) + nodeName + ", ";
                    ++intCounter;
                }
            }
            ++j;
        }
        if (flag) {
            if (intCounter > 1) {
                this.myLogger.trace((Object)("Warning: nodes " + strErrMessage + "in Link with id number - " + linkImpl.getId() + ", don't have any values"));
            } else {
                this.myLogger.trace((Object)("Warning: node " + strErrMessage + "in Link with id number - " + linkImpl.getId() + ", doesn't have any value"));
            }
        }
        int i = 0;
        while (i < expectedNodes.size()) {
            this.myLogger.trace((Object)("Warning: node " + expectedNodes.elementAt(i) + " is missing in Link with id " + linkImpl.getId() + "."));
            ++i;
        }
        linkImpl.doSetCustomAttributes(attributes);
        return linkImpl;
    }

    protected EACInputImpl createEACInput(NodeList nodeList) {
        EACInputImpl eacInput = new EACInputImpl(this.myBTSConfigurationManager);
        eacInput.doSetRatType(this.myBTSConfigurationManager.getRatType());
        if (nodeList.getLength() == 0) {
            this.myLogger.error((Object)"No information was found in an EAC input node!");
            eacInput = null;
        } else {
            Hashtable<String, String> attributes = new Hashtable<String, String>(10);
            Vector<String> expectedNodes = new Vector<String>(10);
            expectedNodes.addElement("_id");
            expectedNodes.addElement("_enabled");
            expectedNodes.addElement("_inputName");
            expectedNodes.addElement("_inputCurrentState");
            expectedNodes.addElement("_alarmSeverity");
            expectedNodes.addElement("_polarity");
            expectedNodes.addElement("_alarmId");
            int i = 0;
            while (i < nodeList.getLength()) {
                Node node = nodeList.item(i);
                String nodeName = node.getNodeName();
                String nodeValue = null;
                expectedNodes.removeElement(nodeName);
                if (node.hasChildNodes()) {
                    nodeValue = node.getFirstChild().getNodeValue();
                }
                if (nodeName.equals("_enabled")) {
                    if (nodeValue != null) {
                        if (nodeValue.equals("enabled")) {
                            eacInput.setEnabledState(27);
                        } else if (nodeValue.equals("disabled")) {
                            eacInput.setEnabledState(28);
                        } else {
                            this.myLogger.debug((Object)("Warning: node " + nodeName + " in EACInput id " + eacInput.getId() + " has unrecognized value " + nodeValue));
                        }
                    }
                } else if (nodeName.equals("_unitId")) {
                    if (nodeValue != null) {
                        try {
                            eacInput.setUnitId(Integer.parseInt(nodeValue));
                        }
                        catch (NumberFormatException nfe) {
                            this.myLogger.error((Object)("Unable to set " + nodeValue + " as unit Id."));
                        }
                    }
                } else if (nodeName.equals("_id")) {
                    if (nodeValue != null) {
                        try {
                            eacInput.doSetId(Integer.parseInt(nodeValue));
                        }
                        catch (NumberFormatException nfe) {
                            this.myLogger.error((Object)("Unable to set " + nodeValue + " as Id."));
                        }
                    }
                } else if (nodeName.equals("_inputName")) {
                    if (nodeValue != null) {
                        eacInput.setName(nodeValue);
                    }
                } else if (nodeName.equals("_inputCurrentState")) {
                    if (nodeValue != null) {
                        if (nodeValue.equals("on")) {
                            eacInput.setState(7);
                        } else if (nodeValue.equals("off")) {
                            eacInput.setState(8);
                        } else {
                            this.myLogger.debug((Object)("Warning: node " + nodeName + " in EACInput id " + eacInput.getId() + " has unrecognized value " + nodeValue));
                        }
                    }
                } else if (nodeName.equals("_alarmSeverity")) {
                    if (nodeValue != null) {
                        if (nodeValue.equals("degraded")) {
                            eacInput.setFaultSeverity(53);
                        } else if (nodeValue.equals("outOfOrder")) {
                            eacInput.setFaultSeverity(32);
                        } else if (nodeValue.equals("info")) {
                            eacInput.setFaultSeverity(30);
                        } else if (nodeValue.equals("test")) {
                            eacInput.setFaultSeverity(29);
                        } else if (nodeValue.equals("debug")) {
                            eacInput.setFaultSeverity(31);
                        } else if (nodeValue.equals("working")) {
                            eacInput.setFaultSeverity(52);
                        } else {
                            this.myLogger.debug((Object)("Warning: node " + nodeName + " in EACInput id " + eacInput.getId() + " has unrecognized value " + nodeValue));
                        }
                    }
                } else if (nodeName.equals("_polarity")) {
                    if (nodeValue != null) {
                        if (nodeValue.equals("on_ok")) {
                            eacInput.setPolarity(25);
                        } else if (nodeValue.equals("off_ok")) {
                            eacInput.setPolarity(26);
                        } else {
                            this.myLogger.debug((Object)("Warning: node " + nodeName + " in EACInput id " + eacInput.getId() + " has unrecognized value " + nodeValue));
                        }
                    }
                } else if (nodeName.equals("_alarmId")) {
                    if (nodeValue != null) {
                        try {
                            eacInput.setLineId(Integer.parseInt(nodeValue));
                        }
                        catch (NumberFormatException nfe) {
                            this.myLogger.error((Object)("Unable to set " + nodeValue + " as LineId."));
                        }
                    }
                } else if (!"#text".equals(nodeName) && !"#comment".equals(node.getNodeName())) {
                    if (nodeValue != null) {
                        attributes.put(nodeName, nodeValue);
                    } else {
                        attributes.put(nodeName, "Coreasset_Unknown");
                    }
                }
                ++i;
            }
            i = 0;
            while (i < expectedNodes.size()) {
                this.myLogger.trace((Object)("Warning: node " + expectedNodes.elementAt(i) + " is missing in EACInput id " + eacInput.getId() + "."));
                ++i;
            }
            eacInput.doSetCustomAttributes(attributes);
        }
        return eacInput;
    }

    protected EACOutputImpl createEACOutput(NodeList nodeList) {
        EACOutputImpl eacOutput = new EACOutputImpl(this.myBTSConfigurationManager);
        eacOutput.doSetRatType(this.myBTSConfigurationManager.getRatType());
        if (nodeList.getLength() == 0) {
            this.myLogger.error((Object)"No information was found in an EAC output node!");
            eacOutput = null;
        } else {
            Hashtable<String, String> attributes = new Hashtable<String, String>(10);
            Vector<String> expectedNodes = new Vector<String>(10);
            expectedNodes.addElement("_id");
            expectedNodes.addElement("_outputName");
            expectedNodes.addElement("_outputCurrentState");
            expectedNodes.addElement("_outputId");
            int i = 0;
            while (i < nodeList.getLength()) {
                Node node = nodeList.item(i);
                String nodeName = node.getNodeName();
                String nodeValue = null;
                expectedNodes.removeElement(nodeName);
                if (node.hasChildNodes()) {
                    nodeValue = node.getFirstChild().getNodeValue();
                }
                if (nodeName.equals("_id")) {
                    if (nodeValue != null) {
                        try {
                            eacOutput.doSetId(Integer.parseInt(nodeValue));
                        }
                        catch (NumberFormatException nfe) {
                            this.myLogger.error((Object)("Unable to set " + nodeValue + " as Id."));
                        }
                    }
                } else if (nodeName.equals("_unitId")) {
                    if (nodeValue != null) {
                        try {
                            eacOutput.setUnitId(Integer.parseInt(nodeValue));
                        }
                        catch (NumberFormatException nfe) {
                            this.myLogger.error((Object)("Unable to set " + nodeValue + " as Unit Id."));
                        }
                    }
                } else if (nodeName.equals("_outputName")) {
                    if (nodeValue != null) {
                        eacOutput.setName(nodeValue);
                    }
                } else if (nodeName.equals("_outputCurrentState")) {
                    if (nodeValue != null) {
                        if (nodeValue.equals("on")) {
                            eacOutput.setState(7);
                        } else if (nodeValue.equals("off")) {
                            eacOutput.setState(8);
                        } else {
                            this.myLogger.debug((Object)("Warning: node " + nodeName + " in EACOutput id " + eacOutput.getId() + " has unrecognized value " + nodeValue));
                        }
                    }
                } else if (nodeName.equals("_outputId")) {
                    if (nodeValue != null) {
                        try {
                            eacOutput.setLineId(Integer.parseInt(nodeValue));
                        }
                        catch (NumberFormatException nfe) {
                            this.myLogger.error((Object)("Unable to set " + nodeValue + " as LineId."));
                        }
                    }
                } else if (!"#text".equals(nodeName) && !"#comment".equals(node.getNodeName())) {
                    if (nodeValue != null) {
                        attributes.put(nodeName, nodeValue);
                    } else {
                        attributes.put(nodeName, "Coreasset_Unknown");
                    }
                }
                ++i;
            }
            i = 0;
            while (i < expectedNodes.size()) {
                this.myLogger.trace((Object)("Warning: node " + expectedNodes.elementAt(i) + " is missing in EACOutput with id " + eacOutput.getId() + "."));
                ++i;
            }
            eacOutput.doSetCustomAttributes(attributes);
        }
        return eacOutput;
    }

    protected SubUnitImpl createSubUnit(NodeList nodeList) {
        boolean flag = false;
        String strErrMessage = "";
        int intCounter = 0;
        SubUnitImpl subUnitImpl = new SubUnitImpl(this.myBTSConfigurationManager);
        subUnitImpl.doSetRatType(this.myBTSConfigurationManager.getRatType());
        Hashtable<String, String> attributes = new Hashtable<String, String>(10);
        Vector<String> expectedNodes = new Vector<String>(10);
        expectedNodes.addElement("_id");
        expectedNodes.addElement("_unitId");
        expectedNodes.addElement("_subunitNumber");
        expectedNodes.addElement("_subunitName");
        expectedNodes.addElement("_state");
        expectedNodes.addElement("_blockingState");
        expectedNodes.addElement("_operationalState");
        expectedNodes.addElement("_supportedOperations");
        int j = 0;
        while (j < nodeList.getLength()) {
            Node node = nodeList.item(j);
            String nodeName = node.getNodeName();
            String nodeValue = null;
            expectedNodes.removeElement(nodeName);
            if (node.hasChildNodes()) {
                nodeValue = node.getFirstChild().getNodeValue();
            }
            if (nodeName.equals("_id")) {
                if (nodeValue != null) {
                    subUnitImpl.doSetId(Integer.parseInt(nodeValue));
                }
            } else if (nodeName.equals("_unitId")) {
                if (nodeValue != null) {
                    subUnitImpl.doSetParentUnitId(Integer.parseInt(nodeValue));
                }
            } else if (nodeName.equals("_subunitNumber")) {
                if (nodeValue != null) {
                    subUnitImpl.doSetNumber(Integer.parseInt(nodeValue));
                }
            } else if (nodeName.equals("_subunitName")) {
                if (nodeValue != null) {
                    subUnitImpl.setName(nodeValue);
                }
            } else if (nodeName.equals("_state")) {
                if (nodeValue != null) {
                    if (nodeValue.equalsIgnoreCase("working")) {
                        subUnitImpl.doSetState(52);
                    } else if (nodeValue.equalsIgnoreCase("degraded")) {
                        subUnitImpl.doSetState(53);
                    } else if (nodeValue.equalsIgnoreCase("faulty")) {
                        subUnitImpl.doSetState(54);
                    } else if (nodeValue.equalsIgnoreCase("resetting")) {
                        subUnitImpl.doSetState(58);
                    } else {
                        this.myLogger.debug((Object)("Warning: node " + nodeName + " in SubUnit id " + subUnitImpl.getId() + " has unrecognized value " + nodeValue));
                    }
                }
            } else if (nodeName.equals("_blockingState")) {
                if (nodeValue != null) {
                    if (nodeValue.equalsIgnoreCase("blocked")) {
                        subUnitImpl.doSetBlockingState(55);
                    } else if (nodeValue.equalsIgnoreCase("unblocked")) {
                        subUnitImpl.doSetBlockingState(57);
                    } else if (nodeValue.equalsIgnoreCase("deferredBlock")) {
                        subUnitImpl.doSetBlockingState(62);
                    } else {
                        this.myLogger.debug((Object)("Warning: node " + nodeName + " in SubUnit id " + subUnitImpl.getId() + " has unrecognized value " + nodeValue));
                    }
                }
            } else if (nodeName.equals("_operationalState")) {
                if (nodeValue != null) {
                    if (nodeValue.equalsIgnoreCase("enabled")) {
                        subUnitImpl.doSetOperationalState(27);
                    } else if (nodeValue.equalsIgnoreCase("disabled")) {
                        subUnitImpl.doSetOperationalState(28);
                    } else {
                        this.myLogger.debug((Object)("Warning: node " + nodeName + " in SubUnit id " + subUnitImpl.getId() + " has unrecognized value " + nodeValue));
                    }
                }
            } else if (nodeName.equals("_supportedOperations")) {
                int i = 0;
                while (i < node.getChildNodes().getLength()) {
                    String supportValue = node.getChildNodes().item(i).getNodeName();
                    if (supportValue.startsWith("_reset")) {
                        subUnitImpl.doAddPermittedOperation(44);
                    } else if (supportValue.startsWith("_block")) {
                        subUnitImpl.doAddPermittedOperation(45);
                    } else {
                        this.myLogger.debug((Object)("Warning: node " + nodeName + " in SubUnit id " + subUnitImpl.getId() + " has unrecognized value " + supportValue));
                    }
                    ++i;
                }
            } else if (!"#text".equals(nodeName) && !"#comment".equals(node.getNodeName())) {
                if (nodeValue != null) {
                    attributes.put(nodeName, nodeValue);
                } else {
                    attributes.put(nodeName, "Coreasset_Unknown");
                    flag = true;
                    strErrMessage = String.valueOf(strErrMessage) + nodeName + ", ";
                    ++intCounter;
                }
            }
            ++j;
        }
        if (flag) {
            if (intCounter > 1) {
                this.myLogger.trace((Object)("Warning: nodes " + strErrMessage + "in SubUnit with id number - " + subUnitImpl.getId() + ", don't have any values"));
            } else {
                this.myLogger.trace((Object)("Warning: node " + strErrMessage + "in SubUnit with id number - " + subUnitImpl.getId() + ", doesn't have any value"));
            }
        }
        int i = 0;
        while (i < expectedNodes.size()) {
            this.myLogger.trace((Object)("Warning: node " + expectedNodes.elementAt(i) + " is missing in SubUnit with id " + subUnitImpl.getId() + "."));
            ++i;
        }
        subUnitImpl.doSetCustomAttributes(attributes);
        return subUnitImpl;
    }

    protected CellGroupImpl createCellGroup(NodeList nodeList) {
        this.myLogger.debug((Object)"CellGroup creation in createCellGroup.");
        CellGroupImpl cellGroup = new CellGroupImpl(-1);
        cellGroup.doSetRatType(this.myBTSConfigurationManager.getRatType());
        Hashtable<String, String> attributes = new Hashtable<String, String>(10);
        int j = 0;
        while (j < nodeList.getLength()) {
            Node node = nodeList.item(j);
            String nodeName = node.getNodeName();
            String nodeValue = null;
            if (node.hasChildNodes()) {
                nodeValue = node.getFirstChild().getNodeValue();
            }
            if (nodeName.equals("_id")) {
                if (nodeValue != null) {
                    this.myLogger.debug((Object)("CellGroup id is '" + nodeValue + "'"));
                    cellGroup.doSetId(Integer.parseInt(nodeValue));
                    cellGroup.doSetCellGroupId(Integer.parseInt(nodeValue));
                }
            } else if (nodeName.equals("CellGroupName")) {
                if (nodeValue != null) {
                    this.myLogger.debug((Object)("CellGroup name is '" + nodeValue + "'"));
                    cellGroup.doSetName(nodeValue);
                }
            } else if (!"#text".equals(node.getNodeName()) && !"#comment".equals(node.getNodeName())) {
                if (nodeValue != null) {
                    attributes.put(nodeName, nodeValue);
                } else {
                    attributes.put(nodeName, "Coreasset_Unknown");
                }
            }
            ++j;
        }
        cellGroup.doSetCustomAttributes(attributes);
        return cellGroup;
    }

    protected UnitImpl createUnit(NodeList nodeList) {
        boolean flag = false;
        String strErrMessage = "";
        int intCounter = 0;
        UnitImpl unitImpl = new UnitImpl(this.myBTSConfigurationManager);
        unitImpl.doSetRatType(this.myBTSConfigurationManager.getRatType());
        Hashtable<String, String> attributes = new Hashtable<String, String>(10);
        Vector<String> expectedNodes = new Vector<String>(20);
        expectedNodes.addElement("_id");
        expectedNodes.addElement("_cabinetId");
        expectedNodes.addElement("_productCode");
        expectedNodes.addElement("_bsId");
        expectedNodes.addElement("_rack");
        expectedNodes.addElement("_shelf");
        expectedNodes.addElement("_slot");
        expectedNodes.addElement("_unitType");
        expectedNodes.addElement("_unitNumber");
        expectedNodes.addElement("_variant");
        expectedNodes.addElement("_unitName");
        expectedNodes.addElement("_distName");
        expectedNodes.addElement("_manufacturer");
        expectedNodes.addElement("_exist");
        expectedNodes.addElement("_serialNro");
        expectedNodes.addElement("_state");
        expectedNodes.addElement("_blockingState");
        expectedNodes.addElement("_operationalState");
        expectedNodes.addElement("_SWState");
        expectedNodes.addElement("_HWversion");
        expectedNodes.addElement("_subrack");
        expectedNodes.addElement("_commissioned");
        int j = 0;
        while (j < nodeList.getLength()) {
            Node node = nodeList.item(j);
            String nodeName = node.getNodeName();
            String nodeValue = null;
            expectedNodes.removeElement(nodeName);
            if (node.hasChildNodes()) {
                nodeValue = node.getFirstChild().getNodeValue();
            }
            if (nodeName.equals("_id")) {
                if (nodeValue != null) {
                    unitImpl.doSetId(Integer.parseInt(nodeValue));
                }
            } else if (nodeName.equals("_cabinetId")) {
                if (nodeValue != null) {
                    unitImpl.doSetCabinetId(Integer.parseInt(nodeValue));
                }
            } else if (nodeName.equals("_productCode")) {
                if (nodeValue != null) {
                    unitImpl.doSetProductCode(nodeValue);
                } else {
                    unitImpl.doSetProductCode("");
                }
            } else if (nodeName.equals("Chassis.Product.Code")) {
                if (nodeValue != null) {
                    unitImpl.doSetChassisProductCode(nodeValue);
                } else {
                    unitImpl.doSetChassisProductCode("");
                }
            } else if (nodeName.equals("_bsId")) {
                if (nodeValue != null) {
                    unitImpl.doSetSiteId(Integer.parseInt(nodeValue));
                }
            } else if (nodeName.equals("_rack")) {
                if (nodeValue != null) {
                    unitImpl.doSetRack(Integer.parseInt(nodeValue));
                }
            } else if (nodeName.equals("_shelf")) {
                if (nodeValue != null) {
                    unitImpl.doSetShelf(Integer.parseInt(nodeValue));
                }
            } else if (nodeName.equals("_slot")) {
                if (nodeValue != null) {
                    unitImpl.doSetSlot(Integer.parseInt(nodeValue));
                }
            } else if (nodeName.equals("_unitType")) {
                if (nodeValue != null) {
                    unitImpl.doSetUnitType(nodeValue);
                } else {
                    unitImpl.doSetUnitType("");
                }
            } else if (nodeName.equals("_unitNumber")) {
                if (nodeValue != null) {
                    unitImpl.doSetNumber(Integer.parseInt(nodeValue));
                }
            } else if (nodeName.equals("_variant")) {
                if (nodeValue != null) {
                    unitImpl.doSetVariant(nodeValue);
                } else {
                    unitImpl.doSetVariant("");
                }
            } else if (nodeName.equals("_unitName")) {
                if (nodeValue != null) {
                    unitImpl.doSetUnitName(nodeValue);
                } else {
                    unitImpl.doSetUnitName("");
                }
            } else if (nodeName.equals("_distName")) {
                if (nodeValue != null) {
                    unitImpl.doSetDistName(nodeValue);
                } else {
                    unitImpl.doSetDistName("");
                }
            } else if (nodeName.equals("_manufacturer")) {
                if (nodeValue != null) {
                    unitImpl.doSetManufacturer(nodeValue);
                } else {
                    unitImpl.doSetManufacturer("");
                }
            } else if (nodeName.equals("_exist")) {
                if (nodeValue != null) {
                    if (nodeValue.equals(TRUE)) {
                        unitImpl.doSetExist(true);
                    } else {
                        unitImpl.doSetExist(false);
                    }
                }
            } else if (nodeName.equals("_serialNro")) {
                if (nodeValue != null) {
                    unitImpl.doSetSerialNro(nodeValue);
                } else {
                    unitImpl.doSetSerialNro("");
                }
            } else if (nodeName.equals("_chassisSerialNumber")) {
                if (nodeValue != null) {
                    unitImpl.doSetChassisSerialNro(nodeValue);
                } else {
                    unitImpl.doSetChassisSerialNro("");
                }
            } else if (nodeName.equals("_state")) {
                if (nodeValue != null) {
                    if (nodeValue.equalsIgnoreCase("working")) {
                        unitImpl.doSetState(52);
                    } else if (nodeValue.equalsIgnoreCase("degraded")) {
                        unitImpl.doSetState(53);
                    } else if (nodeValue.equalsIgnoreCase("faulty")) {
                        unitImpl.doSetState(54);
                    } else if (nodeValue.equalsIgnoreCase("resetting")) {
                        unitImpl.doSetState(58);
                    } else if (nodeValue.equalsIgnoreCase("Unknown")) {
                        unitImpl.doSetState(59);
                    } else if (nodeValue.equalsIgnoreCase("switchedOff")) {
                        unitImpl.doSetState(60);
                    } else {
                        this.myLogger.debug((Object)("Warning: node " + nodeName + " in Unit with id number - " + unitImpl.getId() + " has unrecognized value " + nodeValue));
                    }
                }
            } else if (nodeName.equals("_blockingState")) {
                if (nodeValue != null) {
                    if (nodeValue.equalsIgnoreCase("blocked")) {
                        unitImpl.doSetBlockingState(55);
                    } else if (nodeValue.equalsIgnoreCase("unblocked")) {
                        unitImpl.doSetBlockingState(57);
                    } else if (nodeValue.equalsIgnoreCase("deferredBlock")) {
                        unitImpl.doSetBlockingState(62);
                    } else {
                        this.myLogger.debug((Object)("Warning: node " + nodeName + " in Unit with id number - " + unitImpl.getId() + " has unrecognized value " + nodeValue));
                    }
                }
            } else if (nodeName.equals("_operationalState")) {
                if (nodeValue != null) {
                    if (nodeValue.equalsIgnoreCase("enabled")) {
                        unitImpl.doSetOperationalState(27);
                    } else if (nodeValue.equalsIgnoreCase("disabled")) {
                        unitImpl.doSetOperationalState(28);
                    } else if (nodeValue.equalsIgnoreCase("commissioned")) {
                        unitImpl.doSetOperationalState(29);
                    } else if (nodeValue.equalsIgnoreCase("notCommissioned")) {
                        unitImpl.doSetOperationalState(30);
                    } else if (nodeValue.equalsIgnoreCase("configured")) {
                        unitImpl.doSetOperationalState(31);
                    } else if (nodeValue.equalsIgnoreCase("integratedtoRAN")) {
                        unitImpl.doSetOperationalState(32);
                    } else if (nodeValue.equalsIgnoreCase("onAir")) {
                        unitImpl.doSetOperationalState(33);
                    } else {
                        this.myLogger.debug((Object)("Warning: node " + nodeName + " in Unit with id number - " + unitImpl.getId() + " has unrecognized value " + nodeValue));
                    }
                }
            } else if (nodeName.equals("_SWState")) {
                if (nodeValue != null) {
                    if (nodeValue.equalsIgnoreCase("NotCommissioned")) {
                        unitImpl.doSetSWState(37);
                    } else if (nodeValue.equalsIgnoreCase("Commissioned")) {
                        unitImpl.doSetSWState(38);
                    } else if (nodeValue.equalsIgnoreCase("Configured")) {
                        unitImpl.doSetSWState(39);
                    } else if (nodeValue.equalsIgnoreCase("IntegratedToRAN")) {
                        unitImpl.doSetSWState(40);
                    } else if (nodeValue.equalsIgnoreCase("OnAir")) {
                        unitImpl.doSetSWState(41);
                    } else if (nodeValue.equalsIgnoreCase("Operational")) {
                        unitImpl.doSetSWState(66);
                    } else if (nodeValue.equalsIgnoreCase("Configuring")) {
                        unitImpl.doSetSWState(67);
                    } else if (nodeValue.equalsIgnoreCase("Initializing") || "Initialising".equalsIgnoreCase(nodeValue)) {
                        unitImpl.doSetSWState(36);
                    } else if (nodeValue.equalsIgnoreCase("Detected")) {
                        unitImpl.doSetSWState(69);
                    } else if (nodeValue.equalsIgnoreCase("NotDetected")) {
                        unitImpl.doSetSWState(68);
                    } else if (nodeValue.equalsIgnoreCase("Lost")) {
                        unitImpl.doSetSWState(70);
                    } else if (nodeValue.equalsIgnoreCase("Rejected")) {
                        unitImpl.doSetSWState(71);
                    } else {
                        this.myLogger.debug((Object)("Warning: node " + nodeName + " in Unit with id number - " + unitImpl.getId() + " has unrecognized value " + nodeValue));
                    }
                }
            } else if (nodeName.equals("_HWversion")) {
                if (nodeValue != null) {
                    unitImpl.doSetHWVersion(nodeValue);
                } else {
                    unitImpl.doSetHWVersion("");
                }
            } else if (nodeName.equals("_subrack")) {
                if (nodeValue != null) {
                    unitImpl.doSetSubRack(Integer.parseInt(nodeValue));
                }
            } else if (nodeName.equals("_ledColour")) {
                if (nodeValue != null) {
                    if (nodeValue.equals("green") || nodeValue.equals("red") || nodeValue.equals("yellow") || nodeValue.equals("blinkingGreen") || nodeValue.equals("blinkingRed") || nodeValue.equals("blinkingYellow") || nodeValue.equals("redGreen") || nodeValue.equals("yellowGreen") || nodeValue.equals("yellowRed")) {
                        unitImpl.doSetLedColour(nodeValue);
                    } else {
                        unitImpl.doSetLedColour("Coreasset_Unknown");
                        this.myLogger.debug((Object)("Warning: node " + nodeName + " in Unit with id number - " + unitImpl.getId() + " has unrecoqnized value " + nodeValue + "."));
                    }
                }
            } else if (nodeName.equals("_commissioned")) {
                if (nodeValue != null) {
                    if (nodeValue.equalsIgnoreCase("TRUE") || nodeValue.equalsIgnoreCase(TRUE)) {
                        unitImpl.doSetCommissionedStatus(true);
                    } else if (nodeValue.equalsIgnoreCase("FALSE") || nodeValue.equalsIgnoreCase(FALSE)) {
                        unitImpl.doSetCommissionedStatus(false);
                    } else {
                        this.myLogger.debug((Object)("Warning: node " + nodeName + " in Unit with id number - " + unitImpl.getId() + " has unrecoqnized value " + nodeValue + "."));
                    }
                }
            } else if (nodeName.equals("FRInputVoltage")) {
                unitImpl.doSetInputVoltage(new InputVoltage(unitImpl.getId(), Float.parseFloat(nodeValue)));
            } else if (!"#text".equals(node.getNodeName()) && !"#comment".equals(node.getNodeName())) {
                if (nodeValue != null) {
                    attributes.put(nodeName, nodeValue);
                } else {
                    attributes.put(nodeName, "Coreasset_Unknown");
                    flag = true;
                    strErrMessage = String.valueOf(strErrMessage) + nodeName + ", ";
                    ++intCounter;
                }
            }
            ++j;
        }
        if (this.mySubUnits.size() != 0) {
            int k = 0;
            while (k < this.mySubUnits.size()) {
                SubUnitImpl subUnitImpl = (SubUnitImpl)this.mySubUnits.get(k);
                if (subUnitImpl.getParentUnitId() == unitImpl.getId()) {
                    unitImpl.doAddSubUnit(subUnitImpl);
                }
                ++k;
            }
        }
        if (flag) {
            if (intCounter > 1) {
                this.myLogger.trace((Object)("Warning: nodes " + strErrMessage + "in Unit with id number - " + unitImpl.getId() + ", don't have any values"));
            } else {
                this.myLogger.trace((Object)("Warning: node " + strErrMessage + "in Unit with id number - " + unitImpl.getId() + ", doesn't have any value"));
            }
        }
        int i = 0;
        while (i < expectedNodes.size()) {
            this.myLogger.trace((Object)("Warning: node " + expectedNodes.elementAt(i) + " is missing in Unit with id " + unitImpl.getId() + "."));
            ++i;
        }
        unitImpl.doSetCustomAttributes(attributes);
        return unitImpl;
    }

    private NodeList getChangedObjectParameters(String strObjectType, int intConfigObjectId) {
        Node node = this.myDocument.getElementsByTagName(strObjectType).item(0);
        this.myDocument.removeChild(this.myDocument.getDocumentElement());
        this.myDocument.appendChild(node);
        NodeList nodeList = this.myDocument.getElementsByTagName("_id");
        int i = 0;
        while (i < nodeList.getLength()) {
            if (nodeList.item(i).hasChildNodes() && intConfigObjectId == Integer.parseInt(nodeList.item(i).getFirstChild().getNodeValue())) {
                return nodeList.item(i).getParentNode().getChildNodes();
            }
            ++i;
        }
        this.myLogger.debug((Object)"BTS object for information updating cannot be created!");
        return null;
    }

    private List<SubUnit> createSubUnits() {
        NodeList subUnitsNodeList = this.myDocument.getElementsByTagName("Subunit");
        if (subUnitsNodeList.getLength() != 0) {
            int i = 0;
            while (i < subUnitsNodeList.getLength()) {
                this.mySubUnits.add(this.createSubUnit(subUnitsNodeList.item(i).getChildNodes()));
                ++i;
            }
        }
        return this.mySubUnits;
    }

    private Cabinet createCabinet() {
        NodeList cabinetsNodeList = this.myDocument.getElementsByTagName("Cabinet");
        if (cabinetsNodeList.getLength() != 0) {
            this.myCabinet = this.createCabinet(cabinetsNodeList.item(0).getChildNodes());
        }
        return this.myCabinet;
    }

    private CabinetImpl createCabinet(NodeList nodeList) {
        boolean flag = false;
        StringBuffer strErrMessage = new StringBuffer();
        int intCounter = 0;
        CabinetImpl cabinetImpl = new CabinetImpl(this.myBTSConfigurationManager);
        cabinetImpl.doSetRatType(this.myBTSConfigurationManager.getRatType());
        Hashtable<String, String> attributes = new Hashtable<String, String>(10);
        Vector<String> expectedNodes = new Vector<String>(10);
        expectedNodes.addElement("_id");
        expectedNodes.addElement("_cabinetType");
        expectedNodes.addElement("_productCode");
        expectedNodes.addElement("_bsId");
        expectedNodes.addElement("_serialNro");
        int j = 0;
        while (j < nodeList.getLength()) {
            Node node = nodeList.item(j);
            String nodeName = node.getNodeName();
            String nodeValue = null;
            expectedNodes.removeElement(nodeName);
            if (node.hasChildNodes()) {
                nodeValue = node.getFirstChild().getNodeValue();
            }
            if (nodeName.equals("_id")) {
                if (nodeValue != null) {
                    cabinetImpl.doSetId(Integer.parseInt(nodeValue));
                }
            } else if (nodeName.equals("_cabinetType")) {
                if (nodeValue != null) {
                    cabinetImpl.doSetCabinetType(nodeValue);
                }
            } else if (nodeName.equals("_productCode")) {
                if (nodeValue != null) {
                    cabinetImpl.doSetProductCode(nodeValue);
                }
            } else if (nodeName.equals("_bsId")) {
                if (nodeValue != null) {
                    cabinetImpl.doSetSiteId(Integer.parseInt(nodeValue));
                }
            } else if (nodeName.equals("_serialNro")) {
                if (nodeValue != null) {
                    cabinetImpl.doSetSerialNro(nodeValue);
                }
            } else if (!"#text".equals(nodeName) && !"#comment".equals(node.getNodeName())) {
                if (nodeValue != null) {
                    attributes.put(nodeName, nodeValue);
                } else {
                    attributes.put(nodeName, "Coreasset_Unknown");
                    flag = true;
                    strErrMessage.append(String.valueOf(nodeName) + ", ");
                    ++intCounter;
                }
            }
            ++j;
        }
        if (this.myUnits.size() != 0) {
            int units = this.myUnits.size();
            int k = units - 1;
            while (k >= 0) {
                UnitImpl unitImpl = (UnitImpl)this.myUnits.get(k);
                if (unitImpl.getCabinetId() == cabinetImpl.getId() && unitImpl.doGetSiteId() == cabinetImpl.doGetSiteId()) {
                    cabinetImpl.doAddUnit(unitImpl);
                    this.myUnits.remove(unitImpl);
                }
                --k;
            }
        }
        if (flag) {
            if (intCounter > 1) {
                this.myLogger.trace((Object)("Warning: nodes " + strErrMessage + "in Cabinet with id number - " + cabinetImpl.getId() + ", don't have any values"));
            } else {
                this.myLogger.trace((Object)("Warning: node " + strErrMessage + "in Cabinet with id number - " + cabinetImpl.getId() + ", doesn't have any value"));
            }
        }
        int i = 0;
        while (i < expectedNodes.size()) {
            this.myLogger.trace((Object)("Warning: node " + expectedNodes.elementAt(i) + " is missing in Cabinet with id " + cabinetImpl.getId()));
            ++i;
        }
        cabinetImpl.doSetCustomAttributes(attributes);
        return cabinetImpl;
    }

    private List<Unit> createUnits() {
        NodeList unitsNodeList = this.myDocument.getElementsByTagName("Unit");
        if (unitsNodeList.getLength() != 0) {
            int i = 0;
            while (i < unitsNodeList.getLength()) {
                this.myUnits.add(this.createUnit(unitsNodeList.item(i).getChildNodes()));
                ++i;
            }
        }
        this.myLinks = this.createLinks();
        int j = 0;
        while (j < this.myUnits.size()) {
            UnitImpl unit = (UnitImpl)this.myUnits.get(j);
            int k = 0;
            while (k < this.myLinks.size()) {
                LinkImpl link = (LinkImpl)this.myLinks.get(k);
                if (unit.getId() == link.getUnitId()) {
                    unit.doAddLink(link);
                }
                if (("S1".equals(link.getLinkType()) || "X2".equals(link.getLinkType())) && "CORE_FSM".equals(unit.getUnitType())) {
                    unit.doAddLink(link);
                }
                ++k;
            }
            ++j;
        }
        return this.myUnits;
    }

    private void createCellSubUnitRelations() {
        for (UnitImpl unitImpl : this.getCabinet().getUnits()) {
            for (SubUnitImpl subUnitImpl : unitImpl.getSubUnits()) {
                for (ObjectRelationImpl objectRelationImpl : this.myRelations) {
                    if (objectRelationImpl.getFromType() != 5 || objectRelationImpl.getToType() != 14 || objectRelationImpl.getType() != 2 || objectRelationImpl.getToId() != subUnitImpl.getId()) continue;
                    subUnitImpl.doAddRelationCellId(objectRelationImpl.getFromId());
                }
            }
        }
        for (ObjectRelationImpl objectRelationImpl : this.myRelations) {
            boolean bl;
            if (objectRelationImpl.getFromType() != 5 || objectRelationImpl.getToType() != 14 || objectRelationImpl.getType() != 2) continue;
            boolean bl2 = false;
            int k = 0;
            while (k < this.myCells.size()) {
                CellImpl cellImpl = (CellImpl)this.myCells.get(k);
                if (cellImpl.getCellId() == objectRelationImpl.getFromId()) {
                    bl = true;
                    cellImpl.doAddRelationSubUnitId(objectRelationImpl.getToId());
                }
                ++k;
            }
            if (bl) continue;
            this.myLogger.debug((Object)("Inconsistent information from BTS.CELL-SUBUNIT -relation for unexisting cell " + objectRelationImpl.getFromId() + "  with subunit " + objectRelationImpl.getToId() + " defined."));
            this.myBTSConfigurationManager.addPendingRelationForMissingUnit(objectRelationImpl);
            this.myRelations.remove(objectRelationImpl);
        }
    }

    private void createCellUnitRelations() {
        for (UnitImpl unitImpl : this.getCabinet().getUnits()) {
            for (ObjectRelationImpl objectRelationImpl : this.myRelations) {
                if (objectRelationImpl.getFromType() != 5 || objectRelationImpl.getToType() != 10 || objectRelationImpl.getType() != 2 || objectRelationImpl.getToId() != unitImpl.getId()) continue;
                boolean blnCellExists = false;
                int k = 0;
                while (k < this.myCells.size()) {
                    CellImpl someCell = (CellImpl)this.myCells.get(k);
                    if (someCell.getCellId() == objectRelationImpl.getFromId()) {
                        blnCellExists = true;
                        someCell.doAddRelationUnitId(unitImpl.getId());
                        unitImpl.doAddRelationCellId(someCell.getCellId());
                    }
                    ++k;
                }
                if (blnCellExists) continue;
                this.myLogger.debug((Object)("Inconsistent information from BTS.CELL-UNIT -relation for unexisting cell " + objectRelationImpl.getFromId() + "  with unit " + unitImpl.getId() + " defined."));
                this.myBTSConfigurationManager.addPendingRelationForMissingUnit(objectRelationImpl);
                this.myRelations.remove(objectRelationImpl);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean doesUnitExists(int unitId) {
        this.myLogger.trace((Object)("Searching unit from model." + unitId));
        try {
            for (Unit unit : this.getCabinet().getUnits()) {
                if (unit.getId() != unitId) continue;
                this.myLogger.trace((Object)("Searching unit " + unitId + ", found in model."));
                return true;
            }
        }
        catch (Exception e) {
            this.myLogger.warn((Object)("Searching unit " + unitId + ", intepret as not found, "), (Throwable)e);
            return false;
        }
        this.myLogger.trace((Object)("Searching unit " + unitId + ", not found in model."));
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private void createCellGroupRelations() {
        void var2_7;
        int i = 0;
        while (i < this.myRelations.size()) {
            CellGroupImpl cellGroup;
            ObjectRelationImpl objectRelationImpl = (ObjectRelationImpl)this.myRelations.get(i);
            if (objectRelationImpl.getFromType() == 78) {
                cellGroup = new CellGroupImpl(objectRelationImpl.getFromId());
                cellGroup.doSetId(objectRelationImpl.getFromId());
                if (!this.myCellGroups.contains(cellGroup)) {
                    this.myLogger.trace((Object)("CellGroup " + objectRelationImpl.getFromId() + " adding to cellgroups."));
                    this.myCellGroups.add(cellGroup);
                }
            } else if (objectRelationImpl.getToType() == 78) {
                cellGroup = new CellGroupImpl(objectRelationImpl.getToId());
                cellGroup.doSetId(objectRelationImpl.getToId());
                if (!this.myCellGroups.contains(cellGroup)) {
                    this.myLogger.trace((Object)("CellGroup " + objectRelationImpl.getToId() + " adding to cellgroups."));
                    this.myCellGroups.add(cellGroup);
                }
            }
            ++i;
        }
        for (CellGroupImpl cellGroupImpl : this.myCellGroups) {
            for (ObjectRelationImpl objectRelationImpl : this.myRelations) {
                if (objectRelationImpl.getFromType() == 78 && objectRelationImpl.getFromId() == cellGroupImpl.getCellGroupId()) {
                    if (objectRelationImpl.getToType() == 10) {
                        if (this.doesUnitExists(objectRelationImpl.getToId())) {
                            cellGroupImpl.doAddUnit(objectRelationImpl.getToId());
                        } else {
                            this.myBTSConfigurationManager.addPendingRelationForMissingUnit(objectRelationImpl);
                            this.myRelations.remove(objectRelationImpl);
                        }
                    } else if (objectRelationImpl.getToType() == 5) {
                        for (Cell cell : this.myCells) {
                            if (cell.getCellId() != objectRelationImpl.getToId()) continue;
                            cellGroupImpl.doAddCell(objectRelationImpl.getToId());
                        }
                    } else {
                        this.myLogger.debug((Object)("Warning: Unsupported toType (" + objectRelationImpl.getToType() + ") in CellGroup relation."));
                    }
                }
                if (objectRelationImpl.getToType() != 78 || objectRelationImpl.getToId() != cellGroupImpl.getCellGroupId()) continue;
                if (objectRelationImpl.getFromType() == 10) {
                    if (this.doesUnitExists(objectRelationImpl.getFromId())) {
                        cellGroupImpl.doAddUnit(objectRelationImpl.getFromId());
                        continue;
                    }
                    this.myBTSConfigurationManager.addPendingRelationForMissingUnit(objectRelationImpl);
                    continue;
                }
                if (objectRelationImpl.getFromType() == 5) {
                    for (Cell cell : this.myCells) {
                        if (cell.getCellId() != objectRelationImpl.getFromId()) continue;
                        cellGroupImpl.doAddCell(objectRelationImpl.getFromId());
                    }
                    continue;
                }
                this.myLogger.debug((Object)("Warning: Unsupported toType (" + objectRelationImpl.getFromType() + ") in CellGroup relation."));
            }
        }
        boolean bl = false;
        while (var2_7 < this.myCells.size()) {
            CellImpl someCell = (CellImpl)this.myCells.get((int)var2_7);
            for (CellGroup cellGroup : this.myCellGroups) {
                Set<Integer> cellsInCellGroup = cellGroup.getCellIds();
                if (!cellsInCellGroup.contains(someCell.getCellId())) continue;
                someCell.doSetCellGroupRelation(cellGroup);
            }
            ++var2_7;
        }
    }

    private void createUnitUnitRelations() {
        Object var1_1 = null;
        for (UnitImpl unitImpl : this.getCabinet().getUnits()) {
            int otherId;
            Object var3_6 = null;
            for (ObjectRelationImpl objectRelationImpl : this.myRelations) {
                if (objectRelationImpl.getFromType() != 10 || objectRelationImpl.getToType() != 10 || objectRelationImpl.getFromId() != unitImpl.getId() && objectRelationImpl.getToId() != unitImpl.getId() || objectRelationImpl.getType() != 9) continue;
                if (objectRelationImpl.getFromId() == unitImpl.getId()) {
                    otherId = objectRelationImpl.getToId();
                    if (this.doesUnitExists(otherId)) {
                        unitImpl.doAddContainedRelationUnitId(otherId);
                        continue;
                    }
                    this.myBTSConfigurationManager.addPendingRelationForMissingUnit(objectRelationImpl);
                    this.myRelations.remove(objectRelationImpl);
                    continue;
                }
                otherId = objectRelationImpl.getFromId();
                if (this.doesUnitExists(otherId)) {
                    unitImpl.doSetParentUnitId(otherId);
                    continue;
                }
                this.myBTSConfigurationManager.addPendingRelationForMissingUnit(objectRelationImpl);
                this.myRelations.remove(objectRelationImpl);
            }
            for (ObjectRelationImpl objectRelationImpl : this.myRelations) {
                if (objectRelationImpl.getFromType() != 10 || objectRelationImpl.getToType() != 10 || objectRelationImpl.getFromId() != unitImpl.getId() && objectRelationImpl.getToId() != unitImpl.getId() || objectRelationImpl.getType() == 9) continue;
                if (objectRelationImpl.getToId() == unitImpl.getId()) {
                    otherId = objectRelationImpl.getFromId();
                    if (this.doesUnitExists(otherId)) {
                        unitImpl.doAddRelationUnitId(otherId);
                        continue;
                    }
                    this.myBTSConfigurationManager.addPendingRelationForMissingUnit(objectRelationImpl);
                    this.myRelations.remove(objectRelationImpl);
                    continue;
                }
                otherId = objectRelationImpl.getToId();
                if (this.doesUnitExists(otherId)) {
                    unitImpl.doAddRelationUnitId(otherId);
                    continue;
                }
                this.myBTSConfigurationManager.addPendingRelationForMissingUnit(objectRelationImpl);
                this.myRelations.remove(objectRelationImpl);
            }
            for (CellGroup cellGroup : this.myCellGroups) {
                Set<Integer> cellGroupUnits = cellGroup.getUnitIds();
                if (!cellGroupUnits.contains(unitImpl.getId())) continue;
                unitImpl.doAddCellGroupRelation(cellGroup);
            }
        }
    }

    protected ObjectRelationImpl createObjectRelation(NodeList nodeList) {
        boolean flag = false;
        String strErrMessage = "";
        int intCounter = 0;
        ObjectRelationImpl relImpl = new ObjectRelationImpl(this.myBTSConfigurationManager);
        relImpl.doSetRatType(this.myBTSConfigurationManager.getRatType());
        Hashtable<String, String> attributes = new Hashtable<String, String>(10);
        Vector<String> expectedNodes = new Vector<String>(10);
        expectedNodes.addElement("_id");
        expectedNodes.addElement("_from");
        expectedNodes.addElement("_to");
        expectedNodes.addElement("_relationType");
        expectedNodes.addElement("_fromType");
        expectedNodes.addElement("_toType");
        int j = 0;
        while (j < nodeList.getLength()) {
            Node node = nodeList.item(j);
            String nodeName = node.getNodeName();
            String nodeValue = null;
            expectedNodes.removeElement(nodeName);
            if (node.hasChildNodes()) {
                nodeValue = node.getFirstChild().getNodeValue();
            }
            if (nodeName.equals("_id")) {
                if (nodeValue != null) {
                    relImpl.doSetId(Integer.parseInt(nodeValue));
                }
            } else if (nodeName.equals("_from")) {
                if (nodeValue != null) {
                    relImpl.setFromId(Integer.parseInt(nodeValue));
                }
            } else if (nodeName.equals("_to")) {
                if (nodeValue != null) {
                    relImpl.setToId(Integer.parseInt(nodeValue));
                }
            } else if (nodeName.equals("_relationType")) {
                if (nodeValue != null) {
                    relImpl.setType(Integer.parseInt(nodeValue));
                }
            } else if (nodeName.equals("_fromType")) {
                if (nodeValue != null) {
                    if (nodeValue.trim().equalsIgnoreCase("Cell")) {
                        relImpl.setFromType(5);
                    } else if (nodeValue.trim().equalsIgnoreCase("Unit")) {
                        relImpl.setFromType(10);
                    } else if (nodeValue.trim().equalsIgnoreCase("Subunit")) {
                        relImpl.setFromType(14);
                    } else if ("Site".equalsIgnoreCase(nodeValue.trim())) {
                        relImpl.setFromType(3);
                    } else if (nodeValue.trim().equalsIgnoreCase("CellGroup")) {
                        relImpl.setFromType(78);
                    } else {
                        try {
                            relImpl.setFromType(Integer.parseInt(nodeValue));
                        }
                        catch (NumberFormatException nfe) {
                            this.myLogger.debug((Object)("Warning: node " + nodeName + " in ObjectRelation id " + relImpl.getId() + " has unrecognized value " + nodeValue));
                            relImpl.setFromType(-1);
                        }
                    }
                }
            } else if (nodeName.equals("_toType")) {
                if (nodeValue != null) {
                    if (nodeValue.trim().equalsIgnoreCase("Cell")) {
                        relImpl.setToType(5);
                    } else if (nodeValue.trim().equalsIgnoreCase("Unit")) {
                        relImpl.setToType(10);
                    } else if (nodeValue.trim().equalsIgnoreCase("Subunit")) {
                        relImpl.setToType(14);
                    } else if ("Site".equalsIgnoreCase(nodeValue.trim())) {
                        relImpl.setToType(3);
                    } else if (nodeValue.trim().equalsIgnoreCase("CellGroup")) {
                        relImpl.setToType(78);
                    } else {
                        try {
                            relImpl.setToType(Integer.parseInt(nodeValue));
                        }
                        catch (NumberFormatException nfe) {
                            this.myLogger.debug((Object)("Warning: node " + nodeName + " in ObjectRelation id " + relImpl.getId() + " has unrecognized value " + nodeValue));
                            relImpl.setToType(-1);
                        }
                    }
                }
            } else if (!"#text".equals(nodeName) && !"#comment".equals(node.getNodeName())) {
                if (nodeValue != null) {
                    attributes.put(nodeName, nodeValue);
                } else {
                    attributes.put(nodeName, "Coreasset_Unknown");
                    flag = true;
                    strErrMessage = String.valueOf(strErrMessage) + nodeName + ", ";
                    ++intCounter;
                }
            }
            ++j;
        }
        if (flag) {
            if (intCounter > 1) {
                this.myLogger.debug((Object)("Warning: nodes " + strErrMessage + "in ObjectRelation with id " + relImpl.getId() + " don't have any values."));
            } else {
                this.myLogger.debug((Object)("Warning: node " + strErrMessage + "in ObjectRelation with id " + relImpl.getId() + " doesn't have any value."));
            }
        }
        int i = 0;
        while (i < expectedNodes.size()) {
            this.myLogger.trace((Object)("Warning: node " + expectedNodes.elementAt(i) + " is missing in ObjectRelation with id " + relImpl.getId() + "."));
            ++i;
        }
        relImpl.doSetCustomAttributes(attributes);
        return relImpl;
    }
}

