/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.configuration;

import com.nokia.em.bts.coreasset.CoreAsset;
import com.nokia.em.bts.coreasset.configuration.BTSConfigObject;
import com.nokia.em.bts.coreasset.configuration.BTSConfigurationManager;
import com.nokia.em.bts.coreasset.configuration.EACControlListener;
import com.nokia.em.bts.coreasset.configuration.EACInput;
import com.nokia.em.bts.coreasset.configuration.EACObjectImpl;
import com.nokia.em.bts.coreasset.message.EACInputEnableChangeReply;
import com.nokia.em.bts.coreasset.message.EACInputEnableChangeRequest;
import com.nokia.em.bts.rp.master.message.BTSMessage;
import com.nokia.em.bts.rp.master.tool.CoreAssetThread;
import java.util.concurrent.ExecutionException;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class EACInputImpl
extends EACObjectImpl
implements EACInput {
    protected static final String NODENAME = "EACInput";
    protected static final String ENABLED_NODENAME = "_enabled";
    protected static final String ENABLED_ENABLED_NODEVALUE = "enabled";
    protected static final String ENABLED_DISABLED_NODEVALUE = "disabled";
    protected static final String FAULT_SEVERITY_NODENAME = "_alarmSeverity";
    protected static final String FAULT_SEVERITY_DEGRAGED_NODEVALUE = "degraded";
    protected static final String FAULT_SEVERITY_OUT_OF_ORDER_NODEVALUE = "outOfOrder";
    protected static final String FAULT_SEVERITY_INFO_NODEVALUE = "info";
    protected static final String FAULT_SEVERITY_TEST_NODEVALUE = "test";
    protected static final String FAULT_SEVERITY_DEBUG_NODEVALUE = "debug";
    protected static final String FAULT_SEVERITY_WORKING_NODEVALUE = "working";
    protected static final String INPUT_CURRENT_STATE_NODENAME = "_inputCurrentState";
    protected static final String INPUT_CURRENT_STATE_ON_NODEVALUE = "on";
    protected static final String INPUT_CURRENT_STATE_OFF_NODEVALUE = "off";
    protected static final String INPUT_NAME_NODENAME = "_inputName";
    protected static final String POLARITY_NODENAME = "_polarity";
    protected static final String POLARITY_ON_OK_NODEVALUE = "on_ok";
    protected static final String POLARITY_OFF_OK_NODEVALUE = "off_ok";
    protected static final String FAULT_ID_NODENAME = "_alarmId";
    protected static final String INPUT_LINE_ID_NODENAME = "_alarmId";
    private int myEnabledState;
    private int myFaultSeverity;
    private int myFaultId;
    private int myPolarity;
    private Logger myLogger = Logger.getLogger(this.getClass());

    public EACInputImpl(BTSConfigurationManager btsConfMgr) {
        this(btsConfMgr, -1, -1, -1, "Coreasset_Unknown", -1, -1, -1, -1);
    }

    public EACInputImpl(BTSConfigurationManager btsConfMgr, int intId, int intState, int intPolarity, String strName, int intFaultId, int intFaultSeverity, int unitId, int lineId) {
        super(btsConfMgr, intId, 11, intState, strName, unitId, lineId);
        this.myPolarity = intPolarity;
        this.myFaultId = intFaultId;
        this.myFaultSeverity = intFaultSeverity;
    }

    @Override
    protected final Node getRoot(Document doc) {
        Element root = doc.createElement(NODENAME);
        root.appendChild(this.createElement(doc, "_id", this.getId()));
        root.appendChild(this.createElement(doc, ENABLED_NODENAME, EACInputImpl.nodeValueOf(this.getEnabledState())));
        root.appendChild(this.createElement(doc, FAULT_SEVERITY_NODENAME, EACInputImpl.nodeValueOf(this.getFaultSeverity())));
        root.appendChild(this.createElement(doc, INPUT_CURRENT_STATE_NODENAME, EACInputImpl.nodeValueOf(this.getState())));
        root.appendChild(this.createElement(doc, "_alarmId", this.getLineId()));
        root.appendChild(this.createElement(doc, "_unitId", this.getUnitId()));
        Element inputNameElement = doc.createElement(INPUT_NAME_NODENAME);
        if (this.getName() != null) {
            inputNameElement.appendChild(doc.createTextNode(this.getName()));
        }
        root.appendChild(inputNameElement);
        root.appendChild(this.createElement(doc, POLARITY_NODENAME, EACInputImpl.nodeValueOf(this.getPolarity())));
        return root;
    }

    protected final void setEnabledState(int intEnabledState) {
        this.myEnabledState = intEnabledState;
    }

    protected final void setFaultId(int intFaultId) {
        this.myFaultId = intFaultId;
    }

    protected final void setFaultSeverity(int faultSeverity) {
        this.myFaultSeverity = faultSeverity;
    }

    protected final void setPolarity(int intPolarity) {
        this.myPolarity = intPolarity;
    }

    @Override
    protected final void update(BTSConfigObject btsConfigObject) {
        if (btsConfigObject instanceof EACInputImpl && btsConfigObject != null) {
            try {
                EACInputImpl newEACInput = (EACInputImpl)btsConfigObject;
                this.setEnabledState(newEACInput.getEnabledState());
                this.setFaultSeverity(newEACInput.getFaultSeverity());
                this.setName(newEACInput.getName());
                this.setPolarity(newEACInput.getPolarity());
                this.setState(newEACInput.getState());
                this.setLineId(newEACInput.getLineId());
                this.doSetCustomAttributes(newEACInput.getCustomAttributes());
            }
            catch (Exception e) {
                this.myLogger.error((Object)e.toString());
            }
        } else {
            this.myLogger.error((Object)("Unable to update EACInput using " + btsConfigObject));
        }
    }

    protected static final String nodeValueOf(int intValue) {
        switch (intValue) {
            case 27: {
                return ENABLED_ENABLED_NODEVALUE;
            }
            case 28: {
                return ENABLED_DISABLED_NODEVALUE;
            }
            case 32: {
                return FAULT_SEVERITY_OUT_OF_ORDER_NODEVALUE;
            }
            case 52: {
                return FAULT_SEVERITY_WORKING_NODEVALUE;
            }
            case 53: {
                return FAULT_SEVERITY_DEGRAGED_NODEVALUE;
            }
            case 30: {
                return FAULT_SEVERITY_INFO_NODEVALUE;
            }
            case 31: {
                return FAULT_SEVERITY_DEBUG_NODEVALUE;
            }
            case 29: {
                return FAULT_SEVERITY_TEST_NODEVALUE;
            }
            case 7: {
                return INPUT_CURRENT_STATE_ON_NODEVALUE;
            }
            case 8: {
                return INPUT_CURRENT_STATE_OFF_NODEVALUE;
            }
            case 26: {
                return POLARITY_OFF_OK_NODEVALUE;
            }
            case 25: {
                return POLARITY_ON_OK_NODEVALUE;
            }
        }
        return "Coreasset_Unknown";
    }

    @Override
    public void changeEnabledState(final EACControlListener listener, final int enabledState) {
        CoreAssetThread worker = new CoreAssetThread(){

            protected Object construct() {
                if (CoreAsset.isSnapshotOpening()) {
                    EACInputImpl.this.myLogger.debug((Object)"Snapshot open not supported.");
                    listener.eacInputEnabledStateChangeRequested(EACInputImpl.this.getId(), enabledState, 85);
                    return true;
                }
                int seqNumber = EACInputImpl.this.myConnection.createScenario();
                int btsMessageEnabledState = enabledState == 27 ? 48 : 49;
                EACInputEnableChangeRequest enableChangeRequest = new EACInputEnableChangeRequest(seqNumber, EACInputImpl.this.getId(), btsMessageEnabledState);
                EACInputImpl.this.myConnection.sendToBTS((BTSMessage)enableChangeRequest);
                BTSMessage response = EACInputImpl.this.myConnection.receiveFromBTS(seqNumber);
                EACInputImpl.this.myConnection.deleteScenario(seqNumber);
                if (response instanceof EACInputEnableChangeReply) {
                    EACInputEnableChangeReply reply = (EACInputEnableChangeReply)response;
                    int retValue = reply.getSuccessCode();
                    if (retValue != 34) {
                        EACInputImpl.this.myConnection.deleteScenario(seqNumber);
                        listener.eacInputEnabledStateChangeRequested(EACInputImpl.this.getId(), enabledState, retValue);
                        return false;
                    }
                    EACInputImpl.this.myConnection.deleteScenario(seqNumber);
                    listener.eacInputEnabledStateChangeRequested(EACInputImpl.this.getId(), enabledState, retValue);
                    return true;
                }
                listener.eacInputEnabledStateChangeRequested(EACInputImpl.this.getId(), enabledState, 28);
                EACInputImpl.this.myConnection.deleteScenario(seqNumber);
                return false;
            }

            protected void finished() {
                try {
                    if (!((Boolean)this.get()).booleanValue()) {
                        EACInputImpl.this.myLogger.debug((Object)"Input EAC enabled state change failed.");
                    }
                }
                catch (ExecutionException ite) {
                    EACInputImpl.this.myLogger.error((Object)("Input EAC enabled state change failed: " + ite.getCause()));
                }
            }
        };
        worker.start();
    }

    @Override
    public final int getEnabledState() {
        return this.myEnabledState;
    }

    @Override
    public final int getPolarity() {
        return this.myPolarity;
    }

    @Override
    public final int getFaultId() {
        return this.myFaultId;
    }

    @Override
    public final int getFaultSeverity() {
        return this.myFaultSeverity;
    }

    public String toString() {
        return "EACInput " + this.getId() + "\nEnabled: " + this.myEnabledState + "\nName: " + this.getName() + "\nPolarity: " + this.myPolarity + "\nSeverity: " + this.myFaultSeverity + "\nUnit Id: " + this.getUnitId() + "\nLineId: " + this.getLineId();
    }
}

