/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.configuration;

import com.nokia.em.bts.coreasset.CoreAsset;
import com.nokia.em.bts.coreasset.configuration.BTSConfigObject;
import com.nokia.em.bts.coreasset.configuration.BTSConfigurationManager;
import com.nokia.em.bts.coreasset.configuration.EACControlListener;
import com.nokia.em.bts.coreasset.configuration.EACObjectImpl;
import com.nokia.em.bts.coreasset.configuration.EACOutput;
import com.nokia.em.bts.coreasset.message.EACOutputStateChangeReply;
import com.nokia.em.bts.coreasset.message.EACOutputStateChangeRequest;
import com.nokia.em.bts.rp.master.message.BTSMessage;
import com.nokia.em.bts.rp.master.tool.CoreAssetThread;
import java.util.concurrent.ExecutionException;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class EACOutputImpl
extends EACObjectImpl
implements EACOutput {
    protected static final String NODENAME = "EACOutput";
    protected static final String OUTPUT_LINE_ID_NODENAME = "_outputId";
    private Logger myLogger = Logger.getLogger(this.getClass());

    public EACOutputImpl(BTSConfigurationManager btsConfMgr) {
        this(btsConfMgr, -1, -1, "Coreasset_Unknown", -1, -1);
    }

    public EACOutputImpl(BTSConfigurationManager btsConfMgr, int intId, int intState, String strName, int unitId, int lineId) {
        super(btsConfMgr, intId, 12, intState, strName, unitId, lineId);
    }

    @Override
    protected final Node getRoot(Document doc) {
        Element root = doc.createElement(NODENAME);
        root.appendChild(this.createElement(doc, "_id", this.getId()));
        root.appendChild(this.createElement(doc, "_outputCurrentState", EACOutputImpl.nodeValueOf(this.getState())));
        root.appendChild(this.createElement(doc, OUTPUT_LINE_ID_NODENAME, this.getLineId()));
        root.appendChild(this.createElement(doc, "_outputName", this.getName()));
        root.appendChild(this.createElement(doc, "_unitId", this.getUnitId()));
        return root;
    }

    protected static final String nodeValueOf(int intValue) {
        switch (intValue) {
            case 7: {
                return "on";
            }
            case 8: {
                return "off";
            }
        }
        return "Coreasset_Unknown";
    }

    @Override
    protected final void update(BTSConfigObject btsConfigObject) {
        if (btsConfigObject instanceof EACOutputImpl && btsConfigObject != null) {
            try {
                EACOutputImpl newEACOutput = (EACOutputImpl)btsConfigObject;
                this.setName(newEACOutput.getName());
                this.setState(newEACOutput.getState());
                this.setLineId(newEACOutput.getLineId());
                this.doSetCustomAttributes(newEACOutput.getCustomAttributes());
            }
            catch (Exception e) {
                this.myLogger.error((Object)e.toString());
            }
        } else {
            this.myLogger.error((Object)("Unable to update EACOutput using " + btsConfigObject));
        }
    }

    @Override
    public void changeState(final EACControlListener listener, final int state) {
        CoreAssetThread worker = new CoreAssetThread(){

            protected Object construct() {
                if (CoreAsset.isSnapshotOpening()) {
                    EACOutputImpl.this.myLogger.debug((Object)"Snapshot open not supported.");
                    listener.eacOutputStateChangeRequested(EACOutputImpl.this.getId(), state, 85);
                    return true;
                }
                int seqNumber = EACOutputImpl.this.myConnection.createScenario();
                int btsMessageState = state == 7 ? 44 : 45;
                EACOutputStateChangeRequest changeRequest = new EACOutputStateChangeRequest(seqNumber, EACOutputImpl.this.getId(), btsMessageState);
                EACOutputImpl.this.myConnection.sendToBTS((BTSMessage)changeRequest);
                BTSMessage response = EACOutputImpl.this.myConnection.receiveFromBTS(seqNumber);
                EACOutputImpl.this.myConnection.deleteScenario(seqNumber);
                if (response instanceof EACOutputStateChangeReply) {
                    EACOutputStateChangeReply reply = (EACOutputStateChangeReply)response;
                    int retValue = reply.getSuccessCode();
                    if (retValue != 34) {
                        listener.eacOutputStateChangeRequested(EACOutputImpl.this.getId(), state, retValue);
                        return false;
                    }
                    listener.eacOutputStateChangeRequested(EACOutputImpl.this.getId(), state, retValue);
                    return true;
                }
                EACOutputImpl.this.myConnection.deleteScenario(seqNumber);
                listener.eacOutputStateChangeRequested(EACOutputImpl.this.getId(), state, 28);
                return false;
            }

            protected void finished() {
                try {
                    if (!((Boolean)this.get()).booleanValue()) {
                        EACOutputImpl.this.myLogger.debug((Object)"Output EAC state change failed.");
                    }
                }
                catch (ExecutionException ite) {
                    EACOutputImpl.this.myLogger.error((Object)("Output EAC state change failed: " + ite.getCause()));
                }
            }
        };
        worker.start();
    }

    public String toString() {
        return "EACOutput " + this.getId() + "\nName: " + this.getName() + "\nState: " + this.getState() + "\nUnit Id: " + this.getUnitId() + "\nLineId: " + this.getLineId();
    }
}

