/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.configuration;

import com.nokia.em.bts.coreasset.configuration.AbstractBTSConfigObject;
import com.nokia.em.bts.coreasset.configuration.BTSConfigObject;
import com.nokia.em.bts.coreasset.configuration.BTSConfigurationManager;
import com.nokia.em.bts.coreasset.configuration.Link;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class LinkImpl
extends AbstractBTSConfigObject
implements Link {
    protected static final String NODENAME = "Link";
    protected static final String UNIT_ID_NODENAME = "_unitId";
    protected static final String LINK_TYPE_NODENAME = "_linkType";
    protected static final String LINK_STATE_NODENAME = "_linkState";
    protected static final String LINK_NAME_NODENAME = "LinkName";
    protected static final String LINK_STATE_TRUE_NODEVALUE = "true";
    protected static final String LINK_STATE_FALSE_NODEVALUE = "false";
    private String myLinkType;
    private int myUnitId;
    private boolean myLinkState;
    private String myLinkName;
    private Logger myLogger = Logger.getLogger(this.getClass());

    public LinkImpl(BTSConfigurationManager btsConfMgr) {
        this(btsConfMgr, -1, -1, "Coreasset_Unknown", false, "Coreasset_Unknown");
    }

    public LinkImpl(BTSConfigurationManager btsConfMgr, int intId, int intUnitId, String strLinkType, boolean blnLinkState, String strLinkName) {
        super(btsConfMgr, intId, 13);
        this.myLinkState = blnLinkState;
        this.myUnitId = intUnitId;
        this.myLinkType = strLinkType;
        this.myLinkName = strLinkName;
    }

    @Override
    protected final Node getRoot(Document doc) {
        Element root = doc.createElement(NODENAME);
        root.appendChild(this.createElement(doc, "_id", this.getId()));
        root.appendChild(this.createElement(doc, UNIT_ID_NODENAME, this.getUnitId()));
        root.appendChild(this.createElement(doc, LINK_TYPE_NODENAME, this.getLinkType()));
        if (this.isLinkConnected()) {
            root.appendChild(this.createElement(doc, LINK_STATE_NODENAME, LINK_STATE_TRUE_NODEVALUE));
        } else {
            root.appendChild(this.createElement(doc, LINK_STATE_NODENAME, LINK_STATE_FALSE_NODEVALUE));
        }
        root.appendChild(this.createElement(doc, LINK_NAME_NODENAME, this.getLinkName()));
        return root;
    }

    @Override
    public final String getLinkType() {
        return this.myLinkType;
    }

    @Override
    public final boolean isLinkConnected() {
        return this.myLinkState;
    }

    @Override
    public final int getUnitId() {
        return this.myUnitId;
    }

    @Override
    public final String getLinkName() {
        return this.myLinkName;
    }

    protected final void setLinkType(String strLinkType) {
        this.myLinkType = strLinkType;
    }

    protected final void setLinkState(boolean blnLinkState) {
        this.myLinkState = blnLinkState;
    }

    protected final void setLinkName(String strLinkName) {
        this.myLinkName = strLinkName;
    }

    @Override
    protected final void update(BTSConfigObject btsConfigObject) {
        if (btsConfigObject instanceof LinkImpl && btsConfigObject != null) {
            try {
                LinkImpl newLink = (LinkImpl)btsConfigObject;
                this.doSetId(newLink.getId());
                this.setLinkState(newLink.isLinkConnected());
                this.setLinkType(newLink.getLinkType());
                this.setUnitId(newLink.getUnitId());
                this.setLinkName(newLink.getLinkName());
                this.doSetCustomAttributes(newLink.getCustomAttributes());
            }
            catch (Exception e) {
                this.myLogger.error((Object)"Exception in link update", (Throwable)e);
            }
        } else {
            this.myLogger.error((Object)("Unable to update Link using " + btsConfigObject));
        }
    }

    protected final void setUnitId(int intUnitId) {
        this.myUnitId = intUnitId;
    }

    @Override
    public Object getEditableCopy() {
        throw new UnsupportedOperationException("Editable links are not supported");
    }
}

