/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.configuration;

import com.nokia.em.bts.coreasset.CoreAsset;
import com.nokia.em.bts.coreasset.configuration.AbstractBTSConfigObject;
import com.nokia.em.bts.coreasset.configuration.BTSConfigObject;
import com.nokia.em.bts.coreasset.configuration.BTSConfigurationManager;
import com.nokia.em.bts.coreasset.configuration.Cabinet;
import com.nokia.em.bts.coreasset.configuration.CabinetImpl;
import com.nokia.em.bts.coreasset.configuration.Cell;
import com.nokia.em.bts.coreasset.configuration.CellComparator;
import com.nokia.em.bts.coreasset.configuration.CellGroup;
import com.nokia.em.bts.coreasset.configuration.CellGroupImpl;
import com.nokia.em.bts.coreasset.configuration.CellImpl;
import com.nokia.em.bts.coreasset.configuration.ChangeStateListener;
import com.nokia.em.bts.coreasset.configuration.EACComparator;
import com.nokia.em.bts.coreasset.configuration.EACInput;
import com.nokia.em.bts.coreasset.configuration.EACInputImpl;
import com.nokia.em.bts.coreasset.configuration.EACObject;
import com.nokia.em.bts.coreasset.configuration.EACOutput;
import com.nokia.em.bts.coreasset.configuration.EACOutputImpl;
import com.nokia.em.bts.coreasset.configuration.Site;
import com.nokia.em.bts.coreasset.configuration.SubUnit;
import com.nokia.em.bts.coreasset.configuration.SubUnitComparator;
import com.nokia.em.bts.coreasset.configuration.Unit;
import com.nokia.em.bts.coreasset.configuration.UnitImpl;
import com.nokia.em.bts.coreasset.message.BlockOperationsCompleted;
import com.nokia.em.bts.coreasset.message.ChangeObjectBlockingStateRequest;
import com.nokia.em.bts.rp.master.message.Ack;
import com.nokia.em.bts.rp.master.message.BTSMessage;
import com.nokia.em.bts.rp.master.message.Timeout;
import com.nokia.em.bts.rp.master.time.TimeZoneChangeListener;
import com.nokia.em.bts.rp.master.tool.CoreAssetThread;
import com.nokia.em.poseidon.util.GeneralUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TimeZone;
import java.util.Vector;
import java.util.concurrent.ExecutionException;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SiteImpl
extends AbstractBTSConfigObject
implements Site {
    private volatile int myMaxObjectId = 0;
    protected static final String NODENAME = "BS";
    protected static final String OPERATIONAL_STATE_NODENAME = "_operationalStatus";
    protected static final String OPERATIONAL_STATE_INITIALIZING_NODEVALUE = "initializing";
    protected static final String OPERATIONAL_STATE_NOT_COMMISSIONED_NODEVALUE = "NotCommissioned";
    protected static final String OPERATIONAL_STATE_COMMISSIONED_NODEVALUE = "Commissioned";
    protected static final String OPERATIONAL_STATE_INTEGRATED_TO_RAN_NODEVALUE = "IntegratedToRAN";
    protected static final String OPERATIONAL_STATE_CONFIGURED_NODEVALUE = "Configured";
    protected static final String OPERATIONAL_STATE_TEST_DEDICATED_NODEVALUE = "TestDedicated";
    protected static final String OPERATIONAL_STATE_ON_AIR_NODEVALUE = "OnAir";
    protected static final String OPERATIONAL_STATE_UNCOMMISSIONED_NODEVALUE = "Uncommissioned";
    protected static final String OPERATIONAL_STATE_INTEGRATED_NODEVALUE = "Integrated";
    protected static final String OPERATIONAL_STATE_OPERATIONAL_NODEVALUE = "Operational";
    protected static final String ACTIVE_CLOCK_UNIT_NODENAME = "_activeClockUnit";
    protected static final String AUTHENTICATION_SERVER_NODENAME = "_authenticationServer";
    protected static final String BLOCKING_STATE_NODENAME = "_blockingState";
    protected static final String BLOCKING_STATE_BLOCKED_NODEVALUE = "blocked";
    protected static final String BLOCKING_STATE_UNBLOCKED_NODEVALUE = "unblocked";
    protected static final String BLOCKING_STATE_DEFERRED_BLOCK_NODEVALUE = "deferredBlock";
    protected static final String ADDRESS_NODENAME = "_bsAddress";
    protected static final String DOOR_SWITCH_IN_USE_NODENAME = "_doorSwitchInUse";
    protected static final String DOOR_SWITCH_IN_USE_TRUE_NODEVALUE = "1";
    protected static final String DOOR_SWITCH_IN_USE_FALSE_NODEVALUE = "0";
    protected static final String HOST_ADDRESS_NODENAME = "_hostAddress";
    protected static final String HOST_ID_NODENAME = "_hostId";
    protected static final String MAINS_POWER_ALARM_ID_NODENAME = "_mainsPowerAlarmId";
    protected static final String NETWORK_TYPE_NODENAME = "_networkType";
    protected static final String NTP_ADDRESS_NODENAME = "_NTPAddress";
    protected static final String NUMBER_OF_LINES_NODENAME = "_numberOfLines";
    protected static final String OM_MASTER_NODENAME = "_OMMaster";
    protected static final String BTS_TYPE = "btsType";
    protected static final String NAME_NODENAME = "_siteName";
    protected static final String TIMEZONE_NODENAME = "_timeZone";
    protected static final String TIMEZONE_LOCATION_NODENAME = "_timeZoneLocation";
    protected static final String MIBBU_TYPE_NODENAME = "_mibbuType";
    protected static final String MIBBU_TYPE_NOT_EQUIPPED_NODEVALUE = "NotEquipped";
    protected static final String MIBBU_TYPE_MIBBU_56_AH_NODEVALUE = "56Ah";
    protected static final String MIBBU_TYPE_MIBBU_90_AH_NODEVALUE = "90Ah";
    protected static final String TCOM_MASTER_NODENAME = "_TComMaster";
    protected static final String SW_UPDATE_SOURCE_NODENAME = "_swUpdateSource";
    protected static final String SW_UPDATE_SOURCE_NETACT_NODEVALUE = "netAct";
    protected static final String SW_UPDATE_SOURCE_NONE_NODEVALUE = "none";
    protected static final String SW_UPDATE_SOURCE_INTERNAL_NODEVALUE = "internal";
    protected static final String SW_UPDATE_SOURCE_BTSMGR_NODEVALUE = "btsMgr";
    protected static final String SW_UPDATE_SOURCE_SW_UPDATE_FAILED_NODEVALUE = "swUpdateFailed";
    protected static final String SMOKE_ALARM_IN_USE_NODENAME = "_smokeAlarmInUse";
    protected static final String SMOKE_ALARM_IN_USE_TRUE_NODEVALUE = "1";
    protected static final String SMOKE_ALARM_IN_USE_FALSE_NODEVALUE = "0";
    private String myName;
    private String myHostAddress;
    private String myNetworkType;
    private String myAddress;
    private Cabinet myCabinet;
    private final List<Unit> myUnitsOutsideCabinets;
    private List<Integer> mySiteCellRelationIds;
    private List myEACs;
    private final Vector myEACStateListeners;
    private int myOperationalState;
    private int myTComMaster;
    private int myActiveClockUnit;
    private int myOMMaster;
    private int myHostId;
    private String myBtsType;
    private final EACComparator myEACComparator;
    private final List<Cell> myCells;
    private final CellComparator myCellComparator;
    private final SubUnitComparator mySubUnitComparator;
    private int myBlockingState;
    private int mySwUpdateSource;
    private String myAuthenticationServer;
    private int myDoorSwitchInUse;
    private int mySmokeAlarmInUse;
    private int myMainsPowerAlarmId;
    private String myNTPAddress;
    private int myNumberOfLines;
    private float myTimeZoneOffset;
    private TimeZone myTimeZone;
    private int myMibbuType;
    private Set<CellGroup> myCellGroups;
    private final Logger myLogger = Logger.getLogger(this.getClass());

    public SiteImpl(BTSConfigurationManager btsConfMgr) {
        this(btsConfMgr, -1, "Coreasset_Unknown", "Coreasset_Unknown", -1, "Coreasset_Unknown", "Coreasset_Unknown", -1, -1, -1, -1, -1, "Coreasset_Unknown", -1, -1, -1, "Coreasset_Unknown", -1, -999.0f, null, -1, -1);
    }

    public SiteImpl(BTSConfigurationManager btsConfMgr, int intId, String strAddress, String strHostAddress, int intHostId, String strNetworkType, String strSiteName, int intOperationalState, int intBlockingState, int intActiveClockUnit, int intOMMaster, int intTComMaster, String strAuthenticationServer, int doorSwitchInUse, int smokeAlarmInUse, int intMainsPowerAlarmId, String strNTPAddress, int intNumberOfLines, float fTimeZoneOffset, TimeZone timeZone, int intMibbuType, int swUpdateSource) {
        super(btsConfMgr, intId, 3);
        this.myAddress = strAddress;
        this.myHostAddress = strHostAddress;
        this.myHostId = intHostId;
        this.myNetworkType = strNetworkType;
        this.myName = strSiteName;
        this.myOperationalState = intOperationalState;
        this.myActiveClockUnit = intActiveClockUnit;
        this.myOMMaster = intOMMaster;
        this.myTComMaster = intTComMaster;
        this.myBlockingState = intBlockingState;
        this.myAuthenticationServer = strAuthenticationServer;
        this.myDoorSwitchInUse = doorSwitchInUse;
        this.mySmokeAlarmInUse = smokeAlarmInUse;
        this.myMainsPowerAlarmId = intMainsPowerAlarmId;
        this.myNTPAddress = strNTPAddress;
        this.myNumberOfLines = intNumberOfLines;
        this.myTimeZoneOffset = fTimeZoneOffset;
        this.myTimeZone = timeZone;
        this.myMibbuType = intMibbuType;
        this.myUnitsOutsideCabinets = new ArrayList<Unit>(20);
        this.mySiteCellRelationIds = new ArrayList<Integer>(20);
        this.myEACs = Collections.synchronizedList(new ArrayList());
        this.myEACStateListeners = new Vector(20);
        this.myCells = new ArrayList<Cell>(20);
        this.myCellComparator = new CellComparator();
        this.myEACComparator = new EACComparator();
        this.mySubUnitComparator = SubUnitComparator.getInstance();
        this.mySwUpdateSource = swUpdateSource;
        this.myCellGroups = new HashSet<CellGroup>(10);
    }

    private SiteImpl(Site s) {
        this(null, s.getId(), s.getAddress(), s.getHostAddress(), s.getHostId(), s.getNetworkType(), s.getName(), s.getOperationalState(), s.getBlockingState(), s.getActiveClockUnit(), s.getOMMaster(), s.getTComMaster(), s.getAuthenticationServer(), s.getDoorSwitchInUse(), s.getSmokeAlarmInUse(), s.getMainsPowerAlarmId(), s.getNTPAddress(), s.getNumberOfLines(), s.getTimeZoneOffset(), s.getTimeZone(), s.getMibbuType(), s.getSwUpdateSource());
        this.setEditable(true);
    }

    public SiteImpl() {
        this((BTSConfigurationManager)null);
        this.setEditable(true);
    }

    @Override
    protected final Node getRoot(Document doc) {
        Element root = doc.createElement(NODENAME);
        root.appendChild(this.createElement(doc, "_id", this.getId()));
        root.appendChild(this.createElement(doc, ACTIVE_CLOCK_UNIT_NODENAME, this.getActiveClockUnit()));
        root.appendChild(this.createElement(doc, AUTHENTICATION_SERVER_NODENAME, this.getAuthenticationServer()));
        root.appendChild(this.createElement(doc, BLOCKING_STATE_NODENAME, SiteImpl.nodeValueOf(this.getBlockingState())));
        root.appendChild(this.createElement(doc, ADDRESS_NODENAME, this.getAddress()));
        root.appendChild(this.createElement(doc, DOOR_SWITCH_IN_USE_NODENAME, this.getDoorSwitchInUse()));
        root.appendChild(this.createElement(doc, SMOKE_ALARM_IN_USE_NODENAME, this.getSmokeAlarmInUse()));
        root.appendChild(this.createElement(doc, HOST_ADDRESS_NODENAME, this.getHostAddress()));
        root.appendChild(this.createElement(doc, HOST_ID_NODENAME, this.getHostId()));
        root.appendChild(this.createElement(doc, MAINS_POWER_ALARM_ID_NODENAME, this.getMainsPowerAlarmId()));
        root.appendChild(this.createElement(doc, NETWORK_TYPE_NODENAME, this.getNetworkType()));
        root.appendChild(this.createElement(doc, NTP_ADDRESS_NODENAME, this.getNTPAddress()));
        root.appendChild(this.createElement(doc, NUMBER_OF_LINES_NODENAME, this.getNumberOfLines()));
        root.appendChild(this.createElement(doc, OM_MASTER_NODENAME, this.getOMMaster()));
        root.appendChild(this.createElement(doc, TCOM_MASTER_NODENAME, this.getTComMaster()));
        root.appendChild(this.createElement(doc, OPERATIONAL_STATE_NODENAME, SiteImpl.nodeValueOf(this.getOperationalState())));
        root.appendChild(this.createElement(doc, MIBBU_TYPE_NODENAME, SiteImpl.nodeValueOf(this.getMibbuType())));
        root.appendChild(this.createElement(doc, NAME_NODENAME, this.getName()));
        Element timeZoneOffset = doc.createElement(TIMEZONE_NODENAME);
        if (!GeneralUtils.isEqual((double)this.getTimeZoneOffset(), (double)-999.0)) {
            timeZoneOffset.appendChild(doc.createTextNode(Float.toString(this.getTimeZoneOffset())));
        }
        root.appendChild(timeZoneOffset);
        Element timeZone = doc.createElement(TIMEZONE_LOCATION_NODENAME);
        if (this.getTimeZone() != null) {
            timeZone.appendChild(doc.createTextNode(this.getTimeZone().getID()));
        }
        root.appendChild(timeZone);
        root.appendChild(this.createElement(doc, SW_UPDATE_SOURCE_NODENAME, SiteImpl.nodeValueOf(this.getSwUpdateSource())));
        root.appendChild(this.createElement(doc, BTS_TYPE, this.getBtsType()));
        return root;
    }

    protected static final String nodeValueOf(int intValue) {
        String value = "Coreasset_Unknown";
        switch (intValue) {
            case 55: {
                value = BLOCKING_STATE_BLOCKED_NODEVALUE;
                break;
            }
            case 57: {
                value = BLOCKING_STATE_UNBLOCKED_NODEVALUE;
                break;
            }
            case 62: {
                value = BLOCKING_STATE_DEFERRED_BLOCK_NODEVALUE;
                break;
            }
            case 41: {
                value = OPERATIONAL_STATE_ON_AIR_NODEVALUE;
                break;
            }
            case 40: {
                value = OPERATIONAL_STATE_INTEGRATED_TO_RAN_NODEVALUE;
                break;
            }
            case 38: {
                value = OPERATIONAL_STATE_COMMISSIONED_NODEVALUE;
                break;
            }
            case 42: {
                value = OPERATIONAL_STATE_TEST_DEDICATED_NODEVALUE;
                break;
            }
            case 36: {
                value = OPERATIONAL_STATE_INITIALIZING_NODEVALUE;
                break;
            }
            case 37: {
                value = OPERATIONAL_STATE_NOT_COMMISSIONED_NODEVALUE;
                break;
            }
            case 39: {
                value = OPERATIONAL_STATE_CONFIGURED_NODEVALUE;
                break;
            }
            case 59: {
                value = MIBBU_TYPE_MIBBU_56_AH_NODEVALUE;
                break;
            }
            case 60: {
                value = MIBBU_TYPE_MIBBU_90_AH_NODEVALUE;
                break;
            }
            case 61: {
                value = MIBBU_TYPE_NOT_EQUIPPED_NODEVALUE;
                break;
            }
            case 65: {
                value = OPERATIONAL_STATE_INTEGRATED_NODEVALUE;
                break;
            }
            case 66: {
                value = OPERATIONAL_STATE_OPERATIONAL_NODEVALUE;
                break;
            }
            case 72: {
                value = SW_UPDATE_SOURCE_NONE_NODEVALUE;
                break;
            }
            case 73: {
                value = SW_UPDATE_SOURCE_INTERNAL_NODEVALUE;
                break;
            }
            case 74: {
                value = SW_UPDATE_SOURCE_BTSMGR_NODEVALUE;
                break;
            }
            case 75: {
                value = SW_UPDATE_SOURCE_NETACT_NODEVALUE;
                break;
            }
            case 76: {
                value = SW_UPDATE_SOURCE_SW_UPDATE_FAILED_NODEVALUE;
            }
        }
        return value;
    }

    protected final void doSetCellGroups(Set<CellGroup> cellGroupRelations) {
        for (CellGroup cellGroup : cellGroupRelations) {
            this.doAddCellGroup(cellGroup);
        }
    }

    protected final void doSetBlockingState(int intBlockingState) {
        this.myBlockingState = intBlockingState;
    }

    protected void doSetCells(List<Cell> setCells) {
        for (Cell cell : setCells) {
            this.doAddCell(cell);
        }
    }

    protected final void doSetAuthenticationServer(String strAuthenticationServer) {
        this.myAuthenticationServer = strAuthenticationServer;
    }

    protected final void doSetDoorSwitchInUse(int strDoorSwitchInUse) {
        this.myDoorSwitchInUse = strDoorSwitchInUse;
    }

    protected final void doSetSmokeAlarmInUse(int strSmokeAlarmInUse) {
        this.mySmokeAlarmInUse = strSmokeAlarmInUse;
    }

    protected final void doSetMainsPowerAlarmId(int intMainsPowerAlarmId) {
        this.myMainsPowerAlarmId = intMainsPowerAlarmId;
    }

    protected final void doSetNTPAddress(String strNTPAddress) {
        this.myNTPAddress = strNTPAddress;
    }

    protected final void doSetNumberOfLines(int intNumberOfLines) {
        this.myNumberOfLines = intNumberOfLines;
    }

    protected final void doSetTimeZoneOffset(float fTimeZoneOffset) {
        this.myTimeZoneOffset = fTimeZoneOffset;
    }

    protected final void doSetTimeZone(TimeZone timeZone) {
        this.myTimeZone = timeZone;
        TimeZoneChangeListener listener = this.myBTSConfigurationManager.getTimeListener();
        if (listener != null) {
            listener.timeZoneResolved(timeZone);
        }
    }

    protected final void doSetMibbuType(int intMibbuType) {
        this.myMibbuType = intMibbuType;
    }

    protected final void doSetSwUpdateSource(int swUpdateSource) {
        this.mySwUpdateSource = swUpdateSource;
    }

    private void checkAndBlockWhileHWModelBuild() {
        this.myLogger.debug((Object)"checkblock start.");
        while (!this.myBTSConfigurationManager.isHWModelReady()) {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                this.myLogger.debug((Object)"rebuild model, sleep", (Throwable)e);
            }
        }
        this.myLogger.debug((Object)"checkblock released.");
    }

    @Override
    public int getSwUpdateSource() {
        return this.mySwUpdateSource;
    }

    @Override
    public List<SubUnit> getSubUnits() {
        ArrayList<SubUnit> subUnits = new ArrayList<SubUnit>();
        Iterator<Unit> iter = this.myCabinet.getUnits().iterator();
        while (iter.hasNext()) {
            subUnits.addAll(((UnitImpl)iter.next()).getSubUnits());
        }
        Collections.sort(subUnits, this.mySubUnitComparator);
        return subUnits;
    }

    @Override
    public SubUnit getSubUnit(int id) {
        Iterator<Unit> iter = this.getCabinet().getUnits().iterator();
        while (iter.hasNext()) {
            for (SubUnit subunit : iter.next().getSubUnits()) {
                if (subunit.getId() != id) continue;
                return subunit;
            }
        }
        return null;
    }

    protected final void doSetOperationalState(int intOperationalState) {
        this.myOperationalState = intOperationalState;
    }

    @Override
    protected final void update(BTSConfigObject btsConfigObject) {
        if (btsConfigObject instanceof SiteImpl && btsConfigObject != null) {
            try {
                SiteImpl newSite = (SiteImpl)btsConfigObject;
                this.doSetId(newSite.getId());
                this.doSetName(newSite.getName());
                this.doSetActiveClockUnit(newSite.getActiveClockUnit());
                this.doSetBlockingState(newSite.getBlockingState());
                this.doSetAddress(newSite.getAddress());
                this.doSetOperationalState(newSite.getOperationalState());
                this.doSetHostAddress(newSite.getHostAddress());
                this.doSetHostId(newSite.getHostId());
                this.doSetNetworkType(newSite.getNetworkType());
                this.doSetOMMaster(newSite.getOMMaster());
                this.doSetTComMaster(newSite.getTComMaster());
                this.doSetAuthenticationServer(newSite.getAuthenticationServer());
                this.doSetDoorSwitchInUse(newSite.getDoorSwitchInUse());
                this.doSetSmokeAlarmInUse(newSite.getSmokeAlarmInUse());
                this.doSetMainsPowerAlarmId(newSite.getMainsPowerAlarmId());
                this.doSetNTPAddress(newSite.getNTPAddress());
                this.doSetNumberOfLines(newSite.getNumberOfLines());
                this.doSetTimeZoneOffset(newSite.getTimeZoneOffset());
                this.myTimeZone = newSite.getTimeZone();
                this.doSetMibbuType(newSite.getMibbuType());
                this.doSetSwUpdateSource(newSite.getSwUpdateSource());
                this.doSetCustomAttributes(newSite.getCustomAttributes());
                this.doSetBtsType(newSite.getBtsType());
            }
            catch (Exception e) {
                this.myLogger.error((Object)e.toString());
            }
        } else {
            this.myLogger.error((Object)("Unable to update Site using " + btsConfigObject));
        }
    }

    @Override
    public EACInput getInputEAC(int intId) {
        int i = 0;
        while (i < this.myEACs.size()) {
            EACInputImpl eacInput;
            if (this.myEACs.get(i) instanceof EACInput && (eacInput = (EACInputImpl)this.myEACs.get(i)).getId() == intId) {
                return eacInput;
            }
            ++i;
        }
        return null;
    }

    @Override
    public EACInput getInputEAC(int intId, int unitId) {
        int i = 0;
        while (i < this.myEACs.size()) {
            EACInputImpl eacInput;
            if (this.myEACs.get(i) instanceof EACInput && (eacInput = (EACInputImpl)this.myEACs.get(i)).getId() == intId && eacInput.getUnitId() == unitId) {
                return eacInput;
            }
            ++i;
        }
        return null;
    }

    @Override
    public EACOutput getOutputEAC(int intId) {
        int i = 0;
        while (i < this.myEACs.size()) {
            EACOutputImpl eacOutput;
            if (this.myEACs.get(i) instanceof EACOutput && (eacOutput = (EACOutputImpl)this.myEACs.get(i)).getId() == intId) {
                return eacOutput;
            }
            ++i;
        }
        return null;
    }

    @Override
    public EACOutput getOutputEAC(int intId, int unitId) {
        int i = 0;
        while (i < this.myEACs.size()) {
            EACOutputImpl eacOutput;
            if (this.myEACs.get(i) instanceof EACOutput && (eacOutput = (EACOutputImpl)this.myEACs.get(i)).getId() == intId && eacOutput.getUnitId() == unitId) {
                return eacOutput;
            }
            ++i;
        }
        return null;
    }

    @Override
    public void addOutputEAC(EACOutput eacOutput) {
        if (this.myEACs != null) {
            this.myEACs.add(eacOutput);
        }
    }

    @Override
    public void removeOutputEAC(EACOutput eacOutput) {
        if (this.myEACs != null) {
            this.myEACs.remove(eacOutput);
        }
    }

    @Override
    public void addInputEAC(EACInput eacInput) {
        if (this.myEACs != null) {
            this.myEACs.add(eacInput);
        }
    }

    @Override
    public void removeInputEAC(EACInput eacInput) {
        if (this.myEACs != null) {
            this.myEACs.remove(eacInput);
        }
    }

    protected void doSetEACs(List eacs) {
        this.myEACs = eacs;
    }

    protected Vector doGetEACStateListeners() {
        return this.myEACStateListeners;
    }

    protected final void doSetNetworkType(String strNetworkType) {
        this.myNetworkType = strNetworkType;
    }

    protected final void doSetName(String strSiteName) {
        this.myName = strSiteName;
    }

    protected final void doSetHostAddress(String strHostAddress) {
        this.myHostAddress = strHostAddress;
    }

    protected final void doSetHostId(int intHostId) {
        this.myHostId = intHostId;
    }

    protected final void doSetAddress(String strAddress) {
        this.myAddress = strAddress;
    }

    @Override
    public final String getNetworkType() {
        return this.myNetworkType;
    }

    @Override
    public final String getName() {
        return this.myName;
    }

    @Override
    public final String getHostAddress() {
        return this.myHostAddress;
    }

    @Override
    public final int getHostId() {
        return this.myHostId;
    }

    @Override
    public List<EACObject> getEACs() {
        ArrayList<EACObject> eac = this.myEACs != null ? new ArrayList(this.myEACs) : new ArrayList<EACObject>(0);
        Collections.sort(eac, this.myEACComparator);
        return eac;
    }

    @Override
    public Site getEditableCopy() {
        if (this.isEditable()) {
            throw new UnsupportedOperationException("This site is already editable");
        }
        return new SiteImpl(this);
    }

    @Override
    public Set<CellGroup> getCellGroups() {
        return this.myCellGroups;
    }

    @Override
    @Deprecated
    public List<Cabinet> getCabinets() {
        ArrayList<Cabinet> cabinets = new ArrayList<Cabinet>();
        cabinets.add(this.myCabinet);
        return cabinets;
    }

    @Override
    @Deprecated
    public Cabinet getCabinet(int intCabinetId) {
        return this.myCabinet;
    }

    @Override
    public Cabinet getCabinet() {
        return this.myCabinet;
    }

    @Override
    public final String getAddress() {
        return this.myAddress;
    }

    @Override
    public final synchronized int getAvailableId() {
        return ++this.myMaxObjectId;
    }

    @Override
    public final synchronized void upateMaxObjectId(int id) {
        if (id > this.myMaxObjectId) {
            this.myMaxObjectId = id;
        }
    }

    protected BTSConfigObject doGetObject(int id) {
        try {
            List<Unit> units = this.myCabinet.getUnits();
            int o = 0;
            while (o < units.size()) {
                Unit unit = units.get(o);
                if (unit.getId() == id) {
                    return unit;
                }
                List<SubUnit> subunits = unit.getSubUnits();
                int p = 0;
                while (p < subunits.size()) {
                    SubUnit subunit = subunits.get(o);
                    if (subunit.getId() == id) {
                        return subunit;
                    }
                    ++p;
                }
                ++o;
            }
        }
        catch (Exception e) {
            this.myLogger.error((Object)("Error while searching for object (id=" + id + "): "), (Throwable)e);
        }
        int i = 0;
        while (i < this.myCells.size()) {
            try {
                Cell cell = this.myCells.get(i);
                if (cell.getId() == id) {
                    return cell;
                }
            }
            catch (Exception e) {
                this.myLogger.error((Object)("Error while searching for object (id=" + id + "): "), (Throwable)e);
            }
            ++i;
        }
        return null;
    }

    protected void doDeleteUnitOutsideCabinets(Unit unit) {
        if (unit != null && this.myUnitsOutsideCabinets != null) {
            this.myUnitsOutsideCabinets.remove(unit);
        }
    }

    protected void doDeleteRelationCellId(int intCellId) {
        if (this.mySiteCellRelationIds != null) {
            int i = 0;
            while (i < this.mySiteCellRelationIds.size()) {
                if (Integer.parseInt(this.mySiteCellRelationIds.get(i).toString()) == intCellId) {
                    this.mySiteCellRelationIds.remove(i);
                }
                ++i;
            }
        }
    }

    protected void doAddUnitOutsideCabinets(Unit unit) {
        if (unit != null && this.myUnitsOutsideCabinets != null) {
            this.myUnitsOutsideCabinets.add(unit);
        }
    }

    protected final void doSetRelationCellIds(Vector<Integer> vecCellIds) {
        this.mySiteCellRelationIds = vecCellIds;
    }

    protected void doAddRelationCellId(int intCellId) {
        this.mySiteCellRelationIds.add(intCellId);
    }

    protected final void doAddCell(Cell cell) {
        if (cell.getId() == -1 && cell instanceof CellImpl) {
            ((CellImpl)cell).doSetId(this.getAvailableId());
        } else {
            this.upateMaxObjectId(cell.getId());
        }
        cell.setSite(this);
        this.myCells.add(cell);
        this.sendChildAdded(cell.getCellId(), 5);
    }

    protected final void doAddCellGroup(CellGroup cellGroup) {
        if (cellGroup.getId() == -1 && cellGroup instanceof CellGroupImpl) {
            ((CellGroupImpl)cellGroup).doSetId(this.getAvailableId());
        } else {
            this.upateMaxObjectId(cellGroup.getId());
        }
        this.myCellGroups.add(cellGroup);
        this.sendChildAdded(cellGroup.getId(), 78);
    }

    protected void doSetCabinet(Cabinet cabinet) {
        if (cabinet != null) {
            this.myCabinet = cabinet;
        }
    }

    protected final void doSetActiveClockUnit(int intUnitId) {
        this.myActiveClockUnit = intUnitId;
    }

    @Override
    public final int getActiveClockUnit() {
        return this.myActiveClockUnit;
    }

    @Override
    public final int getOperationalState() {
        return this.myOperationalState;
    }

    protected final void doSetOMMaster(int intUnitId) {
        this.myOMMaster = intUnitId;
    }

    @Override
    public final int getOMMaster() {
        return this.myOMMaster;
    }

    public final void doSetBtsType(String btsType) {
        this.myBtsType = btsType;
    }

    @Override
    public final String getBtsType() {
        return this.myBtsType;
    }

    protected final void doSetTComMaster(int intUnitId) {
        this.myTComMaster = intUnitId;
    }

    @Override
    public final int getTComMaster() {
        return this.myTComMaster;
    }

    @Override
    public List<Cell> getCells() {
        Collections.sort(this.myCells, this.myCellComparator);
        return this.myCells;
    }

    @Override
    public Cell getCell(int cellId) {
        int i = 0;
        while (i < this.myCells.size()) {
            if (((CellImpl)this.myCells.get(i)).getCellId() == cellId) {
                return this.myCells.get(i);
            }
            ++i;
        }
        return null;
    }

    @Override
    public void block(final ChangeStateListener listener) {
        if (this.isEditable()) {
            throw new UnsupportedOperationException("Cannot block editable site");
        }
        CoreAssetThread worker = new CoreAssetThread(){

            protected Object construct() {
                if (CoreAsset.isSnapshotOpening()) {
                    SiteImpl.this.myLogger.debug((Object)"Not supported in snapshot open mode.");
                    listener.stateChangeFailed(85);
                    return false;
                }
                int seqNumber = SiteImpl.this.myConnection.createScenario();
                ChangeObjectBlockingStateRequest blockRequest = new ChangeObjectBlockingStateRequest(seqNumber, SiteImpl.this.getId(), 7, 12);
                SiteImpl.this.myConnection.sendToBTS((BTSMessage)blockRequest);
                BTSMessage response = SiteImpl.this.myConnection.receiveFromBTS(seqNumber);
                if (response instanceof Ack) {
                    Ack ackResponse = (Ack)response;
                    if (!ackResponse.getAck()) {
                        listener.stateChangeRequestDenied(ackResponse.getNackReason());
                        SiteImpl.this.myConnection.deleteScenario(seqNumber);
                        return false;
                    }
                    listener.stateChangeRequestAccepted();
                    response = SiteImpl.this.myConnection.receiveFromBTS(seqNumber);
                    if (response instanceof BlockOperationsCompleted) {
                        BlockOperationsCompleted blockOperResponse = (BlockOperationsCompleted)response;
                        int responseCode = blockOperResponse.getSuccessCode();
                        SiteImpl.this.myConnection.deleteScenario(seqNumber);
                        if (responseCode == 36) {
                            return true;
                        }
                        SiteImpl.this.checkAndBlockWhileHWModelBuild();
                        listener.stateChangeFailed(blockOperResponse.getSuccessCode());
                        return false;
                    }
                }
                SiteImpl.this.myConnection.deleteScenario(seqNumber);
                SiteImpl.this.checkAndBlockWhileHWModelBuild();
                if (response == null) {
                    listener.stateChangeFailed(87);
                    return false;
                }
                listener.stateChangeFailed(28);
                return false;
            }

            protected void finished() {
                try {
                    SiteImpl.this.checkAndBlockWhileHWModelBuild();
                    if (((Boolean)this.get()).booleanValue()) {
                        listener.stateChangeCompleted();
                    }
                }
                catch (ExecutionException ite) {
                    SiteImpl.this.myLogger.error((Object)("Block failed: " + ite.getCause()));
                    listener.stateChangeFailed(30);
                }
            }
        };
        worker.start();
    }

    @Override
    public void unblock(final ChangeStateListener listener) {
        if (this.isEditable()) {
            throw new UnsupportedOperationException("Cannot unblock editable site");
        }
        CoreAssetThread worker = new CoreAssetThread(){

            protected Object construct() {
                if (CoreAsset.isSnapshotOpening()) {
                    SiteImpl.this.myLogger.debug((Object)"Not supported in snapshot open mode.");
                    listener.stateChangeFailed(85);
                    return false;
                }
                int seqNumber = SiteImpl.this.myConnection.createScenario(true);
                ChangeObjectBlockingStateRequest unblockRequest = new ChangeObjectBlockingStateRequest(seqNumber, SiteImpl.this.getId(), 7, 13);
                SiteImpl.this.myConnection.sendToBTS((BTSMessage)unblockRequest);
                BTSMessage response = SiteImpl.this.myConnection.receiveFromBTS(seqNumber, 480000L);
                if (response instanceof Ack) {
                    Ack ackResponse = (Ack)response;
                    if (!ackResponse.getAck()) {
                        listener.stateChangeRequestDenied(ackResponse.getNackReason());
                        SiteImpl.this.myConnection.deleteScenario(seqNumber);
                        return false;
                    }
                    SiteImpl.this.myConnection.deleteScenario(seqNumber);
                    return true;
                }
                SiteImpl.this.myConnection.deleteScenario(seqNumber);
                SiteImpl.this.checkAndBlockWhileHWModelBuild();
                if (response == null) {
                    SiteImpl.this.myLogger.debug((Object)"Connection has been lost during unblock.");
                    listener.stateChangeFailed(87);
                    return false;
                }
                if (response instanceof Timeout) {
                    SiteImpl.this.myLogger.debug((Object)"BTS unblock timeout.");
                    listener.stateChangeFailed(68);
                    return false;
                }
                SiteImpl.this.myLogger.debug((Object)"Invalid message received when unblockin site.");
                listener.stateChangeFailed(28);
                return false;
            }

            protected void finished() {
                try {
                    SiteImpl.this.checkAndBlockWhileHWModelBuild();
                    if (((Boolean)this.get()).booleanValue()) {
                        listener.stateChangeCompleted();
                    }
                }
                catch (ExecutionException ite) {
                    SiteImpl.this.myLogger.error((Object)("Block failed: " + ite.getCause()));
                    listener.stateChangeFailed(30);
                }
            }
        };
        worker.start();
    }

    @Override
    public final int getBlockingState() {
        return this.myBlockingState;
    }

    @Override
    public final String getAuthenticationServer() {
        return this.myAuthenticationServer;
    }

    @Override
    public final int getDoorSwitchInUse() {
        return this.myDoorSwitchInUse;
    }

    @Override
    public final int getSmokeAlarmInUse() {
        return this.mySmokeAlarmInUse;
    }

    @Override
    public final int getMainsPowerAlarmId() {
        return this.myMainsPowerAlarmId;
    }

    @Override
    public final String getNTPAddress() {
        return this.myNTPAddress;
    }

    @Override
    public final int getNumberOfLines() {
        return this.myNumberOfLines;
    }

    @Override
    public final float getTimeZoneOffset() {
        return this.myTimeZoneOffset;
    }

    @Override
    public final TimeZone getTimeZone() {
        return this.myTimeZone;
    }

    @Override
    public final int getMibbuType() {
        return this.myMibbuType;
    }

    @Override
    public void setCells(List<Cell> cells) {
        if (!this.isEditable()) {
            throw new UnsupportedOperationException("Operation not supported in online model");
        }
        if (cells != null) {
            this.doSetCells(cells);
        } else {
            this.myLogger.error((Object)"Cannot set null cells");
        }
    }

    @Override
    public void addCell(Cell cell) {
        if (cell != null) {
            this.doAddCell(cell);
        } else {
            this.myLogger.error((Object)"Cannot add null cell");
        }
    }

    @Override
    public void deleteCell(Cell cell) {
        if (cell != null) {
            this.sendChildRemoved(cell.getCellId(), 5);
            this.myCells.remove(cell);
            cell.sendObjectRemoved();
            cell.destroy();
        } else {
            this.myLogger.error((Object)"Cannot delete null cell");
        }
    }

    @Override
    public void deleteCell(int cellId) {
        this.deleteCell(this.getCell(cellId));
    }

    @Override
    public void clearCells() {
        if (!this.isEditable()) {
            throw new UnsupportedOperationException("Operation not supported in online model");
        }
        int i = 0;
        while (i < this.myCells.size()) {
            this.sendChildRemoved(this.myCells.get(i).getCellId(), 5);
            this.myCells.get(i).sendObjectRemoved();
            this.myCells.get(i).destroy();
            ++i;
        }
        this.myCells.clear();
    }

    @Override
    public void clearCellGroups() {
        if (!this.isEditable()) {
            throw new UnsupportedOperationException("Operation not supported in online model");
        }
        for (CellGroup c : this.myCellGroups) {
            this.sendChildRemoved(c.getId(), 78);
            c.sendObjectRemoved();
            c.destroy();
        }
        this.myCellGroups.clear();
    }

    @Override
    public Cell getCellByCellId(int id) {
        for (Cell cell : this.myCells) {
            if (cell.getId() != id) continue;
            return cell;
        }
        return null;
    }

    @Override
    public void addCellGroup(CellGroup cellGroup) {
        if (!this.isEditable()) {
            throw new UnsupportedOperationException("Operation not supported in online model");
        }
        if (cellGroup != null) {
            this.doAddCellGroup(cellGroup);
        } else {
            this.myLogger.error((Object)"Cannot add null cell group");
        }
    }

    @Override
    public void deleteCellGroup(CellGroup cellGroup) {
        if (!this.isEditable()) {
            throw new UnsupportedOperationException("Operation not supported in online model");
        }
        if (cellGroup != null) {
            this.sendChildRemoved(cellGroup.getId(), 78);
            this.myCellGroups.remove(cellGroup);
            cellGroup.sendObjectRemoved();
            cellGroup.destroy();
        } else {
            this.myLogger.error((Object)"Cannot delete null cell group");
        }
    }

    @Override
    public void deleteCellGroup(int id) {
        if (!this.isEditable()) {
            throw new UnsupportedOperationException("Operation not supported in online model");
        }
        this.deleteCellGroup(this.getCellGroup(id));
    }

    @Override
    public CellGroup getCellGroup(int id) {
        for (CellGroup cg : this.myCellGroups) {
            if (cg.getId() != id) continue;
            return cg;
        }
        return null;
    }

    @Override
    public void addCabinet(Cabinet cabinet) {
        if (!this.isEditable()) {
            throw new UnsupportedOperationException("Operation not supported in online model");
        }
        if (cabinet != null) {
            if (cabinet.getId() == -1 && cabinet instanceof CabinetImpl) {
                ((CabinetImpl)cabinet).doSetId(this.getAvailableId());
            } else {
                this.upateMaxObjectId(cabinet.getId());
            }
            cabinet.setSite(this);
            this.myCabinet = cabinet;
            this.sendChildAdded(cabinet.getId(), 4);
        } else {
            this.myLogger.error((Object)"Cannot add null cabinet");
        }
    }

    @Override
    public void deleteCabinet(Cabinet cabinet) {
        if (!this.isEditable()) {
            throw new UnsupportedOperationException("Operation not supported in online model");
        }
        if (this.myCabinet != null) {
            this.sendChildRemoved(this.myCabinet.getId(), 4);
            this.myCabinet.sendObjectRemoved();
            this.myCabinet.destroy();
        } else {
            this.myLogger.error((Object)"Cannot delete null cabinet");
        }
    }

    @Override
    public void deleteCabinet(int id) {
        if (!this.isEditable()) {
            throw new UnsupportedOperationException("Operation not supported in online model");
        }
        this.deleteCabinet(this.getCabinet(id));
    }

    @Override
    public Unit getUnit(int id) {
        for (Unit unit : this.myCabinet.getUnits()) {
            if (unit == null || unit.getId() != id) continue;
            return unit;
        }
        return null;
    }

    @Override
    public List<Unit> getUnitsByType(String type) {
        ArrayList<Unit> unitsList = new ArrayList<Unit>();
        for (UnitImpl unitImpl : this.myCabinet.getUnits()) {
            if (unitImpl == null || !unitImpl.getUnitType().equals(type)) continue;
            unitsList.add(unitImpl);
        }
        return unitsList;
    }

    @Override
    public Unit getUnitName(String name) {
        for (Unit unit : this.myCabinet.getUnits()) {
            if (unit == null || !unit.getUnitName().equals(name)) continue;
            return unit;
        }
        return null;
    }

    @Override
    public Unit getUnit(String name) {
        for (Unit unit : this.myCabinet.getUnits()) {
            if (unit == null || !unit.getName().equals(name)) continue;
            return unit;
        }
        return null;
    }

    @Override
    public Unit getUnitByDistName(String distName) {
        for (Unit unit : this.myCabinet.getUnits()) {
            if (unit == null || !unit.getDistName().equals(distName)) continue;
            return unit;
        }
        return null;
    }

    @Override
    public void destroy() {
        if (!this.isEditable()) {
            throw new UnsupportedOperationException("Operation not supported in online model");
        }
        this.myCabinet.destroy();
        int i = 0;
        while (i < this.myCells.size()) {
            this.myCells.get(i).destroy();
            ++i;
        }
        Iterator<CellGroup> i2 = this.myCellGroups.iterator();
        while (i2.hasNext()) {
            i2.next().destroy();
        }
        this.myCabinet = null;
        this.myCells.clear();
        this.myCellGroups.clear();
    }
}

