/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.configuration;

import com.nokia.em.bts.coreasset.configuration.AbstractBTSConfigObject;
import com.nokia.em.bts.coreasset.configuration.BTSConfigObject;
import com.nokia.em.bts.coreasset.configuration.BTSConfigurationManager;
import com.nokia.em.bts.coreasset.configuration.Cell;
import com.nokia.em.bts.coreasset.configuration.ChangeStateListener;
import com.nokia.em.bts.coreasset.configuration.Site;
import com.nokia.em.bts.coreasset.configuration.SubUnit;
import com.nokia.em.bts.coreasset.configuration.Unit;
import com.nokia.em.bts.coreasset.message.BlockOperationsCompleted;
import com.nokia.em.bts.coreasset.message.ChangeObjectBlockingStateRequest;
import com.nokia.em.bts.rp.master.message.Ack;
import com.nokia.em.bts.rp.master.message.BTSMessage;
import com.nokia.em.bts.rp.master.tool.CoreAssetThread;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SubUnitImpl
extends AbstractBTSConfigObject
implements SubUnit {
    protected static final String NODENAME = "Subunit";
    protected static final String UNIT_ID_NODENAME = "_unitId";
    protected static final String SUBUNIT_NUMBER_NODENAME = "_subunitNumber";
    protected static final String SUBUNIT_NAME_NODENAME = "_subunitName";
    protected static final String STATE_NODENAME = "_state";
    protected static final String STATE_WORKING_NODEVALUE = "working";
    protected static final String STATE_DEGRADED_NODEVALUE = "degraded";
    protected static final String STATE_FAULTY_NODEVALUE = "faulty";
    protected static final String STATE_RESETTING_NODEVALUE = "resetting";
    protected static final String OPERATIONAL_STATE_NODENAME = "_operationalState";
    protected static final String OPERATIONAL_STATE_ENABLED_NODEVALUE = "enabled";
    protected static final String OPERATIONAL_STATE_DISABLED_NODEVALUE = "disabled";
    protected static final String BLOCKING_STATE_NODENAME = "_blockingState";
    protected static final String BLOCKING_STATE_BLOCKED_NODEVALUE = "blocked";
    protected static final String BLOCKING_STATE_UNBLOCKED_NODEVALUE = "unblocked";
    protected static final String BLOCKING_STATE_DEFERRED_BLOCK_NODEVALUE = "deferredBlock";
    protected static final String SUPPORTED_OPERATIONS_NODENAME = "_supportedOperations";
    protected static final String SUPPORTED_OPERATION_BLOCK_NODENAME = "_blockingOperation";
    protected static final String SUPPORTED_OPERATION_RESET_NODENAME = "_resetOperation";
    private int myParentUnitId;
    private int myNumber;
    private String myName;
    private List<Integer> mySupportedOperations;
    private int myBlockingState;
    private int myState;
    private List<Integer> myCellIds;
    private int myOperationalState;
    private Logger myLogger = Logger.getLogger(this.getClass());
    private List<Cell> myCells;
    private Unit myUnit;

    public SubUnitImpl(BTSConfigurationManager btsConfMgr) {
        this(btsConfMgr, -1, -1, -1, "Coreasset_Unknown", -1, -1, -1);
    }

    public SubUnitImpl(BTSConfigurationManager btsConfMgr, int intId, int intParentUnitId, int intNumber, String strName, int intBlockingState, int intState, int intOperationalState) {
        super(btsConfMgr, intId, 14);
        this.myParentUnitId = intParentUnitId;
        this.myNumber = intNumber;
        this.myName = strName;
        this.myBlockingState = intBlockingState;
        this.myState = intState;
        this.myOperationalState = intOperationalState;
        this.mySupportedOperations = new ArrayList<Integer>(20);
        this.myCellIds = new ArrayList<Integer>(10);
    }

    private SubUnitImpl(SubUnit s) {
        this(null, s.getId(), s.getParentUnitId(), s.getNumber(), s.getName(), s.getBlockingState(), s.getState(), s.getOperationalState());
        this.setEditable(true);
        this.myCells = new ArrayList<Cell>();
    }

    public SubUnitImpl(String name, int number) {
        this((BTSConfigurationManager)null);
        this.myLogger = Logger.getLogger(this.getClass());
        this.setName(name);
        this.doSetNumber(number);
        this.myCells = new ArrayList<Cell>();
        this.setEditable(true);
    }

    @Override
    protected final Node getRoot(Document doc) {
        Element root = doc.createElement(NODENAME);
        root.appendChild(this.createElement(doc, "_id", this.getId()));
        root.appendChild(this.createElement(doc, UNIT_ID_NODENAME, this.getParentUnitId()));
        root.appendChild(this.createElement(doc, SUBUNIT_NUMBER_NODENAME, this.getNumber()));
        root.appendChild(this.createElement(doc, SUBUNIT_NAME_NODENAME, this.getName()));
        root.appendChild(this.createElement(doc, STATE_NODENAME, SubUnitImpl.nodeValueOf(this.myState)));
        root.appendChild(this.createElement(doc, BLOCKING_STATE_NODENAME, SubUnitImpl.nodeValueOf(this.myBlockingState)));
        root.appendChild(this.createElement(doc, OPERATIONAL_STATE_NODENAME, SubUnitImpl.nodeValueOf(this.myOperationalState)));
        Element supportedOperationsElement = doc.createElement(SUPPORTED_OPERATIONS_NODENAME);
        if (this.isOperationAllowed(45)) {
            supportedOperationsElement.appendChild(doc.createElement(SUPPORTED_OPERATION_BLOCK_NODENAME));
        }
        if (this.isOperationAllowed(44)) {
            supportedOperationsElement.appendChild(doc.createElement(SUPPORTED_OPERATION_RESET_NODENAME));
        }
        root.appendChild(supportedOperationsElement);
        return root;
    }

    protected static final String nodeValueOf(int intValue) {
        switch (intValue) {
            case 55: {
                return BLOCKING_STATE_BLOCKED_NODEVALUE;
            }
            case 57: {
                return BLOCKING_STATE_UNBLOCKED_NODEVALUE;
            }
            case 62: {
                return BLOCKING_STATE_DEFERRED_BLOCK_NODEVALUE;
            }
            case 52: {
                return STATE_WORKING_NODEVALUE;
            }
            case 53: {
                return STATE_DEGRADED_NODEVALUE;
            }
            case 54: {
                return STATE_FAULTY_NODEVALUE;
            }
            case 58: {
                return STATE_RESETTING_NODEVALUE;
            }
            case 27: {
                return OPERATIONAL_STATE_ENABLED_NODEVALUE;
            }
            case 28: {
                return OPERATIONAL_STATE_DISABLED_NODEVALUE;
            }
            case 45: {
                return SUPPORTED_OPERATION_BLOCK_NODENAME;
            }
            case 44: {
                return SUPPORTED_OPERATION_RESET_NODENAME;
            }
        }
        return "Coreasset_Unknown";
    }

    protected final void doSetBlockingState(int intBlockingState) {
        this.myBlockingState = intBlockingState;
    }

    protected final void doSetState(int intState) {
        this.myState = intState;
    }

    protected final void doAddPermittedOperation(int intPermittedOperation) {
        this.mySupportedOperations.add(intPermittedOperation);
    }

    protected final void doSetNumber(int intNumber) {
        this.myNumber = intNumber;
    }

    protected final void doSetParentUnitId(int intParentUnitId) {
        this.myParentUnitId = intParentUnitId;
    }

    protected final void doSetOperationalState(int intOperationalState) {
        this.myOperationalState = intOperationalState;
    }

    protected final void doAddRelationCellId(int intCellId) {
        Integer integer = intCellId;
        if (!this.myCellIds.contains(integer)) {
            this.myCellIds.add(integer);
        }
    }

    protected final void doDeleteRelationCellId(int intCellId) {
        this.myCellIds.remove((Object)intCellId);
    }

    @Override
    protected final void update(BTSConfigObject btsConfigObject) {
        if (btsConfigObject instanceof SubUnitImpl && btsConfigObject != null) {
            try {
                SubUnitImpl newSubUnit = (SubUnitImpl)btsConfigObject;
                this.doSetBlockingState(newSubUnit.getBlockingState());
                this.doSetState(newSubUnit.getState());
                this.doSetNumber(newSubUnit.getNumber());
                this.doSetParentUnitId(newSubUnit.getParentUnitId());
                this.mySupportedOperations = newSubUnit.mySupportedOperations;
                this.myOperationalState = newSubUnit.getOperationalState();
                this.doSetCustomAttributes(newSubUnit.getCustomAttributes());
            }
            catch (Exception e) {
                this.myLogger.error((Object)e);
            }
        } else {
            this.myLogger.error((Object)("Unable to update SubUnit using " + btsConfigObject));
        }
    }

    @Override
    public final void setName(String strSubUnitName) {
        this.myName = strSubUnitName;
    }

    @Override
    public final int getParentUnitId() {
        return this.myParentUnitId;
    }

    @Override
    public final List<Integer> getRelationCellIds() {
        return this.myCellIds;
    }

    @Override
    public final int getNumber() {
        return this.myNumber;
    }

    @Override
    public final String getName() {
        return this.myName;
    }

    @Override
    public void block(final ChangeStateListener listener) {
        if (this.isEditable()) {
            throw new UnsupportedOperationException("Cannot block editable sub unit");
        }
        CoreAssetThread worker = new CoreAssetThread(){

            protected Object construct() {
                int seqNumber = SubUnitImpl.this.myConnection.createScenario();
                ChangeObjectBlockingStateRequest blockRequest = new ChangeObjectBlockingStateRequest(seqNumber, SubUnitImpl.this.getId(), 55, 12);
                SubUnitImpl.this.myConnection.sendToBTS((BTSMessage)blockRequest);
                BTSMessage response = SubUnitImpl.this.myConnection.receiveFromBTS(seqNumber);
                if (response instanceof Ack) {
                    Ack ackResponse = (Ack)response;
                    if (!ackResponse.getAck()) {
                        listener.stateChangeRequestDenied(ackResponse.getNackReason());
                        SubUnitImpl.this.myConnection.deleteScenario(seqNumber);
                        return false;
                    }
                    listener.stateChangeRequestAccepted();
                    response = SubUnitImpl.this.myConnection.receiveFromBTS(seqNumber);
                    if (response instanceof BlockOperationsCompleted) {
                        BlockOperationsCompleted blockOperResponse = (BlockOperationsCompleted)response;
                        int successCode = blockOperResponse.getSuccessCode();
                        SubUnitImpl.this.myConnection.deleteScenario(seqNumber);
                        if (successCode == 36) {
                            return true;
                        }
                        listener.stateChangeFailed(successCode);
                        return false;
                    }
                }
                SubUnitImpl.this.myConnection.deleteScenario(seqNumber);
                if (response == null) {
                    listener.stateChangeFailed(87);
                    return false;
                }
                listener.stateChangeFailed(28);
                return false;
            }

            protected void finished() {
                try {
                    if (((Boolean)this.get()).booleanValue()) {
                        listener.stateChangeCompleted();
                    }
                }
                catch (Exception e) {
                    SubUnitImpl.this.myLogger.error((Object)e);
                    listener.stateChangeFailed(30);
                }
            }
        };
        worker.start();
    }

    @Override
    public void unblock(final ChangeStateListener listener) {
        if (this.isEditable()) {
            throw new UnsupportedOperationException("Cannot unblock editable sub unit");
        }
        CoreAssetThread worker = new CoreAssetThread(){

            protected Object construct() {
                int seqNumber = SubUnitImpl.this.myConnection.createScenario(true);
                ChangeObjectBlockingStateRequest unblockRequest = new ChangeObjectBlockingStateRequest(seqNumber, SubUnitImpl.this.getId(), 55, 13);
                SubUnitImpl.this.myConnection.sendToBTS((BTSMessage)unblockRequest);
                BTSMessage response = SubUnitImpl.this.myConnection.receiveFromBTS(seqNumber);
                if (response instanceof Ack) {
                    Ack ackResponse = (Ack)response;
                    if (!ackResponse.getAck()) {
                        listener.stateChangeRequestDenied(ackResponse.getNackReason());
                        SubUnitImpl.this.myConnection.deleteScenario(seqNumber);
                        return false;
                    }
                    listener.stateChangeRequestAccepted();
                    response = SubUnitImpl.this.myConnection.receiveFromBTS(seqNumber);
                    if (response instanceof BlockOperationsCompleted) {
                        BlockOperationsCompleted blockOperResponse = (BlockOperationsCompleted)response;
                        int responseCode = blockOperResponse.getSuccessCode();
                        SubUnitImpl.this.myConnection.deleteScenario(seqNumber);
                        if (responseCode == 36) {
                            return true;
                        }
                        listener.stateChangeFailed(responseCode);
                        return false;
                    }
                }
                SubUnitImpl.this.myConnection.deleteScenario(seqNumber);
                if (response == null) {
                    listener.stateChangeFailed(87);
                    return false;
                }
                listener.stateChangeFailed(28);
                return false;
            }

            protected void finished() {
                try {
                    if (((Boolean)this.get()).booleanValue()) {
                        listener.stateChangeCompleted();
                    }
                }
                catch (Exception e) {
                    SubUnitImpl.this.myLogger.error((Object)e);
                    listener.stateChangeFailed(30);
                }
            }
        };
        worker.start();
    }

    @Override
    public final boolean isOperationAllowed(int intPermittedOperation) {
        return this.mySupportedOperations.contains(intPermittedOperation);
    }

    @Override
    public final int getState() {
        return this.myState;
    }

    @Override
    public final int getBlockingState() {
        return this.myBlockingState;
    }

    @Override
    public final int getOperationalState() {
        return this.myOperationalState;
    }

    @Override
    public SubUnit getEditableCopy() {
        if (this.isEditable()) {
            throw new UnsupportedOperationException("This sub unit is already editable");
        }
        return new SubUnitImpl(this);
    }

    @Override
    public void setCells(List<Cell> cells) {
        if (!this.isEditable()) {
            throw new UnsupportedOperationException("Operation not supported in online model");
        }
        if (cells != null) {
            this.myCells = cells;
        } else {
            this.myLogger.error((Object)"Cannot set null cells");
        }
    }

    @Override
    public void addCell(Cell cell) {
        if (!this.isEditable()) {
            throw new UnsupportedOperationException("Operation not supported in online model");
        }
        if (cell != null) {
            this.myCells.add(cell);
        } else {
            this.myLogger.error((Object)"Cannot add null cell");
        }
    }

    @Override
    public void removeCell(Cell cell) {
        if (!this.isEditable()) {
            throw new UnsupportedOperationException("Operation not supported in online model");
        }
        this.myCells.remove(cell);
    }

    @Override
    public void removeCell(int id) {
        if (!this.isEditable()) {
            throw new UnsupportedOperationException("Operation not supported in online model");
        }
        this.removeCell(this.getCell(id));
    }

    @Override
    public Cell getCell(int id) {
        Site site = this.myBTSConfigurationManager.getSite();
        Cell cell = site.getCell(id);
        if (cell.getSubUnit(this.getId()) == this) {
            return cell;
        }
        return null;
    }

    @Override
    public List<Cell> getCells() {
        ArrayList<Cell> c = new ArrayList<Cell>();
        Site site = this.myBTSConfigurationManager.getSite();
        for (Cell cell : site.getCells()) {
            if (cell.getSubUnit(this.getId()) != this) continue;
            c.add(cell);
        }
        return c;
    }

    @Override
    public void setParentUnit(Unit unit) {
        if (!this.isEditable()) {
            throw new UnsupportedOperationException("Operation not supported in online model");
        }
        if (unit != null) {
            this.myUnit = unit;
        } else {
            this.myLogger.error((Object)"Cannot set null parent unit");
        }
    }

    @Override
    public Unit getParentUnit() {
        if (!this.isEditable()) {
            return this.myBTSConfigurationManager.getSite().getUnit(this.getParentUnitId());
        }
        return this.myUnit;
    }

    @Override
    public void destroy() {
        if (!this.isEditable()) {
            throw new UnsupportedOperationException("Operation not supported in online model");
        }
        this.myUnit = null;
        this.myCells.clear();
    }
}

