/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.configuration;

import com.nokia.em.bts.coreasset.CoreAsset;
import com.nokia.em.bts.coreasset.configuration.AbstractBTSConfigObject;
import com.nokia.em.bts.coreasset.configuration.BTSConfigObject;
import com.nokia.em.bts.coreasset.configuration.BTSConfigurationManager;
import com.nokia.em.bts.coreasset.configuration.Cabinet;
import com.nokia.em.bts.coreasset.configuration.Cell;
import com.nokia.em.bts.coreasset.configuration.CellGroup;
import com.nokia.em.bts.coreasset.configuration.ChangeStateListener;
import com.nokia.em.bts.coreasset.configuration.Link;
import com.nokia.em.bts.coreasset.configuration.RackShelfSlot;
import com.nokia.em.bts.coreasset.configuration.Site;
import com.nokia.em.bts.coreasset.configuration.SubUnit;
import com.nokia.em.bts.coreasset.configuration.SubUnitComparator;
import com.nokia.em.bts.coreasset.configuration.SubUnitImpl;
import com.nokia.em.bts.coreasset.configuration.Unit;
import com.nokia.em.bts.coreasset.message.BlockOperationsCompleted;
import com.nokia.em.bts.coreasset.message.ChangeObjectBlockingStateRequest;
import com.nokia.em.bts.coreasset.scenario.hwmanagement.InputVoltage;
import com.nokia.em.bts.rp.master.message.Ack;
import com.nokia.em.bts.rp.master.message.BTSMessage;
import com.nokia.em.bts.rp.master.tool.CoreAssetThread;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class UnitImpl
extends AbstractBTSConfigObject
implements Unit {
    protected static final String NODENAME = "Unit";
    protected static final String BS_ID_NODENAME = "_bsId";
    protected static final String CABINET_ID_NODENAME = "_cabinetId";
    protected static final String EXIST_NODENAME = "_exist";
    protected static final String EXIST_TRUE_NODEVALUE = "1";
    protected static final String EXIST_FALSE_NODEVALUE = "0";
    protected static final String HW_VERSION_NODENAME = "_HWversion";
    protected static final String STATE_NODENAME = "_state";
    protected static final String STATE_WORKING_NODEVALUE = "working";
    protected static final String STATE_DEGRADED_NODEVALUE = "degraded";
    protected static final String STATE_FAULTY_NODEVALUE = "faulty";
    protected static final String STATE_RESETTING_NODEVALUE = "resetting";
    protected static final String STATE_UNKNOWN_NODEVALUE = "Unknown";
    protected static final String STATE_SWITCHED_OFF_NODEVALUE = "switchedOff";
    protected static final String OPERATIONAL_STATE_NODENAME = "_operationalState";
    protected static final String OPERATIONAL_STATE_ENABLED_NODEVALUE = "enabled";
    protected static final String OPERATIONAL_STATE_DISABLED_NODEVALUE = "disabled";
    protected static final String OPERATIONAL_STATE_COMMISSIONED_NODEVALUE = "commissioned";
    protected static final String OPERATIONAL_STATE_NOTCOMMISSIONED_NODEVALUE = "notCommissioned";
    protected static final String OPERATIONAL_STATE_CONFIGURED_NODEVALUE = "configured";
    protected static final String OPERATIONAL_STATE_INTEGRATED_TO_RAN_NODEVALUE = "integratedtoRAN";
    protected static final String OPERATIONAL_STATE_ON_AIR_NODEVALUE = "onAir";
    protected static final String BLOCKING_STATE_NODENAME = "_blockingState";
    protected static final String BLOCKING_STATE_BLOCKED_NODEVALUE = "blocked";
    protected static final String BLOCKING_STATE_UNBLOCKED_NODEVALUE = "unblocked";
    protected static final String BLOCKING_STATE_DEFERRED_BLOCK_NODEVALUE = "deferredBlock";
    protected static final String SW_STATE_NODENAME = "_SWState";
    protected static final String SW_STATE_NOT_COMMISSIONED_NODEVALUE = "NotCommissioned";
    protected static final String SW_STATE_COMMISSIONED_NODEVALUE = "Commissioned";
    protected static final String SW_STATE_CONFIGURED_NODEVALUE = "Configured";
    protected static final String SW_STATE_INTEGRATED_TO_RAN_NODEVALUE = "IntegratedToRAN";
    protected static final String SW_STATE_ON_AIR_NODEVALUE = "OnAir";
    protected static final String SW_STATE_INITIALIZING_NODEVALUE = "Initializing";
    protected static final String SW_STATE_CONFIGURING_NODEVALUE = "Configuring";
    protected static final String SW_STATE_OPERATIONAL_NODEVALUE = "Operational";
    protected static final String SW_STATE_NOT_DETECTED_NODEVALUE = "NotDetected";
    protected static final String SW_STATE_DETECTED_NODEVALUE = "Detected";
    protected static final String SW_STATE_LOST_NODEVALUE = "Lost";
    protected static final String SW_STATE_REJECTED_NODEVALUE = "Rejected";
    protected static final String CHASSIS_PRODUCT_CODE_NODENAME = "Chassis.Product.Code";
    protected static final String PRODUCT_CODE_NODENAME = "_productCode";
    protected static final String RACK_NODENAME = "_rack";
    protected static final String SUBRACK_NODENAME = "_subrack";
    protected static final String CHASSIS_SERIAL_NRO_NODENAME = "_chassisSerialNumber";
    protected static final String SERIAL_NRO_NODENAME = "_serialNro";
    protected static final String SHELF_NODENAME = "_shelf";
    protected static final String SLOT_NODENAME = "_slot";
    protected static final String UNIT_TYPE_NODENAME = "_unitType";
    protected static final String UNIT_NAME_NODENAME = "_unitName";
    protected static final String UNIT_NUMBER_NODENAME = "_unitNumber";
    protected static final String DIST_NAME_NODENAME = "_distName";
    protected static final String VARIANT_NODENAME = "_variant";
    protected static final String MANUFACTURER_NODENAME = "_manufacturer";
    protected static final String LED_COLOUR_NODENAME = "_ledColour";
    protected static final String LED_COLOUR_GREEN_NODEVALUE = "green";
    protected static final String LED_COLOUR_YELLOW_NODEVALUE = "yellow";
    protected static final String LED_COLOUR_RED_NODEVALUE = "red";
    protected static final String LED_COLOUR_BLINKING_GREEN_NODEVALUE = "blinkingGreen";
    protected static final String LED_COLOUR_BLINKING_RED_NODEVALUE = "blinkingRed";
    protected static final String LED_COLOUR_BLINKING_YELLOW_NODEVALUE = "blinkingYellow";
    protected static final String LED_COLOUR_RED_GREEN_NODEVALUE = "redGreen";
    protected static final String LED_COLOUR_YELLOW_GREEN_NODEVALUE = "yellowGreen";
    protected static final String LED_COLOUR_YELLOW_RED_NODEVALUE = "yellowRed";
    protected static final String COMMISSIONED_NODENAME = "_commissioned";
    protected static final String INPUT_VOLTAGE = "FRInputVoltage";
    protected static final String COMMISSIONED_TRUE_NODEVALUE = "TRUE";
    protected static final String COMMISSIONED_FALSE_NODEVALUE = "FALSE";
    private int mySiteId;
    private int myCabinetId;
    private String myProductCode;
    private String myChassisProductCode;
    private String mySerialNro;
    private String myChassisSerialNro;
    private String myUnitType;
    private boolean myExist;
    private String myName = "Coreasset_Unknown";
    private String myHWVersion;
    private int mySWState;
    private List<Link> myLinks;
    private List<SubUnit> mySubUnits;
    private String myManufacturer;
    private int myNumber;
    private String myVariant;
    private String myUnitname;
    private String myDistName;
    private int mySubRack;
    private int myState;
    private int myOperationalState;
    private int mySiteOperationalStatus;
    private int myBlockingState;
    private RackShelfSlot myRackShelfSlot;
    private final List<Integer> myCellIds;
    private String myLedColour;
    private SubUnitComparator mySubUnitComparator;
    private Boolean myCommissionedStatus;
    private List<CellGroup> myCellGroup;
    private List<Integer> myRelationUnitIds;
    private List<Integer> myRelationContainedUnitIds;
    private int myParentUnitId;
    private Logger myLogger = Logger.getLogger(this.getClass());
    private List<Cell> myCells;
    private List<Unit> myContainedUnits;
    private List<Unit> myRelatedUnits;
    private Site mySite;
    private Cabinet myCabinet;
    private Unit myParentUnit;
    private InputVoltage myInputVoltage;
    private static final Map<Integer, String> myNodeValueMap = new HashMap<Integer, String>(){
        private static final long serialVersionUID = 2363691074839451349L;
        {
            this.put(55, UnitImpl.BLOCKING_STATE_BLOCKED_NODEVALUE);
            this.put(57, UnitImpl.BLOCKING_STATE_UNBLOCKED_NODEVALUE);
            this.put(62, UnitImpl.BLOCKING_STATE_DEFERRED_BLOCK_NODEVALUE);
            this.put(52, UnitImpl.STATE_WORKING_NODEVALUE);
            this.put(53, UnitImpl.STATE_DEGRADED_NODEVALUE);
            this.put(54, UnitImpl.STATE_FAULTY_NODEVALUE);
            this.put(58, UnitImpl.STATE_RESETTING_NODEVALUE);
            this.put(59, UnitImpl.STATE_UNKNOWN_NODEVALUE);
            this.put(60, UnitImpl.STATE_SWITCHED_OFF_NODEVALUE);
            this.put(27, UnitImpl.OPERATIONAL_STATE_ENABLED_NODEVALUE);
            this.put(28, UnitImpl.OPERATIONAL_STATE_DISABLED_NODEVALUE);
            this.put(30, UnitImpl.OPERATIONAL_STATE_NOTCOMMISSIONED_NODEVALUE);
            this.put(29, UnitImpl.OPERATIONAL_STATE_COMMISSIONED_NODEVALUE);
            this.put(31, UnitImpl.OPERATIONAL_STATE_CONFIGURED_NODEVALUE);
            this.put(32, UnitImpl.OPERATIONAL_STATE_INTEGRATED_TO_RAN_NODEVALUE);
            this.put(33, UnitImpl.OPERATIONAL_STATE_ON_AIR_NODEVALUE);
            this.put(37, UnitImpl.SW_STATE_NOT_COMMISSIONED_NODEVALUE);
            this.put(38, UnitImpl.SW_STATE_COMMISSIONED_NODEVALUE);
            this.put(39, UnitImpl.SW_STATE_CONFIGURED_NODEVALUE);
            this.put(40, UnitImpl.SW_STATE_INTEGRATED_TO_RAN_NODEVALUE);
            this.put(41, UnitImpl.SW_STATE_ON_AIR_NODEVALUE);
            this.put(36, UnitImpl.SW_STATE_INITIALIZING_NODEVALUE);
            this.put(67, UnitImpl.SW_STATE_CONFIGURING_NODEVALUE);
            this.put(66, UnitImpl.SW_STATE_OPERATIONAL_NODEVALUE);
            this.put(69, UnitImpl.SW_STATE_DETECTED_NODEVALUE);
            this.put(68, UnitImpl.SW_STATE_NOT_DETECTED_NODEVALUE);
            this.put(70, UnitImpl.SW_STATE_LOST_NODEVALUE);
            this.put(71, UnitImpl.SW_STATE_REJECTED_NODEVALUE);
        }
    };

    public UnitImpl(BTSConfigurationManager btsConfMgr) {
        this(btsConfMgr, -1, -1, -1, false, "Coreasset_Unknown", -1, -1, "Coreasset_Unknown", -1, -1, -1, -1, -1, "Coreasset_Unknown", "Coreasset_Unknown", -1, "Coreasset_Unknown", "Coreasset_Unknown", "Coreasset_Unknown", -1, "Coreasset_Unknown", "Coreasset_Unknown", null);
    }

    public UnitImpl(BTSConfigurationManager btsConfMgr, int intId, int intSiteId, int intCabinetId, boolean blnExist, String strProductCode, int intRack, int intSubRack, String strSerialNro, int intShelf, int intSlot, int intState, int intOperationalState, int intBlockingState, String strUnitType, String strHWVersion, int intSWState, String strVariant, String strUnitname, String strDistName, int intNumber, String strManufacturer, String ledColour, Boolean commissionedStatus) {
        super(btsConfMgr, intId, 10);
        this.mySiteId = intSiteId;
        this.myCabinetId = intCabinetId;
        this.myExist = blnExist;
        this.myProductCode = strProductCode;
        this.mySubRack = intSubRack;
        this.mySerialNro = strSerialNro;
        this.myState = intState;
        this.myOperationalState = intOperationalState;
        this.myBlockingState = intBlockingState;
        this.myUnitType = strUnitType;
        this.myHWVersion = strHWVersion;
        this.mySWState = intSWState;
        this.myVariant = strVariant;
        this.myUnitname = strUnitname;
        this.myDistName = strDistName;
        this.myNumber = intNumber;
        this.myManufacturer = strManufacturer;
        this.myCommissionedStatus = commissionedStatus;
        this.myLinks = new ArrayList<Link>(20);
        this.mySubUnits = new ArrayList<SubUnit>(20);
        this.myRackShelfSlot = new RackShelfSlot(intRack, intShelf, intSlot);
        this.myCellIds = new ArrayList<Integer>(10);
        this.myLedColour = ledColour;
        this.mySubUnitComparator = SubUnitComparator.getInstance();
        this.myCellGroup = new ArrayList<CellGroup>(10);
        this.myRelationContainedUnitIds = new ArrayList<Integer>(10);
        this.myRelationUnitIds = new ArrayList<Integer>(10);
        this.myParentUnitId = -1;
    }

    private UnitImpl(Unit u) {
        this(null, u.getId(), u.getSite().getId(), u.getCabinetId(), u.getExist(), u.getProductCode(), u.getRackShelfSlot().getRack(), u.getSubRack(), u.getSerialNro(), u.getRackShelfSlot().getShelf(), u.getRackShelfSlot().getSlot(), u.getState(), u.getOperationalState(), u.getBlockingState(), u.getUnitType(), u.getHWVersion(), u.getSWState(), u.getVariant(), u.getUnitName(), u.getDistName(), u.getNumber(), u.getManufacturer(), u.getLedColour(), u.getCommissionedStatus());
        this.doSetCustomAttributes(u.getCustomAttributes());
        this.myCells = new ArrayList<Cell>();
        this.myContainedUnits = new ArrayList<Unit>();
        this.myRelatedUnits = new ArrayList<Unit>();
        this.setEditable(true);
    }

    public UnitImpl(String unitType, String variant, int number) {
        this((BTSConfigurationManager)null);
        this.doSetUnitType(unitType);
        this.doSetVariant(variant);
        this.doSetNumber(number);
        this.doSetExist(true);
        this.myCells = new ArrayList<Cell>();
        this.myContainedUnits = new ArrayList<Unit>();
        this.myRelatedUnits = new ArrayList<Unit>();
        this.setEditable(true);
    }

    @Override
    protected final Node getRoot(Document doc) {
        Element root = doc.createElement(NODENAME);
        root.appendChild(this.createElement(doc, "_id", this.getId()));
        root.appendChild(this.createElement(doc, BS_ID_NODENAME, this.doGetSiteId()));
        root.appendChild(this.createElement(doc, CABINET_ID_NODENAME, this.getCabinetId()));
        if (this.getExist()) {
            root.appendChild(this.createElement(doc, EXIST_NODENAME, EXIST_TRUE_NODEVALUE));
        } else {
            root.appendChild(this.createElement(doc, EXIST_NODENAME, EXIST_FALSE_NODEVALUE));
        }
        root.appendChild(this.createElement(doc, HW_VERSION_NODENAME, this.getHWVersion()));
        root.appendChild(this.createElement(doc, STATE_NODENAME, UnitImpl.nodeValueOf(this.myState)));
        root.appendChild(this.createElement(doc, OPERATIONAL_STATE_NODENAME, UnitImpl.nodeValueOf(this.myOperationalState)));
        root.appendChild(this.createElement(doc, BLOCKING_STATE_NODENAME, UnitImpl.nodeValueOf(this.myBlockingState)));
        root.appendChild(this.createElement(doc, SW_STATE_NODENAME, UnitImpl.nodeValueOf(this.mySWState)));
        root.appendChild(this.createElement(doc, PRODUCT_CODE_NODENAME, this.getProductCode()));
        root.appendChild(this.createElement(doc, RACK_NODENAME, this.getRackShelfSlot().getRack()));
        root.appendChild(this.createElement(doc, SUBRACK_NODENAME, this.getSubRack()));
        root.appendChild(this.createElement(doc, SERIAL_NRO_NODENAME, this.getSerialNro()));
        root.appendChild(this.createElement(doc, SHELF_NODENAME, this.getRackShelfSlot().getShelf()));
        root.appendChild(this.createElement(doc, SLOT_NODENAME, this.getRackShelfSlot().getSlot()));
        root.appendChild(this.createElement(doc, UNIT_TYPE_NODENAME, this.getUnitType()));
        root.appendChild(this.createElement(doc, UNIT_NUMBER_NODENAME, this.getNumber()));
        root.appendChild(this.createElement(doc, VARIANT_NODENAME, this.getVariant()));
        root.appendChild(this.createElement(doc, UNIT_NAME_NODENAME, this.getUnitName()));
        root.appendChild(this.createElement(doc, DIST_NAME_NODENAME, this.getDistName()));
        root.appendChild(this.createElement(doc, MANUFACTURER_NODENAME, this.getManufacturer()));
        root.appendChild(this.createElement(doc, LED_COLOUR_NODENAME, this.getLedColour()));
        if (this.getCommissionedStatus() != null) {
            if (this.getCommissionedStatus().booleanValue()) {
                root.appendChild(this.createElement(doc, COMMISSIONED_NODENAME, COMMISSIONED_TRUE_NODEVALUE));
            } else {
                root.appendChild(this.createElement(doc, COMMISSIONED_NODENAME, COMMISSIONED_FALSE_NODEVALUE));
            }
        }
        return root;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doRemoveContainedRelationUnitId(int unitId) {
        List<Integer> list = this.myRelationContainedUnitIds;
        synchronized (list) {
            this.myRelationContainedUnitIds.remove((Object)unitId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doRemoveRelationUnitId(int unitId) {
        List<Integer> list = this.myRelationUnitIds;
        synchronized (list) {
            this.myRelationUnitIds.remove((Object)unitId);
        }
    }

    protected void doRemoveCellGroupRelation(CellGroup cellGroup) {
        this.myCellGroup.remove(cellGroup);
    }

    protected void doAddCellGroupRelation(CellGroup cellGroup) {
        this.myCellGroup.add(cellGroup);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doAddContainedRelationUnitId(int unitId) {
        List<Integer> list = this.myRelationContainedUnitIds;
        synchronized (list) {
            this.myRelationContainedUnitIds.add(unitId);
        }
    }

    protected void doSetParentUnitId(int id) {
        this.myParentUnitId = id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doAddRelationUnitId(int unitId) {
        List<Integer> list = this.myRelationUnitIds;
        synchronized (list) {
            this.myRelationUnitIds.add(unitId);
        }
    }

    protected static final String nodeValueOf(int intValue) {
        String value = myNodeValueMap.get(new Integer(intValue));
        return value == null ? "Coreasset_Unknown" : value;
    }

    protected final List<Integer> doGetRelationCellIds() {
        return this.myCellIds;
    }

    protected final void doDeleteRelationCellId(int intCellId) {
        this.myCellIds.remove((Object)intCellId);
    }

    protected final void doSetSiteId(int intSiteId) {
        this.mySiteId = intSiteId;
    }

    protected final void doSetSerialNro(String strSerialNro) {
        this.mySerialNro = strSerialNro;
    }

    protected final void doSetChassisSerialNro(String strChassisSerialNro) {
        this.myChassisSerialNro = strChassisSerialNro;
    }

    protected void doSetUnitType(String strUnitType) {
        this.myUnitType = strUnitType;
    }

    protected void doSetSlot(int intSlot) {
        this.myRackShelfSlot.setSlot(intSlot);
    }

    protected void doSetShelf(int intShelf) {
        this.myRackShelfSlot.setShelf(intShelf);
    }

    protected void doSetRack(int intRack) {
        this.myRackShelfSlot.setRack(intRack);
    }

    protected final void doSetSubRack(int intSubRack) {
        this.mySubRack = intSubRack;
    }

    protected void doSetProductCode(String strProductCode) {
        this.myProductCode = strProductCode;
    }

    protected void doSetChassisProductCode(String strChassisProductCode) {
        this.myChassisProductCode = strChassisProductCode;
    }

    protected void doSetExist(boolean blnExist) {
        this.myExist = blnExist;
    }

    protected final void doSetCabinetId(int intCabinetId) {
        this.myCabinetId = intCabinetId;
    }

    protected final void doSetHWVersion(String strHWVersion) {
        this.myHWVersion = strHWVersion;
    }

    protected final void doSetSWState(int intSWState) {
        this.mySWState = intSWState;
    }

    protected void doSetNumber(int intNumber) {
        this.myNumber = intNumber;
    }

    protected void doSetVariant(String strVariant) {
        this.myVariant = strVariant;
    }

    protected void doSetUnitName(String strUnitname) {
        this.myUnitname = strUnitname;
    }

    protected void doSetDistName(String strDistName) {
        this.myDistName = strDistName;
    }

    protected final void doSetManufacturer(String strManufacturer) {
        this.myManufacturer = strManufacturer;
    }

    protected final void doSetState(int intState) {
        this.myState = intState;
    }

    protected final void doSetOperationalState(int intOperationalState) {
        this.myOperationalState = intOperationalState;
    }

    protected final void doSetBlockingState(int intBlockingState) {
        this.myBlockingState = intBlockingState;
    }

    protected final void doSetLedColour(String ledColour) {
        this.myLedColour = ledColour;
    }

    protected final void doSetCommissionedStatus(Boolean commStatus) {
        this.myCommissionedStatus = commStatus;
    }

    protected final void doSetInputVoltage(InputVoltage inputVoltage) {
        this.myInputVoltage = inputVoltage;
    }

    protected final int doGetSiteId() {
        return this.mySiteId;
    }

    protected final void doAddRelationCellId(int intCellId) {
        Integer integer = intCellId;
        if (!this.myCellIds.contains(integer)) {
            this.myCellIds.add(integer);
        }
    }

    private void checkAndBlockWhileHWModelBuild() {
        this.myLogger.debug((Object)"checkblock start.");
        while (!this.myBTSConfigurationManager.isHWModelReady()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                this.myLogger.debug((Object)"rebuild model, sleep", (Throwable)e);
            }
        }
        this.myLogger.debug((Object)"checkblock released.");
    }

    @Override
    public final int getCabinetId() {
        return this.myCabinetId;
    }

    @Override
    public final boolean getExist() {
        return this.myExist;
    }

    @Override
    public final String getSerialNro() {
        return this.mySerialNro;
    }

    @Override
    public final String getChassisSerialNro() {
        return this.myChassisSerialNro;
    }

    @Override
    public final int getSubRack() {
        return this.mySubRack;
    }

    @Override
    public final String getUnitType() {
        return this.myUnitType;
    }

    @Override
    public final String getHWVersion() {
        return this.myHWVersion;
    }

    @Override
    public final List<Link> getLinks() {
        return this.myLinks;
    }

    public final InputVoltage getInputVoltage() {
        return this.myInputVoltage;
    }

    @Override
    public final Link getLink(int intId) {
        int i = 0;
        while (i < this.myLinks.size()) {
            if (this.myLinks.get(i).getId() == intId) {
                return this.myLinks.get(i);
            }
            ++i;
        }
        return null;
    }

    protected final void doAddLink(Link link) {
        if (link != null && this.myLinks != null) {
            this.myLinks.add(link);
        }
    }

    protected final void doDeleteLink(Link link) {
        if (link != null && this.myLinks != null) {
            this.myLinks.remove(link);
        }
    }

    @Override
    public final String getProductCode() {
        return this.myProductCode;
    }

    @Override
    public final String getChassisProductCode() {
        return this.myChassisProductCode;
    }

    @Override
    public final void setName(String strUnitName) {
        this.myName = strUnitName;
    }

    @Override
    public final String getName() {
        return this.myName;
    }

    @Override
    public void block(final ChangeStateListener listener) {
        if (this.isEditable()) {
            throw new UnsupportedOperationException("Cannot block editable unit");
        }
        CoreAssetThread worker = new CoreAssetThread(){

            protected Object construct() {
                if (CoreAsset.isSnapshotOpening()) {
                    UnitImpl.this.myLogger.debug((Object)"Not supported in snapshot open mode.");
                    listener.stateChangeFailed(85);
                    return false;
                }
                int seqNumber = UnitImpl.this.myConnection.createScenario();
                ChangeObjectBlockingStateRequest blockRequest = new ChangeObjectBlockingStateRequest(seqNumber, UnitImpl.this.getId(), 56, 12);
                UnitImpl.this.myConnection.sendToBTS((BTSMessage)blockRequest);
                BTSMessage response = UnitImpl.this.myConnection.receiveFromBTS(seqNumber);
                if (response instanceof Ack) {
                    Ack ackResponse = (Ack)response;
                    if (!ackResponse.getAck()) {
                        listener.stateChangeRequestDenied(ackResponse.getNackReason());
                        UnitImpl.this.myConnection.deleteScenario(seqNumber);
                        return false;
                    }
                    listener.stateChangeRequestAccepted();
                    response = UnitImpl.this.myConnection.receiveFromBTS(seqNumber);
                    if (response instanceof BlockOperationsCompleted) {
                        BlockOperationsCompleted blockOperResponse = (BlockOperationsCompleted)response;
                        int successCode = blockOperResponse.getSuccessCode();
                        UnitImpl.this.myConnection.deleteScenario(seqNumber);
                        if (successCode == 36) {
                            return true;
                        }
                        UnitImpl.this.checkAndBlockWhileHWModelBuild();
                        listener.stateChangeFailed(successCode);
                        return false;
                    }
                }
                UnitImpl.this.myConnection.deleteScenario(seqNumber);
                UnitImpl.this.checkAndBlockWhileHWModelBuild();
                if (response == null) {
                    listener.stateChangeFailed(87);
                    return false;
                }
                listener.stateChangeFailed(28);
                return false;
            }

            protected void finished() {
                try {
                    UnitImpl.this.checkAndBlockWhileHWModelBuild();
                    if (((Boolean)this.get()).booleanValue()) {
                        listener.stateChangeCompleted();
                    }
                }
                catch (Exception e) {
                    UnitImpl.this.myLogger.error((Object)"block finished", (Throwable)e);
                    listener.stateChangeFailed(30);
                }
            }
        };
        worker.start();
    }

    @Override
    public void unblock(final ChangeStateListener listener) {
        if (this.isEditable()) {
            throw new UnsupportedOperationException("Cannot unblock editable unit");
        }
        CoreAssetThread worker = new CoreAssetThread(){

            protected Object construct() {
                if (CoreAsset.isSnapshotOpening()) {
                    UnitImpl.this.myLogger.debug((Object)"Not supported in snapshot open mode.");
                    listener.stateChangeFailed(85);
                    return false;
                }
                int seqNumber = UnitImpl.this.myConnection.createScenario(true);
                ChangeObjectBlockingStateRequest unblockRequest = new ChangeObjectBlockingStateRequest(seqNumber, UnitImpl.this.getId(), 56, 13);
                UnitImpl.this.myConnection.sendToBTS((BTSMessage)unblockRequest);
                BTSMessage response = UnitImpl.this.myConnection.receiveFromBTS(seqNumber);
                if (response instanceof Ack) {
                    Ack ackResponse = (Ack)response;
                    if (!ackResponse.getAck()) {
                        listener.stateChangeRequestDenied(ackResponse.getNackReason());
                        UnitImpl.this.myConnection.deleteScenario(seqNumber);
                        return false;
                    }
                    listener.stateChangeRequestAccepted();
                    response = UnitImpl.this.myConnection.receiveFromBTS(seqNumber);
                    if (response instanceof BlockOperationsCompleted) {
                        BlockOperationsCompleted blockOperResponse = (BlockOperationsCompleted)response;
                        int responseCode = blockOperResponse.getSuccessCode();
                        UnitImpl.this.myConnection.deleteScenario(seqNumber);
                        if (responseCode == 36) {
                            return true;
                        }
                        UnitImpl.this.checkAndBlockWhileHWModelBuild();
                        listener.stateChangeFailed(responseCode);
                        return false;
                    }
                }
                UnitImpl.this.myConnection.deleteScenario(seqNumber);
                UnitImpl.this.checkAndBlockWhileHWModelBuild();
                if (response == null) {
                    listener.stateChangeFailed(87);
                    return false;
                }
                listener.stateChangeFailed(28);
                return false;
            }

            protected void finished() {
                try {
                    UnitImpl.this.checkAndBlockWhileHWModelBuild();
                    if (((Boolean)this.get()).booleanValue()) {
                        listener.stateChangeCompleted();
                    }
                }
                catch (Exception e) {
                    UnitImpl.this.myLogger.error((Object)"unblock finished", (Throwable)e);
                    listener.stateChangeFailed(30);
                }
            }
        };
        worker.start();
    }

    @Override
    public SubUnit getSubUnit(int intId) {
        int i = 0;
        int size = this.mySubUnits.size();
        while (i < size) {
            SubUnit subUnit = this.mySubUnits.get(i);
            if (subUnit.getId() == intId) {
                return subUnit;
            }
            ++i;
        }
        return null;
    }

    protected final void doAddSubUnit(SubUnit subUnit) {
        if (subUnit != null && this.mySubUnits != null) {
            this.mySubUnits.add(subUnit);
            if (this.mySite != null) {
                this.mySite.upateMaxObjectId(subUnit.getId());
            }
        }
    }

    protected final void doDeleteSubUnit(SubUnit subUnit) {
        if (subUnit != null && this.mySubUnits != null) {
            this.mySubUnits.remove(subUnit);
        }
    }

    @Override
    public List<SubUnit> getSubUnits() {
        ArrayList returnList = (ArrayList)((ArrayList)this.mySubUnits).clone();
        Collections.sort(returnList, this.mySubUnitComparator);
        return returnList;
    }

    @Override
    public final int getNumber() {
        return this.myNumber;
    }

    @Override
    public final String getVariant() {
        return this.myVariant;
    }

    @Override
    public final String getUnitName() {
        return this.myUnitname;
    }

    @Override
    public final String getDistName() {
        return this.myDistName;
    }

    @Override
    public final String getManufacturer() {
        return this.myManufacturer;
    }

    @Override
    public final int getSWState() {
        return this.mySWState;
    }

    @Override
    public final int getOperationalState() {
        return this.myOperationalState;
    }

    public final int getSiteOperationalStatus() {
        return this.mySiteOperationalStatus;
    }

    @Override
    public final int getState() {
        return this.myState;
    }

    @Override
    public final int getBlockingState() {
        return this.myBlockingState;
    }

    @Override
    public Unit getEditableCopy() {
        if (this.isEditable()) {
            throw new UnsupportedOperationException("This unit is already editable");
        }
        UnitImpl u = new UnitImpl(this);
        u.doSetParentUnitId(this.getParentUnitId());
        return u;
    }

    @Override
    public final RackShelfSlot getRackShelfSlot() {
        return this.myRackShelfSlot;
    }

    @Override
    public Site getSite() {
        return this.isEditable() ? this.mySite : this.myBTSConfigurationManager.getSite();
    }

    @Override
    protected final void update(BTSConfigObject btsConfigObject) {
        if (btsConfigObject instanceof UnitImpl && btsConfigObject != null) {
            try {
                UnitImpl newUnit = (UnitImpl)btsConfigObject;
                this.doSetSiteId(newUnit.doGetSiteId());
                this.doSetCabinetId(newUnit.getCabinetId());
                this.doSetId(newUnit.getId());
                this.setObjectType(newUnit.getObjectType());
                this.doSetExist(newUnit.getExist());
                this.doSetProductCode(newUnit.getProductCode());
                this.doSetChassisProductCode(newUnit.getChassisProductCode());
                this.myRackShelfSlot.setRack(newUnit.getRackShelfSlot().getRack());
                this.doSetSerialNro(newUnit.getSerialNro());
                this.doSetChassisSerialNro(newUnit.getChassisSerialNro());
                this.myRackShelfSlot.setShelf(newUnit.getRackShelfSlot().getShelf());
                this.myRackShelfSlot.setSlot(newUnit.getRackShelfSlot().getSlot());
                this.doSetUnitType(newUnit.getUnitType());
                this.doSetUnitName(newUnit.getUnitName());
                this.doSetHWVersion(newUnit.getHWVersion());
                this.doSetSWState(newUnit.getSWState());
                this.doSetManufacturer(newUnit.getManufacturer());
                this.doSetNumber(newUnit.getNumber());
                this.doSetVariant(newUnit.getVariant());
                this.doSetSubRack(newUnit.getSubRack());
                this.doSetState(newUnit.getState());
                this.doSetOperationalState(newUnit.getOperationalState());
                this.doSetBlockingState(newUnit.getBlockingState());
                this.doSetLedColour(newUnit.getLedColour());
                this.doSetCommissionedStatus(newUnit.getCommissionedStatus());
                this.doSetCustomAttributes(newUnit.getCustomAttributes());
                this.doSetInputVoltage(newUnit.getInputVoltage());
            }
            catch (Exception e) {
                this.myLogger.error((Object)e.toString());
            }
        } else {
            this.myLogger.error((Object)("Unable to update Unit using " + btsConfigObject));
        }
    }

    @Override
    public List<Cell> getCells() {
        ArrayList<Cell> cells = new ArrayList<Cell>(10);
        int i = 0;
        while (i < this.myCellIds.size()) {
            Integer someInteger = this.myCellIds.get(i);
            Cell someCell = this.myBTSConfigurationManager.getSite().getCell(someInteger);
            if (someCell != null) {
                cells.add(someCell);
            }
            ++i;
        }
        return cells;
    }

    @Override
    public String getLedColour() {
        return this.myLedColour;
    }

    @Override
    public Boolean getCommissionedStatus() {
        return this.myCommissionedStatus;
    }

    @Override
    public List<CellGroup> getCellGroups() {
        return this.myCellGroup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Integer> getRelatedUnitIds() {
        List<Integer> list = this.myRelationUnitIds;
        synchronized (list) {
            return new ArrayList<Integer>(this.myRelationUnitIds);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Unit> getRelatedUnits() {
        if (this.isEditable()) {
            return this.myRelatedUnits;
        }
        ArrayList<Unit> returnUnits = new ArrayList<Unit>();
        try {
            List<Integer> list = this.myRelationUnitIds;
            synchronized (list) {
                Cabinet cabinet = this.myBTSConfigurationManager.getSite().getCabinet();
                for (Integer unitId : this.myRelationUnitIds) {
                    Unit unit = cabinet.getUnit(unitId);
                    if (unit != null) {
                        returnUnits.add(unit);
                        continue;
                    }
                    this.myLogger.debug((Object)("Mismatch unit relation with id " + unitId + ", myId is " + this.getId()));
                }
            }
        }
        catch (Exception e) {
            this.myLogger.warn((Object)"Unexpected during relation unit relation search. ", (Throwable)e);
        }
        return returnUnits;
    }

    @Override
    public List<Integer> getContainedUnitIds() {
        if (this.isEditable()) {
            ArrayList<Integer> ids = new ArrayList<Integer>();
            for (Unit unit : this.getContainedUnits()) {
                int id = unit.getId();
                if (ids.contains(id)) continue;
                ids.add(id);
            }
            return ids;
        }
        return this.myRelationContainedUnitIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Unit> getContainedUnits() {
        if (this.isEditable()) {
            return this.myContainedUnits;
        }
        ArrayList<Unit> returnUnits = new ArrayList<Unit>();
        try {
            List<Integer> list = this.myRelationContainedUnitIds;
            synchronized (list) {
                Site site = this.myBTSConfigurationManager.getSite();
                Cabinet cabinet = site.getCabinet();
                for (Integer unitId : this.myRelationContainedUnitIds) {
                    Unit unit = cabinet.getUnit(unitId);
                    if (unit != null) {
                        returnUnits.add(unit);
                        continue;
                    }
                    this.myLogger.debug((Object)("Mismatch unit contained relation with id " + unitId + ", myId is " + this.getId()));
                }
            }
        }
        catch (Exception e) {
            this.myLogger.warn((Object)"Unexpected during relation unit relation search. ", (Throwable)e);
        }
        return returnUnits;
    }

    @Override
    public int getParentUnitId() {
        return this.myParentUnitId;
    }

    @Override
    public void addSubUnit(SubUnit subUnit) {
        if (!this.isEditable()) {
            throw new UnsupportedOperationException("Operation not supported in online model");
        }
        if (subUnit != null) {
            if (subUnit.getId() == -1 && subUnit instanceof SubUnitImpl) {
                if (this.mySite != null) {
                    ((SubUnitImpl)subUnit).doSetId(this.mySite.getAvailableId());
                    this.myLogger.debug((Object)("Assigned id " + subUnit.getId() + " to sub unit " + subUnit.getName()));
                } else {
                    this.myLogger.error((Object)"Cannot assign id to a sub unit because site has not been set for the parent unit");
                }
            } else if (this.mySite != null) {
                this.mySite.upateMaxObjectId(subUnit.getId());
            }
            subUnit.setParentUnit(this);
            this.mySubUnits.add(subUnit);
            this.sendChildAdded(subUnit.getId(), 14);
        } else {
            this.myLogger.error((Object)"Cannot add null sub unit");
        }
    }

    @Override
    public void deleteSubUnit(SubUnit subUnit) {
        if (!this.isEditable()) {
            throw new UnsupportedOperationException("Operation not supported in online model");
        }
        if (subUnit != null) {
            this.sendChildRemoved(subUnit.getId(), 14);
            this.mySubUnits.remove(subUnit);
            subUnit.sendObjectRemoved();
            subUnit.destroy();
        } else {
            this.myLogger.error((Object)"Cannot delete null sub unit");
        }
    }

    @Override
    public void deleteSubUnit(int id) {
        if (!this.isEditable()) {
            throw new UnsupportedOperationException("Operation not supported in online model");
        }
        this.deleteSubUnit(this.getSubUnit(id));
    }

    @Override
    public void setNumber(int number) {
        if (!this.isEditable()) {
            throw new UnsupportedOperationException("Operation not supported in online model");
        }
        this.doSetNumber(number);
        this.sendObjectChanged();
    }

    @Override
    public void setProductCode(String code) {
        if (!this.isEditable()) {
            throw new UnsupportedOperationException("Operation not supported in online model");
        }
        this.doSetProductCode(code);
        this.sendObjectChanged();
    }

    @Override
    public void setUnitType(String type) {
        if (!this.isEditable()) {
            throw new UnsupportedOperationException("Operation not supported in online model");
        }
        this.doSetUnitType(type);
        this.sendObjectChanged();
    }

    @Override
    public void setVariant(String variant) {
        if (!this.isEditable()) {
            throw new UnsupportedOperationException("Operation not supported in online model");
        }
        this.doSetVariant(variant);
        this.sendObjectChanged();
    }

    @Override
    public void setUnitName(String unitname) {
        if (!this.isEditable()) {
            throw new UnsupportedOperationException("Operation not supported in online model");
        }
        this.doSetUnitName(unitname);
        this.sendObjectChanged();
    }

    @Override
    public void setCommissionedStatus(Boolean status) {
        if (!this.isEditable()) {
            throw new UnsupportedOperationException("Operation not supported in online model");
        }
        this.doSetCommissionedStatus(status);
        this.sendObjectChanged();
    }

    @Override
    public void setCells(List<Cell> cells) {
        if (!this.isEditable()) {
            throw new UnsupportedOperationException("Operation not supported in online model");
        }
        if (cells != null) {
            this.myCells = cells;
        } else {
            this.myLogger.error((Object)"Cannot set null cells");
        }
    }

    @Override
    public void addCell(Cell cell) {
        if (!this.isEditable()) {
            throw new UnsupportedOperationException("Operation not supported in online model");
        }
        if (cell != null) {
            this.myCells.add(cell);
        } else {
            this.myLogger.error((Object)"Cannot add null cell");
        }
    }

    @Override
    public void removeCell(Cell cell) {
        if (!this.isEditable()) {
            throw new UnsupportedOperationException("Operation not supported in online model");
        }
        this.myCells.remove(cell);
    }

    @Override
    public void removeCell(int id) {
        if (!this.isEditable()) {
            throw new UnsupportedOperationException("Operation not supported in online model");
        }
        this.myCells.remove(this.getCell(id));
    }

    @Override
    public Cell getCell(int id) {
        int i = 0;
        while (i < this.myCellIds.size()) {
            if (this.myCellIds.get(i) == id) {
                return this.myBTSConfigurationManager.getSite().getCell(this.myCellIds.get(i));
            }
            ++i;
        }
        return null;
    }

    @Override
    public void addContainedUnit(Unit unit) {
        if (!this.isEditable()) {
            throw new UnsupportedOperationException("Operation not supported in online model");
        }
        if (unit != null) {
            if (unit.getParentUnit() != null) {
                unit.getParentUnit().removeContainedUnit(unit);
            }
            this.myContainedUnits.add(unit);
            unit.setParentUnit(this);
        } else {
            this.myLogger.error((Object)"Cannot add null contained unit");
        }
    }

    @Override
    public void addRelatedUnit(Unit unit) {
        if (!this.isEditable()) {
            throw new UnsupportedOperationException("Operation not supported in online model");
        }
        if (unit != null) {
            this.myRelatedUnits.add(unit);
        } else {
            this.myLogger.error((Object)"Cannot add null related unit");
        }
    }

    @Override
    public void removeContainedUnit(Unit unit) {
        if (!this.isEditable()) {
            throw new UnsupportedOperationException("Operation not supported in online model");
        }
        if (unit != null) {
            unit.setParentUnit(null);
            this.myContainedUnits.remove(unit);
        }
    }

    @Override
    public void removeContainedUnit(int id) {
        if (!this.isEditable()) {
            throw new UnsupportedOperationException("Operation not supported in online model");
        }
        this.removeContainedUnit(this.getContainedUnit(id));
    }

    @Override
    public void removeRelatedUnit(Unit unit) {
        if (!this.isEditable()) {
            throw new UnsupportedOperationException("Operation not supported in online model");
        }
        this.myRelatedUnits.remove(unit);
    }

    @Override
    public void removeRelatedUnit(int id) {
        if (!this.isEditable()) {
            throw new UnsupportedOperationException("Operation not supported in online model");
        }
        this.myRelatedUnits.remove(this.getContainedUnit(id));
    }

    @Override
    public Unit getContainedUnit(int id) {
        for (Unit unit : this.getContainedUnits()) {
            if (unit.getId() != id) continue;
            return unit;
        }
        return null;
    }

    @Override
    public Unit getRelatedUnit(int id) {
        for (Unit unit : this.getRelatedUnits()) {
            if (unit.getId() != id) continue;
            return unit;
        }
        return null;
    }

    @Override
    public Cabinet getCabinet() {
        if (!this.isEditable()) {
            return this.myBTSConfigurationManager.getSite().getCabinet();
        }
        return this.myCabinet;
    }

    @Override
    public void setSite(Site s) {
        if (!this.isEditable()) {
            throw new UnsupportedOperationException("Operation not supported in online model");
        }
        if (s != null) {
            this.mySite = s;
        } else {
            this.myLogger.error((Object)"Cannot set null site");
        }
    }

    @Override
    public void destroy() {
        if (!this.isEditable()) {
            throw new UnsupportedOperationException("Operation not supported in online model");
        }
        int i = 0;
        int size = this.mySubUnits.size();
        while (i < size) {
            this.mySubUnits.get(i).destroy();
            ++i;
        }
        this.mySubUnits.clear();
        this.myCells.clear();
        this.myContainedUnits.clear();
        this.myRelatedUnits.clear();
    }

    @Override
    public void setCabinet(Cabinet cabinet) {
        if (!this.isEditable()) {
            throw new UnsupportedOperationException("Operation not supported in online model");
        }
        if (cabinet != null) {
            this.myCabinet = cabinet;
        } else {
            this.myLogger.error((Object)"Cannot set null cabinet");
        }
    }

    @Override
    public Unit getParentUnit() {
        if (!this.isEditable()) {
            return this.myBTSConfigurationManager.getSite().getUnit(this.getParentUnitId());
        }
        return this.myParentUnit;
    }

    @Override
    public void setParentUnit(Unit unit) {
        if (!this.isEditable()) {
            throw new UnsupportedOperationException("Operation not supported in online model");
        }
        this.myParentUnit = unit;
    }

    @Override
    public void setExist(boolean blnExist) {
        if (!this.isEditable()) {
            throw new UnsupportedOperationException("Operation not supported in online model");
        }
        this.doSetExist(blnExist);
        this.sendObjectChanged();
    }

    @Override
    public void setSlot(int intSlot) {
        if (!this.isEditable()) {
            throw new UnsupportedOperationException("Operation not supported in online model");
        }
        this.doSetSlot(intSlot);
    }

    @Override
    public void setSerialNro(String strSerialNro) {
        if (!this.isEditable()) {
            throw new UnsupportedOperationException("Operation not supported in online model");
        }
        this.doSetSerialNro(strSerialNro);
    }

    @Override
    public void setSWState(int swState) {
        if (!this.isEditable()) {
            throw new UnsupportedOperationException("Operation not supported in online model");
        }
        this.doSetSWState(swState);
        this.sendObjectChanged();
    }

    @Override
    public void setManufacturer(String strManufacturer) {
        if (!this.isEditable()) {
            throw new UnsupportedOperationException("Operation not supported in online model");
        }
        this.doSetManufacturer(strManufacturer);
    }

    public String toString() {
        return String.valueOf(this.myUnitType) + this.myVariant + this.myNumber + " (id=" + this.getId() + ")";
    }

    @Override
    public int getUnitId() {
        return this.getId();
    }
}

