/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.message;

import com.nokia.em.bts.coreasset.scenario.btstests.BtsTest;
import com.nokia.em.bts.rp.master.message.BTSInboundMessage;
import java.util.Vector;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ActiveTestListResponse
extends BTSInboundMessage {
    private final Vector myActiveTests;
    private int mySequenceNumber;
    private BtsTest myTest;
    private boolean myOwned;
    private String myTestType;
    private static final String ACTIVE_TEST_NODENAME = "ActiveTest";
    private static final String TESTINFO_NODENAME = "_testInfo";
    private static final String SEQUENCE_NUMBER_NODENAME = "_seqNumber";
    private static final String OWNED_NODENAME = "_owned";
    private static final String OWNED_TRUE_NODEVALUE = "true";
    private static final String OWNED_FALSE_NODEVALUE = "false";

    public ActiveTestListResponse(int intSeqNbr, String strTestType, int intSequenceNumber, boolean blnOwned) {
        super(intSeqNbr);
        this.myTestType = strTestType;
        this.mySequenceNumber = intSequenceNumber;
        this.myOwned = blnOwned;
        this.myTest = new BtsTest(strTestType, intSequenceNumber, blnOwned);
        this.myActiveTests = new Vector(10);
        this.myActiveTests.addElement(this.myTest);
    }

    public ActiveTestListResponse(int intSeqNbr, Node xmlNode) throws Exception {
        super(intSeqNbr);
        this.mySequenceNumber = -1;
        this.myTestType = "Coreasset_Unknown";
        this.myActiveTests = new Vector(10);
        this.myOwned = false;
        this.myTest = null;
        NodeList nodeList = xmlNode.getOwnerDocument().getElementsByTagName(ACTIVE_TEST_NODENAME);
        if (nodeList.getLength() == 0) {
            return;
        }
        int i = 0;
        while (i < nodeList.getLength()) {
            Node activeTestNode = nodeList.item(i);
            if (activeTestNode.hasChildNodes()) {
                NodeList activeTestChildNodeList = activeTestNode.getChildNodes();
                this.myTest = null;
                this.mySequenceNumber = -1;
                this.myTestType = "Coreasset_Unknown";
                int j = 0;
                while (j < activeTestChildNodeList.getLength()) {
                    Node activeTestChildNode = activeTestChildNodeList.item(j);
                    if (activeTestChildNode.getNodeName().equals(TESTINFO_NODENAME)) {
                        this.myTestType = activeTestChildNode.getFirstChild().getNodeValue().trim();
                    } else if (activeTestChildNode.getNodeName().equals(SEQUENCE_NUMBER_NODENAME)) {
                        this.mySequenceNumber = Integer.parseInt(activeTestChildNode.getFirstChild().getNodeValue().trim());
                    } else if (activeTestChildNode.getNodeName().equals(OWNED_NODENAME)) {
                        if (activeTestChildNode.getFirstChild().getNodeValue().trim().equalsIgnoreCase(OWNED_TRUE_NODEVALUE)) {
                            this.myOwned = true;
                        } else if (activeTestChildNode.getFirstChild().getNodeValue().trim().equalsIgnoreCase(OWNED_FALSE_NODEVALUE)) {
                            this.myOwned = false;
                        }
                    }
                    ++j;
                }
                this.myTest = new BtsTest(this.myTestType, this.mySequenceNumber, this.myOwned);
                this.myActiveTests.addElement(this.myTest);
            }
            ++i;
        }
    }

    public Vector getActiveTests() {
        return this.myActiveTests;
    }
}

