/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.message;

import com.nokia.em.bts.coreasset.message.ActiveTestListResponse;
import com.nokia.em.bts.coreasset.message.BatteryBackupTimeNotification;
import com.nokia.em.bts.coreasset.message.BinDataNotification;
import com.nokia.em.bts.coreasset.message.BinDataResponse;
import com.nokia.em.bts.coreasset.message.BlockOperationsCompleted;
import com.nokia.em.bts.coreasset.message.ChangeModeResponse;
import com.nokia.em.bts.coreasset.message.ClockOperationTerminated;
import com.nokia.em.bts.coreasset.message.ConfigurationChangeNotification;
import com.nokia.em.bts.coreasset.message.DataChangeNotif;
import com.nokia.em.bts.coreasset.message.DatabaseFileCreated;
import com.nokia.em.bts.coreasset.message.DownloadProgressNotif;
import com.nokia.em.bts.coreasset.message.EACInputEnableChangeReply;
import com.nokia.em.bts.coreasset.message.EACOutputStateChangeReply;
import com.nokia.em.bts.coreasset.message.ESTModuleTestResultNotif;
import com.nokia.em.bts.coreasset.message.ExtendedLoggingModeResponse;
import com.nokia.em.bts.coreasset.message.ExtendedLoggingModeStatusResponse;
import com.nokia.em.bts.coreasset.message.ExtendedLoggingModeStatusUpdate;
import com.nokia.em.bts.coreasset.message.FileActivationAck;
import com.nokia.em.bts.coreasset.message.FrequencyHistoryResponse;
import com.nokia.em.bts.coreasset.message.GetAutoconnTrsParamsResponse;
import com.nokia.em.bts.coreasset.message.GetBeamDataResponse;
import com.nokia.em.bts.coreasset.message.GetDirectionDataResponse;
import com.nokia.em.bts.coreasset.message.GetRAEPropertiesResponse;
import com.nokia.em.bts.coreasset.message.GetWeightDataResponse;
import com.nokia.em.bts.coreasset.message.LicenceFileDeleteReply;
import com.nokia.em.bts.coreasset.message.LicenceQueryReply;
import com.nokia.em.bts.coreasset.message.LicenceUpToDate;
import com.nokia.em.bts.coreasset.message.LicencedAck;
import com.nokia.em.bts.coreasset.message.MultipleCoreAvailabilityNotif;
import com.nokia.em.bts.coreasset.message.MultipleCoreAvailabilityRequest;
import com.nokia.em.bts.coreasset.message.MultipleCoreAvailabilityResponse;
import com.nokia.em.bts.coreasset.message.OperationFeedback;
import com.nokia.em.bts.coreasset.message.PowerOperationsCompleted;
import com.nokia.em.bts.coreasset.message.PrepareMultipleCoreModelCompleted;
import com.nokia.em.bts.coreasset.message.PrepareMultipleCoreModelRequest;
import com.nokia.em.bts.coreasset.message.RadParamsGetResponse;
import com.nokia.em.bts.coreasset.message.RadParamsSetResponse;
import com.nokia.em.bts.coreasset.message.ReadDACWordReply;
import com.nokia.em.bts.coreasset.message.ResetWeightResponse;
import com.nokia.em.bts.coreasset.message.SFPDiagnosticDataMonitoringNotification;
import com.nokia.em.bts.coreasset.message.SWRollbackReply;
import com.nokia.em.bts.coreasset.message.SWUpToDate;
import com.nokia.em.bts.coreasset.message.SWUpdateReportResponse;
import com.nokia.em.bts.coreasset.message.SWVersionReply;
import com.nokia.em.bts.coreasset.message.SelfTestReportResponse;
import com.nokia.em.bts.coreasset.message.SetEstLevelResponse;
import com.nokia.em.bts.coreasset.message.StartTestResponse;
import com.nokia.em.bts.coreasset.message.StopTestResponse;
import com.nokia.em.bts.coreasset.message.TestCompletedNotif;
import com.nokia.em.bts.coreasset.message.TestDedicatedStateResponse;
import com.nokia.em.bts.coreasset.message.TestProgressResponse;
import com.nokia.em.bts.coreasset.message.TestReportNotifCab;
import com.nokia.em.bts.coreasset.message.TestReportResponse;
import com.nokia.em.bts.coreasset.message.TestReportResponseBER;
import com.nokia.em.bts.coreasset.message.TestReportResponseLTEUL;
import com.nokia.em.bts.coreasset.message.TestStatusResponse;
import com.nokia.em.bts.coreasset.message.UploadBTSTechLogResponse;
import com.nokia.em.bts.coreasset.message.VSWRMonitoringNotification;
import com.nokia.em.bts.coreasset.message.VSWRThresholdTuningStartResponse;
import com.nokia.em.bts.coreasset.scenario.acnonopbackhaulparams.GetACNonOpBackhaulParamsResponse;
import com.nokia.em.bts.rp.master.connection.HttpContent;
import com.nokia.em.bts.rp.master.connection.MessageFactory;
import com.nokia.em.bts.rp.master.message.BTSMessage;
import java.io.ByteArrayInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class BTSMessageFactory
implements MessageFactory {
    private DocumentBuilder myDocBuilder;
    private final ErrorHandler myErrorHandler;
    private final Logger myLogger = Logger.getLogger(this.getClass());
    private static final String SEQ_NUMBER = "_seqNumber";
    private static final String BTS_ID = "_btsId";
    private static final String SESSION_ID = "_sessionId";
    private static final String HEADER = "BTSMessageHdr";
    private static final String MESSAGE = "BTSMessage";

    public BTSMessageFactory() {
        this.myErrorHandler = new ErrorHandler(){

            @Override
            public void error(SAXParseException exception) {
            }

            @Override
            public void fatalError(SAXParseException exception) {
            }

            @Override
            public void warning(SAXParseException exception) {
            }
        };
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        docBuilderFactory.setValidating(true);
        try {
            this.myDocBuilder = docBuilderFactory.newDocumentBuilder();
            this.myDocBuilder.setErrorHandler(this.myErrorHandler);
        }
        catch (ParserConfigurationException e) {
            this.myLogger.error((Object)"Unable to create DocumentBuilder: ", (Throwable)e);
        }
    }

    public synchronized BTSMessage createMessage(HttpContent content) throws InstantiationException {
        Object ret;
        block136: {
            ret = null;
            int seqNbr = 0;
            int btsId = 0;
            int sessionId = 0;
            String mesType = null;
            try {
                Document doc = this.myDocBuilder.parse(new ByteArrayInputStream(content.getContent().getBytes()));
                Element root = doc.getDocumentElement();
                if (root.getNodeName().compareTo(MESSAGE) != 0) break block136;
                NodeList nList = root.getChildNodes();
                int i = 0;
                while (i < nList.getLength()) {
                    if (nList.item(i).getNodeName().compareTo(HEADER) == 0) {
                        NodeList n1List = nList.item(i).getChildNodes();
                        int j = 0;
                        while (j < n1List.getLength()) {
                            if (n1List.item(j).getNodeName().compareTo(SEQ_NUMBER) == 0) {
                                seqNbr = Integer.parseInt(n1List.item(j).getFirstChild().getNodeValue().trim());
                            } else if (n1List.item(j).getNodeName().compareTo(BTS_ID) == 0) {
                                btsId = Integer.parseInt(n1List.item(j).getFirstChild().getNodeValue().trim());
                            } else if (n1List.item(j).getNodeName().compareTo(SESSION_ID) == 0) {
                                sessionId = Integer.parseInt(n1List.item(j).getFirstChild().getNodeValue().trim());
                            }
                            ++j;
                        }
                    } else {
                        mesType = nList.item(i).getNodeName();
                        Node xmlNode = nList.item(i);
                        if (mesType.compareTo("ClockOperationTerminated") == 0) {
                            ret = new ClockOperationTerminated(seqNbr, xmlNode);
                        } else if (mesType.compareTo("DatabaseFileCreated") == 0) {
                            ret = new DatabaseFileCreated(seqNbr, xmlNode);
                        } else if (mesType.compareTo("SWUpToDate") == 0) {
                            ret = new SWUpToDate(seqNbr, xmlNode);
                        } else if (mesType.compareTo("SWVersionReply") == 0) {
                            ret = new SWVersionReply(seqNbr, xmlNode);
                        } else if (mesType.compareTo("StartTestResponse") == 0) {
                            ret = new StartTestResponse(seqNbr, xmlNode);
                        } else if (mesType.compareTo("TestCompletedNotif") == 0) {
                            ret = new TestCompletedNotif(seqNbr, xmlNode);
                        } else if (mesType.compareTo("StopTestResponse") == 0) {
                            ret = new StopTestResponse(seqNbr, xmlNode);
                        } else if (mesType.compareTo("TestReportResponse") == 0) {
                            ret = new TestReportResponse(seqNbr, xmlNode);
                        } else if (mesType.compareTo("TestStatusResponse") == 0) {
                            ret = new TestStatusResponse(seqNbr, xmlNode);
                        } else if (mesType.compareTo("TestProgressResponse") == 0) {
                            ret = new TestProgressResponse(seqNbr, xmlNode);
                        } else if (mesType.compareTo("DataChangeNotif") == 0) {
                            ret = new DataChangeNotif(seqNbr, xmlNode);
                        } else if (mesType.compareTo("DownloadProgressNotif") == 0) {
                            ret = new DownloadProgressNotif(seqNbr, xmlNode);
                        } else if (mesType.compareTo("BlockOperationsCompleted") == 0) {
                            ret = new BlockOperationsCompleted(seqNbr, xmlNode);
                        } else if ("EACInputEnableChangeReply".equals(mesType)) {
                            ret = new EACInputEnableChangeReply(seqNbr, xmlNode);
                        } else if ("EACOutputStateChangeReply".equals(mesType)) {
                            ret = new EACOutputStateChangeReply(seqNbr, xmlNode);
                        } else if ("ReadDACWordReply".equals(mesType)) {
                            ret = new ReadDACWordReply(seqNbr, xmlNode);
                        } else if ("BatteryBackupTimeNotification".equals(mesType)) {
                            ret = new BatteryBackupTimeNotification(seqNbr, xmlNode);
                        } else if ("TestDedicatedStateResponse".equals(mesType)) {
                            ret = new TestDedicatedStateResponse(seqNbr, xmlNode);
                        } else if ("TestReportResponseBER".equals(mesType)) {
                            ret = new TestReportResponseBER(seqNbr, xmlNode);
                        } else if ("TestReportResponseLTEUL".equals(mesType)) {
                            ret = new TestReportResponseLTEUL(seqNbr, xmlNode);
                        } else if ("ActiveTestListResponse".equals(mesType)) {
                            ret = new ActiveTestListResponse(seqNbr, xmlNode);
                        } else if ("UploadBTSTechLogResponse".equals(mesType)) {
                            ret = new UploadBTSTechLogResponse(seqNbr, xmlNode);
                        } else if ("FrequencyHistoryResponse".equals(mesType)) {
                            ret = new FrequencyHistoryResponse(seqNbr, xmlNode);
                        } else if ("LicenceFileDeleteReply".equals(mesType)) {
                            ret = new LicenceFileDeleteReply(seqNbr, xmlNode);
                        } else if ("LicenceQueryReply".equals(mesType)) {
                            ret = new LicenceQueryReply(seqNbr, xmlNode);
                        } else if ("LicenceUpToDate".equals(mesType)) {
                            ret = new LicenceUpToDate(seqNbr, xmlNode);
                        } else if ("ChangeModeResponse".equals(mesType)) {
                            ret = new ChangeModeResponse(seqNbr, xmlNode);
                        } else if ("TestReportNotifCab".equals(mesType)) {
                            ret = new TestReportNotifCab(seqNbr, xmlNode);
                        } else if ("LicencedAck".equals(mesType)) {
                            ret = new LicencedAck(seqNbr, xmlNode);
                        } else if ("RadParamsGetResponse".equals(mesType)) {
                            ret = new RadParamsGetResponse(seqNbr, xmlNode);
                        } else if ("RadParamsSetResponse".equals(mesType)) {
                            ret = new RadParamsSetResponse(seqNbr, xmlNode);
                        } else if ("VSWRThresholdTuningStartResponse".equals(mesType)) {
                            ret = new VSWRThresholdTuningStartResponse(seqNbr, xmlNode);
                        } else if ("SWUpdateReportResponse".equals(mesType)) {
                            ret = new SWUpdateReportResponse(seqNbr, xmlNode);
                        } else if ("FileActivationAck".equals(mesType)) {
                            ret = new FileActivationAck(seqNbr, xmlNode);
                        } else if ("BinDataResponse".equals(mesType)) {
                            ret = new BinDataResponse(seqNbr, xmlNode);
                        } else if ("BinDataNotification".equals(mesType)) {
                            ret = new BinDataNotification(seqNbr, xmlNode);
                        } else if ("PowerOperationsCompleted".equals(mesType)) {
                            ret = new PowerOperationsCompleted(seqNbr, xmlNode);
                        } else if ("MultipleCoreAvailabilityNotif".equals(mesType)) {
                            ret = new MultipleCoreAvailabilityNotif(seqNbr);
                        } else if ("MultipleCoreAvailabilityRequest".equals(mesType)) {
                            ret = new MultipleCoreAvailabilityRequest(seqNbr);
                        } else if ("MultipleCoreAvailabilityResponse".equals(mesType)) {
                            ret = new MultipleCoreAvailabilityResponse(seqNbr, xmlNode);
                        } else if ("PrepareMultipleCoreModelCompleted".equals(mesType)) {
                            ret = new PrepareMultipleCoreModelCompleted(seqNbr);
                        } else if ("PrepareMultipleCoreModelRequest".equals(mesType)) {
                            ret = new PrepareMultipleCoreModelRequest(seqNbr);
                        } else if ("ConfigurationChangeNotification".equals(mesType)) {
                            ret = new ConfigurationChangeNotification(seqNbr, xmlNode);
                        } else if ("ESTModuleTestResultNotif".equals(mesType)) {
                            ret = new ESTModuleTestResultNotif(seqNbr, xmlNode);
                        } else if ("SetEstLevelResponse".equals(mesType)) {
                            ret = new SetEstLevelResponse(seqNbr, xmlNode);
                        } else if ("ExtendedLoggingModeResponse".equals(mesType)) {
                            ret = new ExtendedLoggingModeResponse(seqNbr, xmlNode);
                        } else if ("ExtendedLoggingModeStatusResponse".equals(mesType)) {
                            ret = new ExtendedLoggingModeStatusResponse(seqNbr, xmlNode);
                        } else if ("ExtendedLoggingModeStatusUpdate".equals(mesType)) {
                            ret = new ExtendedLoggingModeStatusUpdate(seqNbr, xmlNode);
                        } else if ("GetAutoconnTrsParamsResponse".equals(mesType)) {
                            ret = new GetAutoconnTrsParamsResponse(seqNbr, xmlNode);
                        } else if ("SWRollbackReply".equals(mesType)) {
                            ret = new SWRollbackReply(seqNbr, xmlNode);
                        } else if ("SFPDiagnosticDataMonitoringNotification".equals(mesType)) {
                            ret = new SFPDiagnosticDataMonitoringNotification(seqNbr, xmlNode);
                        } else if ("VSWRMonitoringNotification".equals(mesType)) {
                            ret = new VSWRMonitoringNotification(seqNbr, xmlNode);
                        } else if ("GetACNonOpBackhaulParamsResponse".equals(mesType)) {
                            ret = new GetACNonOpBackhaulParamsResponse(seqNbr, xmlNode);
                        } else if ("GetRAEPropertiesResponse".equals(mesType)) {
                            ret = new GetRAEPropertiesResponse(seqNbr, xmlNode);
                        } else if ("ResetWeightResponse".equals(mesType)) {
                            ret = new ResetWeightResponse(seqNbr, xmlNode);
                        } else if ("GetBeamDataResponse".equals(mesType)) {
                            ret = new GetBeamDataResponse(seqNbr, xmlNode);
                        } else if ("GetDirectionDataResponse".equals(mesType)) {
                            ret = new GetDirectionDataResponse(seqNbr, xmlNode);
                        } else if ("GetWeightDataResponse".equals(mesType)) {
                            ret = new GetWeightDataResponse(seqNbr, xmlNode);
                        } else if ("OperationFeedback".equals(mesType)) {
                            ret = new OperationFeedback(seqNbr);
                        } else if ("SelfTestReportResponse".equals(mesType)) {
                            ret = new SelfTestReportResponse(seqNbr, xmlNode);
                        } else {
                            this.myLogger.trace((Object)("Unknown message type: " + mesType + ". Invalid tag or empty line in BTSMessage."));
                        }
                    }
                    if (ret != null) {
                        if (seqNbr > 0) {
                            ret.setBtsId(btsId);
                            ret.setSessionId(sessionId);
                            ret.setUnauthorized(content.getStatusCode() == 401);
                            break;
                        }
                        this.myLogger.error((Object)"Unable to create message: (BTSMesssageHdr fault)");
                        throw new InstantiationException(" instantiation failed: (BTSMesssageHdr fault)");
                    }
                    ++i;
                }
            }
            catch (SAXParseException e) {
                String strError = "** Parsing error, line " + e.getLineNumber() + ", uri " + e.getSystemId();
                this.myLogger.error((Object)("Unable to create message: " + strError));
                throw new InstantiationException(" instantiation failed: (" + e + ")");
            }
            catch (SAXException e) {
                this.myLogger.error((Object)"Unable to create message: ", (Throwable)e);
                throw new InstantiationException(" instantiation failed: (" + e + ")");
            }
            catch (Exception e) {
                this.myLogger.error((Object)"Unable to create message: ", (Throwable)e);
                throw new InstantiationException(" instantiation failed: (" + e + ")");
            }
            catch (Throwable t) {
                this.myLogger.error((Object)"Unable to create message:: ", t);
                throw new InstantiationException(" instantiation failed: (" + t + ")");
            }
        }
        return ret;
    }
}

