/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.message;

import com.nokia.em.bts.rp.master.message.BTSInboundMessage;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DataChangeNotif
extends BTSInboundMessage {
    private int myConfigObjectId;
    private int myConfigObjectType;
    private int myOperationType;
    private NodeList myObjectDataNodeList;
    private static final String CONFIG_OPERATION_TYPE_NODENAME = "_configOperationType";
    private static final String CONFIG_OPERATION_TYPE_INSERT_NODEVALUE = "insert";
    private static final String CONFIG_OPERATION_TYPE_UPDATE_NODEVALUE = "update";
    private static final String CONFIG_OPERATION_TYPE_DELETE_NODEVALUE = "delete";
    private static final String CONFIG_OBJECT_ID_NODENAME = "_configObjectId";
    private static final String CONFIG_OBJECT_TYPE_NODENAME = "_configObjectType";
    private static final String CONFIG_OBJECT_TYPE_BS_NODEVALUE = "BS";
    private static final String CONFIG_OBJECT_TYPE_UNIT_NODEVALUE = "Unit";
    private static final String CONFIG_OBJECT_TYPE_CABINET_NODEVALUE = "Cabinet";
    private static final String CONFIG_OBJECT_TYPE_LINK_NODEVALUE = "Link";
    private static final String CONFIG_OBJECT_TYPE_SUBUNIT_NODEVALUE = "Subunit";
    private static final String CONFIG_OBJECT_TYPE_CELLS_NODEVALUE = "Cells";
    private static final String CONFIG_OBJECT_TYPE_CELL_NODEVALUE = "Cell";
    private static final String CONFIG_OBJECT_TYPE_EACINPUT_NODEVALUE = "EACInput";
    private static final String CONFIG_OBJECT_TYPE_EACOUTPUT_NODEVALUE = "EACOutput";
    private static final String CONFIG_OBJECT_TYPE_OBJECT_RELATION_NODEVALUE = "ObjectRelation";
    private static final String CONFIG_OBJECT_TYPE_CELLGROUP_NODEVALUE = "CellGroup";
    private static final String OBJECT_DATA_NODENAME = "_objectData";

    public DataChangeNotif(int intSeqNbr, int intConfigObjectId, int intConfigObjectType, int intOperationType, NodeList objectDataNodeList) {
        super(intSeqNbr);
        this.myConfigObjectId = intConfigObjectId;
        this.myConfigObjectType = intConfigObjectType;
        this.myOperationType = intOperationType;
        this.myObjectDataNodeList = objectDataNodeList;
    }

    public DataChangeNotif(int intSeqNbr, Node xmlNode) throws Exception {
        super(intSeqNbr);
        this.myConfigObjectId = -1;
        this.myConfigObjectType = -1;
        this.myOperationType = -1;
        this.myObjectDataNodeList = null;
        NodeList nodeList = xmlNode.getChildNodes();
        int i = 0;
        while (i < nodeList.getLength()) {
            Node node = nodeList.item(i);
            if (node.hasChildNodes()) {
                String nodeName = node.getNodeName();
                String nodeValue = node.getFirstChild().getNodeValue();
                if (nodeValue != null) {
                    nodeValue = nodeValue.trim();
                    if (nodeName.compareToIgnoreCase(CONFIG_OPERATION_TYPE_NODENAME) == 0) {
                        this.setOperationType(nodeValue);
                    } else if (nodeName.compareTo(CONFIG_OBJECT_ID_NODENAME) == 0) {
                        this.myConfigObjectId = Integer.parseInt(nodeValue);
                    } else if (nodeName.compareTo(CONFIG_OBJECT_TYPE_NODENAME) == 0) {
                        this.setObjectType(nodeValue);
                    }
                }
                if (nodeName.compareToIgnoreCase(OBJECT_DATA_NODENAME) == 0) {
                    this.setObjectData(node.getChildNodes());
                }
            }
            ++i;
        }
    }

    public int getConfigObjectId() {
        return this.myConfigObjectId;
    }

    public final int getConfigObjectType() {
        return this.myConfigObjectType;
    }

    public final int getOperationType() {
        return this.myOperationType;
    }

    public final NodeList getConfigObjectData() {
        return this.myObjectDataNodeList;
    }

    private void setOperationType(String nodeValue) {
        if (nodeValue.compareToIgnoreCase(CONFIG_OPERATION_TYPE_UPDATE_NODEVALUE) == 0) {
            this.myOperationType = 23;
        } else if (nodeValue.compareToIgnoreCase(CONFIG_OPERATION_TYPE_INSERT_NODEVALUE) == 0) {
            this.myOperationType = 22;
        } else if (nodeValue.compareToIgnoreCase(CONFIG_OPERATION_TYPE_DELETE_NODEVALUE) == 0) {
            this.myOperationType = 24;
        }
    }

    private void setObjectType(String nodeValue) {
        if (nodeValue.compareToIgnoreCase(CONFIG_OBJECT_TYPE_UNIT_NODEVALUE) == 0) {
            this.myConfigObjectType = 10;
        } else if (nodeValue.compareToIgnoreCase(CONFIG_OBJECT_TYPE_CABINET_NODEVALUE) == 0) {
            this.myConfigObjectType = 4;
        } else if (nodeValue.compareToIgnoreCase(CONFIG_OBJECT_TYPE_LINK_NODEVALUE) == 0) {
            this.myConfigObjectType = 13;
        } else if (nodeValue.compareToIgnoreCase(CONFIG_OBJECT_TYPE_BS_NODEVALUE) == 0) {
            this.myConfigObjectType = 3;
        } else if (nodeValue.compareToIgnoreCase(CONFIG_OBJECT_TYPE_SUBUNIT_NODEVALUE) == 0) {
            this.myConfigObjectType = 14;
        } else if (nodeValue.compareToIgnoreCase(CONFIG_OBJECT_TYPE_EACINPUT_NODEVALUE) == 0) {
            this.myConfigObjectType = 11;
        } else if (nodeValue.compareToIgnoreCase(CONFIG_OBJECT_TYPE_EACOUTPUT_NODEVALUE) == 0) {
            this.myConfigObjectType = 12;
        } else if (nodeValue.compareToIgnoreCase(CONFIG_OBJECT_TYPE_CELL_NODEVALUE) == 0) {
            this.myConfigObjectType = 5;
        } else if (nodeValue.compareToIgnoreCase(CONFIG_OBJECT_TYPE_OBJECT_RELATION_NODEVALUE) == 0) {
            this.myConfigObjectType = 48;
        } else if (nodeValue.compareToIgnoreCase(CONFIG_OBJECT_TYPE_CELLGROUP_NODEVALUE) == 0) {
            this.myConfigObjectType = 78;
        }
    }

    private void setObjectData(NodeList objNodeList) {
        int j = 0;
        while (j < objNodeList.getLength()) {
            Node objNode = objNodeList.item(j);
            if (objNode.getNodeName().equalsIgnoreCase(CONFIG_OBJECT_TYPE_UNIT_NODEVALUE)) {
                this.myConfigObjectType = 10;
                this.myObjectDataNodeList = objNode.getChildNodes();
            } else if (objNode.getNodeName().equalsIgnoreCase(CONFIG_OBJECT_TYPE_SUBUNIT_NODEVALUE)) {
                this.myConfigObjectType = 14;
                this.myObjectDataNodeList = objNode.getChildNodes();
            } else if (objNode.getNodeName().equalsIgnoreCase(CONFIG_OBJECT_TYPE_CELLS_NODEVALUE)) {
                this.myConfigObjectType = 51;
                this.myObjectDataNodeList = objNode.getChildNodes();
            } else if (objNode.getNodeName().equalsIgnoreCase(CONFIG_OBJECT_TYPE_CELL_NODEVALUE)) {
                this.myConfigObjectType = 5;
                this.myObjectDataNodeList = objNode.getChildNodes();
            } else if (objNode.getNodeName().equalsIgnoreCase(CONFIG_OBJECT_TYPE_CABINET_NODEVALUE)) {
                this.myConfigObjectType = 4;
                this.myObjectDataNodeList = objNode.getChildNodes();
            } else if (objNode.getNodeName().equalsIgnoreCase(CONFIG_OBJECT_TYPE_BS_NODEVALUE)) {
                this.myConfigObjectType = 3;
                this.myObjectDataNodeList = objNode.getChildNodes();
            } else if (objNode.getNodeName().equalsIgnoreCase(CONFIG_OBJECT_TYPE_EACINPUT_NODEVALUE)) {
                this.myConfigObjectType = 11;
                this.myObjectDataNodeList = objNode.getChildNodes();
            } else if (objNode.getNodeName().equalsIgnoreCase(CONFIG_OBJECT_TYPE_EACOUTPUT_NODEVALUE)) {
                this.myConfigObjectType = 12;
                this.myObjectDataNodeList = objNode.getChildNodes();
            } else if (objNode.getNodeName().equalsIgnoreCase(CONFIG_OBJECT_TYPE_LINK_NODEVALUE)) {
                this.myConfigObjectType = 13;
                this.myObjectDataNodeList = objNode.getChildNodes();
            } else if (objNode.getNodeName().equalsIgnoreCase(CONFIG_OBJECT_TYPE_OBJECT_RELATION_NODEVALUE)) {
                this.myConfigObjectType = 48;
                this.myObjectDataNodeList = objNode.getChildNodes();
            } else if (objNode.getNodeName().equalsIgnoreCase(CONFIG_OBJECT_TYPE_CELLGROUP_NODEVALUE)) {
                this.myConfigObjectType = 78;
                this.myObjectDataNodeList = objNode.getChildNodes();
            }
            ++j;
        }
    }
}

