/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.message;

import com.nokia.em.bts.rp.master.filetransfer.FTPTransferInfo;
import com.nokia.em.bts.rp.master.message.BTSInboundMessage;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DatabaseFileCreated
extends BTSInboundMessage {
    private String myFileId;
    private int myDBType;
    private FTPTransferInfo myFTPTransferInfo;
    private static final String DATABASE_TYPE_NODENAME = "_dbType";
    private static final String DATABASE_TYPE_ALARM_NODEVALUE = "alarmDb";
    private static final String DATABASE_TYPE_CONFIG_NODEVALUE = "configDb";
    private static final String DATABASE_TYPE_EACS_NODEVALUE = "eacsDb";
    private static final String DATABASE_TYPE_USER_NODEVALUE = "userDb";
    private static final String FTP_TRANSFER_INFO_NODENAME = "FTPTransferInfo";
    private static final String FILE_ID_NODENAME = "_fileId";
    private static final String SERVER_ADDRESS_NODENAME = "_serverAddress";
    private static final String USER_NAME_NODENAME = "_userName";
    private static final String PASSWORD_NODENAME = "_password";

    public DatabaseFileCreated(int intSeqNbr, int intDbType, String strFileId) {
        super(intSeqNbr);
        this.myDBType = intDbType;
        this.myFileId = strFileId;
    }

    public DatabaseFileCreated(int intSeqNbr, int intDbType, FTPTransferInfo ftpTransferInfo) {
        super(intSeqNbr);
        this.myDBType = intDbType;
        this.myFTPTransferInfo = ftpTransferInfo;
    }

    public DatabaseFileCreated(int intSeqNbr, Node node) throws Exception {
        super(intSeqNbr);
        this.myDBType = -1;
        this.myFileId = "Coreasset_Unknown";
        this.myFTPTransferInfo = null;
        NodeList nList = node.getChildNodes();
        int i = 0;
        while (i < nList.getLength()) {
            if (nList.item(i).getNodeName().compareTo(DATABASE_TYPE_NODENAME) == 0 && nList.item(i).getFirstChild() != null) {
                String temp = nList.item(i).getFirstChild().getNodeValue().trim();
                if (temp.compareTo(DATABASE_TYPE_ALARM_NODEVALUE) == 0) {
                    this.myDBType = 10;
                } else if (temp.compareTo(DATABASE_TYPE_CONFIG_NODEVALUE) == 0) {
                    this.myDBType = 11;
                } else if (temp.compareTo(DATABASE_TYPE_EACS_NODEVALUE) == 0) {
                    this.myDBType = 43;
                } else if (temp.compareTo(DATABASE_TYPE_USER_NODEVALUE) == 0) {
                    this.myDBType = 54;
                }
            } else if (nList.item(i).getNodeName().compareTo(FILE_ID_NODENAME) == 0 && nList.item(i).getFirstChild() != null) {
                this.myFileId = nList.item(i).getFirstChild().getNodeValue().trim();
            } else if (nList.item(i).getNodeName().compareTo(FTP_TRANSFER_INFO_NODENAME) == 0 && nList.item(i).getFirstChild() != null) {
                this.myFTPTransferInfo = this.getFTPTransferInfo(nList.item(i).getChildNodes());
            }
            ++i;
        }
    }

    public final int getDBType() {
        return this.myDBType;
    }

    public final String getFileId() {
        return this.myFileId;
    }

    public final FTPTransferInfo getFTPTransferInfo() {
        return this.myFTPTransferInfo;
    }

    private FTPTransferInfo getFTPTransferInfo(NodeList trInfoNodeList) {
        FTPTransferInfo ftpInfo = new FTPTransferInfo();
        ftpInfo.setFileName(null);
        int j = 0;
        while (j < trInfoNodeList.getLength()) {
            Node trInfoNode = trInfoNodeList.item(j);
            if (trInfoNode.getFirstChild() != null && trInfoNode.getFirstChild().getNodeValue() != null) {
                if (trInfoNode.getNodeName().compareTo(FILE_ID_NODENAME) == 0) {
                    ftpInfo.setFileName(trInfoNode.getFirstChild().getNodeValue().trim());
                } else if (trInfoNode.getNodeName().compareTo(SERVER_ADDRESS_NODENAME) == 0) {
                    ftpInfo.setServerAddress(trInfoNode.getFirstChild().getNodeValue().trim());
                } else if (trInfoNode.getNodeName().compareTo(USER_NAME_NODENAME) == 0) {
                    ftpInfo.setUserName(trInfoNode.getFirstChild().getNodeValue().trim());
                } else if (trInfoNode.getNodeName().compareTo(PASSWORD_NODENAME) == 0) {
                    ftpInfo.setPassword(trInfoNode.getFirstChild().getNodeValue().trim().toCharArray());
                }
            }
            ++j;
        }
        return ftpInfo;
    }
}

