/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.message;

import com.nokia.em.bts.rp.master.message.BTSInboundMessage;
import com.nokia.em.bts.rp.master.tool.Tools;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ESTModuleTestResultNotif
extends BTSInboundMessage {
    private static final String UNIT_ID = "_unitId";
    private static final String TEST_VERDICT = "_testVerdict";
    private String myUnitId = "";
    private int myTestVerdict = -1;
    private static final String TEST_VERDICT_PASS_NODEVALUE = "pass";
    private static final String TEST_VERDICT_FAIL_NODEVALUE = "fail";

    public ESTModuleTestResultNotif(int seqNbr, Node xmlNode) throws Exception {
        super(seqNbr);
        this.setCodedMessage(Tools.xmlToString((Node)xmlNode));
        NodeList nodeList = xmlNode.getChildNodes();
        if (nodeList.getLength() == 0) {
            throw new InstantiationException("Instantiation failed: No child nodes found.");
        }
        int index = 0;
        while (index < nodeList.getLength()) {
            Node firstChild;
            Node node = nodeList.item(index);
            String nodeName = node.getNodeName();
            if (nodeName.equals(UNIT_ID)) {
                firstChild = node.getFirstChild();
                if (firstChild != null && firstChild.getNodeValue() != null) {
                    this.myUnitId = firstChild.getNodeValue().trim();
                }
            } else if (nodeName.equals(TEST_VERDICT) && (firstChild = node.getFirstChild()) != null && firstChild.getNodeValue() != null) {
                String result = firstChild.getNodeValue().trim();
                if (result.equalsIgnoreCase(TEST_VERDICT_PASS_NODEVALUE)) {
                    this.myTestVerdict = 36;
                } else if (result.equalsIgnoreCase(TEST_VERDICT_FAIL_NODEVALUE)) {
                    this.myTestVerdict = 37;
                } else {
                    throw new InstantiationException("Instantiation failed: Invalid _testVerdict value.");
                }
            }
            ++index;
        }
        if (this.myUnitId.length() == 0) {
            throw new InstantiationException("Instantiation failed: _unitId parameter not found.");
        }
        if (this.myTestVerdict == -1) {
            throw new InstantiationException("Instantiation failed: _testVerdict parameter not found.");
        }
    }

    public String getUnitId() {
        return this.myUnitId;
    }

    public int getTestVerdict() {
        return this.myTestVerdict;
    }

    public String getTestVerdictString() {
        String testVerdict;
        switch (this.myTestVerdict) {
            case 36: {
                testVerdict = TEST_VERDICT_PASS_NODEVALUE;
                break;
            }
            case 37: {
                testVerdict = TEST_VERDICT_FAIL_NODEVALUE;
                break;
            }
            default: {
                testVerdict = "Coreasset_Unknown";
            }
        }
        return testVerdict;
    }
}

