/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.message;

import com.nokia.em.bts.coreasset.message.extendedlogging.TTITraceLogMessageUtil;
import com.nokia.em.bts.coreasset.scenario.techlogfiles.LoggingCategory;
import com.nokia.em.bts.rp.master.message.BTSMessage;
import java.util.List;

public class ExtendedLoggingModeRequest
extends BTSMessage {
    private static final String EMPTY_STRING = "";
    private static final String DEFAULT_WINDOW_SIZE_VALUE = "100000";
    private static final String AASYSLOG_LOGGING_FORMAT = "<LoggingCategory><_category>%s</_category><_status>%s</_status></LoggingCategory>";
    private static final String AATRACELOG_LOGGING_FORMAT = "<LoggingCategory><_category>%s</_category><_status>%s</_status><_msgIdFilter>%s</_msgIdFilter><_msgIdHeavyLoadFilter>%s</_msgIdHeavyLoadFilter><_windowSize>%s</_windowSize></LoggingCategory>";
    private String myCategories;

    public ExtendedLoggingModeRequest(int intSeqNbr, List<LoggingCategory> categories) {
        super(intSeqNbr);
        StringBuilder s = new StringBuilder();
        for (LoggingCategory category : categories) {
            String formattedExtendedLoggingModeRequest;
            if ("AaTracelog".equals(category.getCategory())) {
                String messageRange = category.getMessageIdFilter() == null ? EMPTY_STRING : category.getMessageIdFilter();
                String heavyLoadFilter = category.getHeavyLoadFilter() == null ? EMPTY_STRING : category.getHeavyLoadFilter();
                String timeWindowSize = category.getTimeWindowSize() == null || EMPTY_STRING.equals(category.getTimeWindowSize()) ? DEFAULT_WINDOW_SIZE_VALUE : category.getTimeWindowSize();
                formattedExtendedLoggingModeRequest = String.format(AATRACELOG_LOGGING_FORMAT, new Object[]{category.getCategory(), category.getStatus(), messageRange, heavyLoadFilter, timeWindowSize});
            } else {
                formattedExtendedLoggingModeRequest = "TtiTracelog".equalsIgnoreCase(category.getCategory()) ? TTITraceLogMessageUtil.extractTtiTraceLogMessage(category) : String.format(AASYSLOG_LOGGING_FORMAT, new Object[]{category.getCategory(), category.getStatus()});
            }
            s.append(formattedExtendedLoggingModeRequest);
        }
        this.myCategories = s.toString();
    }

    public ExtendedLoggingModeRequest(int intSeqNbr, List<LoggingCategory> categories, BTSMessage.Type type) {
        this(intSeqNbr, categories);
        this.myType = type;
    }

    public String getContent() {
        StringBuilder s = new StringBuilder();
        s.append("<ExtendedLoggingModeRequest>");
        s.append(this.myCategories);
        s.append("</ExtendedLoggingModeRequest>");
        return s.toString();
    }
}

