/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.message;

import com.nokia.em.bts.coreasset.scenario.techlogfiles.LoggingCategory;
import com.nokia.em.bts.rp.master.message.BTSInboundMessage;
import com.nokia.em.bts.rp.master.tool.Tools;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ExtendedLoggingModeResponse
extends BTSInboundMessage {
    private List<LoggingCategory> myCategories = new ArrayList<LoggingCategory>();
    private static final String CATEGORY_NODENAME = "_category";
    private static final String CAUSE_NODENAME = "_cause";
    private static final String CAUSE_SUCCESSFUL_NODEVALUE = "successful";
    private static final String CAUSE_FAILED_NODEVALUE = "failed";
    private static final String CAUSE_FILENOTDELETED_NODEVALUE = "filesNotDeleted";
    private static final String CAUSE_REJECTEDBYCCS_NODEVALUE = "rejectedByCCS";
    private int myLogCategoryCause;
    private Logger myLogger;
    private Map<String, Integer> myLogCategoryMap = new HashMap<String, Integer>();
    private static final Map<String, Integer> myNodeValueMap = ExtendedLoggingModeResponse.createNodeValueMap();

    public ExtendedLoggingModeResponse(int seqNbr, Node node) throws Exception {
        super(seqNbr);
        this.myLogger = Logger.getLogger(((Object)((Object)this)).getClass());
        this.setCodedMessage(Tools.xmlToString((Node)node));
        NodeList categoryList = node.getChildNodes();
        int i = 0;
        while (i < categoryList.getLength()) {
            try {
                String category = null;
                Node categoryNode = categoryList.item(i);
                NodeList valueList = categoryNode.getChildNodes();
                int j = 0;
                while (j < valueList.getLength()) {
                    Node n = valueList.item(j);
                    this.myLogCategoryCause = -1;
                    if (n.hasChildNodes()) {
                        if (n.getNodeName().equals(CATEGORY_NODENAME)) {
                            category = n.getFirstChild().getNodeValue().trim();
                        } else if (n.getNodeName().equals(CAUSE_NODENAME)) {
                            this.myLogCategoryCause = this.getCauseNode(n);
                        } else {
                            this.myLogger.error((Object)("Unrecognized logging category element " + n.getNodeName()));
                        }
                    }
                    if (category != null && this.myLogCategoryCause != -1) {
                        this.myLogger.trace((Object)("Successfully received category " + category + " with cause " + this.myLogCategoryCause));
                        this.myLogCategoryMap.put(category, this.myLogCategoryCause);
                        this.myCategories.add(new LoggingCategory(category, this.myLogCategoryCause));
                    }
                    ++j;
                }
            }
            catch (Exception e) {
                this.myLogger.error((Object)"Cannot parse logging category, continuing on next one.", (Throwable)e);
            }
            ++i;
        }
    }

    public List<LoggingCategory> getLoggingCategories() {
        return this.myCategories;
    }

    public boolean hasFailureCause() {
        if (this.myCategories.isEmpty()) {
            return true;
        }
        Set<String> categories = this.myLogCategoryMap.keySet();
        for (String category : categories) {
            int cause = this.myLogCategoryMap.get(category);
            if (cause == 36) continue;
            return true;
        }
        return false;
    }

    public boolean isAllFailureCause() {
        if (this.myCategories.isEmpty()) {
            return true;
        }
        Set<String> categories = this.myLogCategoryMap.keySet();
        for (String category : categories) {
            int cause = this.myLogCategoryMap.get(category);
            if (cause != 36) continue;
            return false;
        }
        return true;
    }

    private int getCauseNode(Node n) {
        String nodeValue = n.getFirstChild().getNodeValue().trim();
        return myNodeValueMap.get(nodeValue);
    }

    private static Map<String, Integer> createNodeValueMap() {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        result.put(CAUSE_SUCCESSFUL_NODEVALUE, 36);
        result.put(CAUSE_FAILED_NODEVALUE, 37);
        result.put(CAUSE_FILENOTDELETED_NODEVALUE, 122);
        result.put(CAUSE_REJECTEDBYCCS_NODEVALUE, 123);
        return Collections.unmodifiableMap(result);
    }
}

