/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.message;

import com.nokia.em.bts.coreasset.scenario.techlogfiles.LogFile;
import com.nokia.em.bts.coreasset.scenario.techlogfiles.LoggingCategory;
import com.nokia.em.bts.rp.master.message.BTSInboundMessage;
import com.nokia.em.bts.rp.master.tool.Tools;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ExtendedLoggingModeStatusResponse
extends BTSInboundMessage {
    private List<LoggingCategory> myCategories = new ArrayList<LoggingCategory>();
    private static final String LOGGING_CATEGORY_NODENAME = "LoggingCategory";
    private static final String CATEGORY_NODENAME = "_category";
    private static final String STATUS_NODENAME = "_status";
    private static final String MSG_ID_FILTER_NODENAME = "_msgIdFilter";
    private static final String HEAVY_LOAD_FILTER_NODENAME = "_msgIdHeavyLoadFilter";
    private static final String TIME_WINDOW_SIZE_NODENAME = "_windowSize";
    private static final String STATUS_ACTIVE_NODEVALUE = "active";
    private static final String STATUS_INACTIVE_NODEVALUE = "inactive";
    private List<LogFile> myLogFiles = new ArrayList<LogFile>();
    private static final String LOG_FILES_NODENAME = "LogFiles";
    private static final String LOG_FILE_NODENAME = "LogFile";
    private static final String FILE_ID_NODENAME = "_fileId";
    private static final String SIZE_NODENAME = "_size";
    private Logger myLogger = Logger.getLogger(((Object)((Object)this)).getClass());

    public ExtendedLoggingModeStatusResponse(int seqNbr, Node msgnode) throws Exception {
        super(seqNbr);
        this.setCodedMessage(Tools.xmlToString((Node)msgnode));
        NodeList nodeList = msgnode.getChildNodes();
        int i = 0;
        while (i < nodeList.getLength()) {
            Node node = nodeList.item(i);
            NodeList valueList = node.getChildNodes();
            if (LOGGING_CATEGORY_NODENAME.equals(node.getNodeName())) {
                this.processLoggingCategoryNode(valueList);
            } else if (LOG_FILES_NODENAME.equals(node.getNodeName())) {
                this.processLogFilesNode(valueList);
            } else if (STATUS_NODENAME.equals(node.getNodeName())) {
                this.processStatusNode(node);
            }
            ++i;
        }
    }

    private void processLoggingCategoryNode(NodeList nodes) {
        LoggingCategory loggingCategory = this.extractLoggingCategoryNode(nodes);
        if ("TtiTracelog".equalsIgnoreCase(loggingCategory.getCategory()) && loggingCategory.getStatus() != null) {
            this.myLogger.info((Object)("Successfully received category " + loggingCategory.getCategory() + " with status " + (Object)((Object)loggingCategory.getStatus())));
            this.myCategories.add(loggingCategory);
        } else if ("AaTracelog".equalsIgnoreCase(loggingCategory.getCategory()) && loggingCategory.getStatus() != null) {
            this.myLogger.info((Object)("Successfully received category " + loggingCategory.getCategory() + " with status " + (Object)((Object)loggingCategory.getStatus()) + " range " + loggingCategory.getMessageIdFilter() + " heavy load filter " + loggingCategory.getHeavyLoadFilter() + " and time window size " + loggingCategory.getTimeWindowSize()));
            this.myCategories.add(loggingCategory);
        } else if ("AaSyslog".equalsIgnoreCase(loggingCategory.getCategory()) && loggingCategory.getStatus() != null) {
            this.myLogger.info((Object)("Got Aasyslog status " + (Object)((Object)loggingCategory.getStatus())));
            this.myCategories.add(loggingCategory);
        } else {
            this.myLogger.error((Object)("Invalid logging category " + loggingCategory.getCategory() + " with status " + (Object)((Object)loggingCategory.getStatus())));
        }
    }

    private void processStatusNode(Node node) {
        LoggingCategory.Status status = LoggingCategory.Status.NOTFOUND;
        String value = node.getFirstChild().getNodeValue().trim();
        if (STATUS_ACTIVE_NODEVALUE.equalsIgnoreCase(value)) {
            status = LoggingCategory.Status.ACTIVE;
        } else if (STATUS_INACTIVE_NODEVALUE.equalsIgnoreCase(value)) {
            status = LoggingCategory.Status.INACTIVE;
        } else {
            this.myLogger.error((Object)("Unrecognized logging category status " + value));
        }
        if (status != null) {
            this.myLogger.info((Object)("Got Aasyslog status " + (Object)((Object)status)));
            this.myCategories.add(new LoggingCategory("AaSyslog", status));
        } else {
            this.myLogger.error((Object)"Invalid status is null");
        }
    }

    private void processLogFilesNode(NodeList nodes) {
        int j = 0;
        while (j < nodes.getLength()) {
            Node child = nodes.item(j);
            if (LOG_FILE_NODENAME.equals(child.getNodeName())) {
                String fileId = null;
                double size = 0.0;
                NodeList logFileValueList = child.getChildNodes();
                int k = 0;
                while (k < logFileValueList.getLength()) {
                    Node n = logFileValueList.item(k);
                    if (n.hasChildNodes()) {
                        if (FILE_ID_NODENAME.equals(n.getNodeName())) {
                            fileId = n.getFirstChild().getNodeValue().trim();
                        } else if (SIZE_NODENAME.equals(n.getNodeName())) {
                            size = Double.valueOf(n.getFirstChild().getNodeValue().trim());
                        } else {
                            this.myLogger.error((Object)("Unrecognized log file element " + n.getNodeName()));
                        }
                    }
                    ++k;
                }
                if (fileId != null) {
                    this.myLogger.info((Object)("Got log file " + fileId + " with size " + size));
                    this.myLogFiles.add(new LogFile(fileId, size));
                }
            }
            ++j;
        }
    }

    private LoggingCategory extractLoggingCategoryNode(NodeList nodes) {
        LoggingCategory loggingCategory = new LoggingCategory();
        int i = 0;
        while (i < nodes.getLength()) {
            Node n = nodes.item(i);
            if (n.hasChildNodes()) {
                if (CATEGORY_NODENAME.equals(n.getNodeName())) {
                    loggingCategory.setCategory(n.getFirstChild().getNodeValue().trim());
                } else if (STATUS_NODENAME.equals(n.getNodeName())) {
                    String value = n.getFirstChild().getNodeValue().trim();
                    this.setLoggingCategoryStatus(loggingCategory, value);
                } else if (MSG_ID_FILTER_NODENAME.equals(n.getNodeName())) {
                    loggingCategory.setMessageIdFilter(n.getFirstChild().getNodeValue());
                } else if (HEAVY_LOAD_FILTER_NODENAME.equals(n.getNodeName())) {
                    loggingCategory.setHeavyLoadFilter(n.getFirstChild().getNodeValue());
                } else if (TIME_WINDOW_SIZE_NODENAME.equals(n.getNodeName())) {
                    loggingCategory.setTimeWindowSize(n.getFirstChild().getNodeValue());
                } else {
                    this.myLogger.error((Object)("Unrecognized logging category element " + n.getNodeName()));
                }
            }
            ++i;
        }
        return loggingCategory;
    }

    private void setLoggingCategoryStatus(LoggingCategory loggingCategory, String value) {
        if (STATUS_ACTIVE_NODEVALUE.equalsIgnoreCase(value)) {
            loggingCategory.setStatus(LoggingCategory.Status.ACTIVE);
        } else if (STATUS_INACTIVE_NODEVALUE.equalsIgnoreCase(value)) {
            loggingCategory.setStatus(LoggingCategory.Status.INACTIVE);
        } else {
            this.myLogger.error((Object)("Unrecognized logging category status " + value));
        }
    }

    public List<LoggingCategory> getLoggingCategories() {
        return this.myCategories;
    }

    public List<LogFile> getLogFiles() {
        return this.myLogFiles;
    }
}

