/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.message;

import com.nokia.em.bts.coreasset.message.AbstractRAEResponse;
import com.nokia.em.bts.coreasset.scenario.antennamanagement.raemanagement.RAEPortData;
import com.nokia.em.bts.rp.master.tool.Tools;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class GetBeamDataResponse
extends AbstractRAEResponse {
    private static final String GETBEAMDATARESPONSE = "GetBeamDataResponse";
    private static final String BEAMS = "Beams";
    private static final String PORTS = "Ports";
    private static final String PORT = "Port";
    private static final String VERTICAL = "Vertical";
    private static final String HORIZONTAL = "Horizontal";
    private static final String WIDTH = "_width";
    private static final String CAUSE = "_cause";
    private static final String PORT_NODE = "_port";
    private static final String IDENTITY_NODE = "_identity";
    private static final String POLARIZATION_NODE = "_polarization";
    private static final String OPERATION_FEEDBACK = "_operationFeedback";
    private Set<String> myVerticalWidths;
    private Set<String> myHorizontalWidths;
    private List<RAEPortData> myRAEPortDatas;

    public GetBeamDataResponse(int intSeqNbr, Node xmlNode) {
        super(intSeqNbr);
        if (!GETBEAMDATARESPONSE.equals(xmlNode.getNodeName())) {
            return;
        }
        this.myVerticalWidths = new HashSet<String>();
        this.myHorizontalWidths = new HashSet<String>();
        this.myRAEPortDatas = new ArrayList<RAEPortData>();
        this.parseGetBeamDataResponse(xmlNode);
    }

    private void parseGetBeamDataResponse(Node xmlNode) {
        NodeList beamDataNodeList = xmlNode.getChildNodes();
        int beamDataIndex = 0;
        while (beamDataIndex < beamDataNodeList.getLength()) {
            Node beamDataNode = beamDataNodeList.item(beamDataIndex);
            switch (beamDataNode.getNodeName()) {
                case "Beams": {
                    this.parseBeam(beamDataNode);
                    break;
                }
                case "Ports": {
                    this.parsePort(beamDataNode);
                    break;
                }
                case "_cause": {
                    this.myCause = GetBeamDataResponse.getCause(beamDataNode.getTextContent());
                    break;
                }
                case "_operationFeedback": {
                    this.myOperationFeedback = Tools.xmlToString((Node)beamDataNode);
                    break;
                }
            }
            ++beamDataIndex;
        }
    }

    private void parseBeam(Node beamDataNode) {
        NodeList beamList = beamDataNode.getChildNodes();
        int index = 0;
        while (index < beamList.getLength()) {
            Node directionNode = beamList.item(index);
            if (VERTICAL.equals(directionNode.getNodeName())) {
                this.parseDirection(directionNode, this.myVerticalWidths);
            } else if (HORIZONTAL.equals(directionNode.getNodeName())) {
                this.parseDirection(directionNode, this.myHorizontalWidths);
            }
            ++index;
        }
    }

    private void parseDirection(Node node, Set directionSet) {
        NodeList directioNodeList = node.getChildNodes();
        int widthIndex = 0;
        while (widthIndex < directioNodeList.getLength()) {
            Node widthNode = directioNodeList.item(widthIndex);
            String nodeName = widthNode.getNodeName();
            String nodeValue = widthNode.getTextContent();
            if (WIDTH.equals(nodeName)) {
                directionSet.add(nodeValue);
            }
            ++widthIndex;
        }
    }

    private void parsePort(Node beamDataNode) {
        NodeList portList = beamDataNode.getChildNodes();
        int index = 0;
        while (index < portList.getLength()) {
            Node portNode = portList.item(index);
            RAEPortData raePortData = new RAEPortData();
            if (PORT.equalsIgnoreCase(portNode.getNodeName())) {
                NodeList portInfoList = portNode.getChildNodes();
                int portInfoIndex = 0;
                while (portInfoIndex < portInfoList.getLength()) {
                    Node portInfoNode = portInfoList.item(portInfoIndex);
                    String nodeName = portInfoNode.getNodeName();
                    String nodeValue = portInfoNode.getTextContent();
                    if (PORT_NODE.equalsIgnoreCase(nodeName)) {
                        raePortData.setPort(nodeValue);
                    } else if (IDENTITY_NODE.equalsIgnoreCase(nodeName)) {
                        raePortData.setIdentity(nodeValue);
                    } else if (POLARIZATION_NODE.equalsIgnoreCase(nodeName)) {
                        raePortData.setPolarization(nodeValue);
                    }
                    ++portInfoIndex;
                }
            }
            this.myRAEPortDatas.add(raePortData);
            ++index;
        }
    }

    public Set<String> getVerticalWidths() {
        return this.myVerticalWidths;
    }

    public Set<String> getHorizontalWidths() {
        return this.myHorizontalWidths;
    }

    public List<RAEPortData> getRAEPortDatas() {
        return this.myRAEPortDatas;
    }
}

