/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.message;

import com.nokia.em.bts.coreasset.message.AbstractRAEResponse;
import com.nokia.em.bts.rp.master.tool.Tools;
import java.util.HashSet;
import java.util.Set;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class GetDirectionDataResponse
extends AbstractRAEResponse {
    private static final String GETDIRECTIONDATARESPONSE = "GetDirectionDataResponse";
    private static final String TILTS = "Tilts";
    private static final String VERTICAL = "Vertical";
    private static final String HORIZONTAL = "Horizontal";
    private static final String TILT = "_tilt";
    private static final String CAUSE = "_cause";
    private static final String OPERATION_FEEDBACK = "_operationFeedback";
    private Set<String> myVerticalTilts;
    private Set<String> myHorizontalTilts;

    public GetDirectionDataResponse(int intSeqNbr, Node xmlNode) {
        super(intSeqNbr);
        if (!GETDIRECTIONDATARESPONSE.equals(xmlNode.getNodeName())) {
            return;
        }
        this.myVerticalTilts = new HashSet<String>();
        this.myHorizontalTilts = new HashSet<String>();
        this.parseGetDirectionDataResponse(xmlNode);
    }

    private void parseGetDirectionDataResponse(Node xmlNode) {
        NodeList directionDataNodeList = xmlNode.getChildNodes();
        int directionDataIndex = 0;
        while (directionDataIndex < directionDataNodeList.getLength()) {
            Node directionDataNode = directionDataNodeList.item(directionDataIndex);
            switch (directionDataNode.getNodeName()) {
                case "Tilts": {
                    this.parseTilts(directionDataNode);
                    break;
                }
                case "_cause": {
                    this.myCause = GetDirectionDataResponse.getCause(directionDataNode.getTextContent());
                    break;
                }
                case "_operationFeedback": {
                    this.myOperationFeedback = Tools.xmlToString((Node)directionDataNode);
                    break;
                }
            }
            ++directionDataIndex;
        }
    }

    private void parseTilts(Node tiltDataNode) {
        NodeList tiltList = tiltDataNode.getChildNodes();
        int index = 0;
        while (index < tiltList.getLength()) {
            Node directionNode = tiltList.item(index);
            if (VERTICAL.equals(directionNode.getNodeName())) {
                this.parseDirection(directionNode, this.myVerticalTilts);
            } else if (HORIZONTAL.equals(directionNode.getNodeName())) {
                this.parseDirection(directionNode, this.myHorizontalTilts);
            }
            ++index;
        }
    }

    private void parseDirection(Node node, Set directionSet) {
        NodeList directioNodeList = node.getChildNodes();
        int widthIndex = 0;
        while (widthIndex < directioNodeList.getLength()) {
            Node widthNode = directioNodeList.item(widthIndex);
            String nodeName = widthNode.getNodeName();
            String nodeValue = widthNode.getTextContent();
            if (TILT.equals(nodeName)) {
                directionSet.add(nodeValue);
            }
            ++widthIndex;
        }
    }

    public Set<String> getVerticalTilts() {
        return this.myVerticalTilts;
    }

    public Set<String> getHorizontalTilts() {
        return this.myHorizontalTilts;
    }
}

