/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.message;

import com.nokia.em.bts.coreasset.scenario.antennamanagement.raemanagement.RAEFileData;
import com.nokia.em.bts.coreasset.scenario.antennamanagement.raemanagement.RAEFrequencyData;
import com.nokia.em.bts.rp.master.message.BTSInboundMessage;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class GetRAEPropertiesResponse
extends BTSInboundMessage {
    private static final String GET_RAE_PROPERTIES_RESPONSE = "GetRAEPropertiesResponse";
    private static final String FILES = "Files";
    private static final String WEIGHT_PARAMETERS = "WeightParameters";
    private static final String FREQUENCIES = "Frequencies";
    private static final String FILE = "File";
    private static final String FILE_INDEX = "_fileIndex";
    private static final String RAE_TYPE = "_raetype";
    private static final String FILE_NAME = "_fileName";
    private static final String FORMATTING_CODE = "_formattingCode";
    private static final String FILE_VERSION = "_fileVersion";
    private static final String FILE_INFORMATION = "_fileInformation";
    private static final String ADVANCED_PARAMETERS = "_advancedParameters";
    private static final String FREQUENCY = "Frequency";
    private static final String FREQUENCY_LOW = "_low";
    private static final String FREQUENCY_HIGH = "_high";
    private List<RAEFileData> myFiles = new ArrayList<RAEFileData>();
    private String myFormattingCode;
    private String myFileVersion;
    private String myFileInformation;
    private String myAdvancedParameter;
    private List<RAEFrequencyData> myFrequencies = new ArrayList<RAEFrequencyData>();

    public GetRAEPropertiesResponse(int intSeqNbr, Node xmlNode) {
        super(intSeqNbr);
        if (!GET_RAE_PROPERTIES_RESPONSE.equals(xmlNode.getNodeName())) {
            return;
        }
        this.parseGetRAEPropertiesResponse(xmlNode);
    }

    private void parseGetRAEPropertiesResponse(Node xmlNode) {
        NodeList getRAEPropertiesResponseChilds = xmlNode.getChildNodes();
        int childIndex = 0;
        while (childIndex < getRAEPropertiesResponseChilds.getLength()) {
            Node child = getRAEPropertiesResponseChilds.item(childIndex);
            switch (child.getNodeName()) {
                case "Files": {
                    this.parseFiles(child);
                    break;
                }
                case "WeightParameters": {
                    this.parseWeightParameters(child);
                    break;
                }
                case "Frequencies": {
                    this.parseFrequencies(child);
                    break;
                }
            }
            ++childIndex;
        }
    }

    private void parseFiles(Node node) {
        NodeList fileList = node.getChildNodes();
        this.myFiles = new ArrayList<RAEFileData>();
        int fileNum = 0;
        while (fileNum < fileList.getLength()) {
            Node fileNode = fileList.item(fileNum);
            if (FILE.equals(fileNode.getNodeName())) {
                RAEFileData fileData = new RAEFileData();
                NodeList fileInfoList = fileNode.getChildNodes();
                int index = 0;
                while (index < fileInfoList.getLength()) {
                    Node fileInfoNode = fileInfoList.item(index);
                    String nodeName = fileInfoNode.getNodeName();
                    String nodeValue = fileInfoNode.getTextContent();
                    if (FILE_INDEX.equals(nodeName)) {
                        fileData.setFileIndex(nodeValue);
                    } else if (RAE_TYPE.equals(nodeName)) {
                        fileData.setRAEType(nodeValue);
                    } else if (FILE_NAME.equals(nodeName)) {
                        fileData.setFileName(nodeValue);
                    }
                    ++index;
                }
                this.myFiles.add(fileData);
            }
            ++fileNum;
        }
    }

    private void parseWeightParameters(Node node) {
        NodeList weightParametersList = node.getChildNodes();
        int index = 0;
        while (index < weightParametersList.getLength()) {
            Node weightParamNode = weightParametersList.item(index);
            String nodeName = weightParamNode.getNodeName();
            String nodeValue = weightParamNode.getTextContent();
            if (FORMATTING_CODE.equals(nodeName)) {
                this.myFormattingCode = nodeValue;
            } else if (FILE_VERSION.equals(nodeName)) {
                this.myFileVersion = nodeValue;
            } else if (FILE_INFORMATION.equals(nodeName)) {
                this.myFileInformation = nodeValue;
            } else if (ADVANCED_PARAMETERS.equals(nodeName)) {
                this.myAdvancedParameter = nodeValue;
            }
            ++index;
        }
    }

    private void parseFrequencies(Node node) {
        NodeList frequencyList = node.getChildNodes();
        this.myFrequencies = new ArrayList<RAEFrequencyData>();
        int freqNum = 0;
        while (freqNum < frequencyList.getLength()) {
            Node freqNode = frequencyList.item(freqNum);
            if (FREQUENCY.equals(freqNode.getNodeName())) {
                RAEFrequencyData frequencyData = new RAEFrequencyData();
                NodeList freqInfoList = freqNode.getChildNodes();
                int index = 0;
                while (index < freqInfoList.getLength()) {
                    Node freqInfoNode = freqInfoList.item(index);
                    String nodeName = freqInfoNode.getNodeName();
                    int nodeValue = Integer.valueOf(freqInfoNode.getTextContent());
                    if (FREQUENCY_LOW.equals(nodeName)) {
                        frequencyData.setLow(nodeValue);
                    } else if (FREQUENCY_HIGH.equals(nodeName)) {
                        frequencyData.setHigh(nodeValue);
                    }
                    ++index;
                }
                this.myFrequencies.add(frequencyData);
            }
            ++freqNum;
        }
    }

    public List<RAEFileData> getFiles() {
        return this.myFiles;
    }

    public String getFormattingCode() {
        return this.myFormattingCode;
    }

    public String getFileVersion() {
        return this.myFileVersion;
    }

    public String getFileInformation() {
        return this.myFileInformation;
    }

    public String getAdvancedParameter() {
        return this.myAdvancedParameter;
    }

    public List<RAEFrequencyData> getFrequencies() {
        return this.myFrequencies;
    }
}

