/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.message;

import com.nokia.em.bts.coreasset.message.AbstractRAEResponse;
import com.nokia.em.bts.coreasset.scenario.antennamanagement.raemanagement.RAEWeightData;
import com.nokia.em.bts.rp.master.tool.Tools;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class GetWeightDataResponse
extends AbstractRAEResponse {
    private static final String GETWEIGHTDATARESPONSE = "GetWeightDataResponse";
    private static final String GROUPS = "Groups";
    private static final String GROUP = "Group";
    private static final String GROUPID = "_groupId";
    private static final String WEIGHTDATA = "Weightdata";
    private static final String PORT = "_port";
    private static final String AMPLITUDE = "_amplitude";
    private static final String PHASE = "_phase";
    private static final String CAUSE = "_cause";
    private static final String OPERATION_FEEDBACK = "_operationFeedback";
    private Set<RAEWeightData> myGroup;
    private Map<Integer, Set<RAEWeightData>> myGroups;

    public GetWeightDataResponse(int intSeqNbr, Node xmlNode) {
        super(intSeqNbr);
        if (!GETWEIGHTDATARESPONSE.equals(xmlNode.getNodeName())) {
            return;
        }
        this.myGroups = new HashMap<Integer, Set<RAEWeightData>>();
        this.parseGetWeightDataResponse(xmlNode);
    }

    private void parseGetWeightDataResponse(Node xmlNode) {
        NodeList groupsNodeList = xmlNode.getChildNodes();
        int groupsIndex = 0;
        while (groupsIndex < groupsNodeList.getLength()) {
            Node groupsNode = groupsNodeList.item(groupsIndex);
            switch (groupsNode.getNodeName()) {
                case "Groups": {
                    this.parseGroups(groupsNode);
                    break;
                }
                case "_cause": {
                    this.myCause = GetWeightDataResponse.getCause(groupsNode.getTextContent());
                    break;
                }
                case "_operationFeedback": {
                    this.myOperationFeedback = Tools.xmlToString((Node)groupsNode);
                    break;
                }
            }
            ++groupsIndex;
        }
    }

    private void parseGroups(Node groupsNode) {
        NodeList groupList = groupsNode.getChildNodes();
        int groupIndex = 0;
        while (groupIndex < groupList.getLength()) {
            Node groupNode = groupList.item(groupIndex);
            if (GROUP.equals(groupNode.getNodeName())) {
                this.parseGroup(groupNode);
            }
            ++groupIndex;
        }
    }

    private void parseGroup(Node groupNode) {
        NodeList groupInfoNodeList = groupNode.getChildNodes();
        int groupId = 0;
        this.myGroup = new HashSet<RAEWeightData>();
        int groupInfoIndex = 0;
        while (groupInfoIndex < groupInfoNodeList.getLength()) {
            Node groupInfoNode = groupInfoNodeList.item(groupInfoIndex);
            String nodeName = groupInfoNode.getNodeName();
            RAEWeightData weightData = new RAEWeightData();
            if (GROUPID.equals(nodeName)) {
                groupId = Integer.valueOf(groupInfoNode.getTextContent());
            } else if (WEIGHTDATA.equals(nodeName)) {
                this.parseWeightData(groupInfoNode, weightData);
                this.myGroup.add(weightData);
            }
            ++groupInfoIndex;
        }
        this.myGroups.put(groupId, this.myGroup);
    }

    private void parseWeightData(Node groupInfoNode, RAEWeightData weightData) {
        NodeList weightNodeList = groupInfoNode.getChildNodes();
        int weightIndex = 0;
        while (weightIndex < weightNodeList.getLength()) {
            Node weightNode = weightNodeList.item(weightIndex);
            String nodeName = weightNode.getNodeName();
            String nodeValue = weightNode.getTextContent();
            if (PORT.equals(nodeName)) {
                weightData.setPort(nodeValue);
            } else if (AMPLITUDE.equals(nodeName)) {
                weightData.setAmplitude(nodeValue);
            } else if (PHASE.equals(nodeName)) {
                weightData.setPhase(nodeValue);
            }
            ++weightIndex;
        }
    }

    public Map<Integer, Set<RAEWeightData>> getWeightDataGroups() {
        return this.myGroups;
    }
}

