/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.message;

import com.nokia.em.bts.coreasset.scenario.hwmanagement.InputVoltage;
import com.nokia.em.bts.rp.master.message.BTSInboundMessage;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class InputVoltageNotification
extends BTSInboundMessage {
    private static final String INPUT_VOLTAGE_NODENAME = "InputVoltage";
    private static final String ID_NODENAME = "_id";
    private static final String VOLTAGE_NODENAME = "_voltage";
    private List<InputVoltage> myVoltages;

    public InputVoltageNotification(int intSeqNbr) {
        super(intSeqNbr);
    }

    public InputVoltageNotification(int intSeqNbr, Node xmlNode) throws Exception {
        super(intSeqNbr);
        NodeList nodeList = xmlNode.getOwnerDocument().getElementsByTagName(INPUT_VOLTAGE_NODENAME);
        this.myVoltages = new ArrayList<InputVoltage>();
        int i = 0;
        while (i < nodeList.getLength()) {
            NodeList tagNodes = nodeList.item(i).getChildNodes();
            int id = -1;
            float voltage = -1.0f;
            int j = 0;
            while (j < tagNodes.getLength()) {
                Node node = tagNodes.item(j);
                if (node.hasChildNodes()) {
                    String nodeName = node.getNodeName();
                    String nodeValue = node.getFirstChild().getNodeValue().trim();
                    if (ID_NODENAME.equalsIgnoreCase(nodeName)) {
                        id = Integer.valueOf(nodeValue);
                    } else if (VOLTAGE_NODENAME.equalsIgnoreCase(nodeName)) {
                        voltage = Float.valueOf(nodeValue).floatValue();
                    }
                }
                ++j;
            }
            this.myVoltages.add(new InputVoltage(id, voltage));
            ++i;
        }
    }

    public final List<InputVoltage> getInputVoltages() {
        return this.myVoltages;
    }
}

