/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.message;

import com.nokia.em.bts.coreasset.scenario.licencemanagement.LicenceFeatureInfo;
import com.nokia.em.bts.coreasset.scenario.licencemanagement.LicenceInfo;
import com.nokia.em.bts.coreasset.scenario.licencemanagement.LicenceQueryData;
import com.nokia.em.bts.rp.master.message.BTSInboundMessage;
import com.nokia.em.bts.rp.master.tool.Tools;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class LicenceQueryReply
extends BTSInboundMessage {
    private static final SimpleDateFormat DATA_DATE_FORMAT = new SimpleDateFormat("yyyyMMddHHmmss");
    private int myOperationSuccess;
    private List myLicenceDataList;
    private static final String LICENCE_OPERATION_RESULT_NODENAME = "_licenceOperResult";
    private static final String LICENCE_OPERATION_RESULT_SUCCESSFUL_NODEVALUE = "successful";
    private static final String LICENCE_OPERATION_RESULT_MISSING_LICENCE_NODEVALUE = "missingLicence";
    private static final String LICENCE_OPERATION_RESULT_MISSING_FEATURE_NODEVALUE = "missingFeature";
    private static final String LICENCE_OPERATION_RESULT_UNKNOWN_FEATURE_CODE_NODEVALUE = "unknownFeatureCode";
    private static final String LICENCE_QUERY_DATA_NODENAME = "LicenceQueryData";
    private static final String LICENCE_INFO_NODENAME = "LicInfo";
    private static final String LICENCE_FEATURE_INFO_NODENAME = "LicFeatureInfo";
    private static final String FILE_ID_NODENAME = "_fileId";
    private static final String DOWNLOAD_TIME_NODENAME = "_downloadTime";
    private static final String START_TIME_NODENAME = "_startTime";
    private static final String END_TIME_NODENAME = "_endTime";
    private static final String CAPACITY_NODENAME = "_capacity";
    private static final String LICENCE_STATUS_NODENAME = "_licenceStatus";
    private static final String FEATURE_CODE_NODENAME = "_featureCode";
    private static final String FEATURE_NAME_NODENAME = "_featureName";
    private static final String CAPACITY_CODE_NODENAME = "_capacityCode";
    private static final String CAPACITY_CODE_LIMITED_NODEVALUE = "limited";
    private static final String CAPACITY_CODE_UNLIMITED_NODEVALUE = "unlimited";
    private static final String CAPACITY_CODE_UNUSED_NODEVALUE = "unused";
    private static final String MAX_CAPACITY_NODENAME = "_maxCapacity";
    private static final String BASIC_CAPACITY_NODENAME = "_basicCapacity";
    private static final String USED_CAPACITY_NODENAME = "_usedCapacity";
    private static final String FEATURE_STATUS_NODENAME = "_featureStatus";
    private static final String FEATURE_STATUS_UNKNOWN_NODEVALUE = "unknown";
    private static final String FEATURE_STATUS_ON_NODEVALUE = "on";
    private static final String FEATURE_STATUS_OFF_NODEVALUE = "off";
    private static final String FEATURE_STATUS_CONFIGURED_NODEVALUE = "configured";
    private Logger myLogger = Logger.getLogger(((Object)((Object)this)).getClass());

    public LicenceQueryReply(int seqNbr, Node node) throws Exception {
        super(seqNbr);
        this.setCodedMessage(Tools.xmlToString((Node)node));
        this.myLicenceDataList = new ArrayList();
        this.myOperationSuccess = -1;
        NodeList nList = node.getChildNodes();
        int i = 0;
        while (i < nList.getLength()) {
            if (nList.item(i).getNodeName().compareTo(LICENCE_OPERATION_RESULT_NODENAME) == 0 && nList.item(i).getFirstChild() != null) {
                String tempString = nList.item(i).getFirstChild().getNodeValue().trim();
                if (tempString.compareTo(LICENCE_OPERATION_RESULT_SUCCESSFUL_NODEVALUE) == 0) {
                    this.myOperationSuccess = 36;
                } else if (tempString.compareTo(LICENCE_OPERATION_RESULT_MISSING_LICENCE_NODEVALUE) == 0) {
                    this.myOperationSuccess = 77;
                } else if (tempString.compareTo(LICENCE_OPERATION_RESULT_MISSING_FEATURE_NODEVALUE) == 0) {
                    this.myOperationSuccess = 78;
                } else if (tempString.compareTo(LICENCE_OPERATION_RESULT_UNKNOWN_FEATURE_CODE_NODEVALUE) == 0) {
                    this.myOperationSuccess = 83;
                }
            } else if (nList.item(i).getNodeName().compareTo(LICENCE_QUERY_DATA_NODENAME) == 0) {
                LicenceQueryData licQueryData = new LicenceQueryData();
                NodeList licQueryDataNodeList = nList.item(i).getChildNodes();
                int j = 0;
                while (j < licQueryDataNodeList.getLength()) {
                    Node licQueryDataNode = licQueryDataNodeList.item(j);
                    if (licQueryDataNode.getNodeName().compareTo(LICENCE_INFO_NODENAME) == 0) {
                        NodeList licenceInfoList = licQueryDataNode.getChildNodes();
                        LicenceInfo licenceInfo = this.getLicInfoFromNode(licenceInfoList);
                        licQueryData.addLicenceInfo(licenceInfo);
                    } else if (licQueryDataNode.getNodeName().compareTo(LICENCE_FEATURE_INFO_NODENAME) == 0) {
                        NodeList licenceFeatInfoList = licQueryDataNode.getChildNodes();
                        LicenceFeatureInfo licenceFeatureInfo = this.getLicFeatureInfoFromNode(licenceFeatInfoList);
                        licQueryData.setLicenceFeatureInfo(licenceFeatureInfo);
                    }
                    ++j;
                }
                this.myLicenceDataList.add(licQueryData);
            } else if (nList.item(i).getNodeType() != 3) {
                throw new InstantiationException("instantiation failed: LicenceQueryReply");
            }
            ++i;
        }
    }

    public final int getOperationResult() {
        return this.myOperationSuccess;
    }

    public final LicenceQueryData[] getData() {
        return this.myLicenceDataList.toArray(new LicenceQueryData[0]);
    }

    private LicenceInfo getLicInfoFromNode(NodeList nList) {
        LicenceInfo licenceInfo = new LicenceInfo();
        int i = 0;
        while (i < nList.getLength()) {
            try {
                Node licenceInfoNode = nList.item(i);
                if (licenceInfoNode.getFirstChild() != null) {
                    String dateString;
                    if (licenceInfoNode.getNodeName().compareTo(FILE_ID_NODENAME) == 0) {
                        licenceInfo.setFileId(licenceInfoNode.getFirstChild().getNodeValue().trim());
                    } else if (licenceInfoNode.getNodeName().compareTo(DOWNLOAD_TIME_NODENAME) == 0) {
                        dateString = licenceInfoNode.getFirstChild().getNodeValue().trim();
                        licenceInfo.setDownloadTime(DATA_DATE_FORMAT.parse(dateString.substring(0, 14)));
                    } else if (licenceInfoNode.getNodeName().compareTo(START_TIME_NODENAME) == 0) {
                        dateString = licenceInfoNode.getFirstChild().getNodeValue().trim();
                        licenceInfo.setStartTime(DATA_DATE_FORMAT.parse(dateString.substring(0, 14)));
                    } else if (licenceInfoNode.getNodeName().compareTo(END_TIME_NODENAME) == 0) {
                        dateString = licenceInfoNode.getFirstChild().getNodeValue();
                        if (dateString != null) {
                            dateString = dateString.trim();
                            licenceInfo.setEndTime(DATA_DATE_FORMAT.parse(dateString.substring(0, 14)));
                        }
                    } else if (licenceInfoNode.getNodeName().compareTo(CAPACITY_NODENAME) == 0) {
                        licenceInfo.setCapacity(Integer.parseInt(licenceInfoNode.getFirstChild().getNodeValue().trim()));
                    } else if (licenceInfoNode.getNodeName().compareTo(LICENCE_STATUS_NODENAME) == 0) {
                        licenceInfo.setStatus(Integer.parseInt(licenceInfoNode.getFirstChild().getNodeValue().trim()));
                    }
                }
            }
            catch (ParseException pE) {
                this.myLogger.error((Object)"Parse exception, ", (Throwable)pE);
            }
            catch (Exception e) {
                this.myLogger.error((Object)"Exception, ", (Throwable)e);
            }
            ++i;
        }
        return licenceInfo;
    }

    private LicenceFeatureInfo getLicFeatureInfoFromNode(NodeList nList) {
        LicenceFeatureInfo licenceFeatureInfo = new LicenceFeatureInfo();
        int i = 0;
        while (i < nList.getLength()) {
            try {
                Node licFeatureNode = nList.item(i);
                if (licFeatureNode.hasChildNodes()) {
                    String nodeName = licFeatureNode.getNodeName();
                    String nodeValue = licFeatureNode.getFirstChild().getNodeValue().trim();
                    if (nodeName.compareTo(FEATURE_CODE_NODENAME) == 0) {
                        licenceFeatureInfo.setFeatureCode(Long.parseLong(nodeValue));
                    } else if (nodeName.compareTo(FEATURE_NAME_NODENAME) == 0) {
                        licenceFeatureInfo.setFeatureName(nodeValue);
                    } else if (nodeName.compareTo(CAPACITY_CODE_NODENAME) == 0) {
                        licenceFeatureInfo.setCapacityCode(this.getCapacityCode(nodeValue));
                    } else if (nodeName.compareTo(MAX_CAPACITY_NODENAME) == 0) {
                        licenceFeatureInfo.setMaxCapacity(Long.parseLong(nodeValue));
                    } else if (nodeName.compareTo(BASIC_CAPACITY_NODENAME) == 0) {
                        licenceFeatureInfo.setBasicCapacity(Long.parseLong(nodeValue));
                    } else if (nodeName.compareTo(USED_CAPACITY_NODENAME) == 0) {
                        licenceFeatureInfo.setUsedCapacity(Long.parseLong(nodeValue));
                    } else if (nodeName.equals(FEATURE_STATUS_NODENAME)) {
                        licenceFeatureInfo.setFeatureStatus(this.getFeatureStatus(nodeValue));
                    } else {
                        this.myLogger.error((Object)("Invalid node '" + nodeName + "' in licence feature info"));
                    }
                } else {
                    this.myLogger.debug((Object)("LicenceFeatureInfo node " + licFeatureNode.getNodeName() + " doesn't have a value."));
                }
            }
            catch (Exception e) {
                this.myLogger.error((Object)"Exception, ", (Throwable)e);
            }
            ++i;
        }
        return licenceFeatureInfo;
    }

    private int getCapacityCode(String capacityCode) {
        int code = -1;
        if (capacityCode.equalsIgnoreCase(CAPACITY_CODE_LIMITED_NODEVALUE)) {
            code = 1;
        } else if (capacityCode.equalsIgnoreCase(CAPACITY_CODE_UNLIMITED_NODEVALUE)) {
            code = 2;
        } else if (capacityCode.equalsIgnoreCase(CAPACITY_CODE_UNUSED_NODEVALUE)) {
            code = 3;
        }
        return code;
    }

    private int getFeatureStatus(String featureStatus) {
        int status = -1;
        if (featureStatus.equals(FEATURE_STATUS_UNKNOWN_NODEVALUE)) {
            status = 1;
        } else if (featureStatus.equals(FEATURE_STATUS_ON_NODEVALUE)) {
            status = 2;
        } else if (featureStatus.equals(FEATURE_STATUS_OFF_NODEVALUE)) {
            status = 3;
        } else if (featureStatus.equals(FEATURE_STATUS_CONFIGURED_NODEVALUE)) {
            status = 4;
        } else {
            this.myLogger.error((Object)("Invalid value " + featureStatus + " in feature status, using CoreAsset.UNKNOWN_INT."));
        }
        return status;
    }
}

