/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.message;

import com.nokia.em.bts.coreasset.scenario.setrnd.RADParamWithSettingType;
import com.nokia.em.bts.rp.master.message.BTSInboundMessage;
import com.nokia.em.bts.rp.master.tool.Tools;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.log4j.Logger;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RadParamsGetResponse
extends BTSInboundMessage {
    private Map<Long, Long> myRadParams = new TreeMap<Long, Long>();
    private List<RADParamWithSettingType> myRndParams = new ArrayList<RADParamWithSettingType>();
    private static final String KEY_NODENAME = "_paramIndexNumber";
    private static final String VALUE_NODENAME = "_paramValue";
    private static final String VALIDITY_NODENAME = "_radSettingType";
    private Logger myLogger = Logger.getLogger(((Object)((Object)this)).getClass());

    public RadParamsGetResponse(int seqNbr, Node node) throws Exception {
        super(seqNbr);
        this.setCodedMessage(Tools.xmlToString((Node)node));
        NodeList radParamList = node.getChildNodes();
        int i = 0;
        while (i < radParamList.getLength()) {
            try {
                Node radParamNode = radParamList.item(i);
                NodeList keyValueList = radParamNode.getChildNodes();
                long key = -1L;
                long value = -1L;
                String validity = "";
                int j = 0;
                while (j < keyValueList.getLength()) {
                    Node keyValueNode = keyValueList.item(j);
                    if (keyValueNode.hasChildNodes()) {
                        String nodeName = keyValueNode.getNodeName();
                        if (nodeName.equals(KEY_NODENAME)) {
                            try {
                                key = Long.parseLong(keyValueNode.getFirstChild().getNodeValue().trim());
                            }
                            catch (Exception ex) {
                                this.myLogger.warn((Object)"Cannot parse key, using -1.", (Throwable)ex);
                            }
                        } else if (nodeName.equals(VALUE_NODENAME)) {
                            try {
                                value = Long.parseLong(keyValueNode.getFirstChild().getNodeValue().trim());
                            }
                            catch (Exception ex) {
                                this.myLogger.warn((Object)"Cannot parse value, using -1.", (Throwable)ex);
                            }
                        } else if (nodeName.equals(VALIDITY_NODENAME)) {
                            try {
                                validity = keyValueNode.getFirstChild().getNodeValue().trim();
                            }
                            catch (Exception ex) {
                                this.myLogger.warn((Object)"Cannot parse validity, using an empty string", (Throwable)ex);
                            }
                        } else {
                            this.myLogger.info((Object)("Has invalid xml tag, " + nodeName));
                        }
                    }
                    ++j;
                }
                this.myLogger.trace((Object)("Insert rad param. key:" + key + ", value:" + value));
                this.myRadParams.put(key, value);
                this.myRndParams.add(new RADParamWithSettingType(key, value, validity));
            }
            catch (Exception e) {
                this.myLogger.error((Object)"Cannot parse single rad param, continuing on next one. ", (Throwable)e);
            }
            ++i;
        }
    }

    public Map<Long, Long> getRadParams() {
        return this.myRadParams;
    }

    public List<RADParamWithSettingType> getRNDParams() {
        return Collections.unmodifiableList(this.myRndParams);
    }
}

