/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.message;

import com.nokia.em.bts.coreasset.message.SelfTestReportResponseBean;
import com.nokia.em.bts.rp.master.message.BTSInboundMessage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SelfTestReportResponse
extends BTSInboundMessage {
    private final String TEST_SUCCESS_OK_NODE_VALUE = "ok";
    private Map<String, Integer> myTestSuccessMessageMap;
    private List<SelfTestReportResponseBean> mySelfTestReportResponseList;
    private Integer myTestSuccess;

    public SelfTestReportResponse(int intSeqNbr) {
        super(intSeqNbr);
    }

    public SelfTestReportResponse(int intSeqNbr, Node xmlNode) {
        super(intSeqNbr);
        this.myTestSuccessMessageMap = this.createTestSuccessMap();
        this.mySelfTestReportResponseList = new ArrayList<SelfTestReportResponseBean>(10);
        this.writeResponseBeanToList(xmlNode);
    }

    private Map<String, Integer> createTestSuccessMap() {
        HashMap<String, Integer> testSuccessMap = new HashMap<String, Integer>(3);
        testSuccessMap.put("ok", 34);
        return testSuccessMap;
    }

    private void writeResponseBeanToList(Node selfTestReportResponseNode) {
        NodeList selfTestReportResponseChildNodes = selfTestReportResponseNode.getChildNodes();
        int i = 0;
        while (i < selfTestReportResponseChildNodes.getLength()) {
            Node currentNode = selfTestReportResponseChildNodes.item(i);
            if (currentNode.getNodeType() != 3) {
                if ("_testSuccess".equals(currentNode.getNodeName())) {
                    String testSuccessKey = currentNode.getTextContent().trim();
                    this.myTestSuccess = this.myTestSuccessMessageMap.get(testSuccessKey);
                } else if ("ModuleTestResult".equals(currentNode.getNodeName())) {
                    this.parseModuleTestResult(currentNode);
                }
            }
            ++i;
        }
    }

    private void parseModuleTestResult(Node testResultNode) {
        SelfTestReportResponseBean bean = new SelfTestReportResponseBean();
        NodeList testResultChildNodes = testResultNode.getChildNodes();
        int i = 0;
        while (i < testResultChildNodes.getLength()) {
            Node currentNode = testResultChildNodes.item(i);
            if (currentNode.getNodeType() != 3) {
                String currentNodeValue = currentNode.getTextContent().trim();
                if ("_moduleName".equals(currentNode.getNodeName())) {
                    bean.setModuleName(currentNodeValue);
                } else if ("_moduleSn".equals(currentNode.getNodeName())) {
                    bean.setModuleSerialNumber(currentNodeValue);
                } else if ("_testState".equals(currentNode.getNodeName())) {
                    bean.setTestState(currentNodeValue);
                } else if ("TestTimeStamp".equals(currentNode.getNodeName())) {
                    this.parseTestTimeStamp(bean, currentNode);
                }
            }
            ++i;
        }
    }

    private void parseTestTimeStamp(SelfTestReportResponseBean bean, Node testTimeStampNode) {
        NodeList testTimeStampChildNodes = testTimeStampNode.getChildNodes();
        int i = 0;
        while (i < testTimeStampChildNodes.getLength()) {
            Node currentNode = testTimeStampChildNodes.item(i);
            if (currentNode.getNodeType() != 3) {
                String currentNodeValue = currentNode.getTextContent().trim();
                if ("_year".equals(currentNode.getNodeName())) {
                    bean.setTestTimeStampYear(currentNodeValue);
                } else if ("_month".equals(currentNode.getNodeName())) {
                    bean.setTestTimeStampMonth(currentNodeValue);
                } else if ("_day".equals(currentNode.getNodeName())) {
                    bean.setTestTimeStampDay(currentNodeValue);
                } else if ("_hour".equals(currentNode.getNodeName())) {
                    bean.setTestTimeStampHour(currentNodeValue);
                } else if ("_minute".equals(currentNode.getNodeName())) {
                    bean.setTestTimeStampMinute(currentNodeValue);
                } else if ("_second".equals(currentNode.getNodeName())) {
                    bean.setTestTimeStampSecond(currentNodeValue);
                } else if ("_milisecond".equals(currentNode.getNodeName())) {
                    bean.setTestTimeStampMilliSecond(currentNodeValue);
                }
            }
            ++i;
        }
        this.mySelfTestReportResponseList.add(bean);
    }

    public List getReportList() {
        return Collections.unmodifiableList(this.mySelfTestReportResponseList);
    }

    public Integer getTestSuccess() {
        return this.myTestSuccess;
    }
}

