/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.message;

import com.nokia.em.bts.rp.master.filetransfer.FTPTransferInfo;
import com.nokia.em.bts.rp.master.message.BTSInboundMessage;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class StartTestResponse
extends BTSInboundMessage {
    private int mySuccessCode;
    private long myCabinetTestEstimatedDuration;
    private FTPTransferInfo myCabinetTestFTPTransferInfo;
    private static final String FTP_INFO_NODENAME = "FTPTransferInfo";
    private static final String FTP_INFO_USERNAME_NODENAME = "_userName";
    private static final String FTP_INFO_PASSWORD_NODENAME = "_password";
    private static final String FTP_INFO_SERVERADDRESS_NODENAME = "_serverAddress";
    private static final String FTP_INFO_FILEID_NODENAME = "_fileId";
    private static final String TEST_DURATION_TIME_NODENAME = "_testDurationTime";
    private static final String TEST_SUCCESS_NODENAME = "_testSuccess";
    static final String TEST_SUCCESS_OK_NODEVALUE = "ok";
    static final String TEST_SUCCESS_BUSY_NODEVALUE = "busy";
    static final String TEST_SUCCESS_INVALID_PARAMETER_NODEVALUE = "invalidParameter";
    static final String TEST_SUCCESS_TELECOM_NOT_RESPONDING_NODEVALUE = "telecomNotResponding";
    static final String TEST_SUCCESS_TELECOM_REJECTING_NODEVALUE = "telecomRejecting";
    static final String TEST_SUCCESS_INVALID_STATE_NODEVALUE = "invalidState";
    static final String TEST_SUCCESS_EXISTING_STATE_REFERENCED_NODEVALUE = "existingTestReferenced";
    static final String TEST_SUCCESS_INTERRUPTED_BY_USER_NODEVALUE = "interruptedByUser";
    static final String TEST_SUCCESS_SETUP_FAILURE_NODEVALUE = "setupFailure";
    static final String TEST_SUCCESS_RROM_NOT_RESPONDING_NODEVALUE = "rromNotResponding";
    static final String TEST_SUCCESS_RROM_REJECTING_NODEVALUE = "rromRejecting";
    static final String TEST_SUCCESS_RFSW_NOT_RESPONDING_NODEVALUE = "rfswNotResponding";
    static final String TEST_SUCCESS_RFSW_REJECTING_NODEVALUE = "rfswRejecting";
    static final String TEST_SUCCESS_INVALID_BTS_STATE_NODEVALUE = "invalidBTSState";
    static final String TEST_SUCCESS_INVALID_DATA_NODEVALUE = "invalidData";
    static final String TEST_SUCCESS_TEST_MODEL_START_FAIL_NODEVALUE = "testModelStartFail";
    static final String TEST_SUCCESS_MISSING_LICENCE_NODEVALUE = "missingLicence";
    static final String TEST_SUCCESS_FAILURE = "failure";
    private static final Map<String, Integer> successCodeConverter = new HashMap<String, Integer>();

    static {
        successCodeConverter.put(TEST_SUCCESS_OK_NODEVALUE, 34);
        successCodeConverter.put(TEST_SUCCESS_BUSY_NODEVALUE, 27);
        successCodeConverter.put(TEST_SUCCESS_INVALID_PARAMETER_NODEVALUE, 42);
        successCodeConverter.put(TEST_SUCCESS_TELECOM_NOT_RESPONDING_NODEVALUE, 58);
        successCodeConverter.put(TEST_SUCCESS_TELECOM_REJECTING_NODEVALUE, 59);
        successCodeConverter.put(TEST_SUCCESS_INVALID_STATE_NODEVALUE, 60);
        successCodeConverter.put(TEST_SUCCESS_EXISTING_STATE_REFERENCED_NODEVALUE, 61);
        successCodeConverter.put(TEST_SUCCESS_INTERRUPTED_BY_USER_NODEVALUE, 62);
        successCodeConverter.put(TEST_SUCCESS_SETUP_FAILURE_NODEVALUE, 103);
        successCodeConverter.put(TEST_SUCCESS_RROM_NOT_RESPONDING_NODEVALUE, 105);
        successCodeConverter.put(TEST_SUCCESS_RROM_REJECTING_NODEVALUE, 106);
        successCodeConverter.put(TEST_SUCCESS_RFSW_NOT_RESPONDING_NODEVALUE, 107);
        successCodeConverter.put(TEST_SUCCESS_RFSW_REJECTING_NODEVALUE, 108);
        successCodeConverter.put(TEST_SUCCESS_INVALID_BTS_STATE_NODEVALUE, 129);
        successCodeConverter.put(TEST_SUCCESS_INVALID_DATA_NODEVALUE, 65);
        successCodeConverter.put(TEST_SUCCESS_TEST_MODEL_START_FAIL_NODEVALUE, 130);
        successCodeConverter.put(TEST_SUCCESS_MISSING_LICENCE_NODEVALUE, 77);
        successCodeConverter.put(TEST_SUCCESS_FAILURE, 136);
    }

    public StartTestResponse(int intSeqNbr, int intSuccessCode) {
        super(intSeqNbr);
        this.mySuccessCode = intSuccessCode;
    }

    public StartTestResponse(int intSeqNbr, int intSuccessCode, long duration, FTPTransferInfo ftpTransferInfo) {
        super(intSeqNbr);
        this.mySuccessCode = intSuccessCode;
        this.myCabinetTestEstimatedDuration = duration;
        this.myCabinetTestFTPTransferInfo = ftpTransferInfo;
    }

    public StartTestResponse(int intSeqNbr, Node xmlNode) throws Exception {
        super(intSeqNbr);
        NodeList ftpTransferInfo;
        Node node;
        this.myCabinetTestEstimatedDuration = -1L;
        Document doc = xmlNode.getOwnerDocument();
        this.mySuccessCode = StartTestResponse.getSuccessCode(doc.getElementsByTagName(TEST_SUCCESS_NODENAME).item(0).getFirstChild().getNodeValue().trim());
        NodeList testDurationTime = doc.getElementsByTagName(TEST_DURATION_TIME_NODENAME);
        if (testDurationTime.getLength() > 0 && (node = testDurationTime.item(0)) != null && node.hasChildNodes()) {
            this.myCabinetTestEstimatedDuration = Long.parseLong(node.getFirstChild().getNodeValue().trim());
        }
        if ((ftpTransferInfo = doc.getElementsByTagName(FTP_INFO_NODENAME)).getLength() > 0) {
            this.setFTPTransferInfo(ftpTransferInfo.item(0));
        }
    }

    static final int getSuccessCode(String nodeValue) {
        try {
            return successCodeConverter.get(nodeValue);
        }
        catch (NullPointerException e) {
            return -1;
        }
    }

    public final FTPTransferInfo getCabinetTestFTPTransferInfo() {
        return this.myCabinetTestFTPTransferInfo;
    }

    public final long getCabinetTestEstimatedDuration() {
        return this.myCabinetTestEstimatedDuration;
    }

    public final int getSuccessCode() {
        return this.mySuccessCode;
    }

    private void setFTPTransferInfo(Node node) {
        String fileId = "Coreasset_Unknown";
        String serverAddress = "Coreasset_Unknown";
        String userName = "Coreasset_Unknown";
        char[] password = new char[]{};
        if (node != null && node.hasChildNodes()) {
            NodeList ftpNodeList = node.getChildNodes();
            int i = 0;
            while (i < ftpNodeList.getLength()) {
                Node ftpItemNode = ftpNodeList.item(i);
                if (ftpItemNode.hasChildNodes()) {
                    String nodeName = ftpItemNode.getNodeName();
                    String nodeValue = ftpItemNode.getFirstChild().getNodeValue().trim();
                    if (nodeName.equalsIgnoreCase(FTP_INFO_FILEID_NODENAME)) {
                        fileId = nodeValue;
                    } else if (nodeName.equalsIgnoreCase(FTP_INFO_SERVERADDRESS_NODENAME)) {
                        serverAddress = nodeValue;
                    } else if (nodeName.equalsIgnoreCase(FTP_INFO_USERNAME_NODENAME)) {
                        userName = nodeValue;
                    } else if (nodeName.equalsIgnoreCase(FTP_INFO_PASSWORD_NODENAME)) {
                        password = nodeValue.toCharArray();
                    }
                }
                ++i;
            }
        }
        this.myCabinetTestFTPTransferInfo = new FTPTransferInfo(fileId, serverAddress, userName, password);
    }
}

