/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.message;

import com.nokia.em.bts.rp.master.message.BTSInboundMessage;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TestCompletedNotif
extends BTSInboundMessage {
    private String myCdmaTestSuccess = "";
    private int myCabinetTestSuccess = -1;
    private int myRFTestSuccess = -1;
    private int myOverallTestResult = -1;
    private static final String CDMA_TEST_SUCCESS_NODENAME = "_cdmaTestSuccess";
    private static final String CABINET_TEST_SUCCESS_NODENAME = "_cabinetTestSuccess";
    private static final String RF_TEST_SUCCESS_NODENAME = "_rfTestSuccess";
    private static final String CABINET_TEST_SUCCESS_SUCCESSFUL_NODEVALUE = "successful";
    private static final String CABINET_TEST_SUCCESS_FAILED_NODEVALUE = "failed";
    private static final String OVERALL_TEST_VERDICT_NODENAME = "_testVerdict";
    private static final String OVERALL_TEST_VERDICT_PASS_NODEVALUE = "pass";
    private static final String OVERALL_TEST_VERDICT_FAIL_NODEVALUE = "fail";
    private static final String RF_TEST_OK = "ok";
    private static final String RF_TEST_UNABLE_TO_STORE_FILE_NODEVALUE = "unableToStoreFile";
    private static final String RF_TEST_UNABLE_TO_GENERATE_FILE_NODEVALUE = "unableToGenerateFile";
    private static final String RF_TEST_UNABLE_TO_EXECUTE_NODEVALUE = "unableToExecute";
    private static final String RF_TEST_TELECOM_NOT_RELEASED = "telecomNotReleased";
    private static final String RF_TEST_TELECOM_NOT_RESPONDING = "telecomNotResponding";
    private static final String RF_TEST_UNABLE_TO_CLEANUP = "unableToCleanup";

    public TestCompletedNotif(int intSeqNbr, String cdmaTestSuccess) {
        super(intSeqNbr);
        this.myCdmaTestSuccess = cdmaTestSuccess;
    }

    public TestCompletedNotif(int intSeqNbr, Node node) throws Exception {
        super(intSeqNbr);
        Document doc = node.getOwnerDocument();
        this.createCdmaTestResult(doc.getElementsByTagName(CDMA_TEST_SUCCESS_NODENAME));
        this.createCabinetTestResult(doc.getElementsByTagName(CABINET_TEST_SUCCESS_NODENAME));
        this.createOverallResult(doc.getElementsByTagName(OVERALL_TEST_VERDICT_NODENAME));
        this.createRFTestResult(doc.getElementsByTagName(RF_TEST_SUCCESS_NODENAME));
    }

    private void createRFTestResult(NodeList nodeList) {
        Node first;
        if (nodeList.getLength() > 0 && (first = nodeList.item(0).getFirstChild()) != null && first.getNodeValue() != null) {
            String nodeValue = first.getNodeValue().trim();
            this.myRFTestSuccess = nodeValue.equalsIgnoreCase(RF_TEST_OK) ? 34 : (nodeValue.equalsIgnoreCase(RF_TEST_UNABLE_TO_STORE_FILE_NODEVALUE) ? 126 : (nodeValue.equalsIgnoreCase(RF_TEST_UNABLE_TO_GENERATE_FILE_NODEVALUE) ? 127 : (nodeValue.equalsIgnoreCase(RF_TEST_UNABLE_TO_EXECUTE_NODEVALUE) ? 128 : (nodeValue.equalsIgnoreCase(RF_TEST_TELECOM_NOT_RELEASED) ? 135 : (nodeValue.equalsIgnoreCase(RF_TEST_TELECOM_NOT_RESPONDING) ? 58 : (nodeValue.equalsIgnoreCase(RF_TEST_UNABLE_TO_CLEANUP) ? 138 : 132))))));
        }
    }

    private void createOverallResult(NodeList nodeList) {
        Node first;
        if (nodeList.getLength() > 0 && (first = nodeList.item(0).getFirstChild()) != null && first.getNodeValue() != null) {
            String nodeValue = first.getNodeValue().trim();
            if (nodeValue.equalsIgnoreCase(OVERALL_TEST_VERDICT_PASS_NODEVALUE)) {
                this.myOverallTestResult = 36;
            } else if (nodeValue.equalsIgnoreCase(OVERALL_TEST_VERDICT_FAIL_NODEVALUE)) {
                this.myOverallTestResult = 37;
            }
        }
    }

    private void createCabinetTestResult(NodeList nodeList) {
        Node first;
        if (nodeList.getLength() > 0 && (first = nodeList.item(0).getFirstChild()) != null && first.getNodeValue() != null) {
            String nodeValue = first.getNodeValue().trim();
            if (nodeValue.equalsIgnoreCase(CABINET_TEST_SUCCESS_SUCCESSFUL_NODEVALUE)) {
                this.myCabinetTestSuccess = 36;
            } else if (nodeValue.equalsIgnoreCase(CABINET_TEST_SUCCESS_FAILED_NODEVALUE)) {
                this.myCabinetTestSuccess = 37;
            }
        }
    }

    private void createCdmaTestResult(NodeList nodeList) {
        Node first;
        if (nodeList.getLength() > 0 && (first = nodeList.item(0).getFirstChild()) != null && first.getNodeValue() != null) {
            this.myCdmaTestSuccess = first.getNodeValue().trim();
        }
    }

    public final String getCdmaTestSuccess() {
        return this.myCdmaTestSuccess;
    }

    public int getCabinetTestSuccess() {
        return this.myCabinetTestSuccess;
    }

    public int getOverallTestResult() {
        return this.myOverallTestResult;
    }

    public int getRFTestResult() {
        return this.myRFTestSuccess;
    }

    public String getOverallTestResultString() {
        String overallTestResult;
        switch (this.myOverallTestResult) {
            case 36: {
                overallTestResult = OVERALL_TEST_VERDICT_PASS_NODEVALUE;
                break;
            }
            case 37: {
                overallTestResult = OVERALL_TEST_VERDICT_FAIL_NODEVALUE;
                break;
            }
            default: {
                overallTestResult = "Coreasset_Unknown";
            }
        }
        return overallTestResult;
    }
}

