/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.message;

import com.nokia.em.bts.rp.master.message.BTSInboundMessage;
import org.apache.log4j.Logger;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TestReportResponseBER
extends BTSInboundMessage {
    private float myBerPercentage = -1.0f;
    private float myBlerPercentage = -1.0f;
    private boolean myATMSynchronized;
    private boolean myATMResponding;
    private long myReceivedBits = -1L;
    private long myDefectedBits = -1L;
    private long myCrcErrorCount = -1L;
    private long myCountedFrames = -1L;
    private long myUnsynchrFrames = -1L;
    private float myPerPercentage = -1.0f;
    private boolean mySyncState;
    private int myReceivedPackets = -1;
    private int myDefectedPackets = -1;
    private float myAckPercentage = -1.0f;
    private boolean myResultReliability;
    private long myReceivedAcks = -1L;
    private long myReceivedNacks = -1L;
    private float myThroughputPercentage = -1.0f;
    private long myReceivedBlocks = -1L;
    private long myUnreceivedBlocks = -1L;
    private static final String ATM_RESPONDING_NODENAME = "_atmResponding";
    private static final String TEST_REPORT_DATA_BER_NODENAME = "TestReportDataBER";
    private static final String ATM_SYNC_STATE_NODENAME = "_atmSyncState";
    private static final String BER_PERCENTAGE_NODENAME = "_berPercentage";
    private static final String BLER_PERCENTAGE_NODENAME = "_blerPercentage";
    private static final String RECEIVED_BITS_NODENAME = "_receivedBits";
    private static final String DEFECTED_BITS_NODENAME = "_defectedBits";
    private static final String CRC_ERROR_COUNT_NODENAME = "_crcErrorCount";
    private static final String COUNTED_FRAMES_NODENAME = "_countedFrames";
    private static final String UNSYNCHR_FRAMES_NODENAME = "_unsynchrFrames";
    private static final String TEST_REPORT_DATA_BER_WIMAX_NODENAME = "TestReportDataWimaxBER";
    private static final String BB_RESPONDING_NODENAME = "_bbResponding";
    private static final String PER_PERCENTAGE_NODENAME = "_perPercentage";
    private static final String SYNC_STATE_NODENAME = "_syncState";
    private static final String RECEIVED_PACKETS_NODENAME = "_receivedPackets";
    private static final String DEFECTED_PACKETS_NODENAME = "_defectedPackets";
    private Logger myLogger = Logger.getLogger(((Object)((Object)this)).getClass());

    public TestReportResponseBER(int intSeqNbr, float fltBerPercentage, float fltBlerPercentage, boolean blnATMSynchronized, boolean blnATMResponding, long longReceivedBits, long longDefectedBits, long longCrcErrorCount, long longCountedFrames, long longUnsynchrFrames) {
        super(intSeqNbr);
        this.myBerPercentage = fltBerPercentage;
        this.myBlerPercentage = fltBlerPercentage;
        this.myATMSynchronized = blnATMSynchronized;
        this.myATMResponding = blnATMResponding;
        this.myReceivedBits = longReceivedBits;
        this.myDefectedBits = longDefectedBits;
        this.myCrcErrorCount = longCrcErrorCount;
        this.myCountedFrames = longCountedFrames;
        this.myUnsynchrFrames = longUnsynchrFrames;
    }

    public TestReportResponseBER(int intSeqNbr, Node xmlNode) throws Exception {
        super(intSeqNbr);
        NodeList nodeList = xmlNode.getChildNodes();
        String nodeName = "";
        int i = 0;
        while (i < nodeList.getLength()) {
            Node testRepNode;
            int j;
            NodeList testRepNodeList;
            Node node = nodeList.item(i);
            if (node.getNodeName().equals(ATM_RESPONDING_NODENAME) || node.getNodeName().equals(BB_RESPONDING_NODENAME)) {
                this.myATMResponding = Boolean.valueOf(node.getFirstChild().getNodeValue().trim());
                if (!this.isATMResponding()) {
                    break;
                }
            } else if (node.getNodeName().equals(TEST_REPORT_DATA_BER_NODENAME)) {
                testRepNodeList = node.getChildNodes();
                j = 0;
                while (j < testRepNodeList.getLength()) {
                    try {
                        testRepNode = testRepNodeList.item(j);
                        nodeName = testRepNode.getNodeName();
                        this.parseCommonParameters(testRepNode, nodeName);
                        if (nodeName.equals(ATM_SYNC_STATE_NODENAME)) {
                            this.myATMSynchronized = Boolean.valueOf(testRepNode.getFirstChild().getNodeValue().trim());
                        } else if (nodeName.equals(BLER_PERCENTAGE_NODENAME)) {
                            this.myBlerPercentage = Float.parseFloat(testRepNode.getFirstChild().getNodeValue().trim());
                        } else if (nodeName.equals(CRC_ERROR_COUNT_NODENAME)) {
                            this.myCrcErrorCount = Long.parseLong(testRepNode.getFirstChild().getNodeValue().trim());
                        } else if (nodeName.equals(COUNTED_FRAMES_NODENAME)) {
                            this.myCountedFrames = Long.parseLong(testRepNode.getFirstChild().getNodeValue().trim());
                        } else if (nodeName.equals(UNSYNCHR_FRAMES_NODENAME)) {
                            this.myUnsynchrFrames = Long.parseLong(testRepNode.getFirstChild().getNodeValue().trim());
                        }
                    }
                    catch (Exception e) {
                        this.myLogger.error((Object)("Error in parsing data, node " + nodeName + ": " + e.getMessage() + ". Continuing to next node."));
                    }
                    ++j;
                }
            } else if (node.getNodeName().equals(TEST_REPORT_DATA_BER_WIMAX_NODENAME)) {
                testRepNodeList = node.getChildNodes();
                j = 0;
                while (j < testRepNodeList.getLength()) {
                    try {
                        testRepNode = testRepNodeList.item(j);
                        nodeName = testRepNode.getNodeName();
                        this.parseCommonParameters(testRepNode, nodeName);
                        if (nodeName.equals(SYNC_STATE_NODENAME)) {
                            this.mySyncState = Boolean.valueOf(testRepNode.getFirstChild().getNodeValue().trim());
                        } else if (nodeName.equals(PER_PERCENTAGE_NODENAME)) {
                            this.myPerPercentage = Float.parseFloat(testRepNode.getFirstChild().getNodeValue().trim());
                        } else if (nodeName.equals(RECEIVED_PACKETS_NODENAME)) {
                            this.myReceivedPackets = Integer.parseInt(testRepNode.getFirstChild().getNodeValue().trim());
                        } else if (nodeName.equals(DEFECTED_PACKETS_NODENAME)) {
                            this.myDefectedPackets = Integer.parseInt(testRepNode.getFirstChild().getNodeValue().trim());
                        }
                    }
                    catch (Exception e) {
                        this.myLogger.error((Object)("Error in parsing data, node " + nodeName + ": " + e.getMessage() + ". Continuing to next node."));
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    public float getBerPercentage() {
        return this.myBerPercentage;
    }

    public float getBlerPercentage() {
        return this.myBlerPercentage;
    }

    public boolean isATMSynchronized() {
        return this.myATMSynchronized;
    }

    public boolean isATMResponding() {
        return this.myATMResponding;
    }

    public long getReceivedBits() {
        return this.myReceivedBits;
    }

    public long getDefectedBits() {
        return this.myDefectedBits;
    }

    public long getCrcErrorCount() {
        return this.myCrcErrorCount;
    }

    public long getCountedFrames() {
        return this.myCountedFrames;
    }

    public long getUnsynchrFrames() {
        return this.myUnsynchrFrames;
    }

    public boolean getSyncState() {
        return this.mySyncState;
    }

    public float getPerPercentage() {
        return this.myPerPercentage;
    }

    public int getReceivedPackets() {
        return this.myReceivedPackets;
    }

    public int getDefectedPackets() {
        return this.myDefectedPackets;
    }

    public float getAckPercentage() {
        return this.myAckPercentage;
    }

    public boolean isResultReliable() {
        return this.myResultReliability;
    }

    public long getReceivedAcks() {
        return this.myReceivedAcks;
    }

    public long getReceivedNacks() {
        return this.myReceivedNacks;
    }

    public float getThroughputPercentage() {
        return this.myThroughputPercentage;
    }

    public long getReceivedBlocks() {
        return this.myReceivedBlocks;
    }

    public long getUnreceivedBlocks() {
        return this.myUnreceivedBlocks;
    }

    private void parseCommonParameters(Node node, String nodeName) {
        if (nodeName.equals(BER_PERCENTAGE_NODENAME)) {
            this.myBerPercentage = Float.parseFloat(node.getFirstChild().getNodeValue().trim());
        } else if (nodeName.equals(RECEIVED_BITS_NODENAME)) {
            this.myReceivedBits = Long.parseLong(node.getFirstChild().getNodeValue().trim());
        } else if (nodeName.equals(DEFECTED_BITS_NODENAME)) {
            this.myDefectedBits = Long.parseLong(node.getFirstChild().getNodeValue().trim());
        }
    }
}

