/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.message;

import com.nokia.em.bts.rp.master.message.BTSMessage;
import com.nokia.em.poseidon.util.security.Base64;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;

public class TiltConfigureRequest
extends BTSMessage {
    private int myId;
    private String myParameters;

    public TiltConfigureRequest(int intSeqNbr, int configObjectId, Float mechanicalTiltAngle, Byte[] deviceData, float tiltAngleMin, float tiltAngleMax) {
        super(intSeqNbr);
        this.myId = configObjectId;
        DecimalFormatSymbols symbols = new DecimalFormatSymbols();
        symbols.setDecimalSeparator('.');
        DecimalFormat myFormatter = new DecimalFormat("0.0", symbols);
        StringBuilder s = new StringBuilder();
        if (mechanicalTiltAngle != null || deviceData != null) {
            if (deviceData != null) {
                byte[] deviceDataBytes = new byte[deviceData.length];
                int i = 0;
                while (i < deviceData.length) {
                    deviceDataBytes[i] = deviceData[i];
                    ++i;
                }
                s.append("<_deviceData>").append(new String(Base64.encodeToBytes((byte[])deviceDataBytes, (boolean)false))).append("</_deviceData>");
            }
            if (mechanicalTiltAngle != null) {
                s.append("<_mechanicalTiltAngle>").append(myFormatter.format(mechanicalTiltAngle)).append("</_mechanicalTiltAngle>");
            }
        } else {
            s.append("<_tiltAngleMin>").append(myFormatter.format(tiltAngleMin)).append("</_tiltAngleMin>");
            s.append("<_tiltAngleMax>").append(myFormatter.format(tiltAngleMax)).append("</_tiltAngleMax>");
        }
        this.myParameters = s.toString();
    }

    public TiltConfigureRequest(int intSeqNbr, int configObjectId, Float mechanicalTiltAngle, Byte[] deviceData, float tiltAngleMin, float tiltAngleMax, BTSMessage.Type type) {
        this(intSeqNbr, configObjectId, mechanicalTiltAngle, deviceData, tiltAngleMin, tiltAngleMax);
        this.myType = type;
    }

    public String getContent() {
        StringBuilder s = new StringBuilder();
        s.append("<TiltConfigureRequest><_configObjectId>");
        s.append(this.myId);
        s.append("</_configObjectId>");
        s.append(this.myParameters);
        s.append("</TiltConfigureRequest>");
        return s.toString();
    }
}

