/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.message;

import com.nokia.em.bts.coreasset.scenario.antennamanagement.vswr.monitoring.VSWRMonitoringData;
import com.nokia.em.bts.rp.master.message.BTSInboundMessage;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class VSWRMonitoringNotification
extends BTSInboundMessage {
    private static final String VSWR_MONITORING_DATA = "VSWRMonitoringData";
    private static final String CONFIG_OBJECT_ID = "_configObjectId";
    private static final String VSWR_VALUE = "_vswrValue";
    private List<VSWRMonitoringData> myVswrMonitoringDataList = new ArrayList<VSWRMonitoringData>();

    public VSWRMonitoringNotification(int sequenceNumber, Node xmlNode) {
        super(sequenceNumber);
        NodeList nodeList = xmlNode.getChildNodes();
        int index = 0;
        while (index < nodeList.getLength()) {
            Node vswrMonitoringData = nodeList.item(index);
            if (VSWR_MONITORING_DATA.equals(vswrMonitoringData.getNodeName())) {
                VSWRMonitoringData data = this.parseVswrMonitoringData(vswrMonitoringData);
                this.myVswrMonitoringDataList.add(data);
            }
            ++index;
        }
    }

    public List<VSWRMonitoringData> getVswrMonitoringDataList() {
        return this.myVswrMonitoringDataList;
    }

    private VSWRMonitoringData parseVswrMonitoringData(Node vswrMonitoringData) {
        NodeList vswrMonitoringDataChilds = vswrMonitoringData.getChildNodes();
        String configObjectId = "";
        String vswrValue = "";
        int idx = 0;
        while (idx < vswrMonitoringDataChilds.getLength()) {
            Node vswrMonitoringDataChild = vswrMonitoringDataChilds.item(idx);
            if (vswrMonitoringDataChild.hasChildNodes()) {
                String nodeName = vswrMonitoringDataChild.getNodeName();
                if (CONFIG_OBJECT_ID.equals(nodeName)) {
                    configObjectId = vswrMonitoringDataChild.getTextContent();
                }
                if (VSWR_VALUE.equals(nodeName)) {
                    vswrValue = vswrMonitoringDataChild.getTextContent();
                }
            }
            ++idx;
        }
        return new VSWRMonitoringData(configObjectId, vswrValue);
    }
}

