/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.message;

import com.nokia.em.bts.rp.master.message.BTSMessage;
import java.util.List;

public class VSWRMonitoringStateRequest
extends BTSMessage {
    private static final String XML_TAG = "VSWRMonitoringStateRequest";
    private List<Integer> myUnitIds;
    private boolean myEnabled;
    private int myInterval;

    public VSWRMonitoringStateRequest(int sequenceNumber, List<Integer> unitIds, boolean enabled, BTSMessage.Type type) {
        this(sequenceNumber, unitIds, enabled, -1, type);
    }

    public VSWRMonitoringStateRequest(int sequenceNumber, List<Integer> unitIds, boolean enabled, int interval, BTSMessage.Type type) {
        super(sequenceNumber, type);
        this.myUnitIds = unitIds;
        this.myEnabled = enabled;
        this.myInterval = interval;
    }

    public String getContent() {
        return String.valueOf(this.buildXMLStartTag()) + this.buildConfigObjectId() + this.buildEnabledState() + this.buildInterval() + this.buildXMLEndTag();
    }

    private String buildXMLStartTag() {
        return "<VSWRMonitoringStateRequest>";
    }

    private String buildXMLEndTag() {
        return "</VSWRMonitoringStateRequest>";
    }

    private String buildConfigObjectId() {
        StringBuilder builder = new StringBuilder();
        for (Integer unitId : this.myUnitIds) {
            builder.append(String.format("<_configObjectId>%d</_configObjectId>", unitId));
        }
        return builder.toString();
    }

    private String buildEnabledState() {
        return String.format("<_enabledState>%s</_enabledState>", this.myEnabled ? "enabled" : "disabled");
    }

    private String buildInterval() {
        return this.myInterval < 0 ? "" : String.format("<_interval>%d</_interval>", this.myInterval);
    }
}

