/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.message.extendedlogging;

import com.nokia.em.bts.coreasset.scenario.techlogfiles.LoggingCategory;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public final class TTITraceLogMessageUtil {
    private static final String EMPTY_STRING = "";
    private static final String TTITRACELOG_LOGGING_FORMAT = "<LoggingCategory>%s<_category>%s</_category><_status>%s</_status>%s%s</LoggingCategory>";
    private static final String FETCHING_LEVEL_FORMAT = "<_fetchingLevel>%s</_fetchingLevel>";
    private static final String FETCHING_LEVEL_ID_FORMAT = "<FetchingLevelIds>%s</FetchingLevelIds>";

    private TTITraceLogMessageUtil() {
    }

    public static String extractTtiTraceLogMessage(LoggingCategory category) {
        String bbTraceList = TTITraceLogMessageUtil.createBBTraceList(category);
        String level = TTITraceLogMessageUtil.createFetchingLevel(category);
        String levelIds = TTITraceLogMessageUtil.createFetchingLevelIds(category);
        return String.format(TTITRACELOG_LOGGING_FORMAT, new Object[]{level, category.getCategory(), category.getStatus(), bbTraceList, levelIds});
    }

    public static String createBBTraceList(LoggingCategory category) {
        StringBuilder bbTraceList = new StringBuilder(EMPTY_STRING);
        Map<String, String> bbTraceMap = category.getBbTraceList();
        if (bbTraceMap != null && !bbTraceMap.isEmpty()) {
            bbTraceMap.entrySet().stream().forEach(entry -> TTITraceLogMessageUtil.appendBBTrace(bbTraceList, entry));
        }
        return bbTraceList.toString();
    }

    private static void appendBBTrace(StringBuilder bbTraceList, Map.Entry<String, String> entry) {
        bbTraceList.append("<BbTraceList><_bbTraceId>" + entry.getKey() + "</_bbTraceId>");
        Optional.ofNullable(entry.getValue()).filter(TTITraceLogMessageUtil::isNotEmpty).ifPresent(value -> {
            StringBuilder stringBuilder2 = bbTraceList.append("<_bitmask>" + TTITraceLogMessageUtil.convertHexToUnsignedLong(value) + "</_bitmask>");
        });
        bbTraceList.append("</BbTraceList>");
    }

    public static String convertHexToUnsignedLong(String hexValue) {
        String hexOnly = hexValue.substring(hexValue.indexOf(120) + 1);
        return EMPTY_STRING + Long.parseUnsignedLong(hexOnly, 16);
    }

    public static String createFetchingLevel(LoggingCategory category) {
        return Optional.ofNullable(category.getFetchingLevel()).map(level -> String.format(FETCHING_LEVEL_FORMAT, level)).orElse(EMPTY_STRING);
    }

    public static String createFetchingLevelIds(LoggingCategory category) {
        List<String> levelIds = category.getFetchingLevelIds();
        if (levelIds != null && !levelIds.isEmpty()) {
            StringBuilder fetchingLevelIds = new StringBuilder(EMPTY_STRING);
            levelIds.stream().filter(TTITraceLogMessageUtil::isNotEmpty).forEach(id -> {
                StringBuilder stringBuilder2 = fetchingLevelIds.append("<_localCellId>" + id + "</_localCellId>");
            });
            return String.format(FETCHING_LEVEL_ID_FORMAT, fetchingLevelIds.toString());
        }
        return EMPTY_STRING;
    }

    private static boolean isNotEmpty(String value) {
        return !EMPTY_STRING.equals(value);
    }
}

