/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.scenario.acnonopbackhaulparams;

import com.nokia.em.bts.coreasset.CoreAsset;
import com.nokia.em.bts.coreasset.scenario.Scenario;
import com.nokia.em.bts.coreasset.scenario.acnonopbackhaulparams.ACNonOpBackhaulParamsBean;
import com.nokia.em.bts.coreasset.scenario.acnonopbackhaulparams.ACNonOpBackhaulParamsScenarioListener;
import com.nokia.em.bts.coreasset.scenario.acnonopbackhaulparams.ACNonOpBackhaulParamsUpdateRequest;
import com.nokia.em.bts.rp.master.connection.BTSConnection;
import com.nokia.em.bts.rp.master.message.Ack;
import com.nokia.em.bts.rp.master.message.BTSMessage;
import com.nokia.em.bts.rp.master.message.Timeout;
import com.nokia.em.bts.rp.master.tool.CoreAssetThread;
import org.apache.log4j.Logger;

public class ACNonOpBackhaulParamsUpdateScenario
implements Scenario {
    private ACNonOpBackhaulParamsScenarioListener myListener;
    private BTSConnection myBTSConnection;
    private ACNonOpBackhaulParamsBean myBean;
    private Logger myLogger;
    private boolean myRunning = false;
    private int mySeqNumber;

    public ACNonOpBackhaulParamsUpdateScenario(BTSConnection btsConnection, ACNonOpBackhaulParamsScenarioListener listener, ACNonOpBackhaulParamsBean bean) {
        this.myBTSConnection = btsConnection;
        this.myListener = listener;
        this.myBean = bean;
        this.myLogger = Logger.getLogger(this.getClass());
    }

    @Override
    public void execute() {
        if (this.myRunning) {
            throw new IllegalStateException("Cannot execute Scenario. Scenario already in process.");
        }
        this.myRunning = true;
        CoreAssetThread worker = this.createScenarioWorker();
        worker.start();
    }

    private CoreAssetThread createScenarioWorker() {
        return new CoreAssetThread(){

            protected Object construct() {
                ACNonOpBackhaulParamsUpdateScenario.this.runScenario();
                return true;
            }

            protected void finished() {
                ACNonOpBackhaulParamsUpdateScenario.this.myBTSConnection.deleteScenario(ACNonOpBackhaulParamsUpdateScenario.this.mySeqNumber);
                ACNonOpBackhaulParamsUpdateScenario.this.myRunning = false;
            }
        };
    }

    protected void runScenario() {
        if (CoreAsset.isSnapshotOpening()) {
            this.myListener.acNonOpBackhaulParamsUpdateFailed(85);
            this.myLogger.error((Object)"Updating Autocon Non Operator-Owned Backhaul Parameters is not allowed in snapshot mode.");
            return;
        }
        this.mySeqNumber = this.myBTSConnection.createScenario();
        ACNonOpBackhaulParamsUpdateRequest updateRequest = new ACNonOpBackhaulParamsUpdateRequest(this.mySeqNumber, this.myBean);
        this.myBTSConnection.sendToBTS((BTSMessage)updateRequest);
        BTSMessage response = this.myBTSConnection.receiveFromBTS(this.mySeqNumber, 60000L);
        this.handleResponse(response);
    }

    private void handleResponse(BTSMessage response) {
        if (response instanceof Timeout) {
            this.myListener.acNonOpBackhaulParamsUpdateFailed(68);
            this.myLogger.error((Object)"Updating Non Operator-Owned Backhaul Parameters timed out");
        } else if (response instanceof Ack) {
            Ack ack = (Ack)response;
            if (ack.getAck()) {
                this.myListener.acNonOpBackhaulParamsUpdateSuccessful(this.myBean);
            } else {
                this.myListener.acNonOpBackhaulParamsUpdateFailed(ack.getNackReason());
                this.myLogger.error((Object)("Updating Non Operator-Owned Backhaul Parameters failed. Reason: " + ack.getNackReasonString()));
            }
        } else {
            this.myListener.acNonOpBackhaulParamsUpdateFailed(28);
            this.myLogger.error((Object)"Invalid response received");
        }
    }

    @Override
    public boolean abort() {
        return true;
    }
}

