/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.scenario.acnonopbackhaulparams;

import com.nokia.em.bts.coreasset.CoreAsset;
import com.nokia.em.bts.coreasset.scenario.Scenario;
import com.nokia.em.bts.coreasset.scenario.acnonopbackhaulparams.ACNonOpBackhaulParamsBean;
import com.nokia.em.bts.coreasset.scenario.acnonopbackhaulparams.ACNonOpBackhaulParamsScenarioListener;
import com.nokia.em.bts.coreasset.scenario.acnonopbackhaulparams.GetACNonOpBackhaulParamsRequest;
import com.nokia.em.bts.coreasset.scenario.acnonopbackhaulparams.GetACNonOpBackhaulParamsResponse;
import com.nokia.em.bts.rp.master.connection.BTSConnection;
import com.nokia.em.bts.rp.master.message.BTSMessage;
import com.nokia.em.bts.rp.master.message.Timeout;
import com.nokia.em.bts.rp.master.tool.CoreAssetThread;
import org.apache.log4j.Logger;

public class GetACNonOpBackhaulParamsScenario
implements Scenario {
    private static final int DEFAULT_REQUEST_ATTEMPTS = 3;
    private long myRequestInterval = 10000L;
    private ACNonOpBackhaulParamsScenarioListener myListener;
    private boolean myRunning = false;
    private BTSConnection myBTSConnection;
    private int mySeqNumber;
    private Logger myLogger;
    private boolean myRetryAvailable;
    private int myAttempts;

    public GetACNonOpBackhaulParamsScenario(BTSConnection btsConnection, ACNonOpBackhaulParamsScenarioListener listener, boolean retry) {
        this.myBTSConnection = btsConnection;
        this.myListener = listener;
        this.myLogger = Logger.getLogger(this.getClass());
        this.myRetryAvailable = retry;
    }

    @Override
    public void execute() {
        if (this.myRunning) {
            throw new IllegalStateException("Cannot execute Scenario. Scenario already in process.");
        }
        this.myRunning = true;
        CoreAssetThread worker = this.createScenarioWorker();
        worker.start();
    }

    private CoreAssetThread createScenarioWorker() {
        return new CoreAssetThread(){

            protected Object construct() {
                GetACNonOpBackhaulParamsScenario.this.runScenario();
                return true;
            }

            protected void finished() {
                GetACNonOpBackhaulParamsScenario.this.myBTSConnection.deleteScenario(GetACNonOpBackhaulParamsScenario.this.mySeqNumber);
                GetACNonOpBackhaulParamsScenario.this.myRunning = false;
            }
        };
    }

    protected void runScenario() {
        if (CoreAsset.isSnapshotOpening()) {
            this.myListener.acNonOpBackhaulParamsGetFailed(85);
            this.myLogger.error((Object)"Fetching Autocon Non Operator-Owned Backhaul Parameters is not allowed in snapshot mode.");
            return;
        }
        this.mySeqNumber = this.myBTSConnection.createScenario();
        GetACNonOpBackhaulParamsRequest startTestRequest = new GetACNonOpBackhaulParamsRequest(this.mySeqNumber);
        BTSMessage response = null;
        this.myAttempts = 0;
        do {
            try {
                this.myBTSConnection.sendToBTS((BTSMessage)startTestRequest);
                response = this.myBTSConnection.receiveFromBTS(this.mySeqNumber, 60000L);
                if (!this.myRetryAvailable || !this.isTimeout(response)) continue;
                Thread.sleep(this.myRequestInterval);
            }
            catch (InterruptedException e) {
                this.myLogger.error((Object)"Exception occuured when request for backhaul parameters", (Throwable)e);
            }
        } while (this.shouldRetry(response));
        this.handleResponse(response);
    }

    private boolean shouldRetry(BTSMessage response) {
        boolean shouldRetry = this.myRetryAvailable && this.isTimeout(response) && this.myAttempts < 3;
        ++this.myAttempts;
        return shouldRetry;
    }

    private boolean isTimeout(BTSMessage response) {
        return response instanceof Timeout;
    }

    private void handleResponse(BTSMessage response) {
        if (response instanceof Timeout) {
            this.myListener.acNonOpBackhaulParamsGetFailed(68);
            this.myLogger.error((Object)"Fetching Non Operator-Owned Backhaul Parameters timed out");
        } else if (response instanceof GetACNonOpBackhaulParamsResponse) {
            GetACNonOpBackhaulParamsResponse getACNonOpBackhaulParamsResponse = (GetACNonOpBackhaulParamsResponse)response;
            ACNonOpBackhaulParamsBean bean = new ACNonOpBackhaulParamsBean(getACNonOpBackhaulParamsResponse.getData());
            this.myListener.acNonOpBackhaulParamsGetSuccessful(bean);
        } else {
            this.myListener.acNonOpBackhaulParamsGetFailed(28);
            this.myLogger.error((Object)"Invalid response received");
        }
    }

    @Override
    public boolean abort() {
        return true;
    }

    protected void setRetryInterval(long interval) {
        this.myRequestInterval = interval;
    }
}

