/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.scenario.antennamanagement;

import com.nokia.em.bts.coreasset.CoreAsset;
import com.nokia.em.bts.coreasset.message.SWUpToDate;
import com.nokia.em.bts.coreasset.message.SWUpdateRequest;
import com.nokia.em.bts.coreasset.scenario.Scenario;
import com.nokia.em.bts.rp.master.connection.BTSConnection;
import com.nokia.em.bts.rp.master.filetransfer.FTPTransferInfo;
import com.nokia.em.bts.rp.master.filetransfer.FileTransferListener;
import com.nokia.em.bts.rp.master.filetransfer.FileTransferServer;
import com.nokia.em.bts.rp.master.message.Ack;
import com.nokia.em.bts.rp.master.message.BTSMessage;
import com.nokia.em.bts.rp.master.tool.CoreAssetThread;
import java.io.File;
import org.apache.log4j.Logger;

public class SendScannedAntennaInterfacesScenario
implements Scenario {
    private BTSConnection myConnection;
    private FileTransferListener myListener;
    private Logger myLogger;
    private File myFile;
    private BTSMessage.Type myType = BTSMessage.Type.BTS;

    public SendScannedAntennaInterfacesScenario(BTSConnection connection, FileTransferListener fileTransferListener, File antennaInterfacesFile) {
        this.myLogger = Logger.getLogger(this.getClass());
        this.myConnection = connection;
        this.myListener = fileTransferListener;
        this.myFile = antennaInterfacesFile;
    }

    public SendScannedAntennaInterfacesScenario(BTSConnection connection, FileTransferListener fileTransferListener, File antennaInterfacesFile, BTSMessage.Type type) {
        this(connection, fileTransferListener, antennaInterfacesFile);
        this.myType = type;
    }

    @Override
    public boolean abort() {
        return true;
    }

    @Override
    public void execute() {
        CoreAssetThread worker = new CoreAssetThread(){

            protected Object construct() {
                return SendScannedAntennaInterfacesScenario.this.runScenario();
            }
        };
        worker.start();
    }

    protected Object runScenario() {
        if (CoreAsset.isSnapshotOpening()) {
            this.myLogger.debug((Object)"Snapshot open not supported.");
            this.myListener.fileSetTransferFailed(85);
            return true;
        }
        int seqNumber = this.myConnection.createScenario();
        FileTransferServer myServer = this.myConnection.getFileTransferFactory().getFileTransferServer();
        myServer.initListenerAndPath(this.myListener, this.myFile.getParent());
        FTPTransferInfo ftpTransferInfo = new FTPTransferInfo(this.myFile.getName(), this.myConnection.getLocalIPAddress(), myServer.getUserName(), myServer.getPassword().toCharArray());
        try {
            int port = myServer.startServer();
            if (port != 21) {
                ftpTransferInfo.setServerAddress(String.valueOf(ftpTransferInfo.getServerAddress()) + ":" + port);
            }
        }
        catch (Exception fpiue) {
            this.myConnection.deleteScenario(seqNumber);
            this.myListener.fileSetTransferFailed(300);
            this.myLogger.debug((Object)"Scanned Antenna interfaces file sending failed.");
            return false;
        }
        SWUpdateRequest swUpdtReq = new SWUpdateRequest(seqNumber, false, ftpTransferInfo, this.myType);
        this.myConnection.sendToBTS((BTSMessage)swUpdtReq);
        BTSMessage response = this.myConnection.receiveFromBTS(seqNumber);
        if (response instanceof Ack) {
            Ack ackResponse = (Ack)response;
            if (ackResponse.getAck()) {
                response = this.myConnection.receiveFromBTS(seqNumber);
                myServer.stopServer();
                if (response instanceof SWUpToDate) {
                    SWUpToDate swUpToDate = (SWUpToDate)response;
                    if (swUpToDate.getUpdateResult() == 36) {
                        this.myListener.fileSetTransferCompleted(this.myFile.toString());
                        this.myLogger.debug((Object)"Scanned Antenna interfaces file sending succeeded.");
                        return true;
                    }
                    this.myListener.fileSetTransferFailed(301);
                    this.myLogger.debug((Object)"Scanned Antenna interfaces file sending failed reason: 301");
                    return false;
                }
                this.myLogger.error((Object)"Wrong reply received from BTS. FilesUpToDate expected.");
                this.myListener.fileSetTransferFailed(28);
                return false;
            }
            myServer.stopServer();
            this.myLogger.debug((Object)("ComFileUpdateRequestRejected. BTS replied Nack to FileUpdateRequest with reason " + ackResponse.getNackReason()));
            this.myConnection.deleteScenario(seqNumber);
            this.myListener.fileSetTransferFailed(ackResponse.getNackReason());
            return false;
        }
        myServer.stopServer();
        if (response != null) {
            this.myListener.fileSetTransferFailed(28);
            this.myLogger.error((Object)("Wrong reply received from BTS. Ack expected, " + response.getClass() + " received."));
        } else {
            this.myLogger.error((Object)"Null reply received from BTS. Ack expected.");
        }
        this.myConnection.deleteScenario(seqNumber);
        return true;
    }

    public BTSMessage.Type getType() {
        return this.myType;
    }

    public void setType(BTSMessage.Type type) {
        this.myType = type;
    }
}

