/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.scenario.antennamanagement;

import com.nokia.em.bts.coreasset.CoreAsset;
import com.nokia.em.bts.coreasset.message.TiltCalibrateRequest;
import com.nokia.em.bts.coreasset.scenario.Scenario;
import com.nokia.em.bts.coreasset.scenario.antennamanagement.AntennaTiltListener;
import com.nokia.em.bts.rp.master.connection.BTSConnection;
import com.nokia.em.bts.rp.master.message.Ack;
import com.nokia.em.bts.rp.master.message.BTSMessage;
import com.nokia.em.bts.rp.master.message.Timeout;
import com.nokia.em.bts.rp.master.tool.CoreAssetThread;
import org.apache.log4j.Logger;

public class TiltCalibrateScenario
implements Scenario {
    private BTSConnection myConnection;
    private AntennaTiltListener myListener;
    private int myId;
    private String myBtsType = "Coreasset_Unknown";
    private boolean myRunning = false;
    private static final String BTS_TYPE_GSM = "GSM";
    private static final String BTS_TYPE_WCDMA = "WCDMA";
    private Logger myLogger;
    private BTSMessage.Type myType = BTSMessage.Type.BTS;

    public TiltCalibrateScenario(BTSConnection connection, AntennaTiltListener listener, int id, int btsType) {
        this.myLogger = Logger.getLogger(this.getClass());
        this.myConnection = connection;
        this.myListener = listener;
        this.myId = id;
        if (btsType == 1) {
            this.myBtsType = BTS_TYPE_GSM;
        } else if (btsType == 0) {
            this.myBtsType = BTS_TYPE_WCDMA;
        }
    }

    public TiltCalibrateScenario(BTSConnection connection, AntennaTiltListener listener, int id, int btsType, BTSMessage.Type type) {
        this(connection, listener, id, btsType);
        this.myType = type;
    }

    @Override
    public void execute() {
        if (this.myRunning) {
            throw new IllegalStateException("Cannot execute Scenario. Scenario already in process.");
        }
        if (!BTS_TYPE_WCDMA.equals(this.myBtsType) && !BTS_TYPE_GSM.equals(this.myBtsType)) {
            this.myLogger.warn((Object)"Tilt calibrate BTS type unknown.");
            throw new IllegalStateException("BTS Type unknown. Cannot execute.");
        }
        this.myRunning = true;
        CoreAssetThread worker = new CoreAssetThread(){
            int seqNumber;

            protected Object construct() {
                if (CoreAsset.isSnapshotOpening()) {
                    TiltCalibrateScenario.this.myLogger.debug((Object)"No support in snapshot open mode.");
                    TiltCalibrateScenario.this.myListener.calibrateFailed(85);
                    return true;
                }
                this.seqNumber = TiltCalibrateScenario.this.myConnection.createScenario();
                TiltCalibrateRequest tiltCalibrateRequest = new TiltCalibrateRequest(this.seqNumber, TiltCalibrateScenario.this.myId, TiltCalibrateScenario.this.myBtsType, TiltCalibrateScenario.this.myType);
                TiltCalibrateScenario.this.myConnection.sendToBTS((BTSMessage)tiltCalibrateRequest);
                BTSMessage response = TiltCalibrateScenario.this.myConnection.receiveFromBTS(this.seqNumber, 60000L);
                if (response instanceof Ack) {
                    Ack ackResponse = (Ack)response;
                    if (!ackResponse.getAck()) {
                        TiltCalibrateScenario.this.myLogger.debug((Object)("Tilt calibrate failed, " + ackResponse.getNackReasonString()));
                        TiltCalibrateScenario.this.myListener.calibrateFailed(ackResponse.getNackReason());
                        return false;
                    }
                    TiltCalibrateScenario.this.myLogger.debug((Object)"Tilt calibrate accepted.");
                    TiltCalibrateScenario.this.myListener.calibrateAccepted();
                } else {
                    if (response instanceof Timeout) {
                        TiltCalibrateScenario.this.myLogger.debug((Object)"Tilt calibrate failed, timeout.");
                        TiltCalibrateScenario.this.myListener.calibrateFailed(68);
                        return false;
                    }
                    TiltCalibrateScenario.this.myLogger.debug((Object)"Tilt calibrate failed, invalid message or broken connection.");
                    TiltCalibrateScenario.this.myListener.calibrateFailed(28);
                }
                return false;
            }

            protected void finished() {
                TiltCalibrateScenario.this.myConnection.deleteScenario(this.seqNumber);
                TiltCalibrateScenario.this.myRunning = false;
            }
        };
        worker.start();
    }

    @Override
    public boolean abort() {
        return true;
    }

    public BTSMessage.Type getType() {
        return this.myType;
    }

    public void setType(BTSMessage.Type type) {
        this.myType = type;
    }
}

