/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.scenario.antennamanagement;

import com.nokia.em.bts.coreasset.CoreAsset;
import com.nokia.em.bts.coreasset.message.TiltConfigureRequest;
import com.nokia.em.bts.coreasset.scenario.Scenario;
import com.nokia.em.bts.coreasset.scenario.antennamanagement.AntennaTiltListener;
import com.nokia.em.bts.rp.master.connection.BTSConnection;
import com.nokia.em.bts.rp.master.message.Ack;
import com.nokia.em.bts.rp.master.message.BTSMessage;
import com.nokia.em.bts.rp.master.message.Timeout;
import com.nokia.em.bts.rp.master.tool.CoreAssetThread;
import org.apache.log4j.Logger;

public class TiltConfigureScenario
implements Scenario {
    private int myConfigObjectId;
    private float myTiltAngleMin;
    private float myTiltAngleMax;
    private Byte[] myDeviceData = null;
    private Float myMechanicalTiltAngle = null;
    private BTSConnection myConnection;
    private AntennaTiltListener myListener;
    private boolean myRunning = false;
    private Logger myLogger;
    private int mySeqNumber;
    private BTSMessage.Type myType = BTSMessage.Type.BTS;

    private TiltConfigureScenario(BTSConnection connection, AntennaTiltListener listener, int configObjectId) {
        this.myLogger = Logger.getLogger(this.getClass());
        this.myConnection = connection;
        this.myListener = listener;
        this.myConfigObjectId = configObjectId;
    }

    public TiltConfigureScenario(BTSConnection connection, AntennaTiltListener listener, int configObjectId, float tiltAngleMin, float tiltAngleMax) {
        this(connection, listener, configObjectId);
        this.myTiltAngleMin = tiltAngleMin;
        this.myTiltAngleMax = tiltAngleMax;
    }

    public TiltConfigureScenario(BTSConnection connection, AntennaTiltListener listener, int configObjectId, float tiltAngleMin, float tiltAngleMax, BTSMessage.Type type) {
        this(connection, listener, configObjectId, tiltAngleMin, tiltAngleMax);
        this.myType = type;
    }

    public TiltConfigureScenario(BTSConnection connection, AntennaTiltListener listener, int configObjectId, Float mechanicalTiltAngle, Byte[] deviceData) {
        this(connection, listener, configObjectId);
        this.myMechanicalTiltAngle = mechanicalTiltAngle;
        this.myDeviceData = deviceData;
    }

    public TiltConfigureScenario(BTSConnection connection, AntennaTiltListener listener, int configObjectId, Float mechanicalTiltAngle, Byte[] deviceData, BTSMessage.Type type) {
        this(connection, listener, configObjectId, mechanicalTiltAngle, deviceData);
        this.myMechanicalTiltAngle = mechanicalTiltAngle;
        this.myType = type;
    }

    @Override
    public void execute() {
        if (this.myRunning) {
            throw new IllegalStateException("Cannot execute Scenario. Scenario already in process.");
        }
        this.myRunning = true;
        CoreAssetThread worker = new CoreAssetThread(){

            protected Object construct() {
                return TiltConfigureScenario.this.runScenario();
            }

            protected void finished() {
                TiltConfigureScenario.this.myConnection.deleteScenario(TiltConfigureScenario.this.mySeqNumber);
                TiltConfigureScenario.this.myRunning = false;
            }
        };
        worker.start();
    }

    protected Object runScenario() {
        if (CoreAsset.isSnapshotOpening()) {
            this.myLogger.debug((Object)"Snapshot open not supported.");
            this.myListener.calibrateFailed(85);
            return true;
        }
        this.mySeqNumber = this.myConnection.createScenario();
        TiltConfigureRequest tiltConfigureRequest = new TiltConfigureRequest(this.mySeqNumber, this.myConfigObjectId, this.myMechanicalTiltAngle, this.myDeviceData, this.myTiltAngleMin, this.myTiltAngleMax);
        this.myConnection.sendToBTS((BTSMessage)tiltConfigureRequest);
        BTSMessage response = this.myConnection.receiveFromBTS(this.mySeqNumber, 60000L);
        if (response instanceof Ack) {
            Ack ackResponse = (Ack)response;
            if (!ackResponse.getAck()) {
                this.myLogger.debug((Object)("Tilt configuring failed, " + ackResponse.getNackReasonString()));
                this.myListener.configuringFailed(ackResponse.getNackReason());
                return false;
            }
            this.myLogger.debug((Object)"Tilt configuring accepted.");
            this.myListener.configuringAccepted();
        } else {
            if (response instanceof Timeout) {
                this.myLogger.debug((Object)"Tilt configure failed, timeout.");
                this.myListener.configuringFailed(68);
                return false;
            }
            this.myLogger.debug((Object)"Tilt configuring failed, invalid message or broken connection.");
            this.myListener.configuringFailed(28);
        }
        return false;
    }

    @Override
    public boolean abort() {
        return true;
    }

    public BTSMessage.Type getType() {
        return this.myType;
    }

    public void setType(BTSMessage.Type type) {
        this.myType = type;
    }
}

