/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.scenario.antennamanagement;

import com.nokia.em.bts.coreasset.CoreAsset;
import com.nokia.em.bts.coreasset.message.LicencedAck;
import com.nokia.em.bts.coreasset.message.TiltSetAngleRequest;
import com.nokia.em.bts.coreasset.scenario.Scenario;
import com.nokia.em.bts.coreasset.scenario.antennamanagement.AntennaTiltListener;
import com.nokia.em.bts.rp.master.connection.BTSConnection;
import com.nokia.em.bts.rp.master.message.Ack;
import com.nokia.em.bts.rp.master.message.BTSMessage;
import com.nokia.em.bts.rp.master.message.Timeout;
import com.nokia.em.bts.rp.master.tool.CoreAssetThread;
import org.apache.log4j.Logger;

public class TiltSetScenario
implements Scenario {
    private int myConfigObjectId;
    private String myBtsType = "Coreasset_Unknown";
    private float myTiltAngle;
    private BTSConnection myConnection;
    private AntennaTiltListener myListener;
    private boolean myRunning = false;
    private static final String BTS_TYPE_GSM = "GSM";
    private static final String BTS_TYPE_WCDMA = "WCDMA";
    private Logger myLogger;
    private int mySeqNumber;
    private BTSMessage.Type myType = BTSMessage.Type.BTS;

    public TiltSetScenario(BTSConnection connection, AntennaTiltListener listener, int configObjectId, int btsType, float tiltAngle) {
        this.myLogger = Logger.getLogger(this.getClass());
        this.myConnection = connection;
        this.myListener = listener;
        this.myConfigObjectId = configObjectId;
        if (btsType == 1) {
            this.myBtsType = BTS_TYPE_GSM;
        } else if (btsType == 0) {
            this.myBtsType = BTS_TYPE_WCDMA;
        }
        this.myTiltAngle = tiltAngle;
    }

    public TiltSetScenario(BTSConnection connection, AntennaTiltListener listener, int configObjectId, int btsType, float tiltAngle, BTSMessage.Type type) {
        this(connection, listener, configObjectId, btsType, tiltAngle);
        this.myType = type;
    }

    @Override
    public void execute() {
        if (this.myRunning) {
            throw new IllegalStateException("Cannot execute Scenario. Scenario already in process.");
        }
        if (!BTS_TYPE_WCDMA.equals(this.myBtsType) && !BTS_TYPE_GSM.equals(this.myBtsType)) {
            this.myLogger.warn((Object)"BTS Type unknown.");
            throw new IllegalStateException("BTS Type unknown. Cannot execute.");
        }
        this.myRunning = true;
        CoreAssetThread worker = new CoreAssetThread(){

            protected Object construct() {
                return TiltSetScenario.this.runScenario();
            }

            protected void finished() {
                TiltSetScenario.this.myConnection.deleteScenario(TiltSetScenario.this.mySeqNumber);
                TiltSetScenario.this.myRunning = false;
            }
        };
        worker.start();
    }

    @Override
    public boolean abort() {
        return true;
    }

    protected Object runScenario() {
        if (CoreAsset.isSnapshotOpening()) {
            this.myLogger.debug((Object)"Snapshot open not supported.");
            this.myListener.setTiltFailed(85);
            return true;
        }
        this.mySeqNumber = this.myConnection.createScenario();
        TiltSetAngleRequest tiltSetAngleRequest = new TiltSetAngleRequest(this.mySeqNumber, this.myConfigObjectId, this.myBtsType, this.myTiltAngle, this.myType);
        this.myConnection.sendToBTS((BTSMessage)tiltSetAngleRequest);
        BTSMessage response = this.myConnection.receiveFromBTS(this.mySeqNumber, 60000L);
        if (response instanceof Ack) {
            Ack ackResponse = (Ack)response;
            if (!ackResponse.getAck()) {
                this.myLogger.debug((Object)("Set failed, " + ackResponse.getNackReason()));
                this.myListener.setTiltFailed(ackResponse.getNackReason());
                return false;
            }
            this.myLogger.debug((Object)"Set tilt accepted.");
            this.myListener.setTiltAccepted();
        } else if (response instanceof LicencedAck) {
            this.myLogger.debug((Object)"Set tilt failed, licencedAck.");
            this.myListener.setTiltFailed(40);
        } else {
            if (response instanceof Timeout) {
                this.myLogger.debug((Object)"Tilt set failed, timeout.");
                this.myListener.setTiltFailed(68);
                return false;
            }
            this.myLogger.debug((Object)"Set tilt failed, invalid message or broken connection.");
            this.myListener.setTiltFailed(28);
        }
        return false;
    }

    public BTSMessage.Type getType() {
        return this.myType;
    }

    public void setType(BTSMessage.Type type) {
        this.myType = type;
    }
}

