/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.scenario.antennamanagement;

import com.nokia.em.bts.coreasset.CoreAsset;
import com.nokia.em.bts.rp.master.snapshot.SaverProgressListener;
import com.nokia.em.bts.rp.master.snapshot.SnapshotSaver;
import com.nokia.em.bts.rp.master.tool.CoreAssetThread;
import com.nokia.em.bts.rp.master.tool.Tools;
import com.nokia.em.poseidon.services.snapshot.PSnapshotConst;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class VSWRSnapshotSaver
implements SnapshotSaver {
    private static volatile VSWRSnapshotSaver myInstance = null;
    private Logger myLogger = Logger.getLogger(this.getClass());
    private Map<Integer, VSWRDataObject> myVSWRData = new HashMap<Integer, VSWRDataObject>();
    private static final String SNAPSHOT_TASK = "VSWR";
    private static final String SNAPSHOT_TASK_NAME = "CoreAsset_Snapshot_VSWR";
    private static final int SNAPSHOT_TIMEOUT = 5000;
    private static final String VSWR_XML_NODENAME = "VSWR";
    private static final String DATA_XML_NODENAME = "data";
    private static final String ID_XML_NODENAME = "id";
    private static final String MAJOR_XML_NODENAME = "major";
    private static final String MINOR_XML_NODENAME = "major";

    private VSWRSnapshotSaver() {
    }

    protected static VSWRSnapshotSaver getInstance() {
        if (myInstance == null) {
            myInstance = new VSWRSnapshotSaver();
        }
        return myInstance;
    }

    protected synchronized void addVSWRData(int objectId, float major, float minor) {
        this.myVSWRData.put(objectId, new VSWRDataObject(major, minor));
    }

    protected synchronized void removeVSWRData(int objectId) {
        this.myVSWRData.remove(objectId);
    }

    protected VSWRDataObject openSnapshot(int objectId) {
        String vswrFile = String.valueOf(CoreAsset.getSnapshotOpenLocation().getFile()) + CoreAsset.FILE_SEPARATOR + "VSWR" + CoreAsset.FILE_SEPARATOR + "VSWR" + ".xml";
        Element root = Tools.parseElement((String)vswrFile);
        if (root == null) {
            this.myLogger.error((Object)("Cannot parse vswr snapshot id " + objectId));
            return null;
        }
        try {
            NodeList nodeList = root.getChildNodes();
            int i = 0;
            while (i < nodeList.getLength()) {
                VSWRDataObject o = this.getVSWRDataObject(objectId, nodeList.item(i));
                if (o != null) {
                    return o;
                }
                ++i;
            }
        }
        catch (Exception e) {
            this.myLogger.error((Object)"Cannot create vswr data.", (Throwable)e);
        }
        return null;
    }

    private VSWRDataObject getVSWRDataObject(int objectId, Node dataNode) {
        VSWRDataObject object = null;
        NodeList dataNodeList = dataNode.getChildNodes();
        float major = 0.0f;
        float minor = 0.0f;
        boolean found = false;
        int j = 0;
        while (j < dataNodeList.getLength()) {
            Node node = dataNodeList.item(j);
            if (node != null && node.hasChildNodes()) {
                String nodeValue = node.getFirstChild().getNodeValue();
                if (node.getNodeName().equals(ID_XML_NODENAME) && nodeValue.equals(Integer.toString(objectId))) {
                    found = true;
                }
                if (node.getNodeName().equals("major")) {
                    major = Float.parseFloat(nodeValue);
                }
                if (node.getNodeName().equals("major")) {
                    minor = Float.parseFloat(nodeValue);
                }
            }
            ++j;
        }
        if (found) {
            object = new VSWRDataObject(major, minor);
        }
        return object;
    }

    public Collection getSavingTasks(PSnapshotConst.SNAPSHOT_LEVEL snapshot_level) {
        ArrayList<String> l = new ArrayList<String>();
        l.add(SNAPSHOT_TASK_NAME);
        return l;
    }

    public void save(final String url, PSnapshotConst.SNAPSHOT_LEVEL snapshot_level, final SaverProgressListener sp) {
        CoreAssetThread worker = new CoreAssetThread(){

            protected Object construct() {
                VSWRSnapshotSaver.this.runSave(url, sp);
                return null;
            }
        };
        worker.start();
    }

    private void runSave(String url, SaverProgressListener sp) {
        block12: {
            sp.taskStarted(SNAPSHOT_TASK_NAME, 7, 5000, this.isLocalisationRequired());
            File dir = new File(String.valueOf(url) + CoreAsset.FILE_SEPARATOR + "VSWR");
            if (!dir.mkdir()) {
                this.myLogger.warn((Object)"Failed to create directory");
            }
            File f = new File(String.valueOf(url) + CoreAsset.FILE_SEPARATOR + "VSWR" + CoreAsset.FILE_SEPARATOR + "VSWR" + ".xml");
            OutputStreamWriter out = null;
            try {
                try {
                    out = new OutputStreamWriter(new FileOutputStream(f, false));
                    out.write(this.getSnapshotData());
                }
                catch (IOException e) {
                    sp.taskUpdated(SNAPSHOT_TASK_NAME, 4, this.isLocalisationRequired());
                    this.myLogger.error((Object)"Failed to save VSWR snapshot information");
                    try {
                        out.close();
                        sp.taskUpdated(SNAPSHOT_TASK_NAME, 8, this.isLocalisationRequired());
                        this.myLogger.debug((Object)"VSWR snapshot file successfully created");
                    }
                    catch (Exception e2) {
                        sp.taskUpdated(SNAPSHOT_TASK_NAME, 4, this.isLocalisationRequired());
                        this.myLogger.error((Object)"Failed to close VSWR snapshot file");
                    }
                    break block12;
                }
            }
            catch (Throwable throwable) {
                try {
                    out.close();
                    sp.taskUpdated(SNAPSHOT_TASK_NAME, 8, this.isLocalisationRequired());
                    this.myLogger.debug((Object)"VSWR snapshot file successfully created");
                }
                catch (Exception e) {
                    sp.taskUpdated(SNAPSHOT_TASK_NAME, 4, this.isLocalisationRequired());
                    this.myLogger.error((Object)"Failed to close VSWR snapshot file");
                }
                throw throwable;
            }
            try {
                out.close();
                sp.taskUpdated(SNAPSHOT_TASK_NAME, 8, this.isLocalisationRequired());
                this.myLogger.debug((Object)"VSWR snapshot file successfully created");
            }
            catch (Exception e) {
                sp.taskUpdated(SNAPSHOT_TASK_NAME, 4, this.isLocalisationRequired());
                this.myLogger.error((Object)"Failed to close VSWR snapshot file");
            }
        }
        sp.saveCompleted((SnapshotSaver)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getSnapshotData() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<VSWR>");
        VSWRSnapshotSaver vSWRSnapshotSaver = this;
        synchronized (vSWRSnapshotSaver) {
            for (Integer key : this.myVSWRData.keySet()) {
                stringBuilder.append("<data>");
                stringBuilder.append("<id>" + key + "</" + ID_XML_NODENAME + ">");
                stringBuilder.append("<major>" + this.myVSWRData.get(key).getMajor() + "</" + "major" + ">");
                stringBuilder.append("<major>" + this.myVSWRData.get(key).getMinor() + "</" + "major" + ">");
                stringBuilder.append("</data>");
            }
        }
        stringBuilder.append("</VSWR>");
        return stringBuilder.toString();
    }

    public void cancel(SaverProgressListener sp) {
        sp.saveCancelled((SnapshotSaver)this);
    }

    public int getSavingPriority() {
        return 2;
    }

    public void stopProcess(int process) {
    }

    public boolean isLocalisationRequired() {
        return true;
    }

    class VSWRDataObject {
        private float myMajor;
        private float myMinor;

        protected VSWRDataObject(float major, float minor) {
            this.myMajor = major;
            this.myMinor = minor;
        }

        protected float getMajor() {
            return this.myMajor;
        }

        protected float getMinor() {
            return this.myMinor;
        }
    }
}

