/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.scenario.antennamanagement;

import com.nokia.em.bts.coreasset.CoreAsset;
import com.nokia.em.bts.coreasset.message.VSWRThresholdSetRequest;
import com.nokia.em.bts.coreasset.scenario.Scenario;
import com.nokia.em.bts.coreasset.scenario.antennamanagement.VSWRThresholdListener;
import com.nokia.em.bts.rp.master.connection.BTSConnection;
import com.nokia.em.bts.rp.master.message.Ack;
import com.nokia.em.bts.rp.master.message.BTSMessage;
import com.nokia.em.bts.rp.master.tool.CoreAssetThread;
import org.apache.log4j.Logger;

public class VSWRThresholdSetScenario
implements Scenario {
    private int myConfigObjectId;
    private float myThresholdMajor;
    private float myThresholdMinor;
    private BTSConnection myBTSConnection;
    private VSWRThresholdListener myListener;
    private boolean myRunning = false;
    private Logger myLogger;
    private int mySeqNumber;
    private BTSMessage.Type myType = BTSMessage.Type.BTS;

    public VSWRThresholdSetScenario(BTSConnection btsConnection, VSWRThresholdListener listener, int configObjectId, float thresholdMajor, float thresholdMinor) {
        this.myLogger = Logger.getLogger(this.getClass());
        this.myBTSConnection = btsConnection;
        this.myListener = listener;
        this.myConfigObjectId = configObjectId;
        this.myThresholdMajor = thresholdMajor;
        this.myThresholdMinor = thresholdMinor;
    }

    public VSWRThresholdSetScenario(BTSConnection btsConnection, VSWRThresholdListener listener, int configObjectId, float thresholdMajor, float thresholdMinor, BTSMessage.Type type) {
        this(btsConnection, listener, configObjectId, thresholdMajor, thresholdMinor);
        this.myType = type;
    }

    @Override
    public void execute() {
        if (this.myRunning) {
            throw new IllegalStateException("Scenario already executing.");
        }
        this.myRunning = true;
        CoreAssetThread resetWorker = new CoreAssetThread(){

            protected Object construct() {
                return VSWRThresholdSetScenario.this.runScenario();
            }

            protected void finished() {
                VSWRThresholdSetScenario.this.myBTSConnection.deleteScenario(VSWRThresholdSetScenario.this.mySeqNumber);
                try {
                    this.get();
                }
                catch (Exception e) {
                    VSWRThresholdSetScenario.this.myLogger.error((Object)"VSWR_SetScenario.execute, Unknown error.", (Throwable)e);
                }
                VSWRThresholdSetScenario.this.myRunning = false;
            }
        };
        resetWorker.start();
    }

    @Override
    public boolean abort() {
        return true;
    }

    protected Object runScenario() {
        if (CoreAsset.isSnapshotOpening()) {
            this.myLogger.debug((Object)"Snapshot open not supported.");
            this.myListener.thresholdSettingFailed(85, this.myConfigObjectId);
            return true;
        }
        this.mySeqNumber = this.myBTSConnection.createScenario();
        VSWRThresholdSetRequest setRequest = new VSWRThresholdSetRequest(this.mySeqNumber, this.myConfigObjectId, this.myThresholdMajor, this.myThresholdMinor, this.myType);
        this.myBTSConnection.sendToBTS((BTSMessage)setRequest);
        BTSMessage response = this.myBTSConnection.receiveFromBTS(this.mySeqNumber);
        if (response instanceof Ack) {
            Ack ackResponse = (Ack)response;
            if (!ackResponse.getAck()) {
                this.myLogger.debug((Object)"VSWR_SetScenario.execute, Failed, Nacked from BTS.");
                this.myListener.thresholdSettingFailed(ackResponse.getNackReason(), this.myConfigObjectId);
            } else {
                this.myLogger.debug((Object)"VSWR_SetScenario.execute, Set successful.");
                this.myListener.thresholdSet(this.myConfigObjectId);
            }
        } else {
            if (response != null) {
                this.myLogger.debug((Object)("VSWR_SetScenario.execute, Received message " + response.getClass() + " instead of Ack"));
            } else {
                this.myLogger.debug((Object)"VSWR_SetScenario.execute, Null message received instead of Ack, maybe lost connection.");
            }
            this.myListener.thresholdSettingFailed(28, this.myConfigObjectId);
        }
        return true;
    }

    public BTSMessage.Type getType() {
        return this.myType;
    }

    public void setType(BTSMessage.Type type) {
        this.myType = type;
    }
}

