/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.scenario.antennamanagement;

import com.nokia.em.bts.coreasset.CoreAsset;
import com.nokia.em.bts.coreasset.message.LicencedAck;
import com.nokia.em.bts.coreasset.message.VSWRThresholdTuningStartRequest;
import com.nokia.em.bts.coreasset.message.VSWRThresholdTuningStartResponse;
import com.nokia.em.bts.coreasset.scenario.Scenario;
import com.nokia.em.bts.coreasset.scenario.antennamanagement.VSWRThresholdListener;
import com.nokia.em.bts.rp.master.connection.BTSConnection;
import com.nokia.em.bts.rp.master.message.Ack;
import com.nokia.em.bts.rp.master.message.BTSMessage;
import com.nokia.em.bts.rp.master.tool.CoreAssetThread;
import org.apache.log4j.Logger;

public class VSWRThresholdTuningStartScenario
implements Scenario {
    private BTSConnection myBTSConnection;
    private VSWRThresholdListener myListener;
    private int myConfigObjectId;
    private boolean myRunning = false;
    private BTSMessage.Type myType = BTSMessage.Type.BTS;
    private Logger myLogger = Logger.getLogger(this.getClass());

    public VSWRThresholdTuningStartScenario(BTSConnection btsConnection, VSWRThresholdListener listener, int configObjectId) {
        this.myBTSConnection = btsConnection;
        this.myListener = listener;
        this.myConfigObjectId = configObjectId;
    }

    public VSWRThresholdTuningStartScenario(BTSConnection btsConnection, VSWRThresholdListener listener, int configObjectId, BTSMessage.Type type) {
        this(btsConnection, listener, configObjectId);
        this.myType = type;
    }

    @Override
    public void execute() {
        if (this.myRunning) {
            throw new IllegalStateException("Scenario already executing.");
        }
        this.myRunning = true;
        CoreAssetThread resetWorker = new CoreAssetThread(){
            int seqNumber;

            protected Object construct() {
                if (CoreAsset.isSnapshotOpening()) {
                    return true;
                }
                this.seqNumber = VSWRThresholdTuningStartScenario.this.myBTSConnection.createScenario();
                VSWRThresholdTuningStartRequest startRequest = new VSWRThresholdTuningStartRequest(this.seqNumber, VSWRThresholdTuningStartScenario.this.myConfigObjectId, VSWRThresholdTuningStartScenario.this.myType);
                VSWRThresholdTuningStartScenario.this.myBTSConnection.sendToBTS((BTSMessage)startRequest);
                BTSMessage response = VSWRThresholdTuningStartScenario.this.myBTSConnection.receiveFromBTS(this.seqNumber);
                if (response instanceof LicencedAck) {
                    VSWRThresholdTuningStartScenario.this.myLogger.debug((Object)"VSWR_TuningStartScenario.execute, Failed in BTS, LicenceAcked.");
                    VSWRThresholdTuningStartScenario.this.myListener.tuningStartFailed(40, VSWRThresholdTuningStartScenario.this.myConfigObjectId);
                } else if (response instanceof Ack) {
                    Ack ackResponse = (Ack)response;
                    VSWRThresholdTuningStartScenario.this.myLogger.debug((Object)("VSWR_TuningStartScenario.execute, Failed in BTS. Ack is fail:" + !ackResponse.getAck() + ". with reason:" + ackResponse.getNackReasonString()));
                    VSWRThresholdTuningStartScenario.this.myListener.tuningStartFailed(31, VSWRThresholdTuningStartScenario.this.myConfigObjectId);
                } else if (response instanceof VSWRThresholdTuningStartResponse) {
                    VSWRThresholdTuningStartScenario.this.myLogger.debug((Object)"VSWR_TuningStartScenario.execute, Tuning Started.");
                    VSWRThresholdTuningStartResponse startResponse = (VSWRThresholdTuningStartResponse)response;
                    VSWRThresholdTuningStartScenario.this.myListener.tuningStarted(startResponse.getMajorLimit(), startResponse.getMinorLimit(), VSWRThresholdTuningStartScenario.this.myConfigObjectId);
                } else {
                    VSWRThresholdTuningStartScenario.this.myLogger.debug((Object)"VSWR_TuningStartScenario.execute, Failed in BTS, invalid message or connection lost.");
                    VSWRThresholdTuningStartScenario.this.myListener.tuningStartFailed(28, VSWRThresholdTuningStartScenario.this.myConfigObjectId);
                }
                return true;
            }

            protected void finished() {
                VSWRThresholdTuningStartScenario.this.myBTSConnection.deleteScenario(this.seqNumber);
                try {
                    this.get();
                }
                catch (Exception e) {
                    VSWRThresholdTuningStartScenario.this.myLogger.error((Object)"VSWR_TuningStartScenario.execute, Unknown error", (Throwable)e);
                }
                VSWRThresholdTuningStartScenario.this.myRunning = false;
            }
        };
        resetWorker.start();
    }

    @Override
    public boolean abort() {
        return true;
    }

    public BTSMessage.Type getType() {
        return this.myType;
    }

    public void setType(BTSMessage.Type type) {
        this.myType = type;
    }
}

