/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.scenario.antennamanagement;

import com.nokia.em.bts.coreasset.CoreAsset;
import com.nokia.em.bts.coreasset.message.VSWRThresholdTuningStopRequest;
import com.nokia.em.bts.coreasset.scenario.Scenario;
import com.nokia.em.bts.coreasset.scenario.antennamanagement.VSWRThresholdListener;
import com.nokia.em.bts.rp.master.connection.BTSConnection;
import com.nokia.em.bts.rp.master.message.Ack;
import com.nokia.em.bts.rp.master.message.BTSMessage;
import com.nokia.em.bts.rp.master.tool.CoreAssetThread;
import org.apache.log4j.Logger;

public class VSWRThresholdTuningStopScenario
implements Scenario {
    private BTSConnection myBTSConnection;
    private VSWRThresholdListener myListener;
    private int myConfigObjectId;
    private boolean mySaveNewValues;
    private boolean myRunning = false;
    private BTSMessage.Type myType = BTSMessage.Type.BTS;
    private Logger myLogger = Logger.getLogger(this.getClass());

    public VSWRThresholdTuningStopScenario(BTSConnection btsConnection, VSWRThresholdListener listener, int configObjectId, boolean saveNewValues) {
        this.myBTSConnection = btsConnection;
        this.myListener = listener;
        this.myConfigObjectId = configObjectId;
        this.mySaveNewValues = saveNewValues;
    }

    public VSWRThresholdTuningStopScenario(BTSConnection btsConnection, VSWRThresholdListener listener, int configObjectId, boolean saveNewValues, BTSMessage.Type type) {
        this(btsConnection, listener, configObjectId, saveNewValues);
        this.myType = type;
    }

    @Override
    public void execute() {
        if (this.myRunning) {
            throw new IllegalStateException("Scenario already executing.");
        }
        this.myRunning = true;
        CoreAssetThread resetWorker = new CoreAssetThread(){
            int seqNumber;

            protected Object construct() {
                if (CoreAsset.isSnapshotOpening()) {
                    VSWRThresholdTuningStopScenario.this.myLogger.debug((Object)"Snapshot open not supported.");
                    VSWRThresholdTuningStopScenario.this.myListener.tuningStopFailed(85, VSWRThresholdTuningStopScenario.this.myConfigObjectId);
                    return true;
                }
                this.seqNumber = VSWRThresholdTuningStopScenario.this.myBTSConnection.createScenario();
                VSWRThresholdTuningStopRequest startRequest = new VSWRThresholdTuningStopRequest(this.seqNumber, VSWRThresholdTuningStopScenario.this.myConfigObjectId, VSWRThresholdTuningStopScenario.this.mySaveNewValues, VSWRThresholdTuningStopScenario.this.myType);
                VSWRThresholdTuningStopScenario.this.myBTSConnection.sendToBTS((BTSMessage)startRequest);
                BTSMessage response = VSWRThresholdTuningStopScenario.this.myBTSConnection.receiveFromBTS(this.seqNumber);
                if (response instanceof Ack) {
                    Ack ackResponse = (Ack)response;
                    if (!ackResponse.getAck()) {
                        VSWRThresholdTuningStopScenario.this.myLogger.debug((Object)"VSWR_TuningStopScenario.execute, Failed, Nacked from BTS.");
                        VSWRThresholdTuningStopScenario.this.myListener.tuningStopFailed(ackResponse.getNackReason(), VSWRThresholdTuningStopScenario.this.myConfigObjectId);
                    } else {
                        VSWRThresholdTuningStopScenario.this.myLogger.debug((Object)"VSWR_TuningStopScenario.execute, Set successful.");
                        VSWRThresholdTuningStopScenario.this.myListener.tuningStopped(VSWRThresholdTuningStopScenario.this.myConfigObjectId);
                    }
                } else {
                    VSWRThresholdTuningStopScenario.this.myLogger.debug((Object)"VSWR_TuningStopScenario.execute, Failed in BTS, invalid message or connection lost.");
                    VSWRThresholdTuningStopScenario.this.myListener.tuningStopFailed(28, VSWRThresholdTuningStopScenario.this.myConfigObjectId);
                }
                return true;
            }

            protected void finished() {
                VSWRThresholdTuningStopScenario.this.myBTSConnection.deleteScenario(this.seqNumber);
                try {
                    this.get();
                }
                catch (Exception e) {
                    VSWRThresholdTuningStopScenario.this.myLogger.error((Object)"VSWR_TuningStopScenario.execute, Unknown error", (Throwable)e);
                }
                VSWRThresholdTuningStopScenario.this.myRunning = false;
            }
        };
        resetWorker.start();
    }

    @Override
    public boolean abort() {
        return true;
    }

    public BTSMessage.Type getType() {
        return this.myType;
    }

    public void setType(BTSMessage.Type type) {
        this.myType = type;
    }
}

